/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.conv;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoRemovedException;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.upfwk.common.FindMo;
import se.ericsson.wcdma.rbs.boam.upfwk.common.LDNHelper;
import se.ericsson.wcdma.rbs.boam.upfwk.conv.DataConverterBase;
import se.ericsson.wcdma.rbs.boam.upfwk.conv.helper.TopologyMgr;

public class DC8021398To8021399
extends DataConverterBase {
    private static final DC8021398To8021399 instance = new DC8021398To8021399();
    private static final String UNDEFINED_RRU_RRUW_NUMBER = "-1";
    private static final String INTERNAL_RRU_RRUW_NUMBER_BRANCH_A = "1";
    private static final String INTERNAL_RRU_RRUW_NUMBER_BRANCH_B = "2";
    private static final String AUX_PIU_TYPE_NAME = "AuxPlugInUnit";
    private static final String OIL_TYPE_NAME = "OpticalInterfaceLink";
    private static final String SECTOR_ANTENNA_TYPE_NAME = "SectorAntenna";
    private static final String ANT_FEEDER_CABLE_TYPE_NAME = "AntFeederCable";
    private static final String ANTENNA_BRANCH_TYPE_NAME = "AntennaBranch";
    private static final String BRANCH_NAME_ATTR_NAME = "branchName";
    private static final String ANTENNA_BRANCH_REF_ATTR_NAME = "antennaBranchRef";
    private static final String AU_TYPE_ATTR_NAME = "auType";
    private static final String CONNECTED_TO_OBJECT_A_REF_ATTR_NAME = "connectedToObjectARef";
    private static final String CONNECTED_TO_OBJECT_B_REF_ATTR_NAME = "connectedToObjectBRef";
    private static final int AU_TYPE_RRU = 10;
    private static final int AU_TYPE_RRUW = 20;
    private static final String AU_TYPE_RRU_AS_STRING = "RRU";
    private static final String AU_TYPE_RRUW_AS_STRING = "RRUW";
    private static final char DELIM_CHAR = '-';
    private static final String ASSIGN_OP_AS_STRING = "=";
    protected static final int fromConverterRev = 8021398;
    protected static final int toConverterRev = 8021399;
    private Coordinator context;

    protected DC8021398To8021399() {
        super(8021398, 8021399);
    }

    public static DC8021398To8021399 instance() {
        return instance;
    }

    protected void initDC(Coordinator context) throws Exception {
        MessageLog.traceEnter(this.getClass(), (String)"initDC()");
        this.context = context;
    }

    protected void doDC() throws Exception {
        this.traceEnter("doDC()");
        List updateCandidates = this.findUpdateCandidates();
        if (updateCandidates.isEmpty()) {
            this.trace("Found no update candidates - No upgrade is necessary.");
        } else {
            this.updateNamingAttributeValues(updateCandidates);
        }
    }

    private void updateNamingAttributeValues(List dataList) throws Exception {
        this.traceEnter("updateNamingAttributeValues()");
        TopologyMgr mgr = new TopologyMgr(this.workingMoData);
        Iterator iter = dataList.iterator();
        while (iter.hasNext()) {
            UpdateCandidate data = (UpdateCandidate)iter.next();
            this.trace("Info : " + data.moData.getLocalDistinguishedName() + " has wrong identity.");
            String newLDN = this.generateNewLdn(data);
            mgr.changeLdnTopology(data.moData, newLDN);
            this.trace("Info : " + data.moData.getLocalDistinguishedName() + " has now following LDN : " + newLDN);
        }
        this.trace(mgr.getModificationInfo());
    }

    private String generateNewLdn(UpdateCandidate updateCandidate) {
        String source = updateCandidate.moData.getLocalDistinguishedName();
        String oldSubStr = updateCandidate.moData.getMoTypeName() + ASSIGN_OP_AS_STRING + LDNHelper.getNamingAttributeValue(updateCandidate.moData.getLocalDistinguishedName());
        String replacement = updateCandidate.moData.getMoTypeName() + ASSIGN_OP_AS_STRING + updateCandidate.idString;
        return LDNHelper.replaceFirst(source, oldSubStr, replacement);
    }

    private List findUpdateCandidates() throws MoRemovedException {
        this.traceEnter("findUpdateCandidates()");
        Iterator sectorAntennasIt = this.workingMoData.getMoData(SECTOR_ANTENNA_TYPE_NAME).iterator();
        ArrayList<UpdateCandidate> updateCandidates = new ArrayList<UpdateCandidate>();
        while (sectorAntennasIt.hasNext()) {
            MoData sectorAntenna = (MoData)sectorAntennasIt.next();
            List auxPIUList = this.getAllRruAndRruw(sectorAntenna);
            int noAuxPius = auxPIUList.size();
            if (noAuxPius > 2) {
                this.trace("The SectorAntenna " + sectorAntenna.getLocalDistinguishedName() + " contains " + noAuxPius + " AuxPlugInUnits - no action");
                continue;
            }
            Iterator iter = auxPIUList.iterator();
            while (iter.hasNext()) {
                MoData auxPiu = (MoData)iter.next();
                String internalRruRruwNumber = this.getInternalRruRruwNumber(noAuxPius, auxPiu);
                if (internalRruRruwNumber.equals(UNDEFINED_RRU_RRUW_NUMBER)) {
                    this.trace("The internal RRU/RRUW number could not be found");
                    continue;
                }
                String newAuxPiuId = this.buildNewAuxPiuId(internalRruRruwNumber, auxPiu);
                if (newAuxPiuId == null) continue;
                updateCandidates.add(new UpdateCandidate(auxPiu, newAuxPiuId));
                List OilCables = this.getConnectedOilCables(auxPiu);
                Iterator iterator = OilCables.iterator();
                while (iterator.hasNext()) {
                    MoData oilCable = (MoData)iterator.next();
                    String newOilId = this.buildNewOilId(internalRruRruwNumber, oilCable);
                    if (newOilId == null) continue;
                    updateCandidates.add(new UpdateCandidate(oilCable, newOilId));
                }
            }
        }
        return updateCandidates;
    }

    private List getConnectedOilCables(MoData auxPiu) {
        ArrayList<MoData> connectedOils = new ArrayList<MoData>();
        Iterator oilIt = this.workingMoData.getMoData(OIL_TYPE_NAME).iterator();
        while (oilIt.hasNext()) {
            MoData aOil = (MoData)oilIt.next();
            ReferenceAttribute refA = (ReferenceAttribute)aOil.getAttribute(CONNECTED_TO_OBJECT_A_REF_ATTR_NAME);
            if (refA != null && refA.getReferenceAsLDN().equals(auxPiu.getLocalDistinguishedName())) {
                connectedOils.add(aOil);
                continue;
            }
            ReferenceAttribute refB = (ReferenceAttribute)aOil.getAttribute(CONNECTED_TO_OBJECT_B_REF_ATTR_NAME);
            if (refB == null || !refB.getReferenceAsLDN().equals(auxPiu.getLocalDistinguishedName())) continue;
            connectedOils.add(aOil);
        }
        return connectedOils;
    }

    private String buildNewAuxPiuId(String internalRruRruwNumber, MoData auxPiu) {
        this.traceEnter("buildNewAuxPiuId()");
        IntegerAttribute auType = (IntegerAttribute)auxPiu.getAttribute(AU_TYPE_ATTR_NAME);
        if (auType != null) {
            String newId = this.getAuTypeAsString(auType.getValue(this.context)) + '-' + internalRruRruwNumber;
            this.trace("New ID: " + newId);
            return newId;
        }
        this.traceError("Not able to get attribute auType from " + auxPiu.getLocalDistinguishedName());
        return null;
    }

    private String buildNewOilId(String internalRruRruwNumber, MoData oilCable) {
        this.traceEnter("buildNewOilId()");
        String oldId = LDNHelper.getNamingAttributeValue(oilCable.getLocalDistinguishedName());
        this.trace("Old OilId: " + oldId);
        try {
            String sectorNo = oldId.substring(0, oldId.indexOf(45));
            String direction = oldId.substring(oldId.lastIndexOf(45) + 1);
            String newId = sectorNo + '-' + internalRruRruwNumber + '-' + direction;
            this.trace("New OilId: " + newId);
            return newId;
        }
        catch (StringIndexOutOfBoundsException e) {
            this.traceError("Could not build a new OilId since the old Id is not as expected: " + oldId);
            return null;
        }
    }

    private String getInternalRruRruwNumber(int noAuxPius, MoData auxPiu) {
        this.traceEnter("getInternalRruRruwNumber()");
        if (noAuxPius == 1) {
            return INTERNAL_RRU_RRUW_NUMBER_BRANCH_A;
        }
        if (noAuxPius == 2) {
            Iterator antFeederCableIt = this.workingMoData.getMoData(ANT_FEEDER_CABLE_TYPE_NAME).iterator();
            while (antFeederCableIt.hasNext()) {
                StringAttribute branchNameAttribute;
                MoData antFeederCable = (MoData)antFeederCableIt.next();
                ReferenceAttribute refA = (ReferenceAttribute)antFeederCable.getAttribute(CONNECTED_TO_OBJECT_A_REF_ATTR_NAME);
                MoData connectedAuxPiu = this.getMoDataFromLDN(refA.getReferenceAsLDN(), AUX_PIU_TYPE_NAME);
                if (connectedAuxPiu == null || !connectedAuxPiu.getLocalDistinguishedName().equals(auxPiu.getLocalDistinguishedName())) continue;
                ReferenceAttribute antennaBranchRef = (ReferenceAttribute)antFeederCable.getAttribute(ANTENNA_BRANCH_REF_ATTR_NAME);
                if (antennaBranchRef == null) {
                    this.traceError("Not able to get attribute antennaBranchRef from " + antFeederCable.getLocalDistinguishedName());
                    return UNDEFINED_RRU_RRUW_NUMBER;
                }
                MoData antennaBranch = this.getMoDataFromLDN(antennaBranchRef.getReferenceAsLDN(), ANTENNA_BRANCH_TYPE_NAME);
                if (antennaBranch == null) {
                    this.traceError("Not able to get MoData for MO " + antennaBranchRef.getReferenceAsLDN());
                }
                if ((branchNameAttribute = (StringAttribute)antennaBranch.getAttribute(BRANCH_NAME_ATTR_NAME)) == null) {
                    this.traceError("Not able to get attribute branchName from " + antFeederCable.getLocalDistinguishedName());
                    return UNDEFINED_RRU_RRUW_NUMBER;
                }
                String branchName = branchNameAttribute.getValue(null);
                if (branchName == null) {
                    this.traceError("Not able to get value from branchName on " + antFeederCable.getLocalDistinguishedName());
                    return UNDEFINED_RRU_RRUW_NUMBER;
                }
                if (branchName.equals("A")) {
                    return INTERNAL_RRU_RRUW_NUMBER_BRANCH_A;
                }
                if (branchName.equals("B")) {
                    return INTERNAL_RRU_RRUW_NUMBER_BRANCH_B;
                }
                this.trace("branchName " + branchName + " can not be mapped to an internal RRU/RRUW number");
            }
            this.trace("No AntFeederCable with AntennaBranch A or B is connected to " + auxPiu.getLocalDistinguishedName());
        }
        return UNDEFINED_RRU_RRUW_NUMBER;
    }

    private List getAllRruAndRruw(MoData sectorAntenna) {
        ArrayList<MoData> auxPIUList = new ArrayList<MoData>();
        Collection auxPIUs = FindMo.getChildren(AUX_PIU_TYPE_NAME, sectorAntenna.getLocalDistinguishedName(), this.workingMoData);
        Iterator iter = auxPIUs.iterator();
        while (iter.hasNext()) {
            MoData aAuxPIU = (MoData)iter.next();
            IntegerAttribute auType = (IntegerAttribute)aAuxPIU.getAttribute(AU_TYPE_ATTR_NAME);
            if (auType.getValue(this.context) != 10 && auType.getValue(this.context) != 20) continue;
            auxPIUList.add(aAuxPIU);
        }
        return auxPIUList;
    }

    private String getAuTypeAsString(int auType) {
        if (auType == 10) {
            return AU_TYPE_RRU_AS_STRING;
        }
        if (auType == 20) {
            return AU_TYPE_RRUW_AS_STRING;
        }
        return "";
    }

    private MoData getMoDataFromLDN(String LDN, String typeName) {
        Collection moData = this.workingMoData.getMoData(typeName);
        Iterator iter = moData.iterator();
        while (iter.hasNext()) {
            MoData element = (MoData)iter.next();
            if (!element.getLocalDistinguishedName().equals(LDN)) continue;
            return element;
        }
        return null;
    }

    private class UpdateCandidate {
        private MoData moData;
        private String idString;

        public UpdateCandidate(MoData moData, String idString) {
            this.moData = moData;
            this.idString = idString;
        }
    }
}

