/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.conv.operations;

import java.util.Collection;
import java.util.Iterator;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.upfwk.command.Command;
import se.ericsson.wcdma.rbs.boam.upfwk.common.LDNHelper;
import se.ericsson.wcdma.rbs.boam.upfwk.common.ReserveMoHelper;
import se.ericsson.wcdma.rbs.boam.upfwk.common.WorkingMoData;

public class TR85554RepairOp
implements Command {
    private static final Class self = TR85554RepairOp.class;
    private static final String RESERVER_MO_1 = "RfCable";
    private static final String RESERVER_MO_2 = "AntFeederCable";
    private static final String ATTR_NAME = "connectedToObjectARef";
    private static final String REFERRED_MO_1 = "PlugInUnit";
    private static final String REFERRED_MO_2 = "AuxPlugInUnit";
    private final WorkingMoData workingMoData;
    private final Coordinator context;

    public TR85554RepairOp(WorkingMoData workingMoData, Coordinator context) {
        this.workingMoData = workingMoData;
        this.context = context;
    }

    public void execute() throws Exception {
        MessageLog.traceEnter((Class)self, (String)"execute()");
        this.enforceConnectedToObjectARefIsProperlyReserved(this.workingMoData.getMoData(RESERVER_MO_1));
        this.enforceConnectedToObjectARefIsProperlyReserved(this.workingMoData.getMoData(RESERVER_MO_2));
    }

    private void enforceConnectedToObjectARefIsProperlyReserved(Collection reserverMos) {
        MessageLog.traceEnter((Class)self, (String)"scanReserverMos()");
        Iterator it = reserverMos.iterator();
        while (it.hasNext()) {
            MoData reserverMo = (MoData)it.next();
            String reserverLdn = reserverMo.getLocalDistinguishedName();
            if (reserverLdn == null) {
                MessageLog.trace((int)9, (Class)self, (String)("failed to obtain LDN for MO " + reserverMo + " - no action for this MO"));
                continue;
            }
            Attribute attr = reserverMo.getAttribute(ATTR_NAME);
            if (attr == null) {
                MessageLog.trace((int)9, (Class)self, (String)("MO: " + reserverLdn + ", attribute: " + ATTR_NAME + " is unexpectedly not present - no action"));
                continue;
            }
            if (!(attr instanceof ReferenceAttribute)) {
                MessageLog.trace((int)9, (Class)self, (String)("MO: " + reserverLdn + ", attribute " + ATTR_NAME + " is unexpectedly not a ReferenceAttribute - no action"));
                continue;
            }
            ReferenceAttribute refAttr = (ReferenceAttribute)attr;
            String referredLdn = refAttr.getReferenceAsLDN();
            if (referredLdn == null) {
                MessageLog.trace((int)9, (Class)self, (String)("MO: " + reserverLdn + ", attribute " + ATTR_NAME + ", unexpectedly does not specify a LDN - no action"));
                continue;
            }
            MoData referredMo = this.getMoData(referredLdn);
            if (referredMo == null) {
                MessageLog.trace((int)9, (Class)self, (String)("MO: " + reserverLdn + ", attribute " + ATTR_NAME + ", failed to lookup MO for LDN: " + referredLdn + " - no action"));
                continue;
            }
            try {
                ReserveMoHelper.reserve(referredMo, reserverLdn, this.context);
            }
            catch (Throwable t) {
                MessageLog.traceError((Class)self, (String)("exception when trying to make " + reserverLdn + " reserve " + referredLdn + ": " + t));
            }
            this.releaseReferredMos(reserverLdn, this.workingMoData.getMoData(REFERRED_MO_1), referredLdn);
            this.releaseReferredMos(reserverLdn, this.workingMoData.getMoData(REFERRED_MO_2), referredLdn);
        }
    }

    private MoData getMoData(String ldn) {
        String moTypeName = LDNHelper.getMoTypeName(ldn);
        if (moTypeName == null) {
            return null;
        }
        Iterator it = this.workingMoData.getMoData(moTypeName).iterator();
        while (it.hasNext()) {
            MoData moData = (MoData)it.next();
            String candidateLdn = moData.getLocalDistinguishedName();
            if (candidateLdn == null || !candidateLdn.equals(ldn)) continue;
            return moData;
        }
        return null;
    }

    private void releaseReferredMos(String reserverLdn, Collection reservedMos, String skipLdn) {
        MessageLog.traceEnter((Class)self, (String)"releaseReferredMos()");
        Iterator it = reservedMos.iterator();
        while (it.hasNext()) {
            MoData reservedMo = (MoData)it.next();
            String reservedLdn = reservedMo.getLocalDistinguishedName();
            if (reservedLdn == null) {
                MessageLog.trace((int)9, (Class)self, (String)("MO: " + reservedMo + " unexpectedly does not have a LDN - not attempting release"));
                continue;
            }
            if (reservedLdn.equals(skipLdn)) continue;
            try {
                ReserveMoHelper.release(reservedMo, reserverLdn, this.context);
            }
            catch (Throwable t) {
                MessageLog.traceError((Class)self, (String)("exception when trying to make " + reserverLdn + " release " + reservedLdn + ": " + t));
            }
        }
    }
}

