/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.upfwk.aue;

import enea.ose.system.OseProcess;
import enea.ose.system.UnlinkedSignal;
import java.lang.reflect.Field;
import se.ericsson.cello.moframework.FroNotAccessibleException;
import se.ericsson.cello.moframework.FroRequestFailedException;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.support.sigutil.OseNameServer;
import se.ericsson.cello.support.sigutil.SubscriptionObserver;
import se.ericsson.wcdma.rbs.boam.upfwk.command.CommandHandler;

public abstract class AueProxyBase
implements SubscriptionObserver {
    public static final int RBS_OK = 0;
    private final String serviceName;
    private boolean isServicePublished = false;
    protected OseProcess serviceProviderPsId = null;

    public AueProxyBase(String serviceName) {
        MessageLog.traceEnter(this.getClass(), (String)"AueProxyBase()");
        this.serviceName = serviceName;
        this.addServiceObserver();
    }

    public boolean isServicePublished() {
        return this.isServicePublished;
    }

    private void setServicePublished(boolean b) {
        this.isServicePublished = b;
    }

    public void addServiceObserver() {
        this.setServicePublished(false);
        MessageLog.traceEnter(this.getClass(), (String)"addServiceObserver()");
        OseNameServer.addSubscriptionObserver((String)this.serviceName, (SubscriptionObserver)this);
    }

    public void serviceAdded(String aService) {
        MessageLog.traceEnter(this.getClass(), (String)("serviceAdded(),Service " + aService + " added"));
        this.serviceProviderPsId = OseNameServer.lookup((String)this.serviceName);
        this.setServicePublished(true);
    }

    public void serviceRemoved(String aService) {
        MessageLog.traceEnter(this.getClass(), (String)"serviceRemoved()");
        MessageLog.trace((int)7, this.getClass(), (String)("Service " + aService + " removed"));
        this.setServicePublished(false);
        this.serviceProviderPsId = null;
    }

    protected void verifyRoLayerResponse(UnlinkedSignal rspSig) throws FroNotAccessibleException, FroRequestFailedException {
        if (rspSig == null) {
            MessageLog.traceError(this.getClass(), (String)"NullResponseSignalReceived");
            throw new FroNotAccessibleException("AueProxyBase", this.serviceName + "NullResponseSignalReceived");
        }
        FroRequestFailedException froReqProblem = null;
        try {
            Field result = rspSig.getClass().getDeclaredField("result");
            if (result != null && result.getInt(rspSig) != 0) {
                MessageLog.traceError(this.getClass(), (String)("The response signal is returned with result NOK:" + result.getInt(rspSig)));
                froReqProblem = new FroRequestFailedException("AueProxyBase", this.serviceName, rspSig.getClass().getName(), result.getInt(rspSig));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (froReqProblem != null) {
            throw froReqProblem;
        }
    }

    public void checkAndWaiteForProxy() throws MoAccessException {
        for (int noOfRetry = 60; !this.isServicePublished() && noOfRetry > 0; --noOfRetry) {
            MessageLog.trace((int)9, this.getClass(), (String)("Still waiting for fRO, no of tries left before giving up: " + noOfRetry));
            CommandHandler.sleep(1000);
        }
        this.verifyProxyAvaliable();
    }

    public void verifyProxyAvaliable() throws FroNotAccessibleException {
        if (!this.isServicePublished()) {
            MessageLog.info(this.getClass(), (String)("ServiceNotPublished: " + this.serviceName));
            throw new FroNotAccessibleException(this.getClass().getName(), this.serviceName + " ServiceNotPublished");
        }
    }
}

