/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.upfwk.conv;

import se.ericsson.cello.moframework.MoDataConversionException;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.wcdma.rbs.boam.upfwk.conv.DCConstants;

public class BoamDataRevision
implements DCConstants {
    private int fromBoamDataRev;
    private int fromProject;
    private int fromIncrement;
    private int fromSubIncrement;
    private int toBoamDataRev;
    private int toProject;
    private int toIncrement;
    private int toSubIncrement;

    public BoamDataRevision(int froRevision, int toRevision) throws MoDataConversionException {
        MessageLog.traceEnter(this.getClass(), (String)"BoamDataRevision()");
        this.fromBoamDataRev = froRevision;
        this.toBoamDataRev = toRevision;
        this.validateRev();
    }

    public int getFromBoamDataRev() {
        return this.fromBoamDataRev;
    }

    public int getToBoamDataRev() {
        return this.toBoamDataRev;
    }

    public int getFromProject() {
        return this.fromProject;
    }

    public int getFromIncrement() {
        return this.fromIncrement;
    }

    public int getFromSubIncrement() {
        return this.fromSubIncrement;
    }

    public int getToProject() {
        return this.toProject;
    }

    public int getToIncrement() {
        return this.toIncrement;
    }

    public int getToSubIncrement() {
        return this.toSubIncrement;
    }

    private void validateRev() throws MoDataConversionException {
        MessageLog.traceEnter(this.getClass(), (String)"validateRev()");
        if (this.fromBoamDataRev > 99000000) {
            throw new MoDataConversionException("Not supported project int the Boam From Data Revision . Rev:" + this.fromBoamDataRev);
        }
        if (this.toBoamDataRev > 99000000) {
            throw new MoDataConversionException("Not supported project int the Boam To Data Revision . Rev:" + this.toBoamDataRev);
        }
        if (this.toBoamDataRev < this.fromBoamDataRev) {
            throw new MoDataConversionException("Not possible to upgrade, fromBoamDataRev= " + this.fromBoamDataRev + " > toBoamDataRev= " + this.toBoamDataRev);
        }
        this.fromSubIncrement = this.fromBoamDataRev % 1000000 % 10000;
        this.fromIncrement = this.fromBoamDataRev % 1000000 - this.fromSubIncrement;
        this.fromProject = this.fromBoamDataRev - this.fromIncrement - this.fromSubIncrement;
        this.toSubIncrement = this.toBoamDataRev % 1000000 % -10000;
        this.toIncrement = this.toBoamDataRev % 1000000 - this.toSubIncrement;
        this.toProject = this.toBoamDataRev - this.toIncrement - this.toSubIncrement;
        if (this.toProject < 0) {
            this.toProject = 0;
        }
        if (this.fromProject < 0) {
            this.fromProject = 0;
        }
    }
}

