/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emt.moproperties;

import java.util.ListIterator;
import se.ericsson.cello.emt.moproperties.LdnMvcContainer;
import se.ericsson.cello.emt.moproperties.LdnMvcContainerListener;
import se.ericsson.cello.emt.moproperties.MoPropLog;
import se.ericsson.cello.emt.moproperties.controller.MoPropertiesController;
import se.ericsson.cello.emt.moproperties.controller.MoPropertiesControllerFactory;
import se.ericsson.cello.emt.moproperties.model.MoPropertiesModel;
import se.ericsson.cello.emt.moproperties.model.MoPropertiesModelFactory;
import se.ericsson.cello.emt.moproperties.model.MoPropertiesModelListener;
import se.ericsson.cello.emt.moproperties.view.MoPropertiesView;
import se.ericsson.cello.emt.moproperties.view.MoPropertiesViewFactory;
import se.ericsson.cello.emt.motools.common.config.ifc.Configuration;
import se.ericsson.cello.emt.motools.common.toolservices.ToolServices;
import se.ericsson.cello.emt.motools.common.toolservices.ToolServicesFactory;
import se.ericsson.cello.emt.nodeservices.NodeServices;
import se.ericsson.cello.emt.userpreferences.UserPreferencesI;
import se.ericsson.security.launcher.Launchable;
import se.ericsson.security.launcher.LauncherInterface;

public class LdnMvcContainerImpl
implements LdnMvcContainer,
MoPropertiesModelListener {
    private String myLdn;
    private NodeServices myNodeServices;
    private UserPreferencesI myUserPreferences;
    private ToolServices myToolServices;
    private Configuration myConfiguration;
    private MoPropertiesModel myMoPropertiesModel = null;
    private MoPropertiesController myMoPropertiesController = null;
    private MoPropertiesView myMoPropertiesView = null;
    private Launchable myParentLaunchble = null;
    private LauncherInterface myLauncher = null;
    private LdnMvcContainerListener myLdnMvcContainerListener = null;

    public LdnMvcContainerImpl(String anLdn, NodeServices aNodeServices, UserPreferencesI aUserPrefService, Configuration aConfiguration, Launchable parentLaunchble, LauncherInterface theLauncher, LdnMvcContainerListener aListener) {
        this.myLdn = anLdn;
        this.myNodeServices = aNodeServices;
        this.myUserPreferences = aUserPrefService;
        this.myConfiguration = aConfiguration;
        this.myParentLaunchble = parentLaunchble;
        this.myLauncher = theLauncher;
        this.myLdnMvcContainerListener = aListener;
        this.initModelViewControllerStructure();
    }

    public void activate() {
    }

    public void doStart() {
        this.myMoPropertiesController.showUIView(true);
    }

    public void doStop() {
        MoPropLog.logger().info("Stop MoProperties " + this.myLdn);
        if (this.myMoPropertiesView != null) {
            this.myMoPropertiesView.exit();
        }
    }

    public String getLdn() {
        return this.getContainerKey();
    }

    private void initModelViewControllerStructure() {
        this.myToolServices = ToolServicesFactory.createToolServices(this.myParentLaunchble, this.myLauncher, this.myConfiguration, this.myNodeServices, this.myUserPreferences);
        this.myMoPropertiesModel = MoPropertiesModelFactory.createMoPropModel(this.myLdn, this.myToolServices, this.myConfiguration, this);
        this.myMoPropertiesController = MoPropertiesControllerFactory.createMoPropController(this.myMoPropertiesModel);
        this.myMoPropertiesView = MoPropertiesViewFactory.createMoPropertiesView(this.myMoPropertiesController, this.myMoPropertiesModel);
        this.myMoPropertiesController.setView(this.myMoPropertiesView);
        this.myMoPropertiesView.initialize();
        this.myMoPropertiesModel.addUiView(this.myMoPropertiesView);
    }

    private String getContainerKey() {
        if (this.myConfiguration.getSelectedAttrNames() != null || this.myConfiguration.getSelectedActionName() != null) {
            StringBuffer myContainerKeyBuffer = new StringBuffer();
            myContainerKeyBuffer.append(this.myLdn + " ");
            if (this.myConfiguration.getSelectedActionName() != null) {
                myContainerKeyBuffer.append(this.myConfiguration.getSelectedActionName() + " ");
            }
            if (this.myConfiguration.getSelectedAttrNames() != null) {
                ListIterator<String> it = this.myConfiguration.getSelectedAttrNames().listIterator();
                while (it.hasNext()) {
                    String attr = it.next();
                    if (attr == null) continue;
                    myContainerKeyBuffer.append(attr + " ");
                }
            }
            return myContainerKeyBuffer.toString();
        }
        return this.myLdn;
    }

    public void onMoPropertiesModelExit() {
        if (this.myLdnMvcContainerListener != null) {
            this.myLdnMvcContainerListener.onLdnMvcContainerExit(this);
        }
    }
}

