/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emt.moproperties.controller;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.SwingUtilities;
import se.ericsson.cello.emt.moproperties.MoPropLog;
import se.ericsson.cello.emt.moproperties.controller.ProgressAttributeChangeListener;
import se.ericsson.cello.emt.motools.common.config.ifc.Configuration;
import se.ericsson.cello.emt.motools.common.momodel.AttributeModel;
import se.ericsson.cello.emt.motools.common.momodel.MoModel;
import se.ericsson.cello.emt.motools.common.momodel.typevalue.EnumTypeValue;
import se.ericsson.cello.emt.motools.common.momodel.typevalue.TypeValue;
import se.ericsson.cello.mimparser.MomAttribute;
import se.ericsson.cello.neal.cm.NameValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProgressController {
    private Configuration myConfiguration;
    private MoModel myMoModel;
    private String myProgressStartString = "";
    private String myProgressTotalString = "";
    private int myProgressStart;
    private int myProgressTotal;
    private String myProgressDisplay;
    private boolean myProgressStartIsAnAttribute;
    private boolean myProgressTotalIsAnAttribute;
    private String myProgressCountAttribute;
    private String myProgressDisplayAttribute;
    private HashMap<String, ProgressStopExpression> myProgressStopExpressions;
    private LinkedList<String> myAttributeNamesForDisplayInProgressArea;
    private LinkedHashMap<String, NameValue> myLastTimeFetchedNameValues;
    private LinkedHashSet<NameValue> myChangedNameValues;
    private boolean stopProgressCriteriaFound;
    private boolean progressStarted = false;
    private int myFetchedProgress;
    private String[] myAttributesToPoll;
    private Collection<ProgressAttributeChangeListener> myChangeListeners;
    private boolean preparedForProgressInNumber;
    private boolean preparedForProgressIndeterminate;
    private String OP_EQUALS = "==";
    private int myPollperiod = 15000;
    private Timer myAttributePollingTimer;

    public void setConfiguration(Configuration configuration) {
        MoPropLog.logger().finer("Setting Configuration");
        this.myConfiguration = configuration;
    }

    public void setMoModel(MoModel moModel) {
        MoPropLog.logger().finer("Setting MoModel");
        this.myMoModel = moModel;
    }

    public boolean isInitiatedSuccessfully() {
        MoPropLog.logger().entering(this.getClass().getName(), "isInitiatedSuccessfully()");
        this.myChangeListeners = new HashSet<ProgressAttributeChangeListener>();
        LinkedList<String> attributesToPoll = new LinkedList<String>();
        if (null != this.myConfiguration && null != this.myMoModel) {
            if (this.isCountProgress()) {
                attributesToPoll.addAll(this.getAttributesToPollForCountProgress());
            } else if (this.isInterminateProgress()) {
                attributesToPoll.addAll(this.getAttributesToPollForIndeterminateProgress());
            }
            if (null != this.myConfiguration.getProgressSupervisionAttributes()) {
                this.myAttributeNamesForDisplayInProgressArea = new LinkedList<String>(this.myConfiguration.getProgressSupervisionAttributes());
                attributesToPoll.addAll(this.myAttributeNamesForDisplayInProgressArea);
            }
            this.myAttributesToPoll = attributesToPoll.toArray(new String[attributesToPoll.size()]);
            if (this.preparedForProgressInNumber || this.preparedForProgressIndeterminate) {
                this.startTimer(this.myMoModel.getMoRef().getLdn());
            }
        }
        MoPropLog.logger().finer("Exiting method isInitiatedSuccessfully(). preparedForProgressInNumber is: " + this.preparedForProgressInNumber + "  preparedForProgressIndeterminate is: " + this.preparedForProgressIndeterminate);
        return this.preparedForProgressInNumber || this.preparedForProgressIndeterminate;
    }

    private List<String> getAttributesToPollForIndeterminateProgress() {
        LinkedList<String> attributesToPoll = new LinkedList<String>();
        List<String> stopAttributeExpressions = this.myConfiguration.getProgressStopAttributes();
        this.myProgressStopExpressions = new HashMap();
        for (String expression : stopAttributeExpressions) {
            if (!expression.contains(this.OP_EQUALS)) continue;
            String[] parts = expression.split(this.OP_EQUALS);
            if (parts.length == 2) {
                String attributeName = parts[0];
                String value = parts[1];
                this.myProgressStopExpressions.put(attributeName, new ProgressStopExpression(new Equals(), value));
                continue;
            }
            MoPropLog.logger().info("Invalid property value for PROGRESS_STOP_ATTRIBUTES: " + expression);
        }
        this.myProgressDisplayAttribute = this.myConfiguration.getProgressDisplayAttribute();
        attributesToPoll.addAll(this.myProgressStopExpressions.keySet());
        attributesToPoll.add(this.myProgressDisplayAttribute);
        this.preparedForProgressIndeterminate = true;
        return attributesToPoll;
    }

    private List<String> getAttributesToPollForCountProgress() {
        LinkedList<String> attributesToPoll = new LinkedList<String>();
        boolean startNumberFound = this.isProgressStartNumberInitiatedSuccessfully();
        if (startNumberFound) {
            boolean totalNumberFound;
            if (this.myProgressStartIsAnAttribute) {
                attributesToPoll.add(this.myProgressStartString);
            }
            if (totalNumberFound = this.isProgressTotalNumberInitiatedSuccessfully()) {
                boolean progressCountAttributeFound;
                if (this.myProgressTotalIsAnAttribute) {
                    attributesToPoll.add(this.myProgressTotalString);
                }
                if (progressCountAttributeFound = this.isProgressCountInitiatedSuccessfully()) {
                    attributesToPoll.add(this.myProgressCountAttribute);
                    this.preparedForProgressInNumber = true;
                }
            }
        }
        return attributesToPoll;
    }

    private boolean isProgressCountInitiatedSuccessfully() {
        MoPropLog.logger().entering(this.getClass().getName(), "isProgressCountInitiatedSuccessfully()");
        boolean found = false;
        this.myProgressCountAttribute = this.myConfiguration.getProgressCountAttribute();
        MomAttribute progNumberAttribute = this.myMoModel.getMomClass().getAttribute(this.myProgressCountAttribute);
        if (null == progNumberAttribute || !progNumberAttribute.getType().getXmlType().equalsIgnoreCase("long")) {
            MoPropLog.logger().info("Missing information necesarry to display progress information: " + this.myProgressCountAttribute + " is not a name of a " + this.myMoModel.getMomClass().getName() + " attribute containing a number (defined in the MOM as a long).");
        } else {
            found = true;
        }
        MoPropLog.logger().exiting(this.getClass().getName(), "isProgressCountInitiatedSuccessfully", found);
        return found;
    }

    private boolean isProgressTotalNumberInitiatedSuccessfully() {
        MoPropLog.logger().entering(this.getClass().getName(), "isProgressTotalNumberInitiatedSuccessfully()");
        boolean found = false;
        this.myProgressTotalString = this.myConfiguration.getProgressTotal();
        MomAttribute progTotalAttribute = this.myMoModel.getMomClass().getAttribute(this.myProgressTotalString);
        if (null != progTotalAttribute && progTotalAttribute.getType().getXmlType().equalsIgnoreCase("long")) {
            found = true;
            this.myProgressTotalIsAnAttribute = true;
            MoPropLog.logger().finer("progress total attribute name is: " + progTotalAttribute.getName());
        } else {
            try {
                Integer totalInteger = Integer.parseInt(this.myProgressTotalString);
                this.myProgressTotal = totalInteger;
                found = true;
            }
            catch (NumberFormatException e) {
                MoPropLog.logger().info("Missing information necesarry to display progress information: " + this.myProgressTotalString + " is neither a number, nor a name of an attribute containing a number.");
            }
        }
        MoPropLog.logger().exiting(this.getClass().getName(), "isProgressTotalNumberInitiatedSuccessfully", found);
        return found;
    }

    private boolean isProgressStartNumberInitiatedSuccessfully() {
        MoPropLog.logger().entering(this.getClass().getName(), "isProgressStartNumberInitiatedSuccessfully()");
        boolean found = false;
        this.myProgressStartString = this.myConfiguration.getProgressStart();
        MomAttribute progStartAttribute = this.myMoModel.getMomClass().getAttribute(this.myProgressStartString);
        if (null != progStartAttribute && progStartAttribute.getType().getXmlType().equalsIgnoreCase("long")) {
            found = true;
            this.myProgressStartIsAnAttribute = true;
            MoPropLog.logger().finer("progress start attribute name is: " + progStartAttribute.getName());
        } else {
            try {
                Integer startInteger = Integer.parseInt(this.myProgressStartString);
                this.myProgressStart = startInteger;
                found = true;
            }
            catch (NumberFormatException e) {
                MoPropLog.logger().info("Missing information necesarry to display progress information: " + this.myProgressStartString + " is neither a number, nor a name of an attribute containing a number (defined in the MOM as a long).");
            }
        }
        MoPropLog.logger().exiting(this.getClass().getName(), "isProgressStartNumberInitiatedSuccessfully()", found);
        return found;
    }

    public void stop() {
        MoPropLog.logger().finer("Will stop getting progress attribute values.");
        if (null != this.myAttributePollingTimer) {
            this.myAttributePollingTimer.cancel();
        }
        this.myChangeListeners.clear();
        MoPropLog.logger().exiting(this.getClass().getName(), "stop()");
    }

    public void addMoAttributeProgressListener(ProgressAttributeChangeListener listener) {
        MoPropLog.logger().finer("Adding listener for attribute updates");
        this.myChangeListeners.add(listener);
    }

    public boolean isPreparedForProgressInNumber() {
        MoPropLog.logger().finer("preparedForProgressInNumber is: " + this.preparedForProgressInNumber);
        return this.preparedForProgressInNumber;
    }

    public int getProgressStartNumber() {
        MoPropLog.logger().finer("myProgressStart is: " + this.myProgressStart);
        return this.myProgressStart;
    }

    public int getProgressTotalNumber() {
        MoPropLog.logger().finer("myProgressTotal is: " + this.myProgressTotal);
        return this.myProgressTotal;
    }

    public String getProgressCountAttributeName() {
        MoPropLog.logger().finer("myProgressCountAttribute is: " + this.myProgressCountAttribute);
        return this.myProgressCountAttribute;
    }

    public List<String> getProgressSupervisionAttributes() {
        if (null != this.myAttributeNamesForDisplayInProgressArea) {
            MoPropLog.logger().finer("myAttributeNamesForDisplayInProgressArea size is: " + this.myAttributeNamesForDisplayInProgressArea.size());
        } else {
            MoPropLog.logger().finer("No progress supervision attributes.");
        }
        return this.myAttributeNamesForDisplayInProgressArea;
    }

    private void startTimer(String moLdn) {
        MoPropLog.logger().entering(this.getClass().getName(), "startTimer(String moLdn)", moLdn);
        final TimerTask pollingTask = new TimerTask(){

            public void run() {
                ProgressController.this.getMoAttributes();
            }
        };
        Runnable poller = new Runnable(){

            public void run() {
                ProgressController.this.myLastTimeFetchedNameValues = new LinkedHashMap();
                ProgressController.this.myAttributePollingTimer = new Timer();
                ProgressController.this.myAttributePollingTimer.schedule(pollingTask, 100L, (long)ProgressController.this.myPollperiod);
            }
        };
        new Thread(poller, "ProgressControllerPollingAttributeValuesFor_" + moLdn).start();
    }

    private void getMoAttributes() {
        MoPropLog.logger().finer("getMoAttributes called in EventDispathThread is: " + SwingUtilities.isEventDispatchThread());
        NameValue[] attributes = new NameValue[]{};
        try {
            attributes = this.myMoModel.getMoRef().getAttributes(this.myAttributesToPoll, null);
        }
        catch (Exception exep) {
            MoPropLog.logger().fine("Exception when calling node to get new attribute values for progress display.\nIs the node restarting?\n" + exep.getMessage());
        }
        if (attributes.length > 0) {
            this.myChangedNameValues = new LinkedHashSet();
            this.stopProgressCriteriaFound = false;
            ArrayList<NotifyProperty> attributesToNotify = new ArrayList<NotifyProperty>();
            for (int i = 0; i < attributes.length; ++i) {
                String attrName = attributes[i].getName();
                Object attrValue = attributes[i].getValue();
                MoPropLog.logger().finer("Fetched attribute: " + attrName + " with the value:" + attrValue);
                NotifyProperty attr = null;
                if (this.preparedForProgressInNumber) {
                    attr = this.getAttributeToUpdateForNumberProgress(attributes[i]);
                } else if (this.preparedForProgressIndeterminate) {
                    attr = this.getAttributeToUpdateForIndeterminateProgress(attributes[i]);
                }
                if (attr != null) {
                    attributesToNotify.add(attr);
                }
                if (!this.hasAttributeValueChanged(attributes[i])) continue;
                this.myChangedNameValues.add(attributes[i]);
                attributesToNotify.add(NotifyProperty.NAME_VALUES);
            }
            this.notifyListeners(attributesToNotify);
        }
        MoPropLog.logger().exiting(this.getClass().getName(), "getMoAttributes()");
    }

    private NotifyProperty getAttributeToUpdateForNumberProgress(NameValue attribute) {
        int progressTotal;
        String attrName = attribute.getName();
        if (attrName.equalsIgnoreCase(this.myProgressCountAttribute)) {
            int progress = attribute.getIntValue();
            if (this.myFetchedProgress != progress) {
                this.myFetchedProgress = progress;
                return NotifyProperty.PROGRESS_COUNT;
            }
        } else if (this.myProgressStartIsAnAttribute && attrName.equalsIgnoreCase(this.myProgressStartString)) {
            int progressStart = attribute.getIntValue();
            if (progressStart != this.myProgressStart) {
                this.myProgressStart = progressStart;
                return NotifyProperty.PROGRESS_START;
            }
        } else if (this.myProgressTotalIsAnAttribute && attrName.equalsIgnoreCase(this.myProgressTotalString) && (progressTotal = attribute.getIntValue()) != this.myProgressTotal) {
            this.myProgressTotal = progressTotal;
            return NotifyProperty.PROGRESS_TOTAL;
        }
        return null;
    }

    private NotifyProperty getAttributeToUpdateForIndeterminateProgress(NameValue attribute) {
        ProgressStopExpression expression;
        String attrName = attribute.getName();
        String attrValue = attribute.getValue().toString();
        if (attrName.equalsIgnoreCase(this.myProgressDisplayAttribute)) {
            AttributeModel attrModel = this.myMoModel.getAttributeModel(attrName);
            if (attrModel == null) {
                return null;
            }
            TypeValue typeValue = attrModel.getTypeValue();
            String displayValue = typeValue instanceof EnumTypeValue ? ((EnumTypeValue)typeValue).getEnumMemberDescription() : attrModel.getTypeValue().getValueAsString();
            if (displayValue != null && !displayValue.equals(this.myProgressDisplay)) {
                this.myProgressDisplay = displayValue;
                return NotifyProperty.PROGRESS_DISPLAY;
            }
        } else if (this.myProgressStopExpressions.containsKey(attrName) && (expression = this.myProgressStopExpressions.get(attrName)).isValid(attrValue.toString())) {
            this.stopProgressCriteriaFound = true;
            return NotifyProperty.PROGRESS_STOP;
        }
        return null;
    }

    private boolean hasAttributeValueChanged(NameValue attribute) {
        String attrName = attribute.getName();
        Object attrValue = attribute.getValue();
        boolean result = false;
        if (this.myAttributeNamesForDisplayInProgressArea.contains(attrName)) {
            if (null == this.myLastTimeFetchedNameValues.get(attrName)) {
                if (null != attrValue) {
                    MoPropLog.logger().finer("Discovered changed value. From null to: " + attrValue);
                    result = true;
                }
            } else if (!this.myLastTimeFetchedNameValues.get(attrName).equals(attribute)) {
                MoPropLog.logger().finer("Discovered changed value: " + attrValue);
                result = true;
            }
        }
        this.myLastTimeFetchedNameValues.put(attrName, attribute);
        return result;
    }

    private void notifyListeners(List<NotifyProperty> notifyAttributes) {
        for (ProgressAttributeChangeListener listener : this.myChangeListeners) {
            for (NotifyProperty notifyProperty : notifyAttributes) {
                switch (notifyProperty) {
                    case PROGRESS_COUNT: {
                        listener.updateProgress(this.myFetchedProgress, "" + this.myFetchedProgress);
                        MoPropLog.logger().finer("Notifying listener about new progress count: " + this.myFetchedProgress);
                        break;
                    }
                    case PROGRESS_START: {
                        listener.updateProgressStartNumber(this.myProgressStart);
                        MoPropLog.logger().finer("Notifying listener about new progress start number: " + this.myProgressStart);
                        break;
                    }
                    case PROGRESS_TOTAL: {
                        listener.updateProgressTotalNumber(this.myProgressTotal);
                        MoPropLog.logger().finer("Notifying listener about new progress total number: " + this.myProgressTotal);
                        break;
                    }
                    case NAME_VALUES: {
                        listener.updateAttributes(this.myChangedNameValues);
                        MoPropLog.logger().finer("Notifying listener about new name values");
                        break;
                    }
                    case PROGRESS_DISPLAY: {
                        if (!this.stopProgressCriteriaFound) {
                            listener.updateProgressText(this.myProgressDisplay);
                            MoPropLog.logger().finer("Notifying listener about new progress text: " + this.myProgressDisplay);
                            break;
                        }
                        MoPropLog.logger().finer("New progress text, but progress will/is be stoped: " + this.myProgressDisplay);
                        break;
                    }
                    case PROGRESS_STOP: {
                        if (!this.progressStarted) break;
                        listener.progressStop();
                        MoPropLog.logger().finer("Notifying listener to stop progress");
                        this.progressStarted = false;
                    }
                }
            }
            if (this.stopProgressCriteriaFound || this.progressStarted) continue;
            listener.progressStart(this.myProgressDisplay);
            this.progressStarted = true;
        }
    }

    private boolean isCountProgress() {
        return null != this.myConfiguration.getProgressStart() && this.myConfiguration.getProgressStart() != "" && null != this.myConfiguration.getProgressTotal() && this.myConfiguration.getProgressTotal() != "" && null != this.myConfiguration.getProgressCountAttribute() && this.myConfiguration.getProgressCountAttribute() != "";
    }

    private boolean isInterminateProgress() {
        return this.myConfiguration.getProgressStopAttributes() != null && this.myConfiguration.getProgressDisplayAttribute() != null && this.myConfiguration.getProgressDisplayAttribute() != "";
    }

    public void actionExecuted(boolean actionSucceded) {
        if (this.myAttributePollingTimer != null) {
            this.myAttributePollingTimer.cancel();
        }
        this.startTimer(this.myMoModel.getMoRef().getLdn());
        if (!actionSucceded) {
            ArrayList<NotifyProperty> notifyType = new ArrayList<NotifyProperty>(1);
            notifyType.add(NotifyProperty.PROGRESS_STOP);
            this.notifyListeners(notifyType);
        }
    }

    private class Equals
    implements Operator {
        private Equals() {
        }

        public boolean evaluate(String value1, String value2) {
            return value1.equals(value2);
        }
    }

    private static interface Operator {
        public boolean evaluate(String var1, String var2);
    }

    private class ProgressStopExpression {
        private Operator operator;
        private String value;

        public ProgressStopExpression(Operator operator, String value) {
            this.operator = operator;
            this.value = value;
        }

        public boolean isValid(String otherAttributeValue) {
            return this.operator.evaluate(this.value, otherAttributeValue);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum NotifyProperty {
        PROGRESS_COUNT,
        PROGRESS_START,
        PROGRESS_TOTAL,
        NAME_VALUES,
        PROGRESS_DISPLAY,
        PROGRESS_STOP;

    }
}

