/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emt.motools.common.gui.components;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import se.ericsson.cello.emt.motools.common.gui.components.DataTypeGUI;
import se.ericsson.cello.emt.motools.common.gui.components.EnumComboBoxEditor;
import se.ericsson.cello.emt.motools.common.gui.components.GUI_Container;
import se.ericsson.cello.emt.motools.common.momodel.typevalue.EnumTypeValue;
import se.ericsson.cello.emt.motools.common.toolservices.ToolServices;

public class EnumGUI
extends DataTypeGUI {
    private static final long serialVersionUID = 1L;
    private String myInitialDisplaySymbol = null;
    private String myPreviousDisplaySymbol = null;
    private boolean readOnly;
    private JComboBox valueC = null;
    private JPanel panel;
    private JLabel labelC;
    private JLabel statusC;
    private ComboListener myListener = null;
    private String NOT_SET = "  ";
    private EnumTypeValue myEnumAttrModel = null;
    private JTextField hiddenTextField = null;

    public EnumGUI(EnumTypeValue aAttributeModel, boolean isReadOnly, GUI_Container container, boolean supportNullValue, ToolServices aToolServices) {
        super(aAttributeModel, container, aToolServices);
        this.myEnumAttrModel = aAttributeModel;
        this.readOnly = isReadOnly;
        this.panel = this.getPanel();
        JPanel panel1 = new JPanel(new FlowLayout(0, 0, 0));
        this.panel.add(panel1);
        String[] allSymbolicValues = this.myEnumAttrModel.getAllEnumMemberDisplaySymbols();
        this.valueC = new JComboBox<String>(allSymbolicValues);
        this.valueC.setEditable(true);
        EnumComboBoxEditor myEditor = null;
        if (this.myEnumAttrModel.isValueDefined() && !this.myEnumAttrModel.isValueOutOfRange()) {
            String enumValueAsDisplaySymbol = this.myEnumAttrModel.getEnumValueAsDisplaySymbol();
            myEditor = new EnumComboBoxEditor(enumValueAsDisplaySymbol);
            this.valueC.setSelectedItem(enumValueAsDisplaySymbol);
            this.myInitialDisplaySymbol = enumValueAsDisplaySymbol;
            this.myPreviousDisplaySymbol = enumValueAsDisplaySymbol;
        } else {
            String[] allValues = new String[allSymbolicValues.length + 1];
            allValues[0] = new String(this.NOT_SET);
            int i = 1;
            String[] arr$ = allSymbolicValues;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                String tempString;
                allValues[i] = tempString = arr$[i$];
                ++i;
            }
            myEditor = new EnumComboBoxEditor(allValues[0]);
            this.valueC = new JComboBox<String>(allValues);
            this.valueC.setEditable(true);
            this.valueC.setSelectedItem(allValues[0]);
            this.myInitialDisplaySymbol = allValues[0];
            this.myPreviousDisplaySymbol = allValues[0];
        }
        this.hiddenTextField = new JTextField();
        if (this.readOnly) {
            this.setOpaque(false);
            this.setBorder(null);
            myEditor.setBackgroundColor(myEditor.getEditorComponent().getBackground());
        } else {
            myEditor.setBackgroundColor(this.hiddenTextField.getBackground());
        }
        this.valueC.setEditor(myEditor);
        this.valueC.setSize(this.valueC.getPreferredSize());
        this.valueC.setName("valueField");
        panel1.add((Component)this.valueC, "West");
        this.myListener = new ComboListener();
        this.valueC.addActionListener(this.myListener);
        Integer enumIntegerValue = null;
        if (this.myEnumAttrModel.getNameValue() != null) {
            enumIntegerValue = this.myEnumAttrModel.getNameValue().getIntegerValue();
        }
        if (!this.myEnumAttrModel.isValueDefined()) {
            if (!supportNullValue) {
                this.statusC = new JLabel(" Value is not defined.");
                panel1.add(this.statusC);
            }
        } else {
            this.labelC = new JLabel("[" + enumIntegerValue + "]");
            panel1.add(this.labelC);
            if (this.myEnumAttrModel.isValueOutOfRange()) {
                this.statusC = new JLabel(" Value " + enumIntegerValue + " is out of range.");
                panel1.add(this.statusC);
            } else {
                this.labelC.setToolTipText("Current numeric value");
            }
        }
    }

    public boolean addItem(String newitem) {
        try {
            this.valueC.addItem(newitem);
            return true;
        }
        catch (Exception x) {
            return false;
        }
    }

    public boolean removeItem(String obsoleteitem) {
        try {
            this.valueC.removeItem(obsoleteitem);
            return true;
        }
        catch (Exception x) {
            return false;
        }
    }

    public void setGUIEditable(boolean editable) {
        this.readOnly = !editable;
        this.updateEnumComboBox(this.readOnly);
    }

    public boolean faultyValueEntered() {
        return this.valueC != null && this.getValue().equals(this.NOT_SET) && !this.readOnly;
    }

    private void updateEnumComboBox(boolean readOnly) {
        EnumComboBoxEditor myEditor = (EnumComboBoxEditor)this.valueC.getEditor();
        if (myEditor == null) {
            return;
        }
        if (readOnly) {
            myEditor.setBackgroundColor(myEditor.getEditorComponent().getBackground());
        } else {
            myEditor.setBackgroundColor(this.hiddenTextField.getBackground());
        }
        myEditor.getEditorComponent().invalidate();
    }

    protected void finalize() throws Throwable {
        try {
            this.valueC.removeActionListener(this.myListener);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public String getValue() {
        String displaySymbol = (String)this.valueC.getSelectedItem();
        return displaySymbol;
    }

    public void setValue(String displaySymbol) {
        this.valueC.setSelectedItem(displaySymbol);
        this.valueC.setForeground(this.hiddenTextField.getForeground());
        this.myPreviousDisplaySymbol = this.myInitialDisplaySymbol = (String)this.valueC.getSelectedItem();
        this.setModified(false);
        this.getPanel().validate();
    }

    public void verifyInput() {
        String selectedDisplaySymbol = (String)this.valueC.getSelectedItem();
        if (!selectedDisplaySymbol.equals(this.myPreviousDisplaySymbol)) {
            if (this.readOnly) {
                this.valueC.setSelectedItem(this.myInitialDisplaySymbol);
            } else {
                this.setModified(true);
                this.myPreviousDisplaySymbol = selectedDisplaySymbol;
                this.getPanel().validate();
            }
        }
    }

    public String applyValue() {
        this.myEnumAttrModel.setEnumValueByDisplaySymbol(this.getValue());
        return this.getValue();
    }

    class ComboListener
    implements ActionListener {
        ComboListener() {
        }

        public void actionPerformed(ActionEvent e) {
            EnumGUI.this.verifyInput();
        }
    }
}

