/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emt.motools.common.momodel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.logging.Level;
import se.ericsson.cello.emt.moproperties.MoPropLog;
import se.ericsson.cello.emt.motools.common.mimparser.MimCompatibility;
import se.ericsson.cello.emt.motools.common.momodel.ActionModel;
import se.ericsson.cello.emt.motools.common.momodel.ActionModelImpl;
import se.ericsson.cello.emt.motools.common.momodel.AttributeModel;
import se.ericsson.cello.emt.motools.common.momodel.AttributeModelImpl;
import se.ericsson.cello.emt.motools.common.momodel.MoModel;
import se.ericsson.cello.emt.motools.common.momodel.typevalue.TypeValue;
import se.ericsson.cello.emt.motools.common.momodel.typevalue.TypeValueFactory;
import se.ericsson.cello.mimparser.MimModel;
import se.ericsson.cello.mimparser.MomAction;
import se.ericsson.cello.mimparser.MomAttribute;
import se.ericsson.cello.mimparser.MomClass;
import se.ericsson.cello.mimparser.MomEntity;
import se.ericsson.cello.neal.Node;
import se.ericsson.cello.neal.cm.CmException;
import se.ericsson.cello.neal.cm.Mo;
import se.ericsson.cello.neal.cm.NameValue;
import se.ericsson.cello.neal.cm.Transaction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MoModelImpl
implements MoModel {
    private static final String PM_ATTR_PREFIX = "pm";
    private static final String PM_ATTR_GROUP_NAME = "PM Counters";
    private String myLDN = null;
    private Mo myMoRef = null;
    private MomClass myMomClass = null;
    private List<AttributeModel> myOrdinaryAttrModelList = null;
    private List<ActionModel> myActionModelList = null;
    private Node myNode = null;
    private MimModel myMimModel = null;
    private Transaction myNullTx = null;
    private List<String> myOrdinaryAttrNames = new ArrayList<String>(0);
    private List<String> mySelectedAttributeNames = null;
    private boolean myShowAttrsOnly = false;
    private String mySelectedActionName = null;
    private boolean myShowOnlySpecifiedAction = false;
    private List<String> nameListOfAttributesInMom = null;
    private TreeMap<String, List<String>> myGroupedAttributeNames = new TreeMap();
    private TreeMap<String, List<AttributeModel>> myGroupedAttributeModels = new TreeMap();

    public MoModelImpl(String aLDN, Node aNode, MimModel aMimParserMimModel) {
        this(aLDN, aNode, aMimParserMimModel, null);
    }

    public MoModelImpl(String aLDN, Node aNode, MimModel aMimParserMimModel, List<String> selectedAttributeNames) {
        this(aLDN, aNode, aMimParserMimModel, selectedAttributeNames, null);
    }

    public MoModelImpl(String aLDN, Node aNode, MimModel aMimParserMimModel, List<String> selectedAttributeNames, String selectedActionName) {
        this.myLDN = aLDN;
        this.myNode = aNode;
        this.myMimModel = aMimParserMimModel;
        this.mySelectedAttributeNames = selectedAttributeNames;
        this.mySelectedActionName = selectedActionName;
        this.init();
    }

    private void init() {
        if (this.myLDN == null || this.myNode == null || this.myMimModel == null) {
            throw new RuntimeException("SW Error: init(): (myLDN==null) || (myNode==null) || (myMimModel==null)");
        }
        this.myMoRef = this.myNode.getCmService().getMo(this.myLDN);
        this.myMomClass = this.myMimModel.getClass(this.myMoRef.getType());
        if (this.myMomClass == null) {
            throw new RuntimeException("The MO class of the LDN " + this.myLDN + " is not specified in the MOM.");
        }
        if (!this.myMoRef.exists()) {
            MoPropLog.logger().log(Level.INFO, "It does not exist any MO with the ldn='" + this.myLDN + "' on the node.");
            throw new RuntimeException("The MO " + this.myLDN + " does not exist.");
        }
        if (this.mySelectedAttributeNames != null && this.mySelectedAttributeNames.size() > 0) {
            this.myShowAttrsOnly = true;
            this.separateOrdinaryAttrsFromGroupedAttrsForSelectedAttrs();
        } else {
            this.separateOrdinaryAttrsFromGroupedAttrsForAllMomAttrs();
        }
        if (this.mySelectedActionName != null && this.mySelectedActionName.length() > 0) {
            this.myShowOnlySpecifiedAction = true;
        }
        this.clearModels();
    }

    private void separateOrdinaryAttrsFromGroupedAttrsForAllMomAttrs() {
        Iterator momAttrIter = this.myMomClass.getAttributes();
        while (momAttrIter.hasNext()) {
            MomAttribute momAttr = (MomAttribute)momAttrIter.next();
            if (MimCompatibility.isInterfaceOnly((MomEntity)momAttr) || MimCompatibility.getObsolete((MomEntity)momAttr) != null) continue;
            String attrName = momAttr.getName();
            String momAttrApplicationTag = momAttr.getApplicationTag();
            this.separateOrdinaryAttributeFromGroupedAttribute(attrName, momAttrApplicationTag);
        }
    }

    private void separateOrdinaryAttrsFromGroupedAttrsForSelectedAttrs() {
        if (this.mySelectedAttributeNames != null) {
            for (String selectedAttrName : this.mySelectedAttributeNames) {
                MomAttribute momAttr = this.myMomClass.getAttribute(selectedAttrName);
                if (momAttr == null) {
                    MoPropLog.logger().log(Level.WARNING, "One or more of the selected attribute was not displayed in the Properties window: " + selectedAttrName);
                    continue;
                }
                if (MimCompatibility.isInterfaceOnly((MomEntity)momAttr) || MimCompatibility.getObsolete((MomEntity)momAttr) != null) continue;
                this.separateOrdinaryAttributeFromGroupedAttribute(momAttr.getName(), momAttr.getApplicationTag());
            }
        }
    }

    private void separateOrdinaryAttributeFromGroupedAttribute(String attrName, String momAttrApplicationTag) {
        if (attrName.startsWith(PM_ATTR_PREFIX)) {
            this.storeAttributeNameInNamedGroup(attrName, PM_ATTR_GROUP_NAME);
        } else if (momAttrApplicationTag != null) {
            String[] attributeAndValue = momAttrApplicationTag.split("=");
            if (attributeAndValue.length < 2 || !attributeAndValue[0].trim().equals("attrGroup")) {
                MoPropLog.logger().info("Unknown applicationTag contents for attribute " + attrName + ": only \"attrGroup=groupName\" is supported. Ignoring.");
            } else {
                this.storeAttributeNameInNamedGroup(attrName, attributeAndValue[1].trim());
            }
        } else {
            this.myOrdinaryAttrNames.add(attrName);
        }
    }

    private void storeAttributeNameInNamedGroup(String attrName, String groupName) {
        List<String> groupAttrNameList = this.myGroupedAttributeNames.get(groupName);
        if (groupAttrNameList != null) {
            groupAttrNameList.add(attrName);
        } else {
            ArrayList<String> newAttrNameList = new ArrayList<String>(0);
            newAttrNameList.add(attrName);
            this.myGroupedAttributeNames.put(groupName, newAttrNameList);
        }
    }

    @Override
    public List<AttributeModel> getOrdinaryAttributeModels() {
        MoPropLog.logger().log(Level.INFO, "");
        if (this.myOrdinaryAttrModelList == null) {
            this.myOrdinaryAttrModelList = this.getAttributeModels(this.myOrdinaryAttrNames);
        }
        return this.myOrdinaryAttrModelList;
    }

    @Override
    public List<AttributeModel> getAttributeModels(List<String> listOfAttrNames) {
        MoPropLog.logger().log(Level.INFO, "");
        if (!this.myMoRef.exists()) {
            throw new RuntimeException("The MO " + this.myLDN + " does not exist.");
        }
        List<AttributeModel> resultList = null;
        try {
            resultList = this.getAttributeModelsAllAtOnce(listOfAttrNames);
        }
        catch (Exception e) {
            MoPropLog.logger().info("Failed to read all attributed in one corba call, error: " + e.getMessage());
            resultList = this.getAttributeModelsOneByOne(listOfAttrNames);
        }
        resultList = this.arrangeAttributeModelOrder(resultList);
        return resultList;
    }

    @Override
    public AttributeModel getAttributeModel(String attributeName) {
        ArrayList<String> attributeNames = new ArrayList<String>();
        attributeNames.add(attributeName);
        List<AttributeModel> attrModelList = this.getAttributeModels(attributeNames);
        if (attrModelList.size() > 0) {
            return attrModelList.get(0);
        }
        return null;
    }

    private List<AttributeModel> getAttributeModelsAllAtOnce(List<String> listOfAttrNames) {
        MoPropLog.logger().log(Level.INFO, "");
        ArrayList<AttributeModel> resultList = new ArrayList<AttributeModel>();
        if (listOfAttrNames != null && listOfAttrNames.size() > 0) {
            Object[] attrNames = listOfAttrNames.toArray(new String[listOfAttrNames.size()]);
            NameValue[] attributesNameValue = null;
            MoPropLog.logger().info("before myMoRef.getAttributes(attrNames, null). attrNames:" + Arrays.toString(attrNames));
            attributesNameValue = this.myMoRef.getAttributes((String[])attrNames, this.myNullTx);
            MoPropLog.logger().info("after myMoRef.getAttributes(attrNames, null)");
            if (attributesNameValue == null || attributesNameValue.length != attrNames.length) {
                MoPropLog.logger().log(Level.INFO, "Failed to retrieve all attributes in one Corba call. ");
                throw new RuntimeException("Failed to read attribute information. The information was corrupt.");
            }
            for (int i = 0; i < attributesNameValue.length; ++i) {
                NameValue attrNameValue = attributesNameValue[i];
                if (attrNameValue == null) {
                    MoPropLog.logger().info("At least one of the attributes is null.");
                    throw new RuntimeException("Failed to retrieve all attributes in one Corba call. At least one of the attributes is null.");
                }
                MomAttribute momAttribute = this.myMomClass.getAttribute(attrNameValue.getName());
                AttributeModel newAttrModel = this.createAttributeModel(momAttribute, attrNameValue, null);
                resultList.add(newAttrModel);
            }
        }
        return resultList;
    }

    private List<AttributeModel> getAttributeModelsOneByOne(List<String> listOfAttrNames) {
        ArrayList<AttributeModel> resultList = new ArrayList<AttributeModel>();
        if (listOfAttrNames != null && listOfAttrNames.size() > 0) {
            Iterator<String> attrNameIter = listOfAttrNames.iterator();
            String attributeErrorText = null;
            while (attrNameIter.hasNext()) {
                String attrName = attrNameIter.next();
                MomAttribute momAttr = this.myMomClass.getAttribute(attrName);
                NameValue attrNameValue = null;
                try {
                    MoPropLog.logger().log(Level.INFO, "before getAttribute for attrName:" + attrName);
                    attrNameValue = this.myMoRef.getAttribute(attrName, this.myNullTx);
                    MoPropLog.logger().log(Level.INFO, "after getAttribute for attrName:" + attrName);
                }
                catch (Exception e) {
                    MoPropLog.logger().log(Level.INFO, "reading of NameValue for the following attr failed: attrName:" + attrName);
                    attributeErrorText = e.getMessage();
                }
                AttributeModel newAttrModel = this.createAttributeModel(momAttr, attrNameValue, attributeErrorText);
                resultList.add(newAttrModel);
            }
        }
        return resultList;
    }

    private AttributeModel createAttributeModel(MomAttribute momAttr, NameValue attrNameValue, String attributeErrorText) {
        TypeValue newTypeValue = TypeValueFactory.createTypeValue((MomEntity)momAttr, attrNameValue, this.myMoRef.getNode().getCmService());
        if (attributeErrorText != null) {
            newTypeValue.setError(attributeErrorText);
        }
        AttributeModelImpl newAttrModel = new AttributeModelImpl(momAttr, newTypeValue);
        return newAttrModel;
    }

    private List<AttributeModel> arrangeAttributeModelOrder(List<AttributeModel> attrModelList) {
        ArrayList<AttributeModel> resultList = new ArrayList<AttributeModel>();
        TreeMap<String, AttributeModel> sortedAttrMap = new TreeMap<String, AttributeModel>();
        if (attrModelList != null && attrModelList.size() > 0) {
            for (AttributeModel attributeModel : attrModelList) {
                sortedAttrMap.put(attributeModel.getName(), attributeModel);
            }
            String moIdAttribute = this.myMomClass.getName() + "Id";
            AttributeModel idAttrModel = (AttributeModel)sortedAttrMap.get(moIdAttribute);
            sortedAttrMap.remove(moIdAttribute);
            resultList.addAll(sortedAttrMap.values());
            if (idAttrModel != null) {
                resultList.add(0, idAttrModel);
            }
        }
        return resultList;
    }

    @Override
    public String getLDN() {
        return this.myLDN;
    }

    @Override
    public Mo getMoRef() {
        return this.myMoRef;
    }

    @Override
    public MomClass getMomClass() {
        return this.myMomClass;
    }

    @Override
    public List<ActionModel> getActionModels() {
        if (this.myActionModelList == null) {
            this.myActionModelList = new ArrayList<ActionModel>();
            if (!this.myShowAttrsOnly) {
                Iterator momActionIter = this.myMomClass.getActions();
                while (momActionIter.hasNext()) {
                    MomAction action = (MomAction)momActionIter.next();
                    if (this.myShowOnlySpecifiedAction && !this.mySelectedActionName.equalsIgnoreCase(action.getName()) || MimCompatibility.isInterfaceOnly((MomEntity)action) || MimCompatibility.getObsolete((MomEntity)action) != null) continue;
                    ActionModelImpl newActionModel = new ActionModelImpl(action, this.myMoRef);
                    this.myActionModelList.add(newActionModel);
                }
            }
        }
        return this.myActionModelList;
    }

    @Override
    public void pushUpdatedAttributeModelValuesToNode() {
        MoPropLog.logger().info("before apply values for myOrdinaryAttrModelList");
        this.applyAttributeModelValues(this.myOrdinaryAttrModelList);
        MoPropLog.logger().info("after apply values for myOrdinaryAttrModelList");
        ArrayList<String> groupNameList = new ArrayList<String>(0);
        groupNameList.addAll(this.myGroupedAttributeNames.keySet());
        for (String currentGroup : groupNameList) {
            MoPropLog.logger().info("before apply values for attribute group: " + currentGroup);
            List<AttributeModel> attrModelListForCurrentGroup = this.myGroupedAttributeModels.get(currentGroup);
            this.applyAttributeModelValues(attrModelListForCurrentGroup);
            MoPropLog.logger().info("after apply values for attribute group: " + currentGroup);
        }
    }

    private void applyAttributeModelValues(List<AttributeModel> attrModelList) {
        if (attrModelList == null || attrModelList.size() <= 0) {
            MoPropLog.logger().info("no attr model to update to node");
        } else {
            ArrayList<AttributeModel> updatedAttributeModels = new ArrayList<AttributeModel>();
            for (AttributeModel anAttrModel : attrModelList) {
                if (!anAttrModel.getTypeValue().isUpdated()) continue;
                updatedAttributeModels.add(anAttrModel);
            }
            MoPropLog.logger().info(" updatedAttributeModels.size() == " + updatedAttributeModels.size());
            if (updatedAttributeModels.size() <= 0) {
                MoPropLog.logger().info("no attribute is updated, ignore to apply values to the node");
            } else {
                NameValue[] updAttrsAsNameValue = new NameValue[updatedAttributeModels.size()];
                Iterator updAttrIter = updatedAttributeModels.iterator();
                int i = 0;
                while (updAttrIter.hasNext()) {
                    AttributeModel anUpdAttrModel = (AttributeModel)updAttrIter.next();
                    NameValue updatedNameValue = anUpdAttrModel.getTypeValue().getNameValue();
                    if (updatedNameValue == null) {
                        MoPropLog.logger().info("The value for the attribute '" + anUpdAttrModel.getName() + "' is not valid. The value is null.");
                        throw new RuntimeException("The value for the attribute '" + anUpdAttrModel.getName() + "' is not defined.");
                    }
                    updAttrsAsNameValue[i] = updatedNameValue;
                    ++i;
                }
                Transaction tx = this.myNode.getCmService().createTransaction();
                try {
                    MoPropLog.logger().log(Level.INFO, " before myMoRef.setAttributes(updAttrsAsNameValue, tx);");
                    this.myMoRef.setAttributes(updAttrsAsNameValue, tx);
                    MoPropLog.logger().log(Level.INFO, " after myMoRef.setAttributes(updAttrsAsNameValue, tx);");
                    MoPropLog.logger().log(Level.INFO, " before tx.commit();");
                    tx.commit();
                    MoPropLog.logger().log(Level.INFO, " after tx.commit();");
                }
                catch (Exception e) {
                    MoPropLog.logger().log(Level.INFO, " failed to set attributes for updated attributes. e.getMessage=" + e.getMessage());
                    try {
                        tx.rollback();
                    }
                    catch (CmException cmEx) {
                        MoPropLog.logger().log(Level.INFO, " not possible to perform transaction rollback");
                    }
                    throw new RuntimeException(e);
                }
            }
        }
    }

    @Override
    public void clearModels() {
        this.myOrdinaryAttrModelList = null;
        this.myGroupedAttributeModels = new TreeMap();
        this.myActionModelList = null;
    }

    @Override
    public String getDescription() {
        String description = this.myMomClass.getDescription();
        if (description == null) {
            return "No information available.";
        }
        return description;
    }

    @Override
    public int getNumberOfOrdinaryAttributes() {
        int nrOfAttrs = 0;
        if (this.myOrdinaryAttrNames != null) {
            nrOfAttrs = this.myOrdinaryAttrNames.size();
        }
        return nrOfAttrs;
    }

    @Override
    public List<String> getAttributeGroupNames() {
        ArrayList<String> resultList = new ArrayList<String>(0);
        resultList.addAll(this.myGroupedAttributeNames.keySet());
        return resultList;
    }

    @Override
    public List<AttributeModel> getGroupedAttributeModels(String attributeGroupName) {
        List<AttributeModel> resultList = new ArrayList<AttributeModel>(0);
        if (attributeGroupName != null) {
            List<AttributeModel> tmpAttrModelList = this.myGroupedAttributeModels.get(attributeGroupName);
            if (tmpAttrModelList != null) {
                resultList = tmpAttrModelList;
            } else {
                List<String> attrNameList = this.myGroupedAttributeNames.get(attributeGroupName);
                if (attrNameList != null && attrNameList.size() > 0) {
                    List<AttributeModel> newAttrModelList = this.getAttributeModels(attrNameList);
                    this.myGroupedAttributeModels.put(attributeGroupName, newAttrModelList);
                    resultList = newAttrModelList;
                } else {
                    MoPropLog.logger().info("the group name is not valid: " + attributeGroupName);
                }
            }
        }
        return resultList;
    }

    @Override
    public int getNumberOfAttributesForGroup(String attributeGroupName) {
        List<String> attrListForThisGroup;
        int nrOfAttrsForThisGroup = 0;
        if (attributeGroupName != null && (attrListForThisGroup = this.myGroupedAttributeNames.get(attributeGroupName)) != null) {
            nrOfAttrsForThisGroup = attrListForThisGroup.size();
        }
        return nrOfAttrsForThisGroup;
    }

    @Override
    public boolean areAttributesValid(List<String> listOfAttrNames) {
        boolean ok = true;
        List<String> momAttrs = this.getAllMomAttrsList();
        Iterator<String> iter = listOfAttrNames.iterator();
        while (iter.hasNext()) {
            if (momAttrs.contains(iter.next())) continue;
            ok = false;
            break;
        }
        return ok;
    }

    @Override
    public List<String> getAllMomAttrsList() {
        if (this.nameListOfAttributesInMom == null) {
            this.nameListOfAttributesInMom = new ArrayList<String>();
            Iterator momAttrIter = this.myMomClass.getAttributes();
            while (momAttrIter.hasNext()) {
                MomAttribute momAttr = (MomAttribute)momAttrIter.next();
                String attrName = momAttr.getName();
                this.nameListOfAttributesInMom.add(attrName);
            }
        }
        return this.nameListOfAttributesInMom;
    }
}

