/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emt.motools.common.momodel;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import se.ericsson.cello.emt.moadd.MoAddLog;
import se.ericsson.cello.emt.moproperties.MoPropLog;
import se.ericsson.cello.emt.motools.common.momodel.AttributeModel;
import se.ericsson.cello.emt.motools.common.momodel.MoTemplate;
import se.ericsson.cello.emt.motools.common.momodel.MoTemplateImpl;
import se.ericsson.cello.emt.motools.common.momodel.ParentMo;
import se.ericsson.cello.emt.nodeservices.NodeServices;
import se.ericsson.cello.mimparser.MimModel;
import se.ericsson.cello.mimparser.MomClass;
import se.ericsson.cello.neal.Node;
import se.ericsson.cello.neal.cm.CmException;
import se.ericsson.cello.neal.cm.Mo;
import se.ericsson.cello.neal.cm.NameValue;
import se.ericsson.cello.neal.cm.Transaction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParentMoImpl
implements ParentMo {
    private NodeServices nodeServices;
    private List<MoTemplate> moTemplates = null;
    private MimModel myMimModel = null;
    private Node myNode = null;
    private final int TRANSACTION_TIMEOUT = 1800000;

    public ParentMoImpl(NodeServices nodeServices, String ldn) {
        this.nodeServices = nodeServices;
        this.myMimModel = nodeServices.getMimModel();
        this.myNode = nodeServices.getNode();
    }

    @Override
    public Mo getMoRef(String ldn) {
        return this.nodeServices.getNode().getCmService().getMo(ldn);
    }

    @Override
    public MomClass getMomClass(String momClass) {
        if (this.nodeServices.getMimModel().findClasses(momClass).hasNext()) {
            return (MomClass)this.nodeServices.getMimModel().findClasses(momClass).next();
        }
        return null;
    }

    @Override
    public List<MoTemplate> getPossibleChildrenMOs(String parentLdn) {
        MomClass classToValidate = this.myMimModel.getClass(this.getMoRef(parentLdn).getType());
        MoAddLog.logger().log(Level.FINE, "Get the possible children");
        TreeMap<String, MoTemplateImpl> sortedAttrMap = new TreeMap<String, MoTemplateImpl>();
        this.moTemplates = new ArrayList<MoTemplate>();
        if (classToValidate != null) {
            Iterator children = classToValidate.getContainmentChildren();
            while (children.hasNext()) {
                MomClass child = (MomClass)children.next();
                MoTemplateImpl newMoTemplate = new MoTemplateImpl(child, this.myNode.getCmService());
                sortedAttrMap.put(newMoTemplate.getName(), newMoTemplate);
            }
            this.moTemplates.addAll(sortedAttrMap.values());
        }
        return this.moTemplates;
    }

    @Override
    public Mo createChild(MoTemplate moTemplate, String moToCreateId, String parentLdn, Mo sourceMo) {
        String type = moTemplate.getName();
        Mo moRef = this.getMoRef(parentLdn);
        List<AttributeModel> attributeModelList = null;
        attributeModelList = sourceMo == null ? moTemplate.getDefaultAttributeModels() : moTemplate.getAttributeModelsWithSrcLdnValue(sourceMo);
        ArrayList<NameValue> nameValueList = new ArrayList<NameValue>();
        for (AttributeModel currentAttributeModel : attributeModelList) {
            if (sourceMo != null && !currentAttributeModel.isReadOnly()) {
                nameValueList.add(currentAttributeModel.getTypeValue().getNameValue());
                continue;
            }
            if (currentAttributeModel.getMomAttribute().isMandatory()) {
                nameValueList.add(currentAttributeModel.getTypeValue().getNameValue());
                continue;
            }
            if (currentAttributeModel.getMomAttribute().isRestricted() && currentAttributeModel.getTypeValue().isUpdated()) {
                nameValueList.add(currentAttributeModel.getTypeValue().getNameValue());
                continue;
            }
            if (currentAttributeModel.isReadOnly() || !currentAttributeModel.getTypeValue().isUpdated()) continue;
            nameValueList.add(currentAttributeModel.getTypeValue().getNameValue());
        }
        Mo child = null;
        Transaction tx = this.myNode.getCmService().createTransaction(1800000);
        try {
            MoPropLog.logger().fine("Creating  " + type + "=" + moToCreateId);
            child = moRef.createChild(moToCreateId, type, nameValueList.toArray(new NameValue[0]), tx);
            tx.commit();
        }
        catch (Exception e) {
            MoPropLog.logger().log(Level.INFO, " failed to set attributes for updated attributes. e.getMessage=" + e.getMessage());
            try {
                tx.rollback();
            }
            catch (CmException cmEx) {
                MoPropLog.logger().log(Level.INFO, " not possible to perform transaction rollback");
            }
            throw new RuntimeException(e);
        }
        return child;
    }

    @Override
    public boolean isValidParentLdn(String parentLdn, String sourceLdn) {
        String possibleParentTypeLdn = null;
        if (parentLdn.endsWith(",")) {
            return false;
        }
        if (sourceLdn != null && !this.isChildPossible(sourceLdn, parentLdn)) {
            return false;
        }
        String[] typeLdnsFromLdn = null;
        typeLdnsFromLdn = parentLdn.split(",");
        for (int i = 0; i < typeLdnsFromLdn.length; ++i) {
            String typeLdnToValidate = typeLdnsFromLdn[i];
            if (this.validateFormatOnLdnString(typeLdnToValidate)) {
                if (i == 0) {
                    if (!typeLdnToValidate.equals("ManagedElement=1")) {
                        return false;
                    }
                    possibleParentTypeLdn = typeLdnToValidate;
                    continue;
                }
                if (!this.isChildPossible(typeLdnToValidate, possibleParentTypeLdn)) {
                    return false;
                }
                possibleParentTypeLdn = possibleParentTypeLdn + "," + typeLdnToValidate;
                continue;
            }
            return false;
        }
        return true;
    }

    private boolean isChildPossible(String possibleChildLdn, String possibleParentLdn) {
        List<MoTemplate> possibleChildren = this.getPossibleChildrenMOs(possibleParentLdn);
        if (possibleChildren.size() > 0) {
            for (MoTemplate template : possibleChildren) {
                if (!template.getName().equals(this.getMoRef(possibleChildLdn).getType())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean validateFormatOnLdnString(String ldn) {
        String patternStr = "([^=,]+)=([^=,]+)";
        Pattern pattern = Pattern.compile(patternStr);
        Matcher matcher = pattern.matcher(ldn);
        return matcher.find();
    }
}

