/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.config;

import org.apache.avalon.framework.configuration.ConfigurationException;
import org.jacorb.config.Configuration;
import org.jacorb.config.DelegatingConfiguration;
import org.jacorb.orb.CDRInputStreamConfiguration;
import org.jacorb.orb.CDROutputStreamConfiguration;
import org.jacorb.orb.DelegateConfiguration;
import org.jacorb.orb.ReplyReceiverConfiguration;
import org.jacorb.util.ObjectUtil;

public class CDRStreamConfiguration
extends DelegatingConfiguration {
    private Object cdrInConfig;
    private Object cdrOutConfig;
    private Object replyReceiverConfig;
    private Object delegateConfig;
    private Class mutatorClass;

    public CDRStreamConfiguration(Configuration delegate) {
        super(delegate);
    }

    public void setAttribute(String key, String value) {
        super.setAttribute(key, value);
        this.cdrInConfig = null;
        this.cdrOutConfig = null;
        this.replyReceiverConfig = null;
        this.delegateConfig = null;
        this.mutatorClass = null;
    }

    public Object getAttributeAsObject(String key, String defaultValue) throws ConfigurationException {
        if (key == "jacorb.orb.delegate.config" && defaultValue == DelegateConfiguration.DEFAULT) {
            if (this.delegateConfig == null) {
                this.delegateConfig = super.getAttributeAsObject(key, defaultValue);
            }
            return this.delegateConfig;
        }
        if (key == "jacorb.orb.cdr.in.config" && defaultValue == CDRInputStreamConfiguration.CONFIG_DEFAULT) {
            if (this.cdrInConfig == null) {
                this.cdrInConfig = super.getAttributeAsObject(key, defaultValue);
            }
            return this.cdrInConfig;
        }
        if (key == "jacorb.orb.cdr.out.config" && defaultValue == CDROutputStreamConfiguration.CONFIG_DEFAULT) {
            if (this.cdrOutConfig == null) {
                this.cdrOutConfig = super.getAttributeAsObject(key, defaultValue);
            }
            return this.cdrOutConfig;
        }
        if (key == "jacorb.orb.reply_receiver.config" && defaultValue == ReplyReceiverConfiguration.DEFAULT) {
            if (this.replyReceiverConfig == null) {
                this.replyReceiverConfig = super.getAttributeAsObject(key, defaultValue);
            }
            return this.replyReceiverConfig;
        }
        return super.getAttributeAsObject(key, defaultValue);
    }

    public Object getAttributeAsObject(String key) throws ConfigurationException {
        if ("jacorb.iormutator".equals(key)) {
            String className = this.getAttribute(key);
            if (this.mutatorClass == null || this.mutatorClass.getName() != null && !this.mutatorClass.getName().equals(className)) {
                try {
                    this.mutatorClass = ObjectUtil.classForName(className);
                }
                catch (Exception e2) {
                    throw new ConfigurationException("Unable to build class from key >" + key + "<: " + e2);
                }
                if (this.mutatorClass == null) {
                    throw new ConfigurationException("Unable to build class from key >" + key + "< with value: " + className);
                }
            }
            try {
                return this.mutatorClass.newInstance();
            }
            catch (Exception e3) {
                throw new ConfigurationException("Unable to instantiate object from key >" + key + "< with value '" + className + "':" + e3);
            }
        }
        return super.getAttributeAsObject(key);
    }
}

