/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.imrutility.imr.persistence;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.config.Configuration;
import org.jacorb.imrutility.imr.persistence.RepositoryData;

public class FilePersistence {
    private File outputFile;
    protected Logger logger;
    private String dataFile;

    public FilePersistence(Configuration configuration) throws ConfigurationException {
        this.logger = configuration.getNamedLogger("jacorb.imr");
        this.dataFile = configuration.getAttribute("jacorb.imr.imr_data_file", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public RepositoryData read() {
        RepositoryData repData;
        block27: {
            block32: {
                IOException ioe2;
                FileInputStream fi;
                ObjectInputStream ois;
                block24: {
                    block23: {
                        repData = null;
                        if (this.dataFile == null) break block32;
                        File f2 = new File(this.dataFile);
                        ois = null;
                        fi = null;
                        if (!f2.exists()) break block23;
                        fi = new FileInputStream(f2);
                        ois = new ObjectInputStream(fi);
                        repData = (RepositoryData)ois.readObject();
                    }
                    Object var7_5 = null;
                    if (fi == null) break block24;
                    try {
                        fi.close();
                    }
                    catch (IOException ioe2) {
                        this.logger.debug("Caught closing stream", ioe2);
                    }
                    fi = null;
                }
                if (ois == null) break block27;
                try {
                    ois.close();
                }
                catch (IOException ioe2) {
                    this.logger.debug("Caught closing stream", ioe2);
                }
                ois = null;
                {
                    break block27;
                    catch (IOException ioe3) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.warn("WARNING: Unable to read ImR data file " + this.dataFile + "! ", ioe3);
                        }
                        Object var7_6 = null;
                        if (fi != null) {
                            try {
                                fi.close();
                            }
                            catch (IOException ioe2) {
                                this.logger.debug("Caught closing stream", ioe2);
                            }
                            fi = null;
                        }
                        if (ois == null) break block27;
                        try {
                            ois.close();
                        }
                        catch (IOException ioe2) {
                            this.logger.debug("Caught closing stream", ioe2);
                        }
                        ois = null;
                        break block27;
                    }
                    catch (ClassNotFoundException cnfe) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.warn("WARNING: ImR data file " + this.dataFile + " does not contain valid object" + "! ");
                        }
                        Object var7_7 = null;
                        if (fi != null) {
                            try {
                                fi.close();
                            }
                            catch (IOException ioe2) {
                                this.logger.debug("Caught closing stream", ioe2);
                            }
                            fi = null;
                        }
                        if (ois == null) break block27;
                        try {
                            ois.close();
                        }
                        catch (IOException ioe2) {
                            this.logger.debug("Caught closing stream", ioe2);
                        }
                        ois = null;
                        break block27;
                    }
                }
                catch (Throwable throwable) {
                    Object var7_8 = null;
                    if (fi != null) {
                        try {
                            fi.close();
                        }
                        catch (IOException ioe2) {
                            this.logger.debug("Caught closing stream", ioe2);
                        }
                        fi = null;
                    }
                    if (ois != null) {
                        try {
                            ois.close();
                        }
                        catch (IOException ioe2) {
                            this.logger.debug("Caught closing stream", ioe2);
                        }
                        ois = null;
                    }
                    throw throwable;
                }
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.warn("WARNING: ImR data file name not configured! ");
            }
        }
        if (repData == null) {
            repData = new RepositoryData();
        }
        return repData;
    }

    public void write(RepositoryData repData) {
        block5: {
            if (this.outputFile == null) {
                if (this.dataFile == null && this.logger.isDebugEnabled()) {
                    this.logger.warn("WARNING: ImR data file name not configured creating \"data.dat\" in current directory, ");
                    this.dataFile = "data.dat";
                }
                this.outputFile = new File(this.dataFile);
                if (!this.outputFile.exists()) {
                    try {
                        this.outputFile.createNewFile();
                    }
                    catch (IOException ioe) {
                        if (!this.logger.isDebugEnabled()) break block5;
                        this.logger.error("Unable to create ImR data file " + this.dataFile, ioe);
                        System.exit(-1);
                    }
                }
            }
        }
        this.write(this.outputFile, repData);
    }

    public void backup(RepositoryData repData) {
        boolean write = true;
        if (this.dataFile != null) {
            File f2;
            block5: {
                f2 = new File(this.dataFile);
                if (!f2.exists()) {
                    try {
                        f2.createNewFile();
                    }
                    catch (IOException ioe) {
                        if (!this.logger.isDebugEnabled()) break block5;
                        this.logger.warn("Unable to create ImR backup data file " + this.dataFile, ioe);
                        write = false;
                    }
                }
            }
            if (write) {
                this.write(f2, repData);
            }
        }
    }

    private void write(File file, RepositoryData repData) {
        ObjectOutputStream oos;
        block2: {
            oos = null;
            repData.lock.getLock(1);
            try {
                oos = new ObjectOutputStream(new FileOutputStream(file));
                oos.writeObject(repData);
                oos.flush();
                oos.close();
            }
            catch (IOException ioe) {
                if (!this.logger.isDebugEnabled()) break block2;
                this.logger.warn("Unable to write ImR data to file " + file.getName(), ioe);
            }
        }
        repData.lock.releaseLock(1);
        oos = null;
    }
}

