/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.ir;

import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.logger.Logger;
import org.omg.CORBA.ORB;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;

public class TypeCodeUtil {
    private static final Map cache = new HashMap();

    public static TypeCode getTypeCode(Class c2, Object o2, Logger logger) throws ClassNotFoundException {
        return TypeCodeUtil.getTypeCode(c2, null, o2, null, logger);
    }

    public static TypeCode getTypeCode(Class c2, ClassLoader classLoader, Object o2, String idlName, Logger logger) throws ClassNotFoundException {
        String typeName = c2.getName();
        if (logger.isDebugEnabled()) {
            logger.debug("TypeCodes.getTypeCode for class : " + typeName + " idlName: " + idlName);
        }
        ClassLoader loader = classLoader != null ? classLoader : c2.getClassLoader();
        TypeCode _tc = (TypeCode)cache.get(typeName);
        if (_tc != null) {
            return _tc;
        }
        if (idlName != null && (_tc = (TypeCode)cache.get(idlName)) != null) {
            return _tc;
        }
        if (c2.isPrimitive()) {
            if (typeName.equals("void")) {
                return ORB.init().get_primitive_tc(TCKind.tk_void);
            }
            if (typeName.equals("int")) {
                return ORB.init().get_primitive_tc(TCKind.tk_long);
            }
            if (typeName.equals("long")) {
                return ORB.init().get_primitive_tc(TCKind.tk_longlong);
            }
            if (typeName.equals("short")) {
                return ORB.init().get_primitive_tc(TCKind.tk_short);
            }
            if (typeName.equals("float")) {
                return ORB.init().get_primitive_tc(TCKind.tk_float);
            }
            if (typeName.equals("double")) {
                return ORB.init().get_primitive_tc(TCKind.tk_double);
            }
            if (typeName.equals("boolean")) {
                return ORB.init().get_primitive_tc(TCKind.tk_boolean);
            }
            if (typeName.equals("byte")) {
                return ORB.init().get_primitive_tc(TCKind.tk_octet);
            }
            if (typeName.equals("char")) {
                return ORB.init().get_primitive_tc(TCKind.tk_char);
            }
            if (typeName.equals("wchar")) {
                return ORB.init().get_primitive_tc(TCKind.tk_wchar);
            }
            System.err.println("- TypeCode.getTypeCode, primitive class not found " + typeName);
            return null;
        }
        Class<?> tcClass = null;
        Class<?> idlEntity = null;
        try {
            tcClass = Class.forName("org.omg.CORBA.TypeCode", true, loader);
            idlEntity = Class.forName("org.omg.CORBA.portable.IDLEntity", true, loader);
        }
        catch (ClassNotFoundException ce) {
            logger.fatalError("Can't load org.jacorb base classes!", ce);
            throw ce;
        }
        if (tcClass.isAssignableFrom(c2)) {
            return ORB.init().get_primitive_tc(TCKind.tk_TypeCode);
        }
        if (idlName != null && idlName.length() > 0) {
            try {
                if (idlName.equals("java.lang.String")) {
                    return ORB.init().get_primitive_tc(TCKind.tk_string);
                }
                if (idlName.equals("org.omg.CORBA.Boolean")) {
                    return ORB.init().get_primitive_tc(TCKind.tk_boolean);
                }
                if (idlName.equals("org.omg.CORBA.Byte")) {
                    return ORB.init().get_primitive_tc(TCKind.tk_octet);
                }
                if (idlName.equals("org.omg.CORBA.Short")) {
                    return ORB.init().get_primitive_tc(TCKind.tk_short);
                }
                if (idlName.equals("org.omg.CORBA.Long")) {
                    return ORB.init().get_primitive_tc(TCKind.tk_longlong);
                }
                if (idlName.equals("org.omg.CORBA.Int")) {
                    return ORB.init().get_primitive_tc(TCKind.tk_long);
                }
                if (idlName.equals("org.omg.CORBA.String")) {
                    return ORB.init().get_primitive_tc(TCKind.tk_string);
                }
                if (idlName.equals("org.omg.CORBA.Char")) {
                    return ORB.init().get_primitive_tc(TCKind.tk_char);
                }
                if (idlName.equals("org.omg.CORBA.Float")) {
                    return ORB.init().get_primitive_tc(TCKind.tk_float);
                }
                if (idlName.equals("org.omg.CORBA.Double")) {
                    return ORB.init().get_primitive_tc(TCKind.tk_double);
                }
                if (idlName.equals("org.omg.CORBA.Any")) {
                    return ORB.init().get_primitive_tc(TCKind.tk_any);
                }
                if (idlName.equals("org.omg.CORBA.Object")) {
                    return ORB.init().get_primitive_tc(TCKind.tk_objref);
                }
                if (idlName.equals("org.omg.CORBA.TypeCode")) {
                    return ORB.init().get_primitive_tc(TCKind.tk_TypeCode);
                }
                Class<?> type = Class.forName(idlName + "Helper", true, loader);
                return (TypeCode)type.getDeclaredMethod("type", null).invoke(null, (Object[])null);
            }
            catch (ClassNotFoundException cnfe) {
                logger.debug("Caught Exception", cnfe);
                throw new RuntimeException("Could not create TypeCode for: " + c2.getName() + ", no helper class for " + idlName);
            }
            catch (Exception e2) {
                logger.error("Caught Exception", e2);
            }
        }
        if (idlEntity.isAssignableFrom(c2)) {
            try {
                Class<?> resultHelperClass = Class.forName(c2.getName() + "Helper", true, loader);
                return (TypeCode)resultHelperClass.getDeclaredMethod("type", null).invoke(null, (Object[])null);
            }
            catch (Exception cnfe) {
                logger.error("Caught Exception", cnfe);
                throw new RuntimeException("Could not create TypeCode for: " + c2.getName());
            }
        }
        throw new RuntimeException("Could not create TypeCode for: " + c2.getName() + ", not an IDLEntity");
    }

    static {
        cache.put("java.lang.String", ORB.init().get_primitive_tc(TCKind.tk_string));
        cache.put("org.omg.CORBA.String", ORB.init().get_primitive_tc(TCKind.tk_string));
        cache.put("java.lang.Void", ORB.init().get_primitive_tc(TCKind.tk_void));
        cache.put("java.lang.Long", ORB.init().get_primitive_tc(TCKind.tk_longlong));
        cache.put("java.lang.Integer", ORB.init().get_primitive_tc(TCKind.tk_long));
        cache.put("java.lang.Short", ORB.init().get_primitive_tc(TCKind.tk_short));
        cache.put("java.lang.Float", ORB.init().get_primitive_tc(TCKind.tk_float));
        cache.put("java.lang.Double", ORB.init().get_primitive_tc(TCKind.tk_double));
        cache.put("java.lang.Boolean", ORB.init().get_primitive_tc(TCKind.tk_boolean));
        cache.put("java.lang.Byte", ORB.init().get_primitive_tc(TCKind.tk_octet));
        cache.put("org.omg.CORBA.Any", ORB.init().get_primitive_tc(TCKind.tk_any));
        cache.put("java.lang.Character", ORB.init().get_primitive_tc(TCKind.tk_char));
        cache.put("org.omg.CORBA.TypeCode", ORB.init().get_primitive_tc(TCKind.tk_TypeCode));
        cache.put("org.omg.CORBA.Object", ORB.init().get_primitive_tc(TCKind.tk_objref));
    }
}

