/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.CDRInputStream;
import org.jacorb.orb.CDROutputStream;
import org.jacorb.orb.Delegate;
import org.jacorb.orb.ORB;
import org.jacorb.orb.ParsedIOROperations;
import org.jacorb.orb.ProfileSelector;
import org.jacorb.orb.TaggedComponentList;
import org.jacorb.orb.etf.ProfileBase;
import org.jacorb.orb.util.CorbaLoc;
import org.jacorb.orb.util.PrintIOR;
import org.jacorb.util.ObjectUtil;
import org.omg.CONV_FRAME.CodeSetComponentInfo;
import org.omg.CONV_FRAME.CodeSetComponentInfoHelper;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.Object;
import org.omg.CORBA.UNKNOWN;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextExtHelper;
import org.omg.ETF.Factories;
import org.omg.ETF.Profile;
import org.omg.FT.TagFTGroupTaggedComponent;
import org.omg.FT.TagFTHeartbeatEnabledTaggedComponent;
import org.omg.FT.TagFTHeartbeatEnabledTaggedComponentHelper;
import org.omg.GIOP.IORAddressingInfo;
import org.omg.GIOP.TargetAddress;
import org.omg.IOP.IOR;
import org.omg.IOP.IORHelper;
import org.omg.IOP.TaggedComponent;
import org.omg.IOP.TaggedComponentSeqHolder;
import org.omg.IOP.TaggedProfile;
import org.omg.IOP.TaggedProfileHolder;

public class ParsedIOR
implements ParsedIOROperations {
    private Profile effectiveProfile = null;
    private final List profiles = new ArrayList();
    private TaggedComponentList components = new TaggedComponentList();
    private ProfileSelector profileSelector;
    protected boolean endianness = false;
    private String ior_str = null;
    private IOR ior = null;
    private final ORB orb;
    private CodeSetComponentInfo cs_info = null;
    private Integer orbTypeId = null;
    private final Logger logger;
    private ObjectOperations objectOperationsDelegate;
    private final Map cookie = new HashMap();
    static /* synthetic */ Class class$org$omg$FT$TagFTGroupTaggedComponentHelper;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IOR createObjectIOR(ORB orb, Profile profile) {
        String repId = "IDL:omg.org/CORBA/Object:1.0";
        TaggedComponentList components = new TaggedComponentList();
        CDROutputStream out = new CDROutputStream(orb);
        try {
            out.beginEncapsulatedArray();
            out.write_long(1245790976);
            components.addComponent(new TaggedComponent(0, out.getBufferCopy()));
        }
        finally {
            out.close();
        }
        ArrayList<TaggedProfile> taggedProfileList = new ArrayList<TaggedProfile>();
        TaggedProfileHolder tp = new TaggedProfileHolder();
        TaggedComponentSeqHolder tcs = new TaggedComponentSeqHolder();
        tcs.value = components.asArray();
        profile.marshal(tp, tcs);
        taggedProfileList.add(tp.value);
        TaggedProfile[] tps = new TaggedProfile[taggedProfileList.size()];
        taggedProfileList.toArray(tps);
        return new IOR(repId, tps);
    }

    public static byte[] extractObjectKey(TargetAddress addr, ORB orb) {
        TaggedProfile tp = null;
        switch (addr.discriminator()) {
            case 0: {
                return addr.object_key();
            }
            case 1: {
                tp = new TaggedProfile(addr.profile().tag, addr.profile().profile_data);
                break;
            }
            case 2: {
                IORAddressingInfo info = addr.ior();
                tp = new TaggedProfile(info.ior.profiles[info.selected_profile_index].tag, info.ior.profiles[info.selected_profile_index].profile_data);
                break;
            }
            default: {
                throw new BAD_PARAM("Invalid value for TargetAddress discriminator");
            }
        }
        TaggedProfileHolder profile = new TaggedProfileHolder(tp);
        Factories profileFactory = orb.getTransportManager().getFactories(tp.tag);
        if (profileFactory != null) {
            return profileFactory.demarshal_profile(profile, null).get_object_key();
        }
        return null;
    }

    public String getCodebaseComponent() {
        return this.getStringComponent(25);
    }

    private ParsedIOR(ORB orb) {
        this.orb = orb;
        this.logger = orb.getConfiguration().getNamedLogger("jacorb.orb.parsedior");
    }

    public ParsedIOR(ORB orb, String object_reference) throws IllegalArgumentException {
        this(orb);
        this.parse(object_reference);
    }

    public ParsedIOR(ORB orb, IOR ior) {
        this(orb);
        this.decode(ior);
    }

    public boolean equals(java.lang.Object other) {
        if (other == null) {
            return false;
        }
        return other instanceof ParsedIOR && ((ParsedIOR)other).getIORString().equals(this.getIORString()) && this.effectiveProfile != null && this.effectiveProfile.is_match(((ParsedIOR)other).effectiveProfile);
    }

    public int hashCode() {
        return this.getIORString().hashCode();
    }

    private void decode(IOR _ior) {
        block3: for (int i2 = 0; i2 < _ior.profiles.length; ++i2) {
            int tag = _ior.profiles[i2].tag;
            switch (tag) {
                case 1: {
                    this.components = new TaggedComponentList(_ior.profiles[i2].profile_data);
                    continue block3;
                }
                default: {
                    Factories factories = this.orb.getTransportManager().getFactories(tag);
                    if (factories != null) {
                        TaggedProfileHolder tp = new TaggedProfileHolder(_ior.profiles[i2]);
                        this.profiles.add(factories.demarshal_profile(tp, new TaggedComponentSeqHolder()));
                        continue block3;
                    }
                    if (!this.logger.isDebugEnabled()) continue block3;
                    this.logger.debug("No transport available for profile tag " + tag);
                    continue block3;
                }
            }
        }
        this.ior = _ior;
        this.initializeObjectOperationsDelegate(this.ior);
        this.setEffectiveProfile();
    }

    private void initializeObjectOperationsDelegate(IOR ior) {
        this.objectOperationsDelegate = this.orb.isIOGR(ior) ? new FTObjectOperations() : new DefaultObjectOperations();
    }

    public CodeSetComponentInfo getCodeSetComponentInfo() {
        return this.cs_info;
    }

    public Integer getORBTypeId() {
        return this.orbTypeId;
    }

    public IOR getIOR() {
        return this.ior;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getIORString() {
        if (this.ior_str == null) {
            try {
                CDROutputStream out = new CDROutputStream(this.orb);
                try {
                    out.beginEncapsulatedArray();
                    IORHelper.write(out, this.ior);
                    byte[] bytes = out.getBufferCopy();
                    StringBuffer sb = new StringBuffer("IOR:");
                    for (int j2 = 0; j2 < bytes.length; ++j2) {
                        ObjectUtil.appendHex(sb, bytes[j2] >> 4 & 0xF);
                        ObjectUtil.appendHex(sb, bytes[j2] & 0xF);
                    }
                    this.ior_str = sb.toString();
                }
                finally {
                    out.close();
                }
            }
            catch (Exception e2) {
                this.logger.error("Error in building IIOP-IOR", e2);
                throw new UNKNOWN("Error in building IIOP-IOR");
            }
        }
        return this.ior_str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getIORString(ORB orb, IOR ior) {
        try {
            byte[] bytes;
            CDROutputStream out = new CDROutputStream(orb);
            try {
                out.beginEncapsulatedArray();
                IORHelper.write(out, ior);
                bytes = out.getBufferCopy();
            }
            finally {
                out.close();
            }
            StringBuffer sb = new StringBuffer("IOR:");
            for (int j2 = 0; j2 < bytes.length; ++j2) {
                ObjectUtil.appendHex(sb, bytes[j2] >> 4 & 0xF);
                ObjectUtil.appendHex(sb, bytes[j2] & 0xF);
            }
            return sb.toString();
        }
        catch (Exception e2) {
            orb.getConfiguration().getNamedLogger("jacorb.orb").error("Error constructing IOR string", e2);
            throw new UNKNOWN("Error in building IIOP-IOR");
        }
    }

    public byte[] get_object_key() {
        return this.effectiveProfile.get_object_key();
    }

    public List getProfiles() {
        return this.profiles;
    }

    public Profile getEffectiveProfile() {
        return this.effectiveProfile;
    }

    private void setEffectiveProfile() {
        String spsVal;
        this.effectiveProfile = this.getProfileSelector().selectProfile(this.profiles, this.orb.getClientConnectionManager(), this.cookie);
        if (this.effectiveProfile != null) {
            this.cs_info = (CodeSetComponentInfo)this.getComponent(1, CodeSetComponentInfoHelper.class);
            this.orbTypeId = this.getLongComponent(0);
        }
        if ((spsVal = System.getProperty("ShowProfileSelection")) != null && spsVal.equals("1")) {
            System.out.println("[JAC824] ParsedIOR.setEffectiveProfile: profile selector class = " + this.getProfileSelector().getClass().getName());
            System.out.println("[JAC824] ParsedIOR.setEffectiveProfile: selected profile class = " + (this.effectiveProfile == null ? "<null>" : this.effectiveProfile.getClass().getName()));
        }
    }

    public boolean selectNextProfile() {
        boolean hasNext = this.getProfileSelector().selectNext(this.cookie);
        if (hasNext) {
            this.setEffectiveProfile();
        }
        return hasNext;
    }

    public String getTypeId() {
        return this.ior.type_id;
    }

    public String getIDString() {
        return this.objectOperationsDelegate.getIDString();
    }

    public TaggedComponentList getMultipleComponents() {
        return this.components;
    }

    public boolean isNull() {
        return ParsedIOR.isNull(this.ior);
    }

    public static boolean isNull(IOR ior) {
        return "".equals(ior.type_id) && ior.profiles.length == 0;
    }

    private void parse(String object_reference) throws IllegalArgumentException {
        if (object_reference == null) {
            throw new IllegalArgumentException("Null object reference");
        }
        if (object_reference.startsWith("IOR:")) {
            this.parse_stringified_ior(object_reference);
        } else if (object_reference.startsWith("corbaloc:")) {
            this.parse_corbaloc(object_reference);
        } else if (object_reference.startsWith("corbaname:")) {
            this.parse_corbaname(object_reference);
        } else if (object_reference.startsWith("resource:")) {
            this.parse_resource(object_reference.substring(9));
        } else if (object_reference.startsWith("jndi:")) {
            this.parse_jndi(object_reference.substring(5));
        } else {
            String content;
            block15: {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Trying to resolve URL/IOR from: " + object_reference);
                }
                content = null;
                try {
                    content = ObjectUtil.readURL(object_reference);
                }
                catch (IOException e2) {
                    if (!this.logger.isDebugEnabled()) break block15;
                    this.logger.debug("Error reading IOR/URL: ", e2);
                }
            }
            if (content == null) {
                throw new BAD_PARAM("Invalid or unreadable URL/IOR: " + object_reference);
            }
            this.parse(content);
        }
    }

    private void parse_stringified_ior(String object_reference) {
        int length = object_reference.length();
        int cnt = (length - 4) / 2;
        if (length % 2 != 0) {
            throw new BAD_PARAM("Odd number of characters within object reference");
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        for (int j2 = 0; j2 < cnt; ++j2) {
            int i1;
            char c1 = object_reference.charAt(j2 * 2 + 4);
            char c2 = object_reference.charAt(j2 * 2 + 5);
            int n2 = c1 >= 'a' ? 10 + c1 - 97 : (i1 = c1 >= 'A' ? 10 + c1 - 65 : c1 - 48);
            int i2 = c2 >= 'a' ? 10 + c2 - 97 : (c2 >= 'A' ? 10 + c2 - 65 : c2 - 48);
            bos.write(i1 * 16 + i2);
        }
        CDRInputStream in_ = new CDRInputStream(this.orb, bos.toByteArray());
        this.endianness = in_.read_boolean();
        if (this.endianness) {
            in_.setLittleEndian(true);
        }
        try {
            IOR _ior = IORHelper.read(in_);
            this.decode(_ior);
        }
        catch (MARSHAL e2) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Invalid IOR", e2);
            }
            throw new BAD_PARAM("Invalid IOR " + e2, 10, CompletionStatus.COMPLETED_NO);
        }
    }

    private void parse_corbaloc(String object_reference) {
        IOR ior;
        CorbaLoc corbaLoc = new CorbaLoc(this.orb, object_reference);
        if (corbaLoc.rir()) {
            try {
                Object obj = this.orb.resolve_initial_references(corbaLoc.getKeyString());
                if (obj == null) {
                    throw new IllegalArgumentException("Unable to resolve reference for " + corbaLoc.getKeyString());
                }
                ior = ((Delegate)((ObjectImpl)obj)._get_delegate()).getIOR();
            }
            catch (Exception e2) {
                this.logger.error("Invalid corbaloc URL " + corbaLoc.getKeyString(), e2);
                throw new IllegalArgumentException("Invalid corbaloc: URL");
            }
        } else {
            Profile profile = corbaLoc.profileList[0];
            if (profile == null) {
                return;
            }
            profile.set_object_key(corbaLoc.getKey());
            ior = ParsedIOR.createObjectIOR(this.orb, profile);
        }
        this.decode(ior);
    }

    private void parse_corbaname(String object_reference) {
        String corbaloc = "corbaloc:";
        String name = "";
        int colon = object_reference.indexOf(58);
        int pound = object_reference.indexOf(35);
        if (pound == -1) {
            corbaloc = corbaloc + object_reference.substring(colon + 1);
        } else {
            corbaloc = corbaloc + object_reference.substring(colon + 1, pound);
            name = object_reference.substring(pound + 1);
        }
        if (corbaloc.indexOf(47) == -1) {
            corbaloc = corbaloc + "/NameService";
        }
        this.logger.debug(corbaloc);
        try {
            NamingContextExt n2 = NamingContextExtHelper.narrow(this.orb.string_to_object(corbaloc));
            IOR ior = null;
            if (name.length() > 0) {
                Object target = n2.resolve_str(name);
                ior = ((Delegate)((ObjectImpl)target)._get_delegate()).getIOR();
            } else {
                ior = ((Delegate)((ObjectImpl)((java.lang.Object)n2))._get_delegate()).getIOR();
            }
            this.decode(ior);
        }
        catch (Exception e2) {
            this.logger.error("Invalid object reference", e2);
            throw new IllegalArgumentException("Invalid object reference: " + object_reference);
        }
    }

    private void parse_resource(String resourceName) {
        URL url;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Trying to resolve URL/IOR from resource: " + resourceName);
        }
        if ((url = ObjectUtil.getResource(resourceName)) == null) {
            throw new IllegalArgumentException("Failed to get resource: " + resourceName);
        }
        try {
            String content = ObjectUtil.readURL(url.toString());
            this.parse(content);
        }
        catch (IOException e2) {
            throw new IllegalArgumentException("Failed to read resource: " + resourceName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parse_jndi(String jndiName) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Trying to resolve JNDI/IOR from name: " + jndiName);
        }
        try {
            Class<?> initialContextClazz = Class.forName("javax.naming.InitialContext");
            java.lang.Object initialContext = initialContextClazz.newInstance();
            try {
                Class[] types = new Class[]{String.class};
                java.lang.Object[] params = new java.lang.Object[]{jndiName};
                Method method = initialContextClazz.getMethod("lookup", types);
                java.lang.Object result = method.invoke(initialContext, params);
                if (result == null) {
                    throw new IllegalArgumentException("Null JNDI/IOR: " + jndiName);
                }
                this.parse(result.toString());
                java.lang.Object var9_9 = null;
            }
            catch (Throwable throwable) {
                java.lang.Object var9_10 = null;
                Method closeMethod = initialContextClazz.getMethod("close", null);
                closeMethod.invoke(initialContext, (java.lang.Object[])null);
                throw throwable;
            }
            Method closeMethod = initialContextClazz.getMethod("close", null);
            closeMethod.invoke(initialContext, (java.lang.Object[])null);
            {
            }
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Failed to lookup JNDI/IOR: " + jndiName + ": " + ex);
        }
    }

    private java.lang.Object getComponent(int tag, Class helper) {
        java.lang.Object result = null;
        if (this.effectiveProfile instanceof ProfileBase && ((ProfileBase)this.effectiveProfile).getComponents() != null) {
            result = ((ProfileBase)this.effectiveProfile).getComponent(tag, helper);
        }
        if (result != null) {
            return result;
        }
        return this.components.getComponent(tag, helper);
    }

    private Integer getLongComponent(int tag) {
        return (Integer)this.getComponent(tag, LongHelper.class);
    }

    private String getStringComponent(int tag) {
        return (String)this.getComponent(tag, StringHelper.class);
    }

    public static boolean isParsableProtocol(String check) {
        return check.startsWith("IOR:") || check.startsWith("corbaloc:") || check.startsWith("corbaname:") || check.startsWith("resource:") || check.startsWith("jndi:") || check.startsWith("file:") || check.startsWith("http:");
    }

    public void setProfileSelector(ProfileSelector sel) {
        String spsVal = System.getProperty("ShowProfileSelection");
        if (spsVal != null && spsVal.equals("1")) {
            System.out.println("[JAC824] ParsedIOR.setProfileSelector: profile selector = " + sel.toString());
            System.out.println("[JAC824] ParsedIOR.setProfileSelector: profile selector class = " + sel.getClass().getName());
        }
        this.profileSelector = sel;
        this.setEffectiveProfile();
    }

    private ProfileSelector getProfileSelector() {
        if (this.profileSelector == null) {
            return this.orb.getTransportManager().getProfileSelector();
        }
        return this.profileSelector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringWriter out = new StringWriter();
        PrintWriter printWriter = new PrintWriter(out);
        try {
            PrintIOR.printIOR(this.orb, this, printWriter);
            printWriter.println("Effective Profile Id: " + this.profiles.indexOf(this.effectiveProfile));
        }
        finally {
            printWriter.close();
        }
        return out.toString();
    }

    public boolean is_nil() {
        return this.objectOperationsDelegate.is_nil();
    }

    public boolean isIOGR() {
        return this.objectOperationsDelegate.isIOGR();
    }

    public boolean isHeartbeatEnabled() {
        ProfileBase effectiveProfile = (ProfileBase)this.effectiveProfile;
        TagFTHeartbeatEnabledTaggedComponent component = (TagFTHeartbeatEnabledTaggedComponent)effectiveProfile.getComponent(29, TagFTHeartbeatEnabledTaggedComponentHelper.class);
        return component == null ? false : component.heartbeat_enabled;
    }

    static class StringHelper {
        StringHelper() {
        }

        public static String read(InputStream in) {
            return in.read_string();
        }
    }

    static class LongHelper {
        LongHelper() {
        }

        public static Integer read(InputStream in) {
            return ObjectUtil.newInteger(in.read_long());
        }
    }

    class FTObjectOperations
    implements ObjectOperations {
        FTObjectOperations() {
        }

        public boolean is_nil() {
            TaggedProfile[] _profiles = ParsedIOR.this.getIOR().profiles;
            if (_profiles.length == 0) {
                return true;
            }
            for (int i2 = 0; i2 < _profiles.length; ++i2) {
                if (_profiles[i2] == null) continue;
                return false;
            }
            return true;
        }

        public String getIDString() {
            StringBuffer buffer = new StringBuffer();
            TagFTGroupTaggedComponent ftGroupTag = (TagFTGroupTaggedComponent)((ProfileBase)ParsedIOR.this.effectiveProfile).getComponent(27, class$org$omg$FT$TagFTGroupTaggedComponentHelper == null ? (class$org$omg$FT$TagFTGroupTaggedComponentHelper = ParsedIOR.class$("org.omg.FT.TagFTGroupTaggedComponentHelper")) : class$org$omg$FT$TagFTGroupTaggedComponentHelper);
            buffer.append(ftGroupTag.ft_domain_id);
            buffer.append(':');
            buffer.append(ftGroupTag.object_group_id);
            return buffer.toString();
        }

        public boolean isIOGR() {
            return true;
        }
    }

    class DefaultObjectOperations
    implements ObjectOperations {
        DefaultObjectOperations() {
        }

        public boolean is_nil() {
            return "".equals(ParsedIOR.this.getIOR().type_id) && ParsedIOR.this.getIOR().profiles.length == 0;
        }

        public String getIDString() {
            StringBuffer buff = new StringBuffer(ParsedIOR.this.getTypeId());
            buff.append(':');
            byte[] key = ParsedIOR.this.get_object_key();
            for (int j2 = 0; j2 < key.length; ++j2) {
                ObjectUtil.appendHex(buff, key[j2] >> 4 & 0xF);
                ObjectUtil.appendHex(buff, key[j2] & 0xF);
            }
            return buff.toString();
        }

        public boolean isIOGR() {
            return false;
        }
    }

    static interface ObjectOperations {
        public boolean is_nil();

        public String getIDString();

        public boolean isIOGR();
    }
}

