/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.miop;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.MulticastSocket;
import java.net.SocketException;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.jacorb.orb.CDROutputStream;
import org.jacorb.orb.miop.MIOPConnection;
import org.jacorb.orb.miop.MIOPProfile;
import org.jacorb.orb.miop.MulticastUtil;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.ETF.Profile;
import org.omg.MIOP.PacketHeader_1_0;
import org.omg.MIOP.PacketHeader_1_0Helper;

public class ClientMIOPConnection
extends MIOPConnection
implements Configurable {
    private static Thread timingAccuracyThread = new Thread(){

        public void run() {
            try {
                1.sleep(Long.MAX_VALUE);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    };
    private static short nextMessage;
    private MulticastSocket socket;
    private DatagramPacket packet;
    private int packetDataMaxSize;
    private long maxFragmentSize = 0L;
    private long maxFragmentRate = 0L;
    private boolean accumulateDelays = false;
    private long accumulatedDelay = 0L;
    private long threadSleepThreshold = 0L;
    private long totalBytesOutstanding = 0L;
    private long timeLastSend = 0L;
    private boolean reportThrottling = false;
    private boolean reportActualDelays = false;
    private long throttleDelayNanoStart = 0L;
    private long throttleDelayNanoEnd = 0L;
    private boolean forceNewConnections = false;

    public void connect(Profile profile, long timeout) {
        if (!(profile instanceof MIOPProfile)) {
            throw new BAD_PARAM("attempt to connect an MIOP connection to a non-MIOP profile: " + profile.getClass());
        }
        this.profile = (MIOPProfile)profile;
        if (this.is_connected()) {
            if (!this.forceNewConnections) {
                return;
            }
            this.close();
        }
        try {
            this.socket = new MulticastSocket();
        }
        catch (IOException ioe) {
            throw new RuntimeException("Error while creating and setting multicast socket " + profile);
        }
    }

    public boolean is_connected() {
        return this.socket != null && this.profile != null;
    }

    public void close() {
        if (this.socket != null) {
            this.socket.close();
            this.socket = null;
        }
    }

    public void flush() {
        PacketHeader_1_0 header;
        int i2;
        super.flush();
        byte[] data = ((ByteArrayOutputStream)this.out_stream).toByteArray();
        ((ByteArrayOutputStream)this.out_stream).reset();
        int length = data.length;
        int offset = 0;
        int lastPacketSize = length % this.packetDataMaxSize;
        int numberOfFullPackets = length / this.packetDataMaxSize;
        int numberOfPackets = numberOfFullPackets + (lastPacketSize > 0 ? 1 : 0);
        byte[] messageId = this.generateNewId();
        if (lastPacketSize == 0) {
            --numberOfFullPackets;
            lastPacketSize = this.packetDataMaxSize;
        }
        short packet_size = 0;
        for (i2 = 0; i2 < numberOfFullPackets; ++i2) {
            packet_size = this.packetDataMaxSize > Short.MAX_VALUE ? (short)(Short.MAX_VALUE - this.packetDataMaxSize) : (short)this.packetDataMaxSize;
            header = new PacketHeader_1_0(MulticastUtil.MAGIC, 16, 0, packet_size, i2, numberOfPackets, messageId);
            this.sendMIOPPacket(header, data, offset + i2 * this.packetDataMaxSize, this.packetDataMaxSize);
        }
        packet_size = lastPacketSize > Short.MAX_VALUE ? (short)(Short.MAX_VALUE - lastPacketSize) : (short)lastPacketSize;
        header = new PacketHeader_1_0(MulticastUtil.MAGIC, 16, 2, packet_size, i2, numberOfPackets, messageId);
        this.sendMIOPPacket(header, data, offset + i2 * this.packetDataMaxSize, lastPacketSize);
    }

    private void sendMIOPPacket(PacketHeader_1_0 header, byte[] data, int offset, int length) {
        if (!this.is_connected()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Transport to " + this.connection_info + ": socket doesn't connected properly or being closed");
            }
            throw new COMM_FAILURE("Trying to send data via non-initialized or closed socket");
        }
        CDROutputStream os = new CDROutputStream(this.orb);
        PacketHeader_1_0Helper.write(os, header);
        os.check(length, 8);
        os.write_octet_array(data, offset, length);
        try {
            byte[] buffer = os.getBufferCopy();
            if (this.packet == null) {
                this.packet = new DatagramPacket(buffer, 0, buffer.length, ((MIOPProfile)this.profile).getGroupInetAddress(), ((MIOPProfile)this.profile).getUIPMCProfile().the_port);
            } else {
                this.packet.setData(buffer, 0, buffer.length);
            }
            this.throttleSendRate(buffer.length);
            this.socket.send(this.packet);
            this.totalBytesOutstanding += (long)buffer.length;
        }
        catch (IOException se) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Transport to " + this.connection_info + ": stream closed " + se.getMessage());
            }
            throw this.to_COMM_FAILURE(se);
        }
    }

    private void throttleSendRate(int fragmentSize) {
        String msg;
        String logPrefix = this.toString() + " :: throttleSendRate :: ";
        if (this.maxFragmentRate == 0L) {
            return;
        }
        long now = ClientMIOPConnection.getNanoTime();
        if (this.timeLastSend == 0L) {
            this.timeLastSend = now;
            return;
        }
        long elapsedMicroSec = (now - this.timeLastSend) / 1000L;
        long bytesProcessed = elapsedMicroSec * this.maxFragmentSize / this.maxFragmentRate;
        if (this.totalBytesOutstanding <= bytesProcessed) {
            if (this.shouldReportThrottling()) {
                msg = logPrefix + "previous data (" + this.totalBytesOutstanding + " bytes) has cleared (could have sent " + bytesProcessed + " bytes over the last " + elapsedMicroSec + " microseconds";
                this.logger.debug(msg);
            }
            this.totalBytesOutstanding = 0L;
        } else {
            if (this.shouldReportThrottling()) {
                msg = logPrefix + "previous data (" + this.totalBytesOutstanding + " bytes) has reduced by " + bytesProcessed + " bytes over the last " + elapsedMicroSec + " microseconds";
                this.logger.debug(msg);
            }
            this.totalBytesOutstanding -= bytesProcessed;
        }
        this.timeLastSend = now;
        if (this.totalBytesOutstanding > 0L) {
            long delayMicroSec = this.totalBytesOutstanding * this.maxFragmentRate / this.maxFragmentSize;
            if (this.shouldReportThrottling()) {
                this.logger.debug(logPrefix + "delaying for " + delayMicroSec + " microseconds");
            }
            this.performDelay(logPrefix, delayMicroSec);
        }
    }

    private void performDelay(String logPrefix, long delayMicroSec) {
        if (delayMicroSec == 0L) {
            return;
        }
        if (this.accumulateDelays) {
            this.accumulatedDelay += delayMicroSec;
            if (this.shouldReportThrottling()) {
                this.logger.debug(logPrefix + "accumulated delay = " + this.accumulatedDelay + "us (this delay " + delayMicroSec + "us)");
            }
            if (this.accumulatedDelay >= 1000L) {
                if (this.shouldReportThrottling()) {
                    this.logger.debug(logPrefix + "accumulated delay is over 1ms, performing sleep");
                }
                this.recordDelayStart(logPrefix + "thread sleeping for " + this.accumulatedDelay + " microseconds");
                try {
                    Thread.currentThread();
                    Thread.sleep(this.accumulatedDelay / 1000L);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                this.recordDelayEnd(logPrefix);
                this.accumulatedDelay = 0L;
            }
            return;
        }
        if (delayMicroSec < this.threadSleepThreshold) {
            int counter = 0;
            long startPoint = ClientMIOPConnection.getNanoTime();
            long currentTime = 0L;
            boolean keepGoing = true;
            this.recordDelayStart(logPrefix + "loop sleeping for " + delayMicroSec + " microseconds");
            while (keepGoing) {
                for (int i2 = 0; i2 < 10; ++i2) {
                    ++counter;
                }
                currentTime = ClientMIOPConnection.getNanoTime();
                if (currentTime < startPoint + delayMicroSec * 1000L) continue;
                keepGoing = false;
            }
            this.recordDelayEnd(logPrefix);
        } else {
            long delayMilliSec = delayMicroSec / 1000L;
            long delayNanoSec = (delayMicroSec - delayMilliSec * 1000L) * 1000L;
            this.recordDelayStart(logPrefix + "thread sleeping for " + delayMicroSec + " microseconds (" + delayMilliSec + " milliseconds + " + (int)delayNanoSec + " nanoseconds)");
            try {
                Thread.currentThread();
                Thread.sleep(delayMilliSec, (int)delayNanoSec);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            this.recordDelayEnd(logPrefix);
        }
    }

    private void recordDelayStart(String logMessage) {
        if (this.reportActualDelays && this.shouldReportThrottling()) {
            this.throttleDelayNanoStart = ClientMIOPConnection.getNanoTime();
            this.logger.debug(logMessage);
        }
    }

    private void recordDelayEnd(String logPrefix) {
        if (this.reportActualDelays && this.shouldReportThrottling()) {
            this.throttleDelayNanoEnd = ClientMIOPConnection.getNanoTime();
            this.logger.debug(logPrefix + "actual delay = " + (this.throttleDelayNanoEnd - this.throttleDelayNanoStart) / 1000L + " microseconds");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] generateNewId() {
        byte[] id = new byte[12];
        byte[] serverId = this.orb.getServerId();
        System.arraycopy(serverId, 0, id, 0, serverId.length);
        Class clazz = ClientMIOPConnection.class;
        synchronized (clazz) {
            id[10] = (byte)(nextMessage >> 8 & 0xFF);
            id[11] = (byte)(nextMessage & 0xFF);
            nextMessage = (short)(nextMessage + 1);
        }
        return id;
    }

    protected int getTimeout() {
        try {
            return this.socket.getSoTimeout();
        }
        catch (SocketException se) {
            throw this.to_COMM_FAILURE(se);
        }
    }

    protected void setTimeout(int timeout) {
        block4: {
            if (this.socket != null) {
                try {
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("Socket timeout set to " + timeout + " ms");
                    }
                    this.socket.setSoTimeout(timeout);
                }
                catch (SocketException se) {
                    if (!this.logger.isInfoEnabled()) break block4;
                    this.logger.info("SocketException", se);
                }
            }
        }
    }

    private boolean shouldReportThrottling() {
        return this.reportThrottling && this.logger.isDebugEnabled();
    }

    public void configure(Configuration config) throws ConfigurationException {
        super.configure(config);
        int packetMax = config.getAttributeAsInteger("jacorb.miop.packet_max_size", 1500);
        this.packetDataMaxSize = packetMax - 60;
        this.maxFragmentSize = packetMax;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(this.toString() + ": MIOP client maximum fragment size set to " + this.maxFragmentSize + " bytes");
        }
        this.maxFragmentRate = config.getAttributeAsInteger("jacorb.miop.max_fragment_rate", 0);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(this.toString() + ": MIOP client maximum fragment rate set to " + this.maxFragmentRate + " microseconds");
        }
        this.accumulateDelays = config.getAttributeAsBoolean("jacorb.miop.accumulate_delays", false);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(this.toString() + ": MIOP delay accumulation set to " + this.accumulateDelays);
        }
        this.threadSleepThreshold = config.getAttributeAsInteger("jacorb.miop.sleep_threshold", 750);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(this.toString() + ": thread sleep threshold set to " + this.threadSleepThreshold + " microseconds");
        }
        this.reportThrottling = config.getAttributeAsBoolean("jacorb.miop.report_throttling", false);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(this.toString() + ": report throttling set to " + this.reportThrottling);
        }
        this.reportActualDelays = config.getAttributeAsBoolean("jacorb.miop.report_actual_delays", false);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(this.toString() + ": report actual delays set to " + this.reportActualDelays);
        }
        this.forceNewConnections = config.getAttributeAsBoolean("jacorb.miop.force_new_connections", false);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(this.toString() + ": force new connections set to " + this.forceNewConnections);
        }
    }

    private static long getNanoTime() {
        return System.currentTimeMillis() * 1000000L;
    }

    static {
        timingAccuracyThread.setDaemon(true);
        timingAccuracyThread.start();
        nextMessage = 0;
    }
}

