/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.poa;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.Forwarder;
import org.jacorb.orb.ServantDelegate;
import org.jacorb.orb.SystemExceptionHelper;
import org.jacorb.orb.dsi.ServerRequest;
import org.jacorb.orb.giop.ReplyOutputStream;
import org.jacorb.orb.portableInterceptor.InterceptorManager;
import org.jacorb.orb.portableInterceptor.ServerInterceptorIterator;
import org.jacorb.orb.portableInterceptor.ServerRequestInfoImpl;
import org.jacorb.poa.InvocationContext;
import org.jacorb.poa.POA;
import org.jacorb.poa.RPPoolManager;
import org.jacorb.poa.RequestController;
import org.jacorb.poa.ServerInterceptorExceptionHandler;
import org.jacorb.poa.except.POAInternalError;
import org.jacorb.util.Time;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.NO_MEMORY;
import org.omg.CORBA.OBJ_ADAPTER;
import org.omg.CORBA.ORB;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TIMEOUT;
import org.omg.CORBA.UNKNOWN;
import org.omg.CORBA.UserException;
import org.omg.CORBA.portable.InvokeHandler;
import org.omg.IOP.ServiceContext;
import org.omg.PortableServer.DynamicImplementation;
import org.omg.PortableServer.ForwardRequest;
import org.omg.PortableServer.Servant;
import org.omg.PortableServer.ServantActivator;
import org.omg.PortableServer.ServantLocator;
import org.omg.PortableServer.ServantLocatorPackage.CookieHolder;
import org.omg.PortableServer.ServantManager;

public class RequestProcessor
extends Thread
implements InvocationContext,
Configurable {
    private ServerInterceptorExceptionHandler interceptorExceptionHandler;
    private boolean start;
    private boolean terminate;
    private final RPPoolManager poolManager;
    private RequestController controller;
    private ServerRequest request;
    private Servant servant;
    private ServantManager servantManager;
    private CookieHolder cookieHolder;
    private boolean checkReplyEndTime = false;
    private Logger logger;
    private static final Set specialOperations;
    private static int count;

    RequestProcessor(RPPoolManager _poolManager) {
        super("RequestProcessor-" + ++count);
        this.poolManager = _poolManager;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        org.jacorb.config.Configuration jconfig = (org.jacorb.config.Configuration)configuration;
        this.interceptorExceptionHandler = (ServerInterceptorExceptionHandler)jconfig.getAttributeAsObject("jacorb.poa.server_interceptor_exception_handler", ServerInterceptorExceptionHandler.PROPERTY_DEFAULT);
        this.checkReplyEndTime = configuration.getAttributeAsBoolean("jacorb.poa.check_reply_end_time", false);
    }

    synchronized void begin() {
        this.start = true;
        this.notify();
    }

    synchronized void end() {
        this.terminate = true;
        this.notify();
        this.interrupt();
    }

    public byte[] getObjectId() {
        if (!this.start) {
            throw new POAInternalError("error: RequestProcessor not started (getObjectId)");
        }
        return this.request.objectId();
    }

    public ORB getORB() {
        if (!this.start) {
            throw new POAInternalError("error: RequestProcessor not started (getORB)");
        }
        return this.controller.getORB();
    }

    public POA getPOA() {
        if (!this.start) {
            throw new POAInternalError("error: RequestProcessor not started (getPOA)");
        }
        return this.controller.getPOA();
    }

    public Servant getServant() {
        if (!this.start) {
            throw new POAInternalError("error: RequestProcessor not started (getServant)");
        }
        return this.servant;
    }

    void init(RequestController requestController, ServerRequest serverRequest, Servant srvnt, ServantManager manager) {
        this.controller = requestController;
        this.request = serverRequest;
        this.servant = srvnt;
        this.servantManager = manager;
        this.cookieHolder = null;
        this.logger = requestController.getLogger();
    }

    private void clear() {
        this.request.clear();
        this.controller = null;
        this.request = null;
        this.servant = null;
        this.servantManager = null;
        this.cookieHolder = null;
    }

    private void invokeIncarnate() {
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("rid: " + this.request.requestId() + " opname: " + this.request.operation() + " invoke incarnate on servant activator");
            }
            this.servant = this.controller.getAOM().incarnate(this.request.objectIdAsByteArrayKey(), (ServantActivator)this.servantManager, this.controller.getPOA());
            if (this.servant == null) {
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn("rid: " + this.request.requestId() + " opname: " + this.request.operation() + " incarnate: returns null");
                }
                this.request.setSystemException(new OBJ_ADAPTER());
            }
        }
        catch (SystemException e2) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("rid: " + this.request.requestId() + " opname: " + this.request.operation() + " incarnate: system exception was thrown.", e2);
            }
            this.request.setSystemException(e2);
        }
        catch (ForwardRequest e3) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("rid: " + this.request.requestId() + " opname: " + this.request.operation() + " incarnate: forward exception was thrown.", e3);
            }
            this.request.setLocationForward(e3);
        }
        catch (Throwable e4) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error("rid: " + this.request.requestId() + " opname: " + this.request.operation() + " incarnate: throwable was thrown.", e4);
            }
            this.request.setSystemException(new OBJ_ADAPTER(e4.toString()));
        }
    }

    private void invokeOperation() {
        try {
            if (this.servant instanceof InvokeHandler) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("rid: " + this.request.requestId() + " opname: " + this.request.operation() + " invokeOperation on servant " + this.servant + " (stream based)");
                }
                if (specialOperations.contains(this.request.operation())) {
                    ((ServantDelegate)this.servant._get_delegate())._invoke(this.servant, this.request.operation(), this.request.getInputStream(), this.request);
                } else {
                    ((InvokeHandler)((Object)this.servant))._invoke(this.request.operation(), this.request.getInputStream(), this.request);
                }
            } else if (this.servant instanceof DynamicImplementation) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("rid: " + this.request.requestId() + " opname: " + this.request.operation() + " invoke operation on servant (dsi based)");
                }
                if (specialOperations.contains(this.request.operation()) && !(this.servant instanceof Forwarder)) {
                    ((ServantDelegate)this.servant._get_delegate())._invoke(this.servant, this.request.operation(), this.request.getInputStream(), this.request);
                } else {
                    ((DynamicImplementation)this.servant).invoke(this.request);
                }
            } else if (this.logger.isWarnEnabled()) {
                this.logger.warn("rid: " + this.request.requestId() + " opname: " + this.request.operation() + " unknown servant type (neither stream nor dsi based)");
            }
        }
        catch (SystemException e2) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("rid: " + this.request.requestId() + " opname: " + this.request.operation() + " invocation: system exception was thrown.", e2);
            }
            this.request.setSystemException(e2);
        }
        catch (OutOfMemoryError e3) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error("rid: " + this.request.requestId() + " opname: " + this.request.operation() + " invocation: Caught OutOfMemory invoking operation.", e3);
            }
            this.request.setSystemException(new NO_MEMORY(e3.toString()));
        }
        catch (Throwable e4) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error("rid: " + this.request.requestId() + " opname: " + this.request.operation() + " invocation: throwable was thrown.", e4);
            }
            this.request.setSystemException(new UNKNOWN(e4.toString()));
        }
    }

    private void invokePostInvoke() {
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("rid: " + this.request.requestId() + " opname: " + this.request.operation() + " invoke postinvoke on servant locator");
            }
            ((ServantLocator)this.servantManager).postinvoke(this.request.objectId(), this.controller.getPOA(), this.request.operation(), this.cookieHolder.value, this.servant);
        }
        catch (SystemException e2) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("rid: " + this.request.requestId() + " opname: " + this.request.operation() + " postinvoke: system exception was thrown.", e2);
            }
            this.request.setSystemException(e2);
        }
        catch (Throwable e3) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("rid: " + this.request.requestId() + " opname: " + this.request.operation() + " postinvoke: throwable was thrown.", e3);
            }
            this.request.setSystemException(new OBJ_ADAPTER(e3.toString()));
        }
    }

    private void invokePreInvoke() {
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("rid: " + this.request.requestId() + " opname: " + this.request.operation() + " invoke preinvoke on servant locator");
            }
            this.cookieHolder = new CookieHolder();
            this.servant = ((ServantLocator)this.servantManager).preinvoke(this.request.objectId(), this.controller.getPOA(), this.request.operation(), this.cookieHolder);
            if (this.servant == null) {
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn("rid: " + this.request.requestId() + " opname: " + this.request.operation() + " preinvoke: returns null");
                }
                this.request.setSystemException(new OBJ_ADAPTER());
            }
            this.controller.getORB().set_delegate(this.servant);
        }
        catch (SystemException e2) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("rid: " + this.request.requestId() + " opname: " + this.request.operation() + " preinvoke: system exception was thrown.", e2);
            }
            this.request.setSystemException(e2);
        }
        catch (ForwardRequest e3) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("rid: " + this.request.requestId() + " opname: " + this.request.operation() + " preinvoke: forward exception was thrown.", e3);
            }
            this.request.setLocationForward(e3);
        }
        catch (Throwable e4) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("rid: " + this.request.requestId() + " opname: " + this.request.operation() + " preinvoke: throwable was thrown.", e4);
            }
            this.request.setSystemException(new OBJ_ADAPTER(e4.toString()));
        }
    }

    boolean isActive() {
        return this.start;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitForCompletion() {
        RequestProcessor requestProcessor = this;
        synchronized (requestProcessor) {
            while (!this.terminate && this.start) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private void process() {
        InterceptorManager manager;
        org.jacorb.orb.ORB orb = this.controller.getORB();
        ServerRequestInfoImpl info = null;
        orb.notifyTransportListeners(this.request.getConnection());
        if (orb.hasServerRequestInterceptors()) {
            info = new ServerRequestInfoImpl(orb, this.request, this.servant);
            manager = orb.getInterceptorManager();
            info.setCurrent(manager.getEmptyCurrent());
            if (!this.invokeInterceptors(info, (short)0)) {
                ReplyOutputStream out = this.request.getReplyOutputStream();
                Iterator ctx = info.getReplyServiceContexts();
                while (ctx.hasNext()) {
                    out.addServiceContext((ServiceContext)ctx.next());
                }
                return;
            }
            manager.setTSCurrent(info.current());
        }
        if (Time.hasPassed(this.request.getRequestEndTime())) {
            this.request.setSystemException(new TIMEOUT("Request End Time exceeded", 0, CompletionStatus.COMPLETED_NO));
            return;
        }
        if (this.checkReplyEndTime && Time.hasPassed(this.request.getReplyEndTime())) {
            this.request.setSystemException(new TIMEOUT("Reply End Time exceeded", 0, CompletionStatus.COMPLETED_NO));
            return;
        }
        Time.waitFor(this.request.getRequestStartTime());
        if (this.servantManager != null) {
            if (this.servantManager instanceof ServantActivator) {
                this.invokeIncarnate();
            } else {
                this.invokePreInvoke();
            }
        }
        if (this.servant != null) {
            if (info != null) {
                info.setServant(this.servant);
                if (this.servant instanceof InvokeHandler) {
                    if (!this.invokeInterceptors(info, (short)1)) {
                        if (this.cookieHolder != null) {
                            this.invokePostInvoke();
                        }
                        ReplyOutputStream out = this.request.getReplyOutputStream();
                        Iterator ctx = info.getReplyServiceContexts();
                        while (ctx.hasNext()) {
                            out.addServiceContext((ServiceContext)ctx.next());
                        }
                        return;
                    }
                } else if (this.servant instanceof DynamicImplementation) {
                    this.request.setServerRequestInfo(info);
                }
            }
            this.invokeOperation();
        }
        if (this.cookieHolder != null) {
            this.invokePostInvoke();
        }
        if (this.checkReplyEndTime && Time.hasPassed(this.request.getReplyEndTime())) {
            this.request.setSystemException(new TIMEOUT("Reply End Time exceeded after invocation", 0, CompletionStatus.COMPLETED_YES));
        }
        if (info != null) {
            manager = orb.getInterceptorManager();
            info.setCurrent(manager.getCurrent());
            int op = 0;
            switch (this.request.status().value()) {
                case 0: {
                    op = 2;
                    info.setReplyStatus((short)0);
                    break;
                }
                case 1: {
                    info.setReplyStatus((short)2);
                    SystemExceptionHelper.insert(info.sending_exception, new UNKNOWN("Stream-based UserExceptions are not available!"));
                    op = 3;
                    break;
                }
                case 2: {
                    info.setReplyStatus((short)1);
                    SystemExceptionHelper.insert(info.sending_exception, this.request.getSystemException());
                    op = 3;
                    break;
                }
                case 3: {
                    info.setReplyStatus((short)3);
                    op = 4;
                }
            }
            this.invokeInterceptors(info, (short)op);
            ReplyOutputStream out = this.request.get_out();
            Iterator ctx = info.getReplyServiceContexts();
            while (ctx.hasNext()) {
                out.addServiceContext((ServiceContext)ctx.next());
            }
            manager.removeTSCurrent();
        }
    }

    private boolean invokeInterceptors(ServerRequestInfoImpl info, short op) {
        ServerInterceptorIterator interceptorIterator = this.controller.getORB().getInterceptorManager().getServerIterator();
        try {
            interceptorIterator.iterate(info, op);
        }
        catch (UserException ue) {
            this.interceptorExceptionHandler.handleInterceptorUserException(this.request, ue);
            return false;
        }
        catch (SystemException _sys_ex) {
            this.interceptorExceptionHandler.handleInterceptorSystemException(this.request, _sys_ex);
            return false;
        }
        catch (Throwable th) {
            this.logger.error("unexpected exception during interceptor invocation", th);
            UNKNOWN exception = new UNKNOWN(th.getMessage());
            this.interceptorExceptionHandler.handleInterceptorSystemException(this.request, exception);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            RequestProcessor requestProcessor = this;
            synchronized (requestProcessor) {
                while (!this.terminate && !this.start) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (this.terminate) {
                    return;
                }
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("rid: " + this.request.requestId() + " opname: " + this.request.operation() + " starts with request processing");
            }
            if (this.request.syncScope() == 2) {
                this.controller.returnResult(this.request);
                this.process();
            } else {
                this.process();
                this.controller.returnResult(this.request);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("rid: " + this.request.requestId() + " opname: " + this.request.operation() + " ends with request processing for servant " + this.servant);
            }
            this.controller.finish(this.request);
            requestProcessor = this;
            synchronized (requestProcessor) {
                this.start = false;
                this.notifyAll();
            }
            this.clear();
            this.poolManager.releaseProcessor(this);
        }
    }

    static {
        count = 0;
        specialOperations = new HashSet();
        specialOperations.add("_is_a");
        specialOperations.add("_interface");
        specialOperations.add("_non_existent");
        specialOperations.add("_get_policy");
        specialOperations.add("_set_policy_overrides");
        specialOperations.add("_get_component");
    }
}

