/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.persistence;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import se.ericsson.cello.persistence.Convert;
import se.ericsson.cello.persistence.JdbcConnectException;
import se.ericsson.cello.persistence.JdbcDriverNotFoundException;
import se.ericsson.cello.persistence.JdbcHelper;
import se.ericsson.cello.support.debug.Assert;

public class JdbcPostgresHelper
implements JdbcHelper {
    private String host = "";
    private String port = "";
    private String driver = "postgresql";
    private String database = "";
    private String username = "";
    private String password = "";
    private String lastDbName = "";

    @Override
    public Properties getProperties() {
        Properties properties = new Properties();
        properties.setProperty("user", this.username);
        properties.setProperty("password", this.password);
        return properties;
    }

    @Override
    public String getUrl() {
        this.getConnectionParameters();
        return "jdbc:" + this.driver + "://" + this.host + ":" + this.port + "/" + this.database;
    }

    @Override
    public Object connect() throws JdbcConnectException {
        return this.connect(this.getUrl(), this.getProperties());
    }

    @Override
    public Object connect(String string, Properties properties) throws JdbcConnectException {
        Connection connection;
        this.getConnectionParameters();
        this.setNamespace("default");
        try {
            connection = DriverManager.getConnection(string, properties);
        }
        catch (SQLException sQLException) {
            throw new JdbcConnectException(sQLException.toString());
        }
        finally {
            this.setNamespace("OAM_CS_IP_1");
        }
        return connection;
    }

    @Override
    public String getBinary(byte[] byArray) {
        return "E'\\\\x" + Convert.byteArrayToHexString(byArray) + "'";
    }

    @Override
    public String getStringType() {
        return "VARCHAR";
    }

    @Override
    public String getStringType(int n) {
        return "VARCHAR(" + n + ")";
    }

    @Override
    public String getFloatType() {
        return "REAL";
    }

    @Override
    public String getDoubleType() {
        return "DOUBLE PRECISION";
    }

    @Override
    public String getByteType() {
        return "SMALLINT";
    }

    @Override
    public String getShortType() {
        return "SMALLINT";
    }

    @Override
    public String getIntType() {
        return "INTEGER";
    }

    @Override
    public String getBinaryType() {
        return "BYTEA";
    }

    @Override
    public String getBooleanType() {
        return "BOOL";
    }

    @Override
    public String getDateType() {
        return "TIMESTAMP";
    }

    private String getValue(String string) {
        return string.split("=", 2)[1].trim();
    }

    private void handleFatalError(String string) {
        Assert.cppAssert(string);
    }

    private void getConnectionParameters() {
        String string = "[" + this.getDbName() + "]";
        if (string.equals(this.lastDbName)) {
            return;
        }
        this.lastDbName = string;
        String string2 = System.getenv("ODBCSYSINI");
        if (string2 == null) {
            string2 = "/etc";
        }
        try {
            String string3;
            File file = new File(string2 + "/odbc.ini");
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            while ((string3 = bufferedReader.readLine()) != null && !string3.startsWith(string) && !string3.startsWith("[default]")) {
            }
            while ((string3 = bufferedReader.readLine()) != null && !string3.startsWith("[")) {
                if (string3.startsWith("Servername")) {
                    this.host = this.getValue(string3);
                }
                if (string3.startsWith("Database")) {
                    this.database = this.getValue(string3);
                }
                if (string3.startsWith("UserName")) {
                    this.username = this.getValue(string3);
                }
                if (string3.startsWith("Password")) {
                    this.password = this.getValue(string3);
                }
                if (!string3.startsWith("Port")) continue;
                this.port = this.getValue(string3);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.handleFatalError("ODBC configuration error: " + fileNotFoundException.toString());
        }
        catch (IOException iOException) {
            this.handleFatalError("ODBC configuration error: " + iOException.toString());
        }
        if (this.username == null || this.username.length() == 0) {
            this.username = System.getenv("USER");
        }
    }

    private native String getDbName();

    private native void setNamespace(String var1);

    JdbcPostgresHelper() throws JdbcDriverNotFoundException {
        this.getConnectionParameters();
        try {
            Class.forName("org.postgresql.Driver").newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw new JdbcDriverNotFoundException(instantiationException.toString());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new JdbcDriverNotFoundException(classNotFoundException.toString());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new JdbcDriverNotFoundException(illegalAccessException.toString());
        }
    }
}

