/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.sigutil;

import enea.ose.system.InSignal;
import enea.ose.system.OseProcess;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.support.sigutil.OseNameServer;
import se.ericsson.cello.support.sigutil.PortManager;
import se.ericsson.cello.support.sigutil.SignalHelper;
import se.ericsson.cello.support.sigutil.SignalObserver;
import se.ericsson.cello.support.sigutil.SignalPort;
import se.ericsson.cello.support.sigutil.SubscriptionObserver;
import se.ericsson.cello.support.sigutil.SubscriptionObserver2;
import se.ericsson.cello.support.sigutil.signals.NsCancelServiceSubscriptionReply;
import se.ericsson.cello.support.sigutil.signals.NsCancelServiceSubscriptionRequest;
import se.ericsson.cello.support.sigutil.signals.NsSubscribeServiceAddedPid;
import se.ericsson.cello.support.sigutil.signals.NsSubscribeServicePidRequest;
import se.ericsson.cello.support.sigutil.signals.NsSubscribeServiceRemovedPid;
import se.ericsson.cello.support.sigutil.signals.NsSubscribeServiceReply;
import se.ericsson.cello.support.thread.BlockingQueue;

class SubscribeMgr
implements SignalObserver,
Runnable {
    private static final int INITIALIZING = 0;
    private static final int SUBSCRIBING = 1;
    private static final int SERVICE_ADDED = 2;
    private static final int SERVICE_REMOVED = 3;
    private Hashtable subscriptions = new Hashtable();
    private Vector unsubscribed = new Vector(1);
    private BlockingQueue requests = new BlockingQueue();

    SubscribeMgr() {
        MessageLog.traceEnter(this.getClass(), "SubscribeMgr()");
        SignalPort signalPort = PortManager.instance();
        signalPort.addSignalObserver(this, NsSubscribeServiceReply.class);
        signalPort.addSignalObserver(this, NsCancelServiceSubscriptionReply.class);
        signalPort.addSignalObserver(this, NsSubscribeServiceAddedPid.class);
        signalPort.addSignalObserver(this, NsSubscribeServiceRemovedPid.class);
        Thread thread = new Thread((Runnable)this, "Osa_SubscribeMgr_thread");
        thread.start();
        MessageLog.traceReturn(this.getClass(), "SubscribeMgr()");
    }

    public synchronized void signalReceived(InSignal inSignal) {
        MessageLog.traceEnter(this.getClass(), "signalReceived()");
        if (inSignal instanceof NsSubscribeServiceAddedPid) {
            this.enqueueServiceAdded((NsSubscribeServiceAddedPid)inSignal);
        } else if (inSignal instanceof NsSubscribeServiceRemovedPid) {
            this.enqueueServiceRemoved((NsSubscribeServiceRemovedPid)inSignal);
        } else if (inSignal instanceof NsSubscribeServiceReply) {
            this.handleSubscriptionReply((NsSubscribeServiceReply)inSignal);
        } else if (inSignal instanceof NsCancelServiceSubscriptionReply) {
            // empty if block
        }
        MessageLog.traceReturn(this.getClass(), "signalReceived()");
    }

    private void handleSubscriptionReply(NsSubscribeServiceReply nsSubscribeServiceReply) {
        MessageLog.traceEnter(this.getClass(), "handleSubscriptionReply(" + nsSubscribeServiceReply.getTag() + ")");
        String string = nsSubscribeServiceReply.getTag();
        Subscription subscription = (Subscription)this.subscriptions.get(string);
        if (subscription != null) {
            subscription.id = nsSubscribeServiceReply.getSubscriptionId();
            subscription.status = 1;
        } else if (this.unsubscribed.contains(string)) {
            this.unsubscribe(string, nsSubscribeServiceReply.getSubscriptionId());
            this.unsubscribed.removeElement(string);
        }
        MessageLog.traceReturn(this.getClass(), "handleSubscriptionReply()");
    }

    private void enqueueServiceAdded(NsSubscribeServiceAddedPid nsSubscribeServiceAddedPid) {
        MessageLog.traceEnter(this.getClass(), "enqueueServiceAdded(" + nsSubscribeServiceAddedPid.getServiceTag() + ")");
        final String string = nsSubscribeServiceAddedPid.getServiceTag();
        Subscription subscription = (Subscription)this.subscriptions.get(string);
        if (subscription != null) {
            OseProcess oseProcess;
            subscription.status = 2;
            final Vector vector = (Vector)subscription.observers.clone();
            try {
                oseProcess = OseProcess.getProcess(nsSubscribeServiceAddedPid.getServicePid());
                MessageLog.trace(5, this.getClass(), "Service added: " + string + " pid:" + oseProcess);
                subscription.service = oseProcess;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                MessageLog.trace(5, this.getClass(), "Illegal argument: " + illegalArgumentException);
                return;
            }
            this.requests.enqueue(new Runnable(){

                public void run() {
                    SubscribeMgr.this.notifyObserversOnAdd(string, oseProcess, vector);
                }
            });
        }
        MessageLog.traceReturn(this.getClass(), "enqueueServiceAdded()");
    }

    private void enqueueServiceRemoved(NsSubscribeServiceRemovedPid nsSubscribeServiceRemovedPid) {
        MessageLog.traceEnter(this.getClass(), "enqueueServiceRemoved(" + nsSubscribeServiceRemovedPid.getServiceTag() + ")");
        final String string = nsSubscribeServiceRemovedPid.getServiceTag();
        if (string == null) {
            throw new NullPointerException("NsSubscribeServiceRemovedPid");
        }
        Subscription subscription = (Subscription)this.subscriptions.get(string);
        if (subscription != null) {
            if (subscription.service == null) {
                return;
            }
            final Vector vector = (Vector)subscription.observers.clone();
            if (subscription.service.getPID() == nsSubscribeServiceRemovedPid.getServicePid()) {
                subscription.service = null;
                MessageLog.trace(5, this.getClass(), "Removed all services for " + string);
                subscription.status = 3;
            }
            this.requests.enqueue(new Runnable(){

                public void run() {
                    SubscribeMgr.this.notifyObserversOnRemove(string, vector);
                }
            });
        }
        MessageLog.traceReturn(this.getClass(), "enqueueServiceRemoved()");
    }

    private void subscribe(String string) {
        NsSubscribeServicePidRequest nsSubscribeServicePidRequest = new NsSubscribeServicePidRequest(string);
        OseProcess oseProcess = PortManager.instance().getOseProcess();
        MessageLog.trace(5, this.getClass(), "SubscribeRequest to service " + string);
        SignalHelper.sendWithSender(OseNameServer.getOseNs(), oseProcess, nsSubscribeServicePidRequest);
    }

    private void unsubscribe(String string, long l) {
        NsCancelServiceSubscriptionRequest nsCancelServiceSubscriptionRequest = new NsCancelServiceSubscriptionRequest(l);
        OseProcess oseProcess = PortManager.instance().getOseProcess();
        SignalHelper.sendWithSender(OseNameServer.getOseNs(), oseProcess, nsCancelServiceSubscriptionRequest);
        MessageLog.trace(5, this.getClass(), "Cancelling subscription of service " + string);
    }

    synchronized void addSubscriptionObserver_(String string, Object object) {
        final String string2 = string;
        final Object object2 = object;
        MessageLog.traceEnter(this.getClass(), "addSubscriptionObserver_()");
        Subscription subscription = (Subscription)this.subscriptions.get(string2);
        if (subscription == null) {
            MessageLog.trace(9, this.getClass(), "Client " + object2 + " requests a new subscription: " + string2);
            this.subscriptions.put(string2, new Subscription(object2));
            if (this.unsubscribed.contains(string2)) {
                this.unsubscribed.removeElement(string2);
            } else {
                this.subscribe(string2);
            }
        } else if (!subscription.observers.contains(object2)) {
            MessageLog.trace(9, this.getClass(), "Client " + object2 + " added to subscription");
            subscription.observers.addElement(object2);
            if (subscription.status == 2 || subscription.status == 3) {
                MessageLog.trace(9, this.getClass(), "Notifying client for tag " + string2);
                final int n = subscription.status;
                final OseProcess oseProcess = subscription.service;
                this.requests.enqueue(new Runnable(){

                    public void run() {
                        SubscribeMgr.this.notifyObserver(string2, oseProcess, object2, n);
                    }
                });
            }
        }
        MessageLog.traceReturn(this.getClass(), "addSubscriptionObserver_()");
    }

    synchronized void removeSubscriptionObserver_(String string, Object object) {
        MessageLog.traceEnter(this.getClass(), "removeSubscriptionObserver_()");
        Subscription subscription = (Subscription)this.subscriptions.get(string);
        MessageLog.trace(9, this.getClass(), "subscription : " + subscription);
        if (subscription != null) {
            subscription.observers.removeElement(object);
            if (subscription.observers.isEmpty()) {
                if (subscription.status != 0) {
                    this.unsubscribe(string, subscription.id);
                } else {
                    this.unsubscribed.addElement(string);
                }
                this.subscriptions.remove(string);
            }
        }
        MessageLog.traceReturn(this.getClass(), "removeSubscriptionObserver_()");
    }

    synchronized boolean isSubscribed_(String string, Object object) {
        Subscription subscription = (Subscription)this.subscriptions.get(string);
        if (subscription != null) {
            return subscription.observers.contains(object);
        }
        return false;
    }

    OseProcess getService(String string) {
        Subscription subscription = (Subscription)this.subscriptions.get(string);
        if (subscription != null) {
            return subscription.service;
        }
        return null;
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    Runnable runnable = (Runnable)this.requests.dequeue();
                    runnable.run();
                }
            }
            catch (InterruptedException interruptedException) {
                MessageLog.traceError(this.getClass(), "Subscriber notification thread was interrupted.", interruptedException);
                continue;
            }
            catch (Throwable throwable) {
                MessageLog.traceError(this.getClass(), "A subscription observer throwed an exception - check stack trace", throwable);
                continue;
            }
            break;
        }
    }

    private void notifyObserver(String string, OseProcess oseProcess, Object object, int n) {
        MessageLog.traceEnter(this.getClass(), "notifyObserver(" + string + ") for " + object.getClass());
        if (n == 2) {
            this.notifyObserverOnAdd(string, oseProcess, object);
        } else if (n == 3) {
            this.notifyObserverOnRemove(string, object);
        } else {
            MessageLog.traceError(this.getClass(), "Wrong status in notifyObserver: " + n);
        }
        MessageLog.traceReturn(this.getClass(), "notifyObserver() from " + object.getClass());
    }

    private void notifyObserverOnAdd(String string, OseProcess oseProcess, Object object) {
        MessageLog.trace(1, this.getClass(), "calling serviceAdded(" + string + ") for " + object);
        if (object instanceof SubscriptionObserver2) {
            ((SubscriptionObserver2)object).serviceAdded(string, oseProcess);
        } else {
            ((SubscriptionObserver)object).serviceAdded(string);
        }
    }

    private void notifyObserversOnAdd(String string, OseProcess oseProcess, Vector vector) {
        MessageLog.traceEnter(this.getClass(), "Calling notifyObserversOnAdd() ");
        if (vector != null && vector.size() > 0) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                this.notifyObserverOnAdd(string, oseProcess, enumeration.nextElement());
                MessageLog.trace(1, this.getClass(), "serviceAdded(" + string + ") returned");
            }
        }
    }

    private void notifyObserverOnRemove(String string, Object object) {
        MessageLog.trace(1, this.getClass(), "calling serviceRemoved(" + string + ") for " + object);
        if (object instanceof SubscriptionObserver2) {
            ((SubscriptionObserver2)object).serviceRemoved(string);
        } else {
            ((SubscriptionObserver)object).serviceRemoved(string);
        }
    }

    private void notifyObserversOnRemove(String string, Vector vector) {
        MessageLog.traceEnter(this.getClass(), "Calling notifyObserversOnRemove() ");
        if (vector != null && vector.size() > 0) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                this.notifyObserverOnRemove(string, enumeration.nextElement());
                MessageLog.trace(1, this.getClass(), "serviceRemoved(" + string + ") returned");
            }
        }
    }

    private class Subscription {
        long id;
        int status = 0;
        OseProcess service = null;
        Vector observers = new Vector(1);

        Subscription(Object object) {
            this.observers.addElement(object);
        }
    }
}

