/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.cppsec.esa.cipher;

import se.ericsson.security.cppsec.esa.SecurityActivationException;
import se.ericsson.security.cppsec.esa.model.EncryptedContent;
import se.ericsson.security.cppsec.esa.proxy.EsaProxyFactory;

public class EsaCipher {
    private static EsaCipher instance;
    private static String keyDerivationFunction;
    private static String encryptionScheme;

    protected EsaCipher() {
    }

    public byte[] decipherData(String string, String string2, int n, String string3) throws SecurityActivationException {
        byte[] byArray = EsaProxyFactory.getEsaProxy().decipher(string, string2, n, string3, keyDerivationFunction, encryptionScheme);
        return byArray;
    }

    public byte[] decipherData(EncryptedContent encryptedContent, String string) throws SecurityActivationException {
        return this.decipherData(encryptedContent.getContent(), string, encryptedContent.getPBKDF2_iterationCount(), encryptedContent.getPBKDF2_salt());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EsaCipher getInstance() {
        Class clazz = EsaCipher.class;
        synchronized (clazz) {
            if (instance == null) {
                instance = new EsaCipher();
            }
            return instance;
        }
    }

    static {
        keyDerivationFunction = "1.2.840.113549.2.7";
        encryptionScheme = "2.16.840.1.101.3.4.1.2";
    }
}

