/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.cppsec.esa.encryptedcontent;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import se.ericsson.security.cppsec.esa.SecurityActivationInputException;
import se.ericsson.security.cppsec.esa.cipher.EsaCipher;
import se.ericsson.security.cppsec.esa.logger.EsaReportLogger;
import se.ericsson.security.cppsec.esa.model.EncryptedContent;

public class EncryptedContentStorage {
    private final EncryptedContent encryptedContent;
    private final String myFileName;
    private final String myActivationCode;
    private File decryptedFile = null;
    public final File filePath;

    public EncryptedContentStorage(EncryptedContent encryptedContent, String string, String string2, File file) throws SecurityActivationInputException {
        if (string == null || encryptedContent == null) {
            throw new SecurityActivationInputException("Invalid input data for security file");
        }
        this.filePath = file;
        this.encryptedContent = encryptedContent;
        this.myActivationCode = string;
        this.myFileName = string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String decipher() throws SecurityActivationInputException {
        String string = "";
        try {
            byte[] byArray = EsaCipher.getInstance().decipherData(this.encryptedContent.getContent(), this.myActivationCode, this.encryptedContent.getPBKDF2_iterationCount(), this.encryptedContent.getPBKDF2_salt());
            EsaReportLogger.getInstance().logMessage("recieved the deciphered result");
            this.decryptedFile = File.createTempFile(this.myFileName, ".esa", this.filePath);
            string = this.decryptedFile.getAbsolutePath();
            EsaReportLogger.getInstance().logMessage("Created file: " + string);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(this.decryptedFile));
            try {
                bufferedOutputStream.write(byArray);
            }
            finally {
                bufferedOutputStream.close();
            }
        }
        catch (Exception exception) {
            throw new SecurityActivationInputException("Unable to decipher " + this.myFileName, exception);
        }
        return string;
    }

    public final void deleteFile() {
        if (this.decryptedFile == null) {
            EsaReportLogger.getInstance().logMessage("Unable to delete file due to invalid reference!");
        } else if (!this.decryptedFile.delete()) {
            EsaReportLogger.getInstance().logMessage("Unable to delete file: " + this.decryptedFile.getAbsolutePath());
        }
    }
}

