/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.cppsec.esa.enrollment;

import se.ericsson.security.cppsec.esa.EsaDataVerification;
import se.ericsson.security.cppsec.esa.SecurityActivationException;
import se.ericsson.security.cppsec.esa.cipher.EsaCipher;
import se.ericsson.security.cppsec.esa.enrollment.CertEnroller;
import se.ericsson.security.cppsec.esa.enrollment.CertEnrollmentException;
import se.ericsson.security.cppsec.esa.logger.EsaMessageSender;
import se.ericsson.security.cppsec.esa.logger.EsaReportLogger;
import se.ericsson.security.cppsec.esa.model.DataChallengePassword;
import se.ericsson.security.cppsec.esa.model.IpSecEnrollmentData;
import se.ericsson.security.cppsec.esa.model.SecEnrollmentData;

public abstract class CertEnrollerImpl
implements CertEnroller {
    protected EsaDataVerification esaDataVerification;
    protected boolean isEnrolling = false;
    protected String integrationCode = null;
    protected String enrollmentOtp = "";
    protected final EsaReportLogger reportLogger = EsaReportLogger.getInstance();
    private final EsaMessageSender messageSender;

    protected CertEnrollerImpl(EsaMessageSender esaMessageSender) {
        this.esaDataVerification = new EsaDataVerification();
        this.messageSender = esaMessageSender;
    }

    public final boolean isEnrolling() {
        return this.isEnrolling;
    }

    public final void setIntegrationCode(String string) {
        this.integrationCode = string;
    }

    public void setEnrollmentData(IpSecEnrollmentData ipSecEnrollmentData) {
    }

    public void setEnrollmentData(SecEnrollmentData secEnrollmentData) {
    }

    public final boolean overwriteCurrentEnrollmentData(String string, String string2) {
        boolean bl = true;
        try {
            bl = this.esaDataVerification.checkCurrentEnrollmentData(string, string2);
        }
        catch (SecurityActivationException securityActivationException) {
            EsaReportLogger.getInstance().logMessage("Could not compare with previous ipsec enrollment data due to exception.");
        }
        return bl;
    }

    protected void createEnrollmentOtp(DataChallengePassword dataChallengePassword) throws CertEnrollmentException {
        this.reportLogger.logMessage("Deciphering the Enrollment Challenge Password");
        try {
            byte[] byArray = EsaCipher.getInstance().decipherData(dataChallengePassword.getEncryptedContent(), this.integrationCode);
            this.enrollmentOtp = new String(byArray);
        }
        catch (SecurityActivationException securityActivationException) {
            throw new CertEnrollmentException("Unable to dechiper the One Time Password.", securityActivationException);
        }
    }
}

