/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.cppsec.esa.enrollment;

import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.security.mom.StructEnrollmentData;
import se.ericsson.security.cppsec.esa.NodeSecurityHandler;
import se.ericsson.security.cppsec.esa.NodeSecurityHandlerFactory;
import se.ericsson.security.cppsec.esa.SecurityActivationException;
import se.ericsson.security.cppsec.esa.enrollment.CertEnrollerImpl;
import se.ericsson.security.cppsec.esa.enrollment.CertEnrollmentException;
import se.ericsson.security.cppsec.esa.logger.EsaMessageSender;
import se.ericsson.security.cppsec.esa.logger.EsaReportLogger;
import se.ericsson.security.cppsec.esa.model.SecEnrollmentData;
import se.ericsson.security.cppsec.esa.wrapper.EsaConstantsFactory;

public class SecCertEnrollerImpl
extends CertEnrollerImpl {
    private NodeSecurityHandler nodeSecurityHandler;
    private SecEnrollmentData enrollData = null;
    private final EsaMessageSender messageSender;

    public SecCertEnrollerImpl(EsaMessageSender esaMessageSender) {
        super(esaMessageSender);
        this.messageSender = esaMessageSender;
        this.nodeSecurityHandler = NodeSecurityHandlerFactory.getNodeSecurityHandler(esaMessageSender);
    }

    public void enroll() throws CertEnrollmentException {
        int n = 0;
        int n2 = this.enrollData.getEnrollmentTimeLimit();
        EsaReportLogger.getInstance().logMessage("SEC:Initiating certificate enrollment.");
        this.messageSender.sendMessage("Initiating certificate enrollment.");
        Struct struct = null;
        try {
            if (this.enrollData.getEnrollmentMode() == 0 || this.enrollData.getEnrollmentMode() == 2) {
                this.createEnrollmentOtp(this.enrollData.getDataChallengePassword());
            }
            EsaReportLogger.getInstance().logMessage("SEC: Creating struct with members. CAFingerprint: " + this.enrollData.getCAFingerprint() + "EnrollmentServerURL: " + this.enrollData.getEnrollmentServerURL() + "DistinguishName: " + this.enrollData.getDistinguishedName() + "OTP: " + this.enrollmentOtp + "RollbackTimeOut: " + n + "EnrollmentMode: " + this.enrollData.getEnrollmentMode() + "KeyLength: " + this.enrollData.getKeyLength() + "CertificateAuthorityDN: " + this.enrollData.getCertificateAuthorityDn());
            struct = StructEnrollmentData.createStruct((String)this.enrollData.getCAFingerprint(), (String)this.enrollData.getEnrollmentServerURL(), (String)this.enrollData.getDistinguishedName(), (String)this.enrollmentOtp, (int)n, (int)this.enrollData.getEnrollmentMode(), (int)this.enrollData.getKeyLength(), (String)this.enrollData.getCertificateAuthorityDn());
            if (this.overwriteCurrentEnrollmentData(this.enrollmentOtp, EsaConstantsFactory.getEsaConstants().getEsaStateFilePath())) {
                this.isEnrolling = true;
                this.nodeSecurityHandler.setEnrollmentTimeLimit(n2);
                this.nodeSecurityHandler.initiateCertificateEnrollment(struct);
            }
        }
        catch (SecurityActivationException securityActivationException) {
            this.isEnrolling = false;
            throw new CertEnrollmentException("Action InitCertEnrollment failed.", securityActivationException);
        }
        EsaReportLogger.getInstance().logMessage("SEC:Initiated certificate enrollment.");
        this.messageSender.sendMessage("Initiated certificate enrollment.");
    }

    public void setEnrollmentData(SecEnrollmentData secEnrollmentData) {
        this.enrollData = secEnrollmentData;
    }

    public void waitForCertEnrollment() throws CertEnrollmentException {
        if (this.isEnrolling) {
            try {
                this.nodeSecurityHandler.waitForCertEnrollment();
                this.esaDataVerification.writeStateFile(this.enrollmentOtp);
                this.enrollmentOtp = null;
                this.messageSender.sendMessage("Certificate enrollment is completed.");
                EsaReportLogger.getInstance().logMessage("SEC:Certificate enrollment is completed.");
                this.isEnrolling = false;
            }
            catch (SecurityActivationException securityActivationException) {
                throw new CertEnrollmentException(securityActivationException);
            }
        }
    }
}

