/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.cppsec.esa.model.elements;

import java.util.List;
import org.xml.sax.Attributes;
import se.ericsson.security.cppsec.esa.SecurityActivationInputException;
import se.ericsson.security.cppsec.esa.model.Level3ConfigSettings;
import se.ericsson.security.cppsec.esa.model.elements.AAServerIPAddressListElement;
import se.ericsson.security.cppsec.esa.parser.StackElement;

public class Level3ConfigSettingsElement
extends StackElement
implements Level3ConfigSettings {
    private static final String SECURITY_LEVEL3_TIMEOUT = "securityLevel3Timeout";
    private static final String AUTH_CACHE_TIMEOUT = "authorizationCacheTimeOut";
    public static final String INSTALL_LAAD_DURATION = "installLaadDuration";
    public static final String LEVEL3CONFIGSETTINGS = "level3ConfigSettings";
    private String securityLevel3Timeout;
    private String authorizationCacheTimeOut;
    private String installLaadDuration;
    private AAServerIPAddressListElement aaServerIPAddressList = null;

    protected StackElement createElement(String string, String string2, String string3, Attributes attributes) {
        AAServerIPAddressListElement aAServerIPAddressListElement = null;
        if ("aaServerIPAddressList".equalsIgnoreCase(string2)) {
            this.aaServerIPAddressList = aAServerIPAddressListElement = new AAServerIPAddressListElement();
        }
        return aAServerIPAddressListElement;
    }

    protected void fetchAttributes(Attributes attributes) throws SecurityActivationInputException {
        this.securityLevel3Timeout = super.getOptionalAttribute(attributes, SECURITY_LEVEL3_TIMEOUT, "30");
        this.authorizationCacheTimeOut = super.getOptionalAttribute(attributes, AUTH_CACHE_TIMEOUT, "60");
        this.installLaadDuration = super.getOptionalAttribute(attributes, INSTALL_LAAD_DURATION, "30");
        this.validateAttributes();
    }

    public void checkConsistency() throws SecurityActivationInputException {
        if (this.aaServerIPAddressList == null) {
            throw new SecurityActivationInputException("The Level3ConfigSettings element is not consistent - must contain an AaServerIPAddressList element");
        }
        this.aaServerIPAddressList.checkConsistency();
    }

    protected void validateAttributes() throws SecurityActivationInputException {
        int n;
        int n2;
        int n3;
        try {
            n3 = Integer.parseInt(this.securityLevel3Timeout);
        }
        catch (Throwable throwable) {
            throw new SecurityActivationInputException("Level3ConfigSettingsElement attribute securityLevel3Timeout invalid value - " + this.securityLevel3Timeout, throwable);
        }
        if (n3 < 5 || n3 > 300) {
            throw new SecurityActivationInputException("Level3ConfigSettingsElement attribute securityLevel3Timeout invalid value - " + this.securityLevel3Timeout);
        }
        try {
            n2 = Integer.parseInt(this.authorizationCacheTimeOut);
        }
        catch (Throwable throwable) {
            throw new SecurityActivationInputException("Level3ConfigSettingsElement attribute authorizationCacheTimeOut invalid value - " + this.authorizationCacheTimeOut, throwable);
        }
        if (n2 < 15 || n2 > 480) {
            throw new SecurityActivationInputException("Level3ConfigSettingsElement attribute authorizationCacheTimeOut invalid value - " + this.authorizationCacheTimeOut);
        }
        try {
            n = Integer.parseInt(this.installLaadDuration);
        }
        catch (Throwable throwable) {
            throw new SecurityActivationInputException("Level3ConfigSettingsElement attribute installLaadDuration invalid value - " + this.installLaadDuration, throwable);
        }
        if (n < 5 || n > 600) {
            throw new SecurityActivationInputException("Level3ConfigSettingsElement attribute installLaadDuration invalid value - " + this.installLaadDuration);
        }
    }

    public List getAAServerIpAddressList() {
        if (this.aaServerIPAddressList != null) {
            return this.aaServerIPAddressList.getIPAddresses();
        }
        return null;
    }

    public Integer getSecurityLevel3Timeout() {
        return Integer.valueOf(this.securityLevel3Timeout);
    }

    public Integer getAuthorizationCacheTimeout() {
        return Integer.valueOf(this.authorizationCacheTimeOut);
    }

    public Integer getInstallLaadDuration() {
        return Integer.valueOf(this.installLaadDuration);
    }
}

