/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.cppsec.esa.model.elements;

import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;
import se.ericsson.security.cppsec.esa.SecurityActivationInputException;
import se.ericsson.security.cppsec.esa.model.CertFile;
import se.ericsson.security.cppsec.esa.model.Level3Files;
import se.ericsson.security.cppsec.esa.model.LocalAuthenticationDB;
import se.ericsson.security.cppsec.esa.model.LocalAuthorizationDB;
import se.ericsson.security.cppsec.esa.model.elements.CertFileElement;
import se.ericsson.security.cppsec.esa.model.elements.LocalAuthenticationDBElement;
import se.ericsson.security.cppsec.esa.model.elements.LocalAuthorizationDBElement;
import se.ericsson.security.cppsec.esa.parser.StackElement;

public class Level3FilesElement
extends StackElement
implements Level3Files {
    public static final String LEVEL3FILES = "level3Files";
    private ArrayList certFiles = null;
    private LocalAuthenticationDBElement localAuthenticationDBElement = null;
    private LocalAuthorizationDBElement localAuthorizationDBElement = null;

    protected StackElement createElement(String string, String string2, String string3, Attributes attributes) {
        StackElement stackElement = null;
        if ("certFile".equalsIgnoreCase(string2)) {
            stackElement = new CertFileElement();
            if (this.certFiles == null) {
                this.certFiles = new ArrayList();
            }
            this.certFiles.add(stackElement);
        } else if ("localAuthenticationDB".equalsIgnoreCase(string2)) {
            stackElement = new LocalAuthenticationDBElement();
            this.localAuthenticationDBElement = (LocalAuthenticationDBElement)stackElement;
        } else if ("localAuthorizationDB".equalsIgnoreCase(string2)) {
            stackElement = new LocalAuthorizationDBElement();
            this.localAuthorizationDBElement = (LocalAuthorizationDBElement)stackElement;
        }
        return stackElement;
    }

    public void checkConsistency() throws SecurityActivationInputException {
        if (this.certFiles == null || this.certFiles.size() == 0) {
            throw new SecurityActivationInputException("The Level3Files element is not consistent - it must contain at least one CertFile element");
        }
        int n = this.certFiles.size();
        for (int i = 0; i < n; ++i) {
            ((CertFileElement)this.certFiles.get(i)).checkConsistency();
        }
        if (this.localAuthenticationDBElement == null) {
            throw new SecurityActivationInputException("The Level3Files element is not consistent - it must contain the LocalAuthenticationDB element");
        }
        this.localAuthenticationDBElement.checkConsistency();
        if (this.localAuthorizationDBElement == null) {
            throw new SecurityActivationInputException("The Level3Files element is not consistent - it must contain the LocalAuthorizationDB element");
        }
        this.localAuthorizationDBElement.checkConsistency();
    }

    public List getLocalAADbFileSignersCerts() {
        ArrayList arrayList = new ArrayList();
        if (this.certFiles != null) {
            int n = this.certFiles.size();
            for (int i = 0; i < n; ++i) {
                if (!((CertFile)this.certFiles.get(i)).getCategory().equalsIgnoreCase("localAaDbFileSigner")) continue;
                arrayList.add(this.certFiles.get(i));
            }
        }
        return arrayList;
    }

    public List getAAServersCerts() {
        ArrayList arrayList = new ArrayList();
        if (this.certFiles != null) {
            int n = this.certFiles.size();
            for (int i = 0; i < n; ++i) {
                if (!((CertFile)this.certFiles.get(i)).getCategory().equalsIgnoreCase("aaServer")) continue;
                arrayList.add(this.certFiles.get(i));
            }
        }
        return arrayList;
    }

    public LocalAuthenticationDB getLocalAuthenticationDB() {
        return this.localAuthenticationDBElement;
    }

    public LocalAuthorizationDB getLocalAuthorizationDB() {
        return this.localAuthorizationDBElement;
    }
}

