/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.cppsec.esa.wrapper;

import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.Status;
import se.ericsson.cello.transaction.TransactionFactory;
import se.ericsson.cello.transaction.TransactionRolledBackException;
import se.ericsson.security.cppsec.esa.SecurityActivationException;
import se.ericsson.security.cppsec.esa.wrapper.TransactionServiceWrapperFactory;

public class TransactionHelper {
    private static final TransactionFactory txFactory = TransactionServiceWrapperFactory.getTransactionServiceWrapper().getTransactionFactory();
    private static final int DEFAULT_TX_TIMEOUT = 900;

    public static Control create() throws SecurityActivationException {
        return TransactionHelper.create(900);
    }

    public static Control create(int n) throws SecurityActivationException {
        try {
            return txFactory.create(n);
        }
        catch (TransactionRolledBackException transactionRolledBackException) {
            throw new SecurityActivationException("Configuration failed due to rolled back transaction.", transactionRolledBackException);
        }
    }

    public static Control restart(Control control) throws SecurityActivationException {
        TransactionHelper.commit(control);
        return TransactionHelper.create(900);
    }

    public static Control restart(Control control, int n) throws SecurityActivationException {
        TransactionHelper.commit(control);
        return TransactionHelper.create(n);
    }

    public static void commit(Control control) throws SecurityActivationException {
        try {
            if (control != null && TransactionHelper.isActive(control)) {
                control.getTerminator().commit();
            }
        }
        catch (TransactionRolledBackException transactionRolledBackException) {
            throw new SecurityActivationException("Configuration failed due to rolled back transaction.", transactionRolledBackException);
        }
        catch (InactiveTransactionException inactiveTransactionException) {
            throw new SecurityActivationException("Configuration failed due to inactive transaction.", inactiveTransactionException);
        }
    }

    public static void rollback(Control control) throws SecurityActivationException {
        try {
            if (control != null && TransactionHelper.isActive(control)) {
                control.getTerminator().rollback();
            }
        }
        catch (InactiveTransactionException inactiveTransactionException) {
            throw new SecurityActivationException("Configuration failed due to inactive transaction.", inactiveTransactionException);
        }
    }

    private static boolean isActive(Control control) {
        return control.getCoordinator().getStatus() == Status.ACTIVE;
    }
}

