/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.licensing.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import se.ericsson.cello.emt.nodeservices.NodeServices;
import se.ericsson.cello.licensing.LicensingLogger;
import se.ericsson.cello.licensing.model.LicenseAttributeRecord;
import se.ericsson.cello.licensing.model.LicenseAttributeRecordImpl;
import se.ericsson.cello.licensing.model.LicenseType;
import se.ericsson.cello.licensing.model.LicensingNameValue;
import se.ericsson.cello.neal.cm.DnNameValues;
import se.ericsson.cello.neal.cm.NameValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecordExtractor {
    private NodeServices nodeServices;
    private static final String EMPTY_STRING = "";
    private String[] licenseAttributeNames = new String[]{"featureState", "keyId", "licenseCapacity", "licenseState", "serviceState", "licensedCapacityLimit"};

    public RecordExtractor(NodeServices nodeServices) {
        this.nodeServices = nodeServices;
    }

    public List<LicenseAttributeRecord> extractRecords(DnNameValues[] dnNameValues) {
        return this.extractRecords(dnNameValues, null);
    }

    public List<LicenseAttributeRecord> extractRecords(DnNameValues[] dnNameValues, LicenseType type) {
        ArrayList<LicenseAttributeRecord> list = new ArrayList<LicenseAttributeRecord>();
        if (dnNameValues != null) {
            for (DnNameValues dnNameValue : dnNameValues) {
                LicensingLogger.logger().fine("Extracting " + (type == null ? "all" : type) + " records from " + dnNameValue.getDn());
                List<LicenseAttributeRecord> records = this.extractRecords(dnNameValue, type);
                LicensingLogger.logger().fine("Found " + records.size() + " records");
                list.addAll(records);
            }
        } else {
            LicensingLogger.logger().warning("Cannot extract records, dnNameValues is null.");
        }
        return list;
    }

    List<LicenseAttributeRecord> extractRecords(DnNameValues dnNameValue, LicenseType type) {
        Collection<LicenseAttributeRecord> unFilteredRecords = this.createRecordList(dnNameValue);
        if (type == null) {
            return new ArrayList<LicenseAttributeRecord>(unFilteredRecords);
        }
        ArrayList<LicenseAttributeRecord> specificRecords = new ArrayList<LicenseAttributeRecord>();
        for (LicenseAttributeRecord record : unFilteredRecords) {
            if (type == LicenseType.FEATURE && this.isFeatureRecord(record)) {
                specificRecords.add(record);
                continue;
            }
            if (type != LicenseType.CAPACITY || !this.isCapacityRecord(record)) continue;
            specificRecords.add(record);
        }
        return specificRecords;
    }

    private Collection<LicenseAttributeRecord> createRecordList(DnNameValues dnNameValue) {
        String recordName = EMPTY_STRING;
        LicenseAttributeRecord currentRecord = null;
        HashMap<String, LicenseAttributeRecord> records = new HashMap<String, LicenseAttributeRecord>();
        for (NameValue nameValue : dnNameValue.getNameValues()) {
            recordName = this.getSuffix(nameValue.getName());
            if (EMPTY_STRING.equals(recordName)) {
                recordName = dnNameValue.getDn().substring(dnNameValue.getDn().lastIndexOf("=") + 1);
            }
            if ((currentRecord = (LicenseAttributeRecord)records.get(recordName)) == null) {
                currentRecord = new LicenseAttributeRecordImpl(recordName, dnNameValue.getDn());
            }
            currentRecord.addAttribute(new LicensingNameValue(this.nodeServices, nameValue, dnNameValue.getDn()));
            records.put(recordName, currentRecord);
        }
        return records.values();
    }

    private String getSuffix(String attribute) {
        String suffix = EMPTY_STRING;
        for (String licenseAttribute : this.licenseAttributeNames) {
            if (!attribute.startsWith(licenseAttribute)) continue;
            suffix = attribute.substring(licenseAttribute.length());
            break;
        }
        return suffix;
    }

    private boolean isFeatureRecord(LicenseAttributeRecord record) {
        return record.getAttribute("featureState") != null;
    }

    private boolean isCapacityRecord(LicenseAttributeRecord record) {
        return record.getAttribute("licenseCapacity") != null;
    }
}

