/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.licensing.view;

import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import se.ericsson.cello.licensing.LicensingLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HyperToolParser {
    static final String NOT_DEFINED = "NOT DEFINED";
    static final String HYPER_TOOL_KEYS = "HYPER_TOOL_KEYS";
    static final String KEY_DELIMITER = ";";
    static final String NAME_SUFFIX = "_NAME";
    static final String FILE_SUFFIX = "_CONFIG";
    private Properties properties;
    private TreeMap<String, String> hyperTools;

    public HyperToolParser(Properties properties) {
        this.properties = properties;
        this.resolveTools();
    }

    public Map<String, String> getHyperTools() {
        return this.hyperTools;
    }

    public String[] getHyperToolNames() {
        return this.hyperTools.keySet().toArray(new String[0]);
    }

    private void resolveTools() {
        this.hyperTools = new TreeMap();
        String toolKeys = this.properties.getProperty(HYPER_TOOL_KEYS, NOT_DEFINED);
        if (toolKeys.equals(NOT_DEFINED)) {
            LicensingLogger.logger().info("No hyper tools defined");
        } else {
            String[] keys;
            for (String key : keys = toolKeys.split(KEY_DELIMITER)) {
                String configFile = this.properties.getProperty(key + FILE_SUFFIX, NOT_DEFINED);
                String name = this.properties.getProperty(key + NAME_SUFFIX, NOT_DEFINED);
                if (configFile.equals(NOT_DEFINED) || name.equals(NOT_DEFINED)) {
                    LicensingLogger.logger().warning("Incomplete entry for " + key + ". Ignored as hypertool");
                    continue;
                }
                this.hyperTools.put(name, configFile);
            }
        }
    }
}

