/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.sctp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationHandler;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationSubscriber;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.mao.AttrListImpl;
import se.ericsson.cello.mao.CelloMao;
import se.ericsson.cello.mao.ConcurrentTransactionHandler;
import se.ericsson.cello.mao.FroInfo;
import se.ericsson.cello.mao.GenPmMaoHandler;
import se.ericsson.cello.mao.MaoFroTypeConverter;
import se.ericsson.cello.mao.MaoPmStrategyForReqContext;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.mao.PmRequestContextImpl;
import se.ericsson.cello.mao.TransactionHandler;
import se.ericsson.cello.mao.TransactionalFroIdMap;
import se.ericsson.cello.maofro.framework.FroData;
import se.ericsson.cello.maofro.framework.FroProxy;
import se.ericsson.cello.maofro.framework.SignedIntParameter;
import se.ericsson.cello.maofro.framework.StringParameter;
import se.ericsson.cello.maofro.framework.UnsignedIntParameter;
import se.ericsson.cello.maofro.proxy.MaoFroGenericEventInd;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.TransactionRequiredException;
import se.ericsson.cello.sctp.SctpAssociationMo;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.TransactionFactory;
import se.ericsson.cello.transaction.TransactionRolledBackException;
import se.ericsson.cello.transaction.TransactionServiceImpl;

public class SctpAssociationMoImpl
extends CelloMao
implements SctpAssociationMo,
FroInfo {
    private static TransactionalFroIdMap froIdTable = new TransactionalFroIdMap((TransactionHandler)new ConcurrentTransactionHandler());
    private MoData data;
    private Map myPmProxyFroIdMap = new HashMap(3);
    private static final int MO_DATA_REVISION_9000 = 9000;
    private static final int MO_DATA_REVISION_LATEST = 9000;
    private static final int MAX_NUMBER_SCTP_ASSOCIATION = 512;
    public static final String SCTP_FROID = "sctpFroId";
    public static final String SCTPPROFILE_FROID = "sctpProfileFroId";
    public static final String CLIENT_FROID = "clientFroId";
    public static final String CLIENT_TYPE = "clientType";
    public static final String SCTP_ASSOC_FROID = "sctpAssociationId";
    private static final int SCTP_ASSOC_EVENT_DELETE = 2;
    private FroProxy sctpAssociationProxy = null;
    private MaoFroIndicationHandler indicationHandler = null;

    public static synchronized ManagedObject create(ManagedObject managedObject, ArrayList arrayList, Coordinator coordinator, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoAccessException {
        Object object;
        AttrListImpl attrListImpl = new AttrListImpl(arrayList.size());
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            if (object instanceof StringParameter) {
                attrListImpl.addElement(((StringParameter)object).getName(), (Object)((StringParameter)object).getValue());
            }
            if (object instanceof SignedIntParameter) {
                attrListImpl.addElement(((SignedIntParameter)object).getName(), (Object)new Integer(((SignedIntParameter)object).getValue()));
            }
            if (!(object instanceof UnsignedIntParameter)) continue;
            attrListImpl.addElement(((UnsignedIntParameter)object).getName(), (Object)new Integer((int)((UnsignedIntParameter)object).getValue()));
        }
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        MoAttributeValidator.checkNoOfSiblings((ManagedObject)managedObject, (String)"SctpAssociation", (int)512);
        MoAttributeValidator.checkAndGetMandatoryAttribute((String)SCTP_FROID, (AttrList)attrListImpl, (String)"SctpAssociation", (Class)Integer.class);
        object = MoAttributeValidator.checkAndGetStringAttribute((String)"localIpAddress1", (AttrList)attrListImpl, (boolean)true, (String)"", (String)"SctpAssociation");
        MoAttributeValidator.checkAndGetStringAttribute((String)"localIpAddress2", (AttrList)attrListImpl, (boolean)false, (String)"", (String)"SctpAssociation");
        int n = (Integer)MoAttributeValidator.checkAndGetMandatoryAttribute((String)"localPortNumber", (AttrList)attrListImpl, (String)"SctpAssociation", (Class)Integer.class);
        String string = MoAttributeValidator.checkAndGetStringAttribute((String)"remoteIpAddress1", (AttrList)attrListImpl, (boolean)true, (String)"", (String)"SctpAssociation");
        MoAttributeValidator.checkAndGetStringAttribute((String)"remoteIpAddress2", (AttrList)attrListImpl, (boolean)false, (String)"", (String)"SctpAssociation");
        int n2 = (Integer)MoAttributeValidator.checkAndGetMandatoryAttribute((String)"remotePortNumber", (AttrList)attrListImpl, (String)"SctpAssociation", (Class)Integer.class);
        MoAttributeValidator.checkOtherAttributes((AttrList)attrListImpl, (String)"SctpAssociation");
        String string2 = "" + n + "-" + object + "_" + n2 + "-" + string;
        MoAttributeValidator.checkIdentity((String)"SctpAssociation", (String)string2);
        ManagedObject managedObject2 = MoRepository.instance().lookup(managedObject.getLocalDistinguishedName() + "," + "SctpAssociation" + "=" + string2);
        if (managedObject2 != null) {
            MessageLog.info((Class)SctpAssociationMoImpl.class, (String)("SctpAssociation MO with same LDN " + managedObject2.getLocalDistinguishedName() + " already present! aborting the creation of SctpAssociation MO again with same LDN"));
            return managedObject2;
        }
        return new SctpAssociationMoImpl(managedObject, string2, arrayList, coordinator, froProxy, maoFroIndicationHandler);
    }

    private SctpAssociationMoImpl(ManagedObject managedObject, String string, ArrayList arrayList, Coordinator coordinator, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoAccessException {
        super(managedObject, "SctpAssociation", string, coordinator);
        super.setPmHandler((GenPmMaoHandler)new MaoPmStrategyForReqContext((ManagedObject)this, this.myPmAppPortal));
        this.sctpAssociationProxy = froProxy;
        this.indicationHandler = maoFroIndicationHandler;
        this.data = new MoData(this.getLocalDistinguishedName(), this.getType(), true, coordinator);
        FroData froData = this.sctpAssociationProxy.create(coordinator, (Collection)arrayList);
        int n = froData.getFroId();
        this.data.registerPersistentAttr((Attribute)new IntegerAttribute(SCTP_ASSOC_FROID, false, n));
        this.indicationHandler.registerForNotifications(coordinator, (MaoFroIndicationSubscriber)this, n);
        froIdTable.put(n, (ManagedObject)this, coordinator);
        this.data.setRevision(9000);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
    }

    public SctpAssociationMoImpl(MoData moData, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoNameAlreadyTakenException {
        super(moData.getLocalDistinguishedName());
        super.setPmHandler((GenPmMaoHandler)new MaoPmStrategyForReqContext((ManagedObject)this, this.myPmAppPortal));
        this.data = moData;
        this.sctpAssociationProxy = froProxy;
        this.indicationHandler = maoFroIndicationHandler;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.data, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(9000);
        moDataRecoveryHelper.assertAttribute(SCTP_ASSOC_FROID);
        this.indicationHandler.registerForNotifications(null, (MaoFroIndicationSubscriber)this, ((IntegerAttribute)this.data.getAttribute(SCTP_ASSOC_FROID)).getValue(null));
        froIdTable.put(((IntegerAttribute)moData.getAttribute(SCTP_ASSOC_FROID)).getValue(null), (ManagedObject)this);
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        froIdTable.remove(this.getFroId(coordinator), coordinator);
        this.sctpAssociationProxy.delete(coordinator, this.getFroId(coordinator), null);
        this.indicationHandler.deregisterForNotifications(coordinator, this.getFroId(coordinator));
        super.delete(coordinator);
        this.data.delete(coordinator);
    }

    public String getType() {
        return "SctpAssociation";
    }

    public int getFroId(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return ((IntegerAttribute)this.data.getAttribute(SCTP_ASSOC_FROID)).getValue(coordinator);
    }

    public String getSctpAssociationId(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute(this.getType() + "Id", coordinator);
    }

    public String getCreationTimeStamp(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("creationTimeStamp", coordinator);
    }

    public String getLocalIpAddress1(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("localIpAddress1", coordinator);
    }

    public String getLocalIpAddress2(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("localIpAddress2", coordinator);
    }

    public int getLocalPortNumber(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("localPortNumber", coordinator);
    }

    public String getLocalPrimaryIpAddress(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("localPrimaryIpAddress", coordinator);
    }

    public String getRemoteIpAddress1(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("remoteIpAddress1", coordinator);
    }

    public String getRemoteIpAddress2(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("remoteIpAddress2", coordinator);
    }

    public int getRemotePortNumber(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("remotePortNumber", coordinator);
    }

    public String getRemotePrimaryIpAddress(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("remotePrimaryIpAddress", coordinator);
    }

    public String getLastCommLostTimeStamp(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("lastCommLostTimeStamp", coordinator);
    }

    public int getLastCommLostReason(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("lastCommLostReason", coordinator);
    }

    public int getLastCommLostOrigin(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("lastCommLostOrigin", coordinator);
    }

    public ManagedObject getSctpProfileRef(Coordinator coordinator) throws MoAccessException {
        return (ManagedObject)this.getAttribute("sctpProfileRef", coordinator);
    }

    public ManagedObject getClientRef(Coordinator coordinator) throws MoAccessException {
        return (ManagedObject)this.getAttribute("clientRef", coordinator);
    }

    public int getOperationalState(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("operationalState", coordinator);
    }

    public int getPmInControlChunks(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmInControlChunks", coordinator);
    }

    public int getPmInDataChunks(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmInDataChunks", coordinator);
    }

    public int getPmInPacks(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmInPacks", coordinator);
    }

    public int getPmOutControlChunks(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmOutControlChunks", coordinator);
    }

    public int getPmOutDataChunks(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmOutDataChunks", coordinator);
    }

    public int getPmOutPacks(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmOutPacks", coordinator);
    }

    public int getPmOutUserMsgDiscards(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmOutUserMsgDiscards", coordinator);
    }

    public int getPmRtxChunks(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmRtxChunks", coordinator);
    }

    public int getPmTimeUnavail(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmTimeUnavail", coordinator);
    }

    public int getPmInControlChunkAbnormal(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmInControlChunkAbnormal", coordinator);
    }

    public int getPmInControlChunkDiscards(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmInControlChunkDiscards", coordinator);
    }

    public int getPmInDataChunkAbnormal(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmInDataChunkAbnormal", coordinator);
    }

    public int getPmInDataChunkDiscards(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmInDataChunkDiscards", coordinator);
    }

    public long getPmInOctets(Coordinator coordinator) throws MoAccessException {
        return (Long)this.getAttribute("pmInOctets", coordinator);
    }

    public int getPmOutDataChunkDiscards(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmOutDataChunkDiscards", coordinator);
    }

    public long getPmOutOctets(Coordinator coordinator) throws MoAccessException {
        return (Long)this.getAttribute("pmOutOctets", coordinator);
    }

    public int getPmTimeCongested(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmTimeCongested", coordinator);
    }

    public int getPmCongestions(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmCongestions", coordinator);
    }

    public int getPmShutdowns(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmShutdowns", coordinator);
    }

    public int getPmAborteds(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmAborteds", coordinator);
    }

    public int getPmUnavailRetrans(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmUnavailRetrans", coordinator);
    }

    public int getPmTimePeerZeroWindow(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmTimePeerZeroWindow", coordinator);
    }

    public int getPmPeerZeroWindows(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmPeerZeroWindows", coordinator);
    }

    private Map getFroAttributes(Coordinator coordinator) throws MoAccessException {
        Map map = this.sctpAssociationProxy.getAttributes(coordinator, this.getFroId(coordinator));
        return map;
    }

    public Object getAttribute(String string, Coordinator coordinator) throws MoAccessException, NoSuchAttributeException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        String[] stringArray = new String[]{string};
        Object[] objectArray = this.getAttributes(stringArray, coordinator);
        return objectArray[0];
    }

    public Object[] getAttributes(String[] stringArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        Object[] objectArray = new Object[stringArray.length];
        PmRequestContextImpl pmRequestContextImpl = new PmRequestContextImpl((ManagedObject)this, this.myPmProxyFroIdMap, coordinator);
        Map map = null;
        for (int i = 0; i < stringArray.length; ++i) {
            UnsignedIntParameter unsignedIntParameter;
            if (stringArray[i].equalsIgnoreCase("operationalState")) {
                map = this.getAttrFromRes(map, coordinator);
                unsignedIntParameter = (UnsignedIntParameter)map.get("operationalState");
                objectArray[i] = new Integer((int)unsignedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("SctpAssociationId")) {
                objectArray[i] = super.getNamingAttributeValue();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("creationTimeStamp")) {
                map = this.getAttrFromRes(map, coordinator);
                unsignedIntParameter = (StringParameter)map.get("creationTimeStamp");
                objectArray[i] = unsignedIntParameter.getValue();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("lastCommLostTimeStamp")) {
                map = this.getAttrFromRes(map, coordinator);
                unsignedIntParameter = (StringParameter)map.get("lastCommLostTimeStamp");
                objectArray[i] = unsignedIntParameter.getValue();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("localIpAddress1")) {
                map = this.getAttrFromRes(map, coordinator);
                unsignedIntParameter = (StringParameter)map.get("localIpAddress1");
                objectArray[i] = unsignedIntParameter.getValue();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("localIpAddress2")) {
                map = this.getAttrFromRes(map, coordinator);
                unsignedIntParameter = (StringParameter)map.get("localIpAddress2");
                objectArray[i] = unsignedIntParameter.getValue();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("localPortNumber")) {
                map = this.getAttrFromRes(map, coordinator);
                unsignedIntParameter = (UnsignedIntParameter)map.get("localPortNumber");
                objectArray[i] = new Integer((int)unsignedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("localPrimaryIpAddress")) {
                map = this.getAttrFromRes(map, coordinator);
                unsignedIntParameter = (StringParameter)map.get("localPrimaryIpAddress");
                objectArray[i] = unsignedIntParameter.getValue();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("remoteIpAddress1")) {
                map = this.getAttrFromRes(map, coordinator);
                unsignedIntParameter = (StringParameter)map.get("remoteIpAddress1");
                objectArray[i] = unsignedIntParameter.getValue();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("remoteIpAddress2")) {
                map = this.getAttrFromRes(map, coordinator);
                unsignedIntParameter = (StringParameter)map.get("remoteIpAddress2");
                objectArray[i] = unsignedIntParameter.getValue();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("remotePortNumber")) {
                map = this.getAttrFromRes(map, coordinator);
                unsignedIntParameter = (UnsignedIntParameter)map.get("remotePortNumber");
                objectArray[i] = new Integer((int)unsignedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("remotePrimaryIpAddress")) {
                map = this.getAttrFromRes(map, coordinator);
                unsignedIntParameter = (StringParameter)map.get("remotePrimaryIpAddress");
                objectArray[i] = unsignedIntParameter.getValue();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("lastCommLostOrigin")) {
                map = this.getAttrFromRes(map, coordinator);
                unsignedIntParameter = (UnsignedIntParameter)map.get("lastCommLostOrigin");
                objectArray[i] = new Integer((int)unsignedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("lastCommLostReason")) {
                map = this.getAttrFromRes(map, coordinator);
                unsignedIntParameter = (UnsignedIntParameter)map.get("lastCommLostReason");
                objectArray[i] = new Integer((int)unsignedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("clientRef")) {
                map = this.getAttrFromRes(map, coordinator);
                unsignedIntParameter = (UnsignedIntParameter)map.get(CLIENT_FROID);
                StringParameter stringParameter = (StringParameter)map.get(CLIENT_TYPE);
                objectArray[i] = MaoFroTypeConverter.froId2MaoInstance((String)stringParameter.getValue(), (int)((int)unsignedIntParameter.getValue()), (Coordinator)coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("sctpProfileRef")) {
                map = this.getAttrFromRes(map, coordinator);
                unsignedIntParameter = (UnsignedIntParameter)map.get(SCTPPROFILE_FROID);
                objectArray[i] = MaoFroTypeConverter.froId2MaoInstance((String)"SctpProfile", (int)((int)unsignedIntParameter.getValue()), (Coordinator)coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmInControlChunks")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmInControlChunks", INTEGER_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmInDataChunks")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmInDataChunks", INTEGER_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmInPacks")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmInPacks", INTEGER_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmOutControlChunks")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmOutControlChunks", INTEGER_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmOutDataChunks")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmOutDataChunks", INTEGER_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmOutPacks")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmOutPacks", INTEGER_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmOutUserMsgDiscards")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmOutUserMsgDiscards", INTEGER_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmRtxChunks")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmRtxChunks", INTEGER_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmTimeUnavail")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmTimeUnavail", INTEGER_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmInControlChunkAbnormal")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmInControlChunkAbnormal", INTEGER_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmInControlChunkDiscards")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmInControlChunkDiscards", INTEGER_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmInDataChunkAbnormal")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmInDataChunkAbnormal", INTEGER_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmInDataChunkDiscards")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmInDataChunkDiscards", INTEGER_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmInOctets")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmInOctets", LONG_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmOutDataChunkDiscards")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmOutDataChunkDiscards", INTEGER_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmOutOctets")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmOutOctets", LONG_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmTimeCongested")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmTimeCongested", INTEGER_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmCongestions")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmCongestions", INTEGER_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmShutdowns")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmShutdowns", INTEGER_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmAborteds")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmAborteds", INTEGER_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmUnavailRetrans")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmUnavailRetrans", INTEGER_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmTimePeerZeroWindow")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmTimePeerZeroWindow", INTEGER_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmPeerZeroWindows")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmPeerZeroWindows", INTEGER_PM_TYPE);
                continue;
            }
            throw new NoSuchAttributeException(stringArray[i], "SctpAssociation");
        }
        return objectArray;
    }

    private Map getAttrFromRes(Map map, Coordinator coordinator) throws MoAccessException {
        if (map == null) {
            return this.getFroAttributes(coordinator);
        }
        return map;
    }

    public static SctpAssociationMoImpl lookupInstance(int n, Coordinator coordinator) throws MoAccessException {
        return (SctpAssociationMoImpl)froIdTable.get(n, coordinator);
    }

    public void eventRaised(MaoFroGenericEventInd maoFroGenericEventInd) {
        Control control = null;
        try {
            if (maoFroGenericEventInd.getSpecificEvent() == 2) {
                TransactionFactory transactionFactory = TransactionServiceImpl.instance().getTransactionFactory();
                control = transactionFactory.create(3600);
                Coordinator coordinator = control.getCoordinator();
                this.delete(coordinator);
                control.getTerminator().commit();
            } else {
                MessageLog.info(this.getClass(), (String)("Unknown specificEvent: " + maoFroGenericEventInd.getSpecificEvent() + " sent in signal MaoFroGenericEventInd"));
            }
        }
        catch (TransactionRequiredException transactionRequiredException) {
            MessageLog.traceError(this.getClass(), (String)" start of TransportNetwork failed", (Throwable)transactionRequiredException);
        }
        catch (TransactionRolledBackException transactionRolledBackException) {
            MessageLog.traceError(this.getClass(), (String)" start of TransportNetwork failed", (Throwable)transactionRolledBackException);
        }
        catch (InactiveTransactionException inactiveTransactionException) {
            MessageLog.traceError(this.getClass(), (String)" start of TransportNetwork failed", (Throwable)inactiveTransactionException);
        }
        catch (MoAccessException moAccessException) {
            MessageLog.traceError(this.getClass(), (String)" SctpAssociationMo not deleted", (Throwable)moAccessException);
            this.rollbackTransaction(control);
        }
    }

    private void rollbackTransaction(Control control) {
        try {
            if (control != null) {
                control.getTerminator().rollback();
            }
        }
        catch (InactiveTransactionException inactiveTransactionException) {
            MessageLog.info(this.getClass(), (String)("rollback failed - Inactive Transaction " + (Object)((Object)inactiveTransactionException)));
        }
    }
}

