/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.launchpad.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.Collection;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ScrollPaneLayout;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import se.ericsson.cello.launchpad.LaunchpadLog;
import se.ericsson.cello.launchpad.toolservice.StartFailureException;
import se.ericsson.cello.launchpad.toolservice.ToolServices;

public class LaunchPadGui
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JScrollPane jToolListScrollPane = null;
    private JList jToolList = null;
    private JPanel jButtonPanel = null;
    private JButton jLaunchToolButton = null;
    private JButton jCancelButton = null;
    private JPanel jSouthPanel = null;
    private ToolServices toolServices;
    private String title;
    private String hostName;
    private static Image iconImage;
    private final LaunchPadGui launchpad;

    public LaunchPadGui(String hostName, ToolServices toolServices) {
        this.hostName = hostName;
        this.toolServices = toolServices;
        this.launchpad = this;
        this.title = toolServices.getTitle();
        this.initialize();
    }

    public JFrame getMainWindow() {
        return this;
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource() instanceof Exception) {
            this.displayMessage(event.getActionCommand() + "\n" + ((Exception)event.getSource()).getMessage());
        }
    }

    private void initialize() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            LaunchpadLog.logger().warning("Could not load system look and feel");
        }
        this.setLocationRelativeTo(null);
        LaunchpadLog.logger().finer("Initializing Launchpad gui");
        this.setSize(560, 200);
        this.setContentPane(this.getJContentPane());
        this.setTitle(this.hostName + " - " + this.title);
        iconImage = this.getIconImage(this.toolServices.getIconImage());
        if (iconImage != null) {
            LaunchpadLog.logger().fine("Setting application image");
            this.setIconImage(iconImage);
        }
        this.setDefaultCloseOperation(0);
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            LaunchpadLog.logger().finest("Initilizing Contentpane");
            BorderLayout borderLayout = new BorderLayout();
            this.jContentPane = new JPanel();
            this.jContentPane.setName("jContentPane");
            this.jContentPane.setLayout(borderLayout);
            this.jContentPane.add((Component)this.getJToolListScrollPane(), "Center");
            this.jContentPane.add((Component)this.getJSouthPanel(), "South");
        }
        return this.jContentPane;
    }

    private JScrollPane getJToolListScrollPane() {
        if (this.jToolListScrollPane == null) {
            LaunchpadLog.logger().finest("Initilizing Scrollpane");
            this.jToolListScrollPane = new JScrollPane();
            ScrollPaneLayout layout = new ScrollPaneLayout();
            this.jToolListScrollPane.setLayout(layout);
            this.jToolListScrollPane.setViewportView(this.getJToolList());
        }
        return this.jToolListScrollPane;
    }

    private JList getJToolList() {
        if (this.jToolList == null) {
            LaunchpadLog.logger().finest("Initilizing tool list");
            String[] tools = this.toolServices.getAvailableTools().toArray(new String[0]);
            this.jToolList = new JList<String>(tools);
            this.jToolList.setName("list");
            MouseAdapter mouseListener = new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        try {
                            LaunchpadLog.logger().info("Starting tool: " + LaunchPadGui.this.jToolList.getSelectedValue());
                            LaunchPadGui.this.toolServices.startTool(LaunchPadGui.this.jToolList.getSelectedValue().toString(), LaunchPadGui.this.hostName, null, LaunchPadGui.this.launchpad);
                        }
                        catch (StartFailureException e1) {
                            LaunchpadLog.logger().severe("Could not start " + LaunchPadGui.this.jToolList.getSelectedValue());
                            LaunchPadGui.this.displayMessage("Could not start " + LaunchPadGui.this.jToolList.getSelectedValue() + "\n" + e1.getMessage());
                        }
                    }
                }
            };
            this.jToolList.addMouseListener(mouseListener);
        }
        return this.jToolList;
    }

    private JPanel getJSouthPanel() {
        if (this.jSouthPanel == null) {
            LaunchpadLog.logger().finest("initializing south panel");
            this.jSouthPanel = new JPanel(new BorderLayout());
            this.jSouthPanel.add((Component)this.getJButtonPanel(), "North");
        }
        return this.jSouthPanel;
    }

    private JPanel getJButtonPanel() {
        if (this.jButtonPanel == null) {
            LaunchpadLog.logger().finest("initializing button panel");
            this.jButtonPanel = new JPanel(new FlowLayout(2));
            this.jButtonPanel.add(this.getJLaunchToolButton());
            this.jButtonPanel.add(this.getJCancelButton());
        }
        return this.jButtonPanel;
    }

    private JButton getJLaunchToolButton() {
        if (this.jLaunchToolButton == null) {
            LaunchpadLog.logger().finest("initializing launch button");
            this.jLaunchToolButton = new JButton();
            this.jLaunchToolButton.setName("start_button");
            this.jLaunchToolButton.setText("Start");
            this.jLaunchToolButton.setMnemonic('s');
            this.jLaunchToolButton.setToolTipText("Start the selected tool");
            this.jLaunchToolButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (LaunchPadGui.this.jToolList.getSelectedValue() != null) {
                        Object[] values = LaunchPadGui.this.jToolList.getSelectedValues();
                        for (int i = 0; i < values.length; ++i) {
                            try {
                                LaunchPadGui.this.toolServices.startTool(values[i].toString(), LaunchPadGui.this.hostName, null, LaunchPadGui.this.launchpad);
                                continue;
                            }
                            catch (StartFailureException e1) {
                                LaunchpadLog.logger().severe("Could not start " + values[i]);
                                LaunchPadGui.this.displayMessage("Could not start " + values[i] + "\n" + e1.getMessage());
                            }
                        }
                    }
                }
            });
        }
        return this.jLaunchToolButton;
    }

    private JButton getJCancelButton() {
        if (this.jCancelButton == null) {
            LaunchpadLog.logger().finest("Initializing cancel button");
            this.jCancelButton = new JButton();
            this.jCancelButton.setName("cancel_button");
            this.jCancelButton.setText("Close");
            this.jCancelButton.setMnemonic('c');
            this.jCancelButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    LaunchPadGui.this.userClosing();
                }
            });
        }
        return this.jCancelButton;
    }

    private Image getIconImage(String path) {
        LaunchpadLog.logger().finer("Start fetching application image");
        Image icon = null;
        File imgFile = new File(path);
        if (imgFile != null) {
            LaunchpadLog.logger().finest("Loading image from user cache");
            try {
                int c;
                FileInputStream stream = new FileInputStream(imgFile);
                BufferedInputStream in = new BufferedInputStream(stream);
                ByteArrayOutputStream byteArrayOut = new ByteArrayOutputStream();
                while ((c = in.read()) != -1) {
                    byteArrayOut.write(c);
                }
                return Toolkit.getDefaultToolkit().createImage(byteArrayOut.toByteArray());
            }
            catch (Exception e) {
                LaunchpadLog.logger().finest("Could not load image from user cache, load it from jar");
                ClassLoader classLoader = this.getClass().getClassLoader();
                if (null != Toolkit.getDefaultToolkit().getImage(classLoader.getResource(path))) {
                    icon = Toolkit.getDefaultToolkit().getImage(classLoader.getResource(path));
                } else if (null != Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource(path))) {
                    icon = Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource(path));
                } else {
                    LaunchpadLog.logger().fine("Could not load application image.");
                    return null;
                }
                return icon;
            }
        }
        LaunchpadLog.logger().fine("Could not load application image.");
        return null;
    }

    private void userClosing() {
        Collection<String> appNames = this.toolServices.getStartedTools();
        if (1 == appNames.size()) {
            String qu = "Launchpad will be closed. Do you want to proceed?                             ";
            Object[] opt = new Object[]{"Close", "Cancel"};
            int answ = JOptionPane.showOptionDialog(this, qu, this.getTitle() + " - Exit", 2, 3, null, opt, opt[0]);
            if (0 == answ) {
                this.setVisible(false);
                this.toolServices.exit();
            }
        } else if (appNames.size() > 1) {
            StringBuilder appStrings = new StringBuilder();
            for (String name : appNames) {
                appStrings.append(name);
                appStrings.append("\n");
            }
            String question = "Do you want to close Launchpad,\n or close all following tools towards " + this.hostName + "?                     \n\n" + appStrings.toString();
            Object[] options = new Object[]{"Close Launchpad", "Close All", "Cancel"};
            int n = JOptionPane.showOptionDialog(this, question, this.getTitle() + " - Exit", 1, 3, null, options, options[0]);
            if (0 == n) {
                this.setVisible(false);
                this.toolServices.exit();
            } else if (1 == n) {
                this.setVisible(false);
                this.toolServices.exitAllTools();
            }
        }
    }

    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            super.processWindowEvent(e);
            this.userClosing();
        } else {
            super.processWindowEvent(e);
        }
    }

    private void displayMessage(final String message) {
        if (!SwingUtilities.isEventDispatchThread()) {
            Runnable runner = new Runnable(){

                public void run() {
                    LaunchPadGui.this.displayMessage(message);
                }
            };
            SwingUtilities.invokeLater(runner);
            return;
        }
        Object[] options = new Object[]{"Close"};
        JOptionPane pane = new JOptionPane(message, 1, -1, null, options);
        JDialog dialog = pane.createDialog(this.launchpad, "Message");
        dialog.pack();
        dialog.setVisible(true);
    }
}

