/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.maofro.proxy;

import enea.ose.io.SignalOutputStream;
import java.io.IOException;
import java.util.Iterator;
import se.ericsson.cello.maofro.framework.AggregateParameter;
import se.ericsson.cello.maofro.framework.ArrayParameter;
import se.ericsson.cello.maofro.framework.Parameter;
import se.ericsson.cello.maofro.framework.ParameterVisitor;
import se.ericsson.cello.maofro.framework.SignedIntArrayParameter;
import se.ericsson.cello.maofro.framework.SignedIntParameter;
import se.ericsson.cello.maofro.framework.StringParameter;
import se.ericsson.cello.maofro.framework.StructParameter;
import se.ericsson.cello.maofro.framework.UnsignedIntParameter;
import se.ericsson.cello.maofro.proxy.TagNameDictionary;
import se.ericsson.cello.maofro.proxy.TagNameDictionaryException;
import se.ericsson.cello.support.debug.MessageLog;

public class MaoFroGenericSignalWriter
implements ParameterVisitor {
    private SignalOutputStream sos;
    private TagNameDictionary dictionary;
    public static final int MAOFRO_NONE = 0;
    public static final int MAOFRO_STRING_TYPE = 1;
    public static final int MAOFRO_U32_TYPE = 2;
    public static final int MAOFRO_S32_TYPE = 3;
    public static final int MAOFRO_STRUCT_TYPE = 4;
    public static final int MAOFRO_STRUCT_END = 5;
    public static final int MAOFRO_ARRAY_TYPE = 6;
    public static final int MAOFRO_ARRAY_END = 7;
    public static final int MAOFRO_S32ARRAY_TYPE = 8;
    public static final int MAOFRO_STATUS_OK = 0;

    public MaoFroGenericSignalWriter(SignalOutputStream signalOutputStream, TagNameDictionary tagNameDictionary) {
        this.sos = signalOutputStream;
        this.dictionary = tagNameDictionary;
    }

    public void visitStringParameter(StringParameter stringParameter) throws IOException, TagNameDictionaryException {
        int[] nArray = MaoFroGenericSignalWriter.encodeValue(stringParameter);
        this.writeHeader(stringParameter, 1, nArray.length);
        this.sos.writeU8Array(nArray);
    }

    public static int[] encodeValue(StringParameter stringParameter) {
        int n = stringParameter.length();
        int[] nArray = new int[n + 4 - n % 4];
        String string = stringParameter.getValue();
        for (int i = 0; i < string.length(); ++i) {
            nArray[i] = string.charAt(i);
        }
        return nArray;
    }

    public void visitSignedIntParameter(SignedIntParameter signedIntParameter) throws IOException, TagNameDictionaryException {
        this.writeHeader(signedIntParameter, 3, signedIntParameter.getValue());
    }

    public void visitUnsignedIntParameter(UnsignedIntParameter unsignedIntParameter) throws IOException, TagNameDictionaryException {
        this.writeHeader(unsignedIntParameter, 2, unsignedIntParameter.getValue());
    }

    public void writeHeader(Parameter parameter, int n, long l) throws IOException, TagNameDictionaryException {
        int n2 = this.lookupTag(parameter.getName());
        MessageLog.trace((int)5, this.getClass(), (String)("write parameter: " + parameter.toString() + ", tag= " + n2 + ", type= " + n + ", value= " + l));
        this.sos.writeU32((long)n2);
        this.sos.writeU16(n);
        this.sos.writeU16(0);
        this.sos.writeU32(l);
    }

    public void visitArrayParameter(ArrayParameter arrayParameter) throws Exception {
        this.handleAggregateParameter(arrayParameter, 6, 7);
    }

    public void visitStructParameter(StructParameter structParameter) throws Exception {
        this.handleAggregateParameter(structParameter, 4, 5);
    }

    public void visitSignedIntArrayParameter(SignedIntArrayParameter signedIntArrayParameter) throws Exception {
        this.writeHeader(signedIntArrayParameter, 8, signedIntArrayParameter.getValue().length);
        this.sos.writeS32Array(signedIntArrayParameter.getValue());
    }

    private void handleAggregateParameter(AggregateParameter aggregateParameter, int n, int n2) throws Exception {
        this.writeHeader(aggregateParameter, n, aggregateParameter.size());
        Iterator iterator = aggregateParameter.iterator();
        while (iterator.hasNext()) {
            Parameter parameter = (Parameter)iterator.next();
            parameter.accept(this);
        }
        this.writeHeader(aggregateParameter, n2, aggregateParameter.size());
    }

    private int lookupTag(String string) throws TagNameDictionaryException {
        return this.dictionary.lookupTag(string);
    }
}

