/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.security.mom;

import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.transaction.Coordinator;

public interface Security {
    public static final String REQUESTED_SECURITY_LEVEL = "requestedSecurityLevel";
    public static final String OPERATIONAL_SECURITY_LEVEL = "operationalSecurityLevel";
    public static final String TELNET_AND_FTPSERVERS_ACTIVE = "telnetAndFTPServersActive";
    public static final String DEBUG_PORTS_ACTIVE = "debugPortsActive";
    public static final String FILE_TRANSFER_CLIENT_MODE = "fileTransferClientMode";
    public static final String AUTHORIZATION_CACHE_TIME_OUT = "authorizationCacheTimeOut";
    public static final int AUTHORIZATION_CACHE_TIME_OUT_MIN = 15;
    public static final int AUTHORIZATION_CACHE_TIME_OUT_MAX = 480;
    public static final int AUTHORIZATION_CACHE_TIME_OUT_DEFAULT = 60;
    public static final String LOCAL_AUTHENTICATION_FILE_VERSION = "localAuthenticationFileVersion";
    public static final String A_ASERVER_IPADDRESS_LIST = "aAServerIPAddressList";
    public static final String SECURITY_ID = "SecurityId";
    public static final String USER_LABEL = "userLabel";
    public static final int USER_LABEL_MIN_LENGTH = 0;
    public static final int USER_LABEL_MAX_LENGTH = 128;
    public static final String USER_LABEL_DEFAULT = "";
    public static final String LOCAL_AADATABASE_INSTALLATION_FAILURE = "localAADatabaseInstallationFailure";
    public static final boolean LOCAL_AADATABASE_INSTALLATION_FAILURE_DEFAULT = false;
    public static final String TRUSTED_CERTIFICATE_INSTALLATION_FAILURE = "trustedCertificateInstallationFailure";
    public static final boolean TRUSTED_CERTIFICATE_INSTALLATION_FAILURE_DEFAULT = false;
    public static final String INSTALLED_TRUSTED_CERTIFICATES = "installedTrustedCertificates";
    public static final String TARGET_MONITOR_PORT_ACTIVE = "targetMonitorPortActive";
    public static final String LOCAL_AUTHORIZATION_FILE_VERSION = "localAuthorizationFileVersion";
    public static final String CORBA_SECURITY_ACTIVE = "corbaSecurityActive";
    public static final String CERT_ENROLL_STATE = "certEnrollState";
    public static final String CERT_ENROLL_ERROR_MSG = "certEnrollErrorMsg";
    public static final int CERT_ENROLL_ERROR_MSG_MIN_LENGTH = 0;
    public static final int CERT_ENROLL_ERROR_MSG_MAX_LENGTH = 255;
    public static final String NODE_CERTIFICATE = "nodeCertificate";
    public static final String CERT_EXPIR_WARN_TIME = "certExpirWarnTime";
    public static final int CERT_EXPIR_WARN_TIME_MIN = 2;
    public static final int CERT_EXPIR_WARN_TIME_MAX = 365;
    public static final int CERT_EXPIR_WARN_TIME_DEFAULT = 90;
    public static final String INSTALLED_USER_DEF_PROFILES_INFO = "installedUserDefProfilesInfo";
    public static final String ACTIVE_USER_DEF_PROFILES_INFO = "activeUserDefProfilesInfo";
    public static final String AUTO_UPDATE_CERT_ENROLLMENT_SERVER = "autoUpdateCertEnrollmentServer";
    public static final int AUTO_UPDATE_CERT_ENROLLMENT_SERVER_MIN_LENGTH = 0;
    public static final int AUTO_UPDATE_CERT_ENROLLMENT_SERVER_MAX_LENGTH = 255;
    public static final String AUTO_UPDATE_CERT_ENROLLMENT_SERVER_DEFAULT = "";
    public static final String CRL_EARLY_UPDATE_INTERVAL = "crlEarlyUpdateInterval";
    public static final int CRL_EARLY_UPDATE_INTERVAL_MIN = 0;
    public static final int CRL_EARLY_UPDATE_INTERVAL_MAX = 0;
    public static final int CRL_EARLY_UPDATE_INTERVAL_MIN_2 = 10;
    public static final int CRL_EARLY_UPDATE_INTERVAL_MAX_2 = 1440;
    public static final int CRL_EARLY_UPDATE_INTERVAL_DEFAULT = 60;
    public static final String TYPE_NAME = "Security";

    public int getRequestedSecurityLevel(Coordinator var1) throws MoAccessException;

    public int getOperationalSecurityLevel(Coordinator var1) throws MoAccessException;

    public boolean getTelnetAndFTPServersActive(Coordinator var1) throws MoAccessException;

    public boolean getDebugPortsActive(Coordinator var1) throws MoAccessException;

    public int getFileTransferClientMode(Coordinator var1) throws MoAccessException;

    public int getAuthorizationCacheTimeOut(Coordinator var1) throws MoAccessException;

    public void setAuthorizationCacheTimeOut(int var1, Coordinator var2) throws MoAccessException;

    public String getLocalAuthenticationFileVersion(Coordinator var1) throws MoAccessException;

    public String[] getAAServerIPAddressList(Coordinator var1) throws MoAccessException;

    public String getUserLabel(Coordinator var1) throws MoAccessException;

    public void setUserLabel(String var1, Coordinator var2) throws MoAccessException;

    public boolean getLocalAADatabaseInstallationFailure(Coordinator var1) throws MoAccessException;

    public void setLocalAADatabaseInstallationFailure(boolean var1, Coordinator var2) throws MoAccessException;

    public boolean getTrustedCertificateInstallationFailure(Coordinator var1) throws MoAccessException;

    public void setTrustedCertificateInstallationFailure(boolean var1, Coordinator var2) throws MoAccessException;

    public Struct[] getInstalledTrustedCertificates(Coordinator var1) throws MoAccessException;

    public boolean getTargetMonitorPortActive(Coordinator var1) throws MoAccessException;

    public String getLocalAuthorizationFileVersion(Coordinator var1) throws MoAccessException;

    public boolean getCorbaSecurityActive(Coordinator var1) throws MoAccessException;

    public int getCertEnrollState(Coordinator var1) throws MoAccessException;

    public String getCertEnrollErrorMsg(Coordinator var1) throws MoAccessException;

    public Struct getNodeCertificate(Coordinator var1) throws MoAccessException;

    public int getCertExpirWarnTime(Coordinator var1) throws MoAccessException;

    public void setCertExpirWarnTime(int var1, Coordinator var2) throws MoAccessException;

    public Struct getInstalledUserDefProfilesInfo(Coordinator var1) throws MoAccessException;

    public Struct getActiveUserDefProfilesInfo(Coordinator var1) throws MoAccessException;

    public String getAutoUpdateCertEnrollmentServer(Coordinator var1) throws MoAccessException;

    public void setAutoUpdateCertEnrollmentServer(String var1, Coordinator var2) throws MoAccessException;

    public int getCrlEarlyUpdateInterval(Coordinator var1) throws MoAccessException;

    public void setCrlEarlyUpdateInterval(int var1, Coordinator var2) throws MoAccessException;

    public void actionAddAAServerAddresses(String[] var1, Coordinator var2) throws MoAccessException;

    public void actionRemoveAAServerAddresses(String[] var1, Coordinator var2) throws MoAccessException;

    public void actionInstallLocalAADatabase(String var1, String var2, String var3, int var4, Struct[] var5, Coordinator var6) throws MoAccessException;

    public void actionInstallTrustedCertificates(Struct[] var1, String var2, int var3, Struct[] var4, Coordinator var5) throws MoAccessException;

    public void actionClearAuthorizationCache(Coordinator var1) throws MoAccessException;

    public void actionSetSecurityLevel3(int var1, Coordinator var2) throws MoAccessException;

    public void actionAdaptSecurityLevel(Coordinator var1) throws MoAccessException;

    public void actionCancelInstallLocalAADatabase(Coordinator var1) throws MoAccessException;

    public void actionCancelInstallTrustedCertificates(Coordinator var1) throws MoAccessException;

    public void actionCancelSetSecurityLevel3(Coordinator var1) throws MoAccessException;

    public void actionInitCertEnrollment(Struct var1, Coordinator var2) throws MoAccessException;

    public void actionCancelCertEnrollment(Coordinator var1) throws MoAccessException;

    public void actionConfirmNewCreds(Coordinator var1) throws MoAccessException;

    public void actionRemoveTrustedCert(String var1, String var2, int var3, Coordinator var4) throws MoAccessException;

    public void actionInstallUserDefProfilesFile(Struct[] var1, String var2, Coordinator var3) throws MoAccessException;

    public void actionRemoveUserDefProfilesFile(Coordinator var1) throws MoAccessException;

    public void actionActivateUserDefProfiles(Coordinator var1) throws MoAccessException;

    public void actionDeactivateUserDefProfiles(Coordinator var1) throws MoAccessException;
}

