/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.mao.commonmo.metadata;

import java.util.HashMap;
import java.util.Map;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.crbs.omf.mao.commonmo.Definitions;
import se.ericsson.crbs.omf.mao.commonmo.metadata.AttributeMetaData;
import se.ericsson.crbs.omf.mao.commonmo.metadata.factory.AttributeDataTypeFactory;
import se.ericsson.crbs.omf.mao.commonmo.metadata.types.AttributeDataType;

class AttributeMetaDataImpl
implements AttributeMetaData {
    public static final AttributeDataTypeFactory adtFactory = new AttributeDataTypeFactory();
    private final String name;
    private final String description;
    private final boolean mandatory;
    private final boolean noNotification;
    private final boolean nonPersistent;
    private final boolean readOnly;
    private final boolean restricted;
    private boolean isLocal = false;
    private boolean requiredRemotelyAtCreate = false;
    private boolean uniqueInNode = false;
    private boolean systemWriteableOnly = false;
    private final AttributeDataType data;
    private Struct replacedBy;
    private Struct replacing;
    private final Map domainSpecificMap = new HashMap();

    AttributeMetaDataImpl(String name, String description, boolean mandatory, boolean noNotification, boolean nonPersistent, boolean readOnly, boolean restricted, AttributeDataType data, Struct replacedBy) {
        this.name = name;
        this.description = description;
        this.mandatory = mandatory;
        this.noNotification = noNotification;
        this.nonPersistent = nonPersistent;
        this.readOnly = readOnly;
        this.restricted = restricted;
        this.data = data;
        this.replacedBy = replacedBy;
    }

    public AttributeDataType getData() {
        return this.data;
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public Struct getReplacedBy() {
        return this.replacedBy;
    }

    public Struct getReplacing() {
        return this.replacing;
    }

    public String getDomainSpecific(String domainName) {
        return (String)this.domainSpecificMap.get(domainName);
    }

    public boolean isLocalStored() {
        return this.isLocal;
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public boolean isNoNotification() {
        return this.noNotification;
    }

    public boolean isNonPersistent() {
        return this.nonPersistent;
    }

    public boolean isPmAttribute() {
        return Definitions.isPmAttribute(this.getName());
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean isRequiredRemotelyAtCreate() {
        return this.requiredRemotelyAtCreate;
    }

    public boolean isRestricted() {
        return this.restricted;
    }

    public boolean isSystemWriteableOnly() {
        return this.systemWriteableOnly;
    }

    public boolean isUniqueInNode() {
        return this.uniqueInNode;
    }

    public void setLocalStored() {
        this.isLocal = true;
    }

    public void setRequiredRemotelyAtCreate() {
        this.requiredRemotelyAtCreate = true;
    }

    public void setSystemWriteableOnly() {
        this.systemWriteableOnly = true;
    }

    public void setUniqueInNode() {
        this.uniqueInNode = true;
    }

    public void setReplacedBy(Struct replacedBy) {
        this.replacedBy = replacedBy;
    }

    public void setReplacing(Struct replacing) {
        this.replacing = replacing;
    }

    public void storeDomainSpecific(String doaminName, String doaminSpecific) {
        this.domainSpecificMap.put(doaminName, doaminSpecific);
    }

    public String toString() {
        return this.name + " Mandatory: " + this.mandatory + " No Notification: " + this.noNotification + " Non Persistent: " + this.nonPersistent + " Read Only: " + this.readOnly + " Restricted: " + this.restricted + " Data: " + this.data + " Replaced by: " + this.replacedBy + " Replacing: " + this.replacing;
    }
}

