/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.mao.commonmo.metadata.factory;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import se.ericsson.crbs.omf.mao.commonmo.metadata.AttributeMetaData;
import se.ericsson.crbs.omf.mao.commonmo.metadata.ChildMetaData;
import se.ericsson.crbs.omf.mao.commonmo.metadata.MoMetaData;
import se.ericsson.crbs.omf.mao.commonmo.metadata.factory.MetaDataParser;
import se.ericsson.crbs.omf.mao.commonmo.metadata.finder.MoMetaDataFinder;
import se.ericsson.crbs.omf.mao.commonmo.metadata.types.AttributeDataType;
import se.ericsson.crbs.omf.mao.commonmo.metadata.types.BiDirectionalAssociationDataType;
import se.ericsson.crbs.omf.mao.commonmo.metadata.types.MoRefType;
import se.ericsson.crbs.omf.mao.commonmo.metadata.types.SeqDataType;
import se.ericsson.crbs.omf.mao.xml.XMLElement;

public class RelationshipFactory {
    private static final String CONTAINMENT_TAG = "containment";
    private static final String BI_DIRECTIONAL_ASSOCIATION_TAG = "biDirectionalAssociation";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String RESERVED_BY = "reservedBy";
    private static final String HAS_CLASS_TAG = "hasClass";
    private static final String CARDINALITY_TAG = "cardinality";
    private static final String MAX_TAG = "max";

    private static int extractCardinality(XMLElement currentAssociationEndProperty) {
        int maxCardinality = Integer.MAX_VALUE;
        List cardinalityChildren = currentAssociationEndProperty.getChildren();
        Iterator cardinalityChildIter = cardinalityChildren.iterator();
        while (cardinalityChildIter.hasNext()) {
            XMLElement currentRangeElement = (XMLElement)cardinalityChildIter.next();
            if (!currentRangeElement.getType().equals(MAX_TAG)) continue;
            String currentMaxValue = currentRangeElement.getText();
            maxCardinality = new Integer(currentMaxValue);
        }
        return maxCardinality;
    }

    private static void extractReservedByRefEndPoint(MoMetaDataFinder finder, String relationshipName, Map nameValue, XMLElement currentAssociationEnd) throws IOException {
        int maxCardinality = Integer.MAX_VALUE;
        List currentAssociationEndProperties = currentAssociationEnd.getChildren();
        Iterator associationEndPropertiesIter = currentAssociationEndProperties.iterator();
        String referredToMoType = "";
        while (associationEndPropertiesIter.hasNext()) {
            XMLElement currentAssociationEndProperty = (XMLElement)associationEndPropertiesIter.next();
            if (currentAssociationEndProperty.getType().equals(HAS_CLASS_TAG)) {
                referredToMoType = currentAssociationEndProperty.getAttributes().getValue(NAME_ATTRIBUTE);
                nameValue.put(RESERVED_BY, referredToMoType);
            }
            if (!currentAssociationEndProperty.getType().equals(CARDINALITY_TAG)) continue;
            maxCardinality = RelationshipFactory.extractCardinality(currentAssociationEndProperty);
        }
        BiDirectionalAssociationDataType dataType = RelationshipFactory.getBiDirectionalAssociation(relationshipName, referredToMoType, finder);
        if (dataType != null) {
            dataType.addAssociation(referredToMoType, maxCardinality);
        }
    }

    private static BiDirectionalAssociationDataType getBiDirectionalAssociation(String relationshipName, String referredToMoType, MoMetaDataFinder finder) throws IOException {
        BiDirectionalAssociationDataType dataType = null;
        StringTokenizer moFinder = new StringTokenizer(relationshipName, "_");
        while (moFinder.hasMoreElements()) {
            String currentMoType = moFinder.nextToken();
            if (currentMoType.equals(referredToMoType) || "to".equals(currentMoType)) continue;
            MoMetaData moMetaData = finder.getMoData(currentMoType);
            dataType = RelationshipFactory.getTheDataType(moMetaData);
        }
        return dataType;
    }

    private static BiDirectionalAssociationDataType getTheDataType(MoMetaData moMetaData) {
        AttributeMetaData reservedByAttribute;
        BiDirectionalAssociationDataType dataType = null;
        if (moMetaData != null && (reservedByAttribute = (AttributeMetaData)moMetaData.getAttributes().get(RESERVED_BY)) != null && reservedByAttribute.getData() instanceof BiDirectionalAssociationDataType) {
            dataType = (BiDirectionalAssociationDataType)reservedByAttribute.getData();
        }
        return dataType;
    }

    public static void storeBiDirectionalRelationship(XMLElement relationshipElement, Map biDirectionalRelationshipMap, MoMetaDataFinder finder) throws IOException {
        String relationshipName = relationshipElement.getAttributes().getValue(NAME_ATTRIBUTE);
        List associationElements = relationshipElement.getChildren();
        Iterator associationIter = associationElements.iterator();
        while (associationIter.hasNext()) {
            HashMap<String, String> nameValue = new HashMap<String, String>();
            XMLElement currentAssociation = (XMLElement)associationIter.next();
            List associationEndElements = currentAssociation.getChildren();
            Iterator associationEndIter = associationEndElements.iterator();
            while (associationEndIter.hasNext()) {
                XMLElement currentAssociationEnd = (XMLElement)associationEndIter.next();
                String currentAssociationEndAttributeName = currentAssociationEnd.getAttributes().getValue(NAME_ATTRIBUTE);
                if (currentAssociationEndAttributeName.equals(RESERVED_BY)) {
                    RelationshipFactory.extractReservedByRefEndPoint(finder, relationshipName, nameValue, currentAssociationEnd);
                    continue;
                }
                List currentAssociationEndProperties = currentAssociationEnd.getChildren();
                Iterator associationEndPropertiesIter = currentAssociationEndProperties.iterator();
                while (associationEndPropertiesIter.hasNext()) {
                    XMLElement currentAssociationEndProperty = (XMLElement)associationEndPropertiesIter.next();
                    if (!currentAssociationEndProperty.getType().equals(HAS_CLASS_TAG)) continue;
                    String referredToMoType = "";
                    referredToMoType = currentAssociationEndProperty.getAttributes().getValue(NAME_ATTRIBUTE);
                    nameValue.put(currentAssociationEndAttributeName, referredToMoType);
                }
            }
            biDirectionalRelationshipMap.put(relationshipName, nameValue);
        }
    }

    private static void storeContainmentRelationship(XMLElement containmentTag, Map childParentMap) throws IOException {
        ChildMetaData childMetaData = MetaDataParser.getChildMetaData(containmentTag);
        if (childParentMap.containsKey(childMetaData.getName())) {
            List parentTypes = (List)childParentMap.get(childMetaData.getName());
            parentTypes.add(childMetaData);
        } else {
            ArrayList<ChildMetaData> parentTypes = new ArrayList<ChildMetaData>();
            parentTypes.add(childMetaData);
            childParentMap.put(childMetaData.getName(), parentTypes);
        }
    }

    public static void storeReferencedMOTypes(Map biDirectionalRelationshipMap, MoMetaDataFinder finder) {
        Iterator relationshipIter = biDirectionalRelationshipMap.values().iterator();
        while (relationshipIter.hasNext()) {
            AttributeMetaData attribute;
            Map relationshipEnds = (Map)relationshipIter.next();
            Iterator relationshipEndsIter = relationshipEnds.keySet().iterator();
            String moToUpdate = null;
            String attributeToUpdate = null;
            String referencedMoType = null;
            while (relationshipEndsIter.hasNext()) {
                String relationshipEnd = (String)relationshipEndsIter.next();
                if (RESERVED_BY.equals(relationshipEnd)) {
                    moToUpdate = (String)relationshipEnds.get(RESERVED_BY);
                    continue;
                }
                attributeToUpdate = relationshipEnd;
                referencedMoType = (String)relationshipEnds.get(attributeToUpdate);
            }
            if (moToUpdate == null || (attribute = finder.getMoAttributes(moToUpdate, attributeToUpdate)) == null || referencedMoType == null) continue;
            AttributeDataType attributeData = attribute.getData();
            if (attributeData instanceof MoRefType) {
                ((MoRefType)attributeData).addPossibleReferenceMoType(referencedMoType);
                continue;
            }
            if (!(attributeData instanceof SeqDataType)) continue;
            AttributeDataType seqType = ((SeqDataType)attributeData).getSeqType();
            ((MoRefType)seqType).addPossibleReferenceMoType(referencedMoType);
        }
    }

    public static void storeRelationship(XMLElement relationshipElement, Map childParentMap, Map biDirectionalRelationshipMap, MoMetaDataFinder finder) throws IOException {
        List relationshipChildren = relationshipElement.getChildren();
        Iterator relChildIter = relationshipChildren.iterator();
        while (relChildIter.hasNext()) {
            XMLElement currentRelChild = (XMLElement)relChildIter.next();
            if (currentRelChild.getType().equals(CONTAINMENT_TAG)) {
                RelationshipFactory.storeContainmentRelationship(currentRelChild, childParentMap);
                continue;
            }
            if (!currentRelChild.getType().equals(BI_DIRECTIONAL_ASSOCIATION_TAG)) continue;
            RelationshipFactory.storeBiDirectionalRelationship(relationshipElement, biDirectionalRelationshipMap, finder);
        }
    }

    private RelationshipFactory() {
    }
}

