/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.mao.commonmo.transactions;

import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.Resource;
import se.ericsson.cello.transaction.Resource2;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.ProcessingFailureException;
import se.ericsson.crbs.omf.mao.commonmo.transactions.TransactionManager;

public class TransactionManagerImpl
implements TransactionManager {
    private static final Class THIS_CLASS = TransactionManagerImpl.class;
    private static AbstractLogger logger = LoggingService.getLogger(TransactionManagerImpl.class.getName());
    private Coordinator registeredCoord = null;
    private final Resource myResource;
    private final Resource2 myResource2;
    private final String myResourceName;

    TransactionManagerImpl(Resource aResource, String aResourceName) {
        this.myResource = aResource;
        this.myResource2 = null;
        this.myResourceName = aResourceName;
    }

    TransactionManagerImpl(Resource2 aResource2, String aResourceName) {
        this.myResource = null;
        this.myResource2 = aResource2;
        this.myResourceName = aResourceName;
    }

    public Coordinator getCoordinator() {
        logger.traceGeneral(THIS_CLASS, "Returning coordinator " + this.registeredCoord + (this.registeredCoord == null ? "" : " for Transaction " + this.registeredCoord.getTransactionID()));
        return this.registeredCoord;
    }

    public void markRollBackOnly(Coordinator coordinator) throws ProcessingFailureException {
        logger.traceEnter(this.getClass(), "markRollBackOnly() " + this.myResourceName);
        try {
            coordinator.rollbackOnly();
            logger.traceGeneral(THIS_CLASS, "Resource " + this.myResourceName + " marked Transaction " + coordinator.getTransactionID() + " as rollbackOnly");
        }
        catch (InactiveTransactionException e) {
            throw new ProcessingFailureException(this.myResourceName + " " + e.reason);
        }
        logger.traceReturn(this.getClass(), "markRollBackOnly()");
    }

    public void registerAndCheckResource(Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(this.getClass(), "registerAndCheckResource() " + this.myResourceName);
        try {
            if (this.registeredCoord != null && coordinator.isSameTransaction(this.registeredCoord)) {
                logger.traceDebug(this.getClass(), "Resource " + this.myResourceName + " is already registered in Transaction " + coordinator.getTransactionID());
                return;
            }
            if (this.myResource2 == null) {
                coordinator.registerResource(this.myResource);
            } else {
                coordinator.registerResource(this.myResource2);
            }
            this.registeredCoord = coordinator;
            logger.traceGeneral(THIS_CLASS, "Resource " + this.myResourceName + " registered in Transaction " + coordinator.getTransactionID());
        }
        catch (InactiveTransactionException e) {
            throw new ProcessingFailureException("Transaction is inactive, failed to register Resource " + this.myResourceName);
        }
        logger.traceReturn(this.getClass(), "registerAndCheckResource()");
    }
}

