/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.mao.genericmo.attributes.manager;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.cello.moframework.NoPermissionException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.NoSuchFieldException;
import se.ericsson.cello.moframework.NotHandledAttributeTypeException;
import se.ericsson.cello.moframework.ResourceLockedException;
import se.ericsson.cello.moframework.SequenceDiffInfo;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.TransactionRequiredException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.common.StringHelper;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.AttrListImpl;
import se.ericsson.crbs.omf.mao.commonmo.Definitions;
import se.ericsson.crbs.omf.mao.commonmo.ProcessingFailureException;
import se.ericsson.crbs.omf.mao.commonmo.ResourceUnavailableException;
import se.ericsson.crbs.omf.mao.commonmo.metadata.AttributeMetaData;
import se.ericsson.crbs.omf.mao.commonmo.metadata.MoMetaData;
import se.ericsson.crbs.omf.mao.commonmo.metadata.finder.MoMetaDataFinder;
import se.ericsson.crbs.omf.mao.commonmo.metadata.finder.MoMetaDataFinderFactory;
import se.ericsson.crbs.omf.mao.commonmo.metadata.finder.MoMetaDataNames;
import se.ericsson.crbs.omf.mao.commonmo.metadata.supplier.DataSupplier;
import se.ericsson.crbs.omf.mao.commonmo.metadata.types.AttributeDataType;
import se.ericsson.crbs.omf.mao.commonmo.metadata.types.BooleanDataType;
import se.ericsson.crbs.omf.mao.commonmo.metadata.types.EnumDataType;
import se.ericsson.crbs.omf.mao.commonmo.metadata.types.IntegerDataType;
import se.ericsson.crbs.omf.mao.commonmo.metadata.types.LongDataType;
import se.ericsson.crbs.omf.mao.commonmo.metadata.types.MoRefType;
import se.ericsson.crbs.omf.mao.commonmo.metadata.types.SeqDataType;
import se.ericsson.crbs.omf.mao.commonmo.metadata.types.StringDataType;
import se.ericsson.crbs.omf.mao.commonmo.metadata.types.StructRefType;
import se.ericsson.crbs.omf.mao.commonmo.mo.GenericManagedObject;
import se.ericsson.crbs.omf.mao.commonmo.validation.MoValidator;
import se.ericsson.crbs.omf.mao.commonmo.validation.MoValidatorFactory;
import se.ericsson.crbs.omf.mao.genericmo.DeprecatedGenericMaoHelper;
import se.ericsson.crbs.omf.mao.genericmo.GenericMao;
import se.ericsson.crbs.omf.mao.genericmo.attributes.manager.AttributeManager;
import se.ericsson.crbs.omf.mao.genericmo.attributes.manager.LocalAttributeManager;
import se.ericsson.crbs.omf.mao.genericmo.attributes.manager.PmAttribute;
import se.ericsson.crbs.omf.mao.genericmo.attributes.manager.RemoteAttributeManager;
import se.ericsson.crbs.omf.mao.genericmo.attributes.type.MaoSequenceAttribute;
import se.ericsson.crbs.omf.mao.indications.IndicationHandler;
import se.ericsson.crbs.omf.mao.indications.IndicationHandlerSdn;
import se.ericsson.crbs.omf.mao.wrappers.MoDataWrapper;
import se.ericsson.crbs.omf.mao.wrappers.MoDataWrapperFactory;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

class AttributeManagerImpl
implements AttributeManager {
    private static final Class THIS_CLASS = AttributeManagerImpl.class;
    private static AbstractLogger logger = LoggingService.getLogger(AttributeManagerImpl.class.getName());
    private final MoValidatorFactory moValidatorFactory;
    private final LocalAttributeManager localAttributeManager;
    private final RemoteAttributeManager remoteAttributeManager;
    private final GenericManagedObject myMo;
    private final MoDataWrapperFactory myMoDataWrapperFactory;
    private MoMetaDataFinder moMetaDataFinder;
    private final String myMoType;
    private final IndicationHandler myIndicationHandler;
    private final PmAttribute pmAttributeHandler;
    private final MoMetaDataNames moMetaDataNames;
    private final MoRepositoryWrapper moRepositoryWrapper;
    private final DataSupplier dataSupplier;

    public AttributeManagerImpl(GenericManagedObject myMo, LocalAttributeManager aLocalAttributeManager, RemoteAttributeManager aRemoteAttributeManager, MoDataWrapperFactory aMoDataWrapperFactory, MoValidatorFactory aMoValidatorFactory, MoMetaDataFinder aFinder, IndicationHandler anIndicationHandler, PmAttribute aPmAttributeHandler, MoMetaDataNames aMoMetaDataNames, MoRepositoryWrapper aMoRepositoryWrapper, DataSupplier aDataSupplier) throws MoAccessException {
        logger.traceEnter(this.getClass(), "AttributeManagerImpl() - " + myMo.getType());
        this.moMetaDataNames = aMoMetaDataNames;
        this.localAttributeManager = aLocalAttributeManager;
        this.remoteAttributeManager = aRemoteAttributeManager;
        this.myMoDataWrapperFactory = aMoDataWrapperFactory;
        this.moValidatorFactory = aMoValidatorFactory;
        this.moMetaDataFinder = aFinder;
        this.myIndicationHandler = anIndicationHandler;
        this.pmAttributeHandler = aPmAttributeHandler;
        this.moRepositoryWrapper = aMoRepositoryWrapper;
        this.dataSupplier = aDataSupplier;
        this.myMo = myMo;
        this.myMoType = myMo.getType();
        logger.traceReturn(this.getClass(), "AttributeManagerImpl() - " + this.myMoType);
    }

    public void addReservedBy(ManagedObject moToReference, Coordinator coordinator) throws TransactionRequiredException, MoAccessException {
        this.localAttributeManager.addReservedBy(moToReference, coordinator);
        this.sdnForReservedBy(coordinator);
    }

    public void checkForReferencesToMO(Coordinator coordinator) throws MoAccessException {
        this.localAttributeManager.validateReferencesAtDelete(coordinator);
    }

    public void clear() {
        logger.traceEnter(this.getClass(), "clear() - " + this.myMoType);
        this.remoteAttributeManager.clear();
        logger.traceReturn(this.getClass(), "clear() - " + this.myMoType);
    }

    public void createMo(AttrList attributes, Integer softwareRevision, ManagedObject parent, GenericManagedObject genericMao, boolean deprecated, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(this.getClass(), "createMo() - " + this.myMoType);
        AttrList attributeList = this.replaceDeprecatedAttributes(attributes);
        MoDataWrapper mMoData = this.myMoDataWrapperFactory.createMoDataWrapper(this.myMo.getLocalDistinguishedName(), this.myMo.getType(), true, coordinator);
        mMoData.setRevision(softwareRevision);
        if (deprecated) {
            this.initMoData(attributeList, mMoData, coordinator);
        } else {
            AttrList signalParameters = this.getParametersForCreate(attributeList, parent);
            signalParameters = genericMao.addFroParametersAtCreate(signalParameters, attributeList, coordinator);
            logger.traceDebug(THIS_CLASS, "Parameters sent to FRO: \n" + StringHelper.toString(signalParameters));
            try {
                GenericMao castedGenericMao = (GenericMao)genericMao;
                attributeList = castedGenericMao.addMaoParametersAtCreate(signalParameters, attributeList, coordinator);
            }
            catch (ClassCastException e) {
                logger.traceDebug(THIS_CLASS, "Due to attribute genericMao is not instance of GenericMao class, method addMaoParametersAtCreate cannot be executed.");
            }
            this.initMoData(attributeList, mMoData, coordinator);
            int froId = this.remoteAttributeManager.createMo(coordinator, signalParameters);
            this.localAttributeManager.initFroId(froId);
        }
        logger.traceReturn(this.getClass(), "createMo() - " + this.myMoType);
    }

    private final AttrList getParametersForCreate(AttrList attributes, ManagedObject parent) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "getParametersForCreate(" + this.getClass().getPackage().getName() + ") - " + this.myMoType);
        AttrListImpl froParameters = new AttrListImpl(this.moRepositoryWrapper);
        froParameters.addAttribute("parentRef", parent);
        Map moAttributes = this.moMetaDataFinder.getMoAttributes(this.myMoType);
        Iterator attributeIter = moAttributes.values().iterator();
        while (attributeIter.hasNext()) {
            AttributeMetaData currentAttribute = (AttributeMetaData)attributeIter.next();
            String currentAttributeName = currentAttribute.getName();
            if (currentAttribute.isPmAttribute() || (this.myMoType + "Id").equals(currentAttributeName) || currentAttribute.isReadOnly() || this.isAttributeDeprecated(currentAttribute) || currentAttribute.isLocalStored() && !currentAttribute.isRequiredRemotelyAtCreate()) continue;
            if (attributes.contains(new String[]{currentAttributeName})) {
                froParameters.addElement(currentAttributeName, attributes.getValue(attributes.indexOf(currentAttributeName)));
                logger.traceDebug(THIS_CLASS, "Parameter " + currentAttributeName + " is needed by Fro");
                continue;
            }
            throw new ProcessingFailureException("No attribute value for attribute: " + currentAttributeName + " when creating MO: " + this.myMoType);
        }
        logger.traceReturn(THIS_CLASS, "getParametersForCreate(" + this.getClass().getPackage().getName() + ") - " + this.myMoType);
        return froParameters;
    }

    public void delete(Coordinator coordinator) throws MoAccessException, ProcessingFailureException {
        logger.traceEnter(this.getClass(), "delete() - " + this.myMoType);
        this.localAttributeManager.delete(coordinator);
        logger.traceReturn(this.getClass(), "delete() - " + this.myMoType);
    }

    public void deleteAdditionalAttribute(String attributeName, Coordinator coordinator) {
        logger.traceEnter(THIS_CLASS, "deleteAdditionalAttribute(" + attributeName + ") - " + this.myMoType);
        this.localAttributeManager.deleteAdditionalAttribute(attributeName, coordinator);
        logger.traceReturn(THIS_CLASS, "deleteAdditionalAttribute(" + attributeName + ") - " + this.myMoType);
    }

    public void deleteMo(AttrList attrList, boolean deprecated, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(this.getClass(), "deleteMo() - " + this.myMoType);
        this.localAttributeManager.handleTransaction(coordinator, MoDataWrapper.WRITE_ACCESS);
        if (!deprecated) {
            this.checkForReferencesToMO(coordinator);
            this.remoteAttributeManager.deleteMo(attrList, coordinator);
        }
        this.delete(coordinator);
        logger.traceReturn(this.getClass(), "deleteMo() - " + this.myMoType);
    }

    public Object getAdditionalAttribute(String attributeName, Coordinator coordinator) throws TransactionRequiredException, ProcessingFailureException, ResourceUnavailableException, MoAccessException {
        logger.traceEnter(this.getClass(), "getAdditionalAttribute() - " + this.myMoType);
        Object res = this.localAttributeManager.getAdditionalAttribute(attributeName, coordinator);
        logger.traceReturn(this.getClass(), "getAdditionalAttribute() - " + this.myMoType);
        return res;
    }

    /*
     * Unable to fully structure code
     */
    public Object getAttribute(String attributeName, Coordinator coordinator) throws TransactionRequiredException, ProcessingFailureException, ResourceUnavailableException, MoAccessException {
        AttributeManagerImpl.logger.traceEnter(this.getClass(), "getAttribute(" + attributeName + ") - " + this.myMoType);
        attributeValue = null;
        replacingMoName = this.checkIfDeprecatedMo();
        if (replacingMoName == null) {
            attrName = this.checkIfDeprecatedAttribute(attributeName);
            if (Definitions.isPmAttribute(attrName)) {
                AttributeManagerImpl.logger.traceDebug(this.getClass(), attrName + " is a PM counter");
                if (this.pmAttributeHandler == null) {
                    throw new ResourceUnavailableException("PmHandler", "Not registred");
                }
                counters = new String[]{attrName};
                counterValues = this.pmAttributeHandler.getCounterValues(this.myMo.getLocalDistinguishedName(), counters);
                attributeValue = this.isPmCounterValueASingleInteger(attrName) ? new Integer(counterValues[0][0]) : (Object)counterValues[0];
            } else {
                moValidator = this.moValidatorFactory.createMoValidatorImpl(this.myMo.getType());
                try {
                    AttributeManagerImpl.logger.traceDebug(this.getClass(), attrName + " is not a PM counter");
                    moValidator.verifyAtGet(this.myMo.getType(), attrName);
                    if (this.localAttributeManager.isLocal(attrName)) {
                        attributeValue = this.localAttributeManager.getAttribute(attrName, coordinator);
                    }
                    attributeValue = this.remoteAttributeManager.getAttribute(attrName, coordinator);
                }
                catch (NoSuchAttributeException nse) {
                    if ("enabled".equalsIgnoreCase(System.getProperty("additionalAttributes"))) {
                        attributeValue = this.getAdditionalAttribute(attrName, coordinator);
                        if (attributeValue != null) ** GOTO lbl31
                        throw nse;
                    }
                    throw nse;
                }
            }
        } else {
            replacingMo = this.lookupReplacingMo(replacingMoName);
            attributeValue = replacingMo.getAttribute(attributeName, coordinator);
        }
lbl31:
        // 5 sources

        AttributeManagerImpl.logger.traceReturn(this.getClass(), "getAttribute(" + attributeName + ") - " + this.myMoType);
        return attributeValue;
    }

    public Object[] getAttributes(String[] attrNames, Coordinator coordinator) throws TransactionRequiredException, ProcessingFailureException, ResourceUnavailableException, MoAccessException {
        Object[] attributeValues;
        logger.traceEnter(this.getClass(), "getAttributes() - " + this.myMoType);
        String replacingMoName = this.checkIfDeprecatedMo();
        if (replacingMoName == null) {
            int i;
            HashMap<String, Object> allAttributes = new HashMap<String, Object>();
            ArrayList<String> remoteAttributeNames = new ArrayList<String>();
            ArrayList<String> counterAttributeNames = new ArrayList<String>();
            String[] attrNamesArr = new String[attrNames.length];
            System.arraycopy(attrNames, 0, attrNamesArr, 0, attrNames.length);
            for (i = 0; i < attrNames.length; ++i) {
                attrNamesArr[i] = this.checkIfDeprecatedAttribute(attrNames[i]);
                if (Definitions.isPmAttribute(attrNamesArr[i])) {
                    logger.traceDebug(this.getClass(), attrNamesArr[i] + " is a PM counter");
                    counterAttributeNames.add(attrNamesArr[i]);
                    continue;
                }
                MoValidator moValidator = this.moValidatorFactory.createMoValidatorImpl(this.myMo.getType());
                try {
                    logger.traceDebug(this.getClass(), attrNamesArr[i] + " is not a PM counter");
                    moValidator.verifyAtGet(this.myMo.getType(), attrNamesArr[i]);
                    if (this.localAttributeManager.isLocal(attrNamesArr[i])) {
                        allAttributes.put(attrNamesArr[i], this.localAttributeManager.getAttribute(attrNamesArr[i], coordinator));
                        continue;
                    }
                    remoteAttributeNames.add(attrNamesArr[i]);
                    continue;
                }
                catch (NoSuchAttributeException nse) {
                    if ("enabled".equalsIgnoreCase(System.getProperty("additionalAttributes"))) {
                        Object attributeValue = this.getAdditionalAttribute(attrNamesArr[i], coordinator);
                        if (attributeValue == null) {
                            throw nse;
                        }
                        allAttributes.put(attrNamesArr[i], attributeValue);
                        continue;
                    }
                    throw nse;
                }
            }
            if (!remoteAttributeNames.isEmpty()) {
                allAttributes.putAll(this.getRemoteAttributes(remoteAttributeNames, coordinator));
            }
            if (!counterAttributeNames.isEmpty()) {
                allAttributes.putAll(this.getCounterAttributes(counterAttributeNames));
            }
            attributeValues = new Object[attrNamesArr.length];
            for (i = 0; i < attrNamesArr.length; ++i) {
                attributeValues[i] = allAttributes.get(attrNamesArr[i]);
            }
        } else {
            ManagedObject replacingMo = this.lookupReplacingMo(replacingMoName);
            attributeValues = replacingMo.getAttributes(attrNames, coordinator);
        }
        logger.traceReturn(this.getClass(), "getAttributes()");
        return attributeValues;
    }

    private String checkIfDeprecatedMo() throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "checkIfDeprecatedMo()");
        String replacingMo = null;
        MoMetaData moMetaData = this.moMetaDataFinder.getMoData(this.myMoType);
        Struct replacedByValue = moMetaData.getReplacedBy();
        if (replacedByValue != null) {
            try {
                replacingMo = (String)replacedByValue.getValue("moName");
            }
            catch (NoSuchFieldException nsfe) {
                logger.traceAbnormal(THIS_CLASS, "Failed to get replacing MO name for MO " + this.myMoType + ".");
                throw nsfe;
            }
        }
        logger.traceReturn(THIS_CLASS, "checkIfDeprecatedMo(), replacingMo=" + replacingMo);
        return replacingMo;
    }

    private ManagedObject lookupReplacingMo(String replacingMoName) throws MoNotFoundException {
        String parentLdn = this.myMo.getParent().getLocalDistinguishedName();
        String replacingLdn = parentLdn + "," + replacingMoName + "=" + this.myMo.getNamingAttributeValue();
        ManagedObject replacingMo = this.moRepositoryWrapper.lookup(replacingLdn);
        if (replacingMo == null) {
            throw new MoNotFoundException("Failed to lookup the MO with LDN=" + replacingLdn + ", that replaces the MO with LDN=" + this.myMo.getLocalDistinguishedName());
        }
        return replacingMo;
    }

    private String checkIfDeprecatedAttribute(String attributeName) throws NoSuchAttributeException, MoAccessException {
        logger.traceEnter(THIS_CLASS, "checkIfDeprecatedAttribute()");
        boolean checkDeprecated = true;
        String attributeToCheck = attributeName;
        String attrName = attributeName;
        while (checkDeprecated) {
            AttributeMetaData attributeMetaData = this.moMetaDataFinder.getMoAttributes(this.myMoType, attributeToCheck);
            if (attributeMetaData == null) {
                throw new NoSuchAttributeException(attributeToCheck, this.myMoType);
            }
            if (this.isAttributeDeprecated(attributeMetaData)) {
                attributeToCheck = attrName = DeprecatedGenericMaoHelper.getReplacingAttributeName(attributeMetaData, this.myMoType);
                logger.traceDebug(THIS_CLASS, "The attribute " + attributeToCheck + " is deprecated and is replaced by " + attrName);
                continue;
            }
            checkDeprecated = false;
        }
        logger.traceReturn(THIS_CLASS, "checkIfDeprecatedAttribute()");
        return attrName;
    }

    private Map getCounterAttributes(List countrAttributeNames) throws ResourceUnavailableException, ProcessingFailureException {
        String[] counterNames = new String[countrAttributeNames.size()];
        ListIterator raIter = countrAttributeNames.listIterator();
        int i = 0;
        while (raIter.hasNext()) {
            counterNames[i] = raIter.next().toString();
            ++i;
        }
        int[][] counterValues = this.pmAttributeHandler.getCounterValues(this.myMo.getLocalDistinguishedName(), counterNames);
        HashMap<String, Object> counterAttributes = new HashMap<String, Object>();
        for (int j = 0; j < counterNames.length; ++j) {
            if (this.isPmCounterValueASingleInteger(counterNames[j])) {
                counterAttributes.put(counterNames[j], new Integer(counterValues[j][0]));
                continue;
            }
            counterAttributes.put(counterNames[j], counterValues[j]);
        }
        return counterAttributes;
    }

    private Map getRemoteAttributes(List remoteAttributeNames, Coordinator coordinator) throws MoAccessException {
        String[] remoteAttrNames = new String[remoteAttributeNames.size()];
        ListIterator raIter = remoteAttributeNames.listIterator();
        int i = 0;
        while (raIter.hasNext()) {
            remoteAttrNames[i] = raIter.next().toString();
            ++i;
        }
        return this.remoteAttributeManager.getAttributes(remoteAttrNames, coordinator);
    }

    public int getFroId(Coordinator coordinator) throws MoAccessException, TransactionRequiredException {
        logger.traceEnter(this.getClass(), "getFroId() - " + this.myMoType);
        int res = this.localAttributeManager.getFroId(coordinator);
        logger.traceReturn(this.getClass(), "getFroId() - " + this.myMoType);
        return res;
    }

    private final void handleAVCNotification(Map changedNameValues, String moType, Coordinator coord) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "handleAVCNotification() - " + this.myMoType);
        Iterator attrIter = changedNameValues.entrySet().iterator();
        while (attrIter.hasNext()) {
            Map.Entry entry = attrIter.next();
            String currentAttrName = (String)entry.getKey();
            AttributeMetaData attrMetaData = this.getMoMetaDataFinder().getMoAttributes(moType, currentAttrName);
            if (attrMetaData == null || attrMetaData.isNoNotification()) continue;
            Object val = this.correctTheTypeForEmptyArrays(entry.getValue(), attrMetaData);
            this.myIndicationHandler.handleAvcNotification(currentAttrName, val, coord);
        }
        logger.traceReturn(THIS_CLASS, "handleAVCNotification() - " + this.myMoType);
    }

    private Object correctTheTypeForEmptyArrays(Object val, AttributeMetaData attrMetaData) {
        Object[] result = val;
        AttributeDataType attrDataType = attrMetaData.getData();
        if (attrDataType instanceof SeqDataType && val instanceof Object[] && ((Object[])val).length == 0) {
            AttributeDataType seqType = ((SeqDataType)attrDataType).getSeqType();
            if (seqType instanceof BooleanDataType) {
                result = new Boolean[]{};
            } else if (seqType instanceof EnumDataType) {
                result = new Integer[]{};
            } else if (seqType instanceof IntegerDataType) {
                result = new Integer[]{};
            } else if (seqType instanceof LongDataType) {
                result = new Long[]{};
            } else if (seqType instanceof MoRefType) {
                result = new ManagedObject[]{};
            } else if (seqType instanceof StringDataType) {
                result = new String[]{};
            } else if (seqType instanceof StructRefType) {
                result = new Struct[]{};
            }
        }
        return result;
    }

    private final MoMetaDataFinder getMoMetaDataFinder() throws MoAccessException {
        if (this.moMetaDataFinder == null) {
            try {
                this.moMetaDataFinder = MoMetaDataFinderFactory.getFinderInstance("MOM_META_DATA", this.moMetaDataNames);
            }
            catch (IOException e) {
                throw new ProcessingFailureException("Cannot read MOM XML Files. Original Exception: " + e.getMessage());
            }
        }
        return this.moMetaDataFinder;
    }

    public final void handleTransactionRead(Coordinator coordinator) throws TransactionRequiredException, NoPermissionException, ResourceLockedException {
        this.localAttributeManager.handleTransaction(coordinator, MoDataWrapper.READ_ACCESS);
    }

    public final void handleTransactionWrite(Coordinator coordinator) throws TransactionRequiredException, NoPermissionException, ResourceLockedException {
        this.localAttributeManager.handleTransaction(coordinator, MoDataWrapper.WRITE_ACCESS);
    }

    public void initFroId(int froId) throws MoAccessException {
        this.localAttributeManager.initFroId(froId);
    }

    public void initMoData(AttrList attributes, MoDataWrapper myMoData, Coordinator coordinator) throws MoAccessException {
        this.localAttributeManager.initMoData(attributes, myMoData, coordinator);
    }

    public void recover(MoDataWrapper recoveredData) {
        this.localAttributeManager.recover(recoveredData);
    }

    public void removeReservedBy(ManagedObject moToRemove, Coordinator coordinator) throws TransactionRequiredException, MoAccessException {
        this.localAttributeManager.removeReservedBy(moToRemove, coordinator);
        this.sdnForReservedBy(coordinator);
    }

    public Map sendActionWithCfm(String actionName, Coordinator coordinator, Map attributes) throws TransactionRequiredException, MoAccessException {
        return this.remoteAttributeManager.sendActionWithCfm(actionName, coordinator, attributes);
    }

    public void sendActionWithoutCfm(String actionName, Coordinator coordinator, Map attributes) throws MoAccessException {
        this.remoteAttributeManager.sendActionWithoutCfm(actionName, coordinator, attributes);
    }

    public void setAdditionalAttribute(String attributeName, Object attributeValue, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(this.getClass(), "setAdditionalAttribute() - " + this.myMoType);
        this.localAttributeManager.setAdditionalAttribute(attributeName, attributeValue, coordinator);
        logger.traceReturn(this.getClass(), "setAdditionalAttribute() - " + this.myMoType);
    }

    public void setAttributes(Map attributeNameValuePairs, boolean isSystemWriteableOnly, boolean performValidation, MoValidator moValidator, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(this.getClass(), "setAttributes() - " + this.myMoType);
        String replacingMoName = this.checkIfDeprecatedMo();
        if (replacingMoName == null) {
            Map attrNameValuePairs = this.replaceDeprecatedAttributes(attributeNameValuePairs);
            Iterator attributeIter = attrNameValuePairs.entrySet().iterator();
            HashMap froSetSignalParameters = new HashMap();
            HashMap maoSetSignalParameters = new HashMap();
            while (attributeIter.hasNext()) {
                Map.Entry entry = attributeIter.next();
                String currentAttributeName = (String)entry.getKey();
                Object currentAttributeValue = entry.getValue();
                logger.traceDebug(this.getClass(), "setAttribute() " + currentAttributeName + " invoked");
                try {
                    if (performValidation) {
                        moValidator.verifyAtSet(currentAttributeName, currentAttributeValue, isSystemWriteableOnly, this.myMo, coordinator);
                    }
                    AttributeMetaData attrMetaData = this.moMetaDataFinder.getMoAttributes(this.myMoType, currentAttributeName);
                    currentAttributeValue = this.addMissingStructMembersInOptionalAttribute(coordinator, currentAttributeName, currentAttributeValue, attrMetaData);
                    currentAttributeValue = ((GenericMao)this.myMo).preSet(currentAttributeName, attrNameValuePairs, currentAttributeValue, coordinator);
                    if (this.localAttributeManager.isLocal(currentAttributeName)) {
                        maoSetSignalParameters.put(currentAttributeName, currentAttributeValue);
                        AttributeMetaData attrData = this.moMetaDataFinder.getMoAttributes(this.myMo.getType(), currentAttributeName);
                        if (!attrData.isRequiredRemotelyAtCreate()) continue;
                        froSetSignalParameters.put(currentAttributeName, currentAttributeValue);
                        continue;
                    }
                    froSetSignalParameters.put(currentAttributeName, currentAttributeValue);
                }
                catch (NoSuchAttributeException nse) {
                    if ("enabled".equalsIgnoreCase(System.getProperty("additionalAttributes"))) {
                        this.setAdditionalAttribute(currentAttributeName, currentAttributeValue, coordinator);
                        continue;
                    }
                    throw nse;
                }
            }
            logger.traceParam(THIS_CLASS, "Parameters sent to FRO: \n" + StringHelper.toString(froSetSignalParameters));
            this.localAttributeManager.setAttributes(maoSetSignalParameters, coordinator);
            this.remoteAttributeManager.setAttributes(coordinator, froSetSignalParameters, moValidator, attrNameValuePairs);
            this.handleAVCNotification(attrNameValuePairs, this.myMo.getType(), coordinator);
        } else {
            ManagedObject replacingMo = this.lookupReplacingMo(replacingMoName);
            String[] attrNames = attributeNameValuePairs.keySet().toArray(new String[0]);
            Object[] attrValues = attributeNameValuePairs.values().toArray();
            replacingMo.setAttributes(attrNames, attrValues, coordinator);
        }
        logger.traceReturn(this.getClass(), "setAttributes() - " + this.myMoType);
    }

    private Object addMissingStructMembersInOptionalAttribute(Coordinator coordinator, String currentAttributeName, Object currentAttributeValue, AttributeMetaData attrMetaData) throws TransactionRequiredException, ProcessingFailureException, ResourceUnavailableException, MoAccessException {
        Object result = currentAttributeValue;
        if (!attrMetaData.isMandatory() && (currentAttributeValue instanceof Struct || currentAttributeValue instanceof Struct[])) {
            Object attrValueInDataBase = this.getAttribute(currentAttributeName, coordinator);
            result = this.dataSupplier.supplyStructDataAtSet(currentAttributeValue, attrValueInDataBase, attrMetaData, coordinator);
        }
        return result;
    }

    private boolean isAttributeDeprecated(AttributeMetaData attributeMetaData) {
        boolean deprecated = false;
        Struct replacedByValue = attributeMetaData.getReplacedBy();
        if (replacedByValue != null) {
            deprecated = true;
        }
        return deprecated;
    }

    private Map replaceDeprecatedAttributes(Map attributeNameValuePairs) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "replaceDeprecatedAttributes(Map)");
        HashMap newAttributeNameValuePairs = new HashMap(attributeNameValuePairs);
        Iterator iter = attributeNameValuePairs.entrySet().iterator();
        while (iter.hasNext()) {
            String resultingAttrName;
            Map.Entry entry = iter.next();
            String attrName = (String)entry.getKey();
            if (Definitions.isTransparentData(attrName) || (resultingAttrName = this.checkIfDeprecatedAttribute(attrName)).equals(attrName)) continue;
            newAttributeNameValuePairs.remove(attrName);
            newAttributeNameValuePairs.put(resultingAttrName, entry.getValue());
        }
        logger.traceReturn(THIS_CLASS, "replaceDeprecatedAttributes(Map)");
        return newAttributeNameValuePairs;
    }

    private AttrList replaceDeprecatedAttributes(AttrList attributes) throws NotHandledAttributeTypeException, NoSuchFieldException, MoNotFoundException, NoSuchAttributeException {
        logger.traceEnter(THIS_CLASS, "replaceDeprecatedAttributes(AttrList)");
        AttrListImpl newAttrList = new AttrListImpl(this.moRepositoryWrapper);
        Map attrMetaDataMap = this.moMetaDataFinder.getMoAttributes(this.myMoType);
        for (int attrIndex = 0; attrIndex < attributes.size(); ++attrIndex) {
            String attrName = attributes.getName(attrIndex);
            Object attrValue = attributes.getValue(attrIndex);
            if (Definitions.isTransparentData(attrName)) continue;
            AttributeMetaData attrMetaData = (AttributeMetaData)attrMetaDataMap.get(attrName);
            if (attrMetaData == null) {
                throw new NoSuchAttributeException(attrName, this.myMoType);
            }
            if (this.isAttributeDeprecated(attrMetaData)) {
                String replacingAttrName = DeprecatedGenericMaoHelper.getReplacingAttributeName(attrMetaData, this.myMoType);
                newAttrList.addAttribute(replacingAttrName, attrValue);
                continue;
            }
            newAttrList.addAttribute(attrName, attrValue);
        }
        logger.traceReturn(THIS_CLASS, "replaceDeprecatedAttributes(AttrList)");
        return newAttrList;
    }

    private boolean isPmCounterValueASingleInteger(String counterName) {
        logger.traceEnter(THIS_CLASS, "isPmCounterValueASingleInteger()");
        AttributeMetaData attributeMetaData = this.moMetaDataFinder.getMoAttributes(this.myMoType, counterName);
        boolean singleInteger = attributeMetaData.getData() instanceof IntegerDataType;
        logger.traceReturn(THIS_CLASS, "isPmCounterValueASingleInteger(), singleInteger=" + singleInteger);
        return singleInteger;
    }

    private void sdnForReservedBy(Coordinator coordinator) throws TransactionRequiredException, ProcessingFailureException, ResourceUnavailableException, MoAccessException {
        HashMap<String, Object> resByMap = new HashMap<String, Object>();
        resByMap.put("reservedBy", this.localAttributeManager.getLocalAttribute("reservedBy", coordinator));
        this.handleSDNNotification(resByMap, this.myMoType, coordinator);
    }

    private final void handleSDNNotification(Map changedNameValues, String moType, Coordinator coord) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "handleSDNNotification() - " + this.myMoType);
        if (this.myIndicationHandler instanceof IndicationHandlerSdn) {
            Iterator attrIter = changedNameValues.entrySet().iterator();
            while (attrIter.hasNext()) {
                Object attribute;
                Map.Entry entry = attrIter.next();
                String currentAttrName = (String)entry.getKey();
                AttributeMetaData attrMetaData = this.getMoMetaDataFinder().getMoAttributes(moType, currentAttrName);
                if (attrMetaData == null || attrMetaData.isNoNotification() || !((attribute = entry.getValue()) instanceof MaoSequenceAttribute)) continue;
                SequenceDiffInfo sequenceDiffInfo = ((MaoSequenceAttribute)attribute).getSequenceDiffInfo(coord);
                ((IndicationHandlerSdn)this.myIndicationHandler).handleSdnNotification("reservedBy", sequenceDiffInfo, coord);
            }
        } else {
            this.handleAVCNotification(changedNameValues, moType, coord);
        }
        logger.traceReturn(THIS_CLASS, "handleSDNNotification() - " + this.myMoType);
    }
}

