/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.mao.genericmo.attributes.type;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.metadata.AttributeMetaData;
import se.ericsson.crbs.omf.mao.commonmo.metadata.finder.MoMetaDataFinder;
import se.ericsson.crbs.omf.mao.commonmo.metadata.types.AttributeDataType;
import se.ericsson.crbs.omf.mao.commonmo.metadata.types.BooleanDataType;
import se.ericsson.crbs.omf.mao.commonmo.metadata.types.EnumDataType;
import se.ericsson.crbs.omf.mao.commonmo.metadata.types.IntegerDataType;
import se.ericsson.crbs.omf.mao.commonmo.metadata.types.LongDataType;
import se.ericsson.crbs.omf.mao.commonmo.metadata.types.MoRefType;
import se.ericsson.crbs.omf.mao.commonmo.metadata.types.SeqDataType;
import se.ericsson.crbs.omf.mao.commonmo.metadata.types.StringDataType;
import se.ericsson.crbs.omf.mao.commonmo.metadata.types.StructRefType;
import se.ericsson.crbs.omf.mao.genericmo.attributes.type.LocalAttribute;
import se.ericsson.crbs.omf.mao.genericmo.attributes.type.MaoAttributeFactory;
import se.ericsson.crbs.omf.mao.genericmo.attributes.type.MaoBooleanAttribute;
import se.ericsson.crbs.omf.mao.genericmo.attributes.type.MaoIntegerAttribute;
import se.ericsson.crbs.omf.mao.genericmo.attributes.type.MaoLongAttribute;
import se.ericsson.crbs.omf.mao.genericmo.attributes.type.MaoReferenceAttribute;
import se.ericsson.crbs.omf.mao.genericmo.attributes.type.MaoSequenceAttribute;
import se.ericsson.crbs.omf.mao.genericmo.attributes.type.MaoStringAttribute;
import se.ericsson.crbs.omf.mao.genericmo.attributes.type.MaoStructureAttribute;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

public class MaoAttributeFactoryImpl
implements MaoAttributeFactory {
    private static AbstractLogger logger = LoggingService.getLogger(MaoAttributeFactoryImpl.class.getName());
    private static final Class THIS_CLASS = MaoAttributeFactoryImpl.class;
    private final MoMetaDataFinder moMetaDataFinder;

    public MaoAttributeFactoryImpl(MoMetaDataFinder aMoMetaDataFinder) {
        this.moMetaDataFinder = aMoMetaDataFinder;
    }

    public Map getMaoStoredAttributes(String moTypeName, MoRepositoryWrapper aMoRepositoryWrapper) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "getMaoStoredAttributes");
        Map moAttributes = this.moMetaDataFinder.getMoAttributes(moTypeName);
        Iterator attrIter = moAttributes.values().iterator();
        HashMap<String, LocalAttribute> maoStoredAttributes = new HashMap<String, LocalAttribute>();
        while (attrIter.hasNext()) {
            AttributeMetaData currentAttr = (AttributeMetaData)attrIter.next();
            if (!currentAttr.isLocalStored()) continue;
            AttributeDataType currentData = currentAttr.getData();
            String currentName = currentAttr.getName();
            if (currentData instanceof MoRefType) {
                maoStoredAttributes.put(currentName, new MaoReferenceAttribute(currentName, false));
                continue;
            }
            if (currentData instanceof SeqDataType) {
                maoStoredAttributes.put(currentName, new MaoSequenceAttribute(moTypeName, currentName, false, this.moMetaDataFinder, aMoRepositoryWrapper));
                continue;
            }
            if (currentData instanceof StringDataType) {
                maoStoredAttributes.put(currentName, new MaoStringAttribute(currentName, false));
                continue;
            }
            if (currentData instanceof IntegerDataType) {
                maoStoredAttributes.put(currentName, new MaoIntegerAttribute(currentName, false));
                continue;
            }
            if (currentData instanceof LongDataType) {
                maoStoredAttributes.put(currentName, new MaoLongAttribute(currentName, false));
                continue;
            }
            if (currentData instanceof StructRefType) {
                maoStoredAttributes.put(currentName, new MaoStructureAttribute(moTypeName, currentName, false, this.moMetaDataFinder));
                continue;
            }
            if (currentData instanceof EnumDataType) {
                maoStoredAttributes.put(currentName, new MaoIntegerAttribute(currentName, false));
                continue;
            }
            if (!(currentData instanceof BooleanDataType)) continue;
            maoStoredAttributes.put(currentName, new MaoBooleanAttribute(currentName, false));
        }
        logger.traceReturn(THIS_CLASS, "getMaoStoredAttributes");
        return maoStoredAttributes;
    }
}

