/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.mao.genericmo.systemcreatedmos;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.AttrListImpl;
import se.ericsson.crbs.omf.mao.commonmo.ProcessingFailureException;
import se.ericsson.crbs.omf.mao.commonmo.metadata.AttributeMetaData;
import se.ericsson.crbs.omf.mao.commonmo.metadata.ChildMetaData;
import se.ericsson.crbs.omf.mao.commonmo.metadata.MoMetaData;
import se.ericsson.crbs.omf.mao.commonmo.metadata.finder.MoMetaDataFinder;
import se.ericsson.crbs.omf.mao.commonmo.metadata.finder.MoMetaDataFinderFactory;
import se.ericsson.crbs.omf.mao.commonmo.metadata.types.MoRefType;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.genericmo.systemcreatedmos.MoInstanceData;
import se.ericsson.crbs.omf.mao.genericmo.systemcreatedmos.ReferenceNotYetAvailableException;

public class SystemCreatedMosHandler {
    private static final Class THIS_CLASS = SystemCreatedMosHandler.class;
    private static AbstractLogger logger = LoggingService.getLogger(THIS_CLASS.getName());
    private static final String RDN_ID = "RDN";
    private static final String ID_FIELD = "Id";
    private static final String RESERVED_BY = "reservedBy";
    private static final Object FINDER_MUTEX = new Object();
    private MoMetaDataFinder moMetaDataFinderInst = null;
    private MoMetaDataFinder moMetaDataFinderMom = null;
    private final String moType;
    private String parentMoType = null;
    private ManagedObject parent = null;
    private final GenericMaoContext genericMaoContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initiateTheFinders(GenericMaoContext aGenericMaoContext) {
        Object object = FINDER_MUTEX;
        synchronized (object) {
            try {
                if (this.moMetaDataFinderMom == null) {
                    this.moMetaDataFinderMom = aGenericMaoContext.getMoMetaDataFinder();
                }
                if (this.moMetaDataFinderInst == null) {
                    this.moMetaDataFinderInst = MoMetaDataFinderFactory.getFinderInstance("SYSTEM_MO_INSTANCE_DATA", aGenericMaoContext.getMoMetaDataNames());
                }
            }
            catch (IOException e) {
                String msg = "Could not get the MoMetaDataFinder for the MOM Meta Data and/or the System Mo Instance Data!";
                logger.traceError(THIS_CLASS, "Could not get the MoMetaDataFinder for the MOM Meta Data and/or the System Mo Instance Data!", e);
            }
        }
    }

    public SystemCreatedMosHandler(String moName, GenericMaoContext genericMaoContext) {
        String msg = "SystemCreatedMosHandler(), " + moName + ", " + genericMaoContext;
        logger.traceEnter(THIS_CLASS, msg);
        this.initiateTheFinders(genericMaoContext);
        this.moType = moName;
        this.genericMaoContext = genericMaoContext;
        logger.traceReturn(THIS_CLASS, msg);
    }

    public SystemCreatedMosHandler(String moName, ManagedObject parent, GenericMaoContext genericMaoContext) {
        String msg = "SystemCreatedMosHandler(), " + moName + ", " + parent + ", " + genericMaoContext;
        logger.traceEnter(THIS_CLASS, msg);
        this.initiateTheFinders(genericMaoContext);
        this.moType = moName;
        this.parentMoType = parent.getType();
        this.parent = parent;
        this.genericMaoContext = genericMaoContext;
        logger.traceReturn(THIS_CLASS, msg);
    }

    public SystemCreatedMosHandler(String moName, String parentName, GenericMaoContext genericMaoContext) {
        String msg = "SystemCreatedMosHandler(), " + moName + ", " + parentName + ", " + genericMaoContext;
        logger.traceEnter(THIS_CLASS, msg);
        this.initiateTheFinders(genericMaoContext);
        this.moType = moName;
        this.parentMoType = parentName;
        this.genericMaoContext = genericMaoContext;
        logger.traceReturn(THIS_CLASS, msg);
    }

    public SystemCreatedMosHandler(String moName, String parentName, ManagedObject parent, GenericMaoContext genericMaoContext) {
        String msg = "SystemCreatedMosHandler(): " + moName + ", " + parentName + ", " + parent + ", " + genericMaoContext;
        logger.traceEnter(THIS_CLASS, msg);
        this.initiateTheFinders(genericMaoContext);
        this.moType = moName;
        this.parentMoType = parent == null ? parentName : parent.getType();
        this.parent = parent;
        this.genericMaoContext = genericMaoContext;
        logger.traceReturn(THIS_CLASS, msg);
    }

    private List filterInstancesByParent(List allInstances) throws MoAccessException {
        String msg = "filterInstancesByParent()";
        logger.traceEnter(THIS_CLASS, "filterInstancesByParent()");
        ArrayList<String> filteredInstances = new ArrayList<String>();
        Iterator moIterator = allInstances.iterator();
        while (moIterator.hasNext()) {
            String moInstance = (String)moIterator.next();
            String parentInstanceName = this.getParentName(moInstance);
            if (!parentInstanceName.startsWith(this.parentMoType + "--") && !this.parentMoType.equals("*") || (this.parent != null || !this.isSystemCreated(parentInstanceName)) && (this.parent == null || this.isSystemCreated(parentInstanceName))) continue;
            filteredInstances.add(moInstance);
        }
        logger.traceReturn(THIS_CLASS, "filterInstancesByParent()");
        return filteredInstances;
    }

    private List findInstances() throws MoAccessException {
        String msg = "findInstances()";
        logger.traceEnter(THIS_CLASS, "findInstances()");
        List<String> moInstances = new ArrayList();
        Map moMap = this.moMetaDataFinderInst.getMoMap();
        Set keySet = moMap.keySet();
        Iterator moIterator = keySet.iterator();
        String name = "";
        while (moIterator.hasNext()) {
            name = (String)moIterator.next();
            if (!name.startsWith(this.moType + "--") || !this.isSystemCreated(name)) continue;
            moInstances.add(name);
        }
        if (this.parentMoType != null) {
            moInstances = this.filterInstancesByParent(moInstances);
        }
        logger.traceReturn(THIS_CLASS, "findInstances()");
        return moInstances;
    }

    private AttrList getAttributes(String instanceName) throws MoAccessException {
        String msg = "getAttributes(instanceName), instanceName = " + instanceName;
        logger.traceEnter(THIS_CLASS, msg);
        AttrListImpl attributes = new AttrListImpl(this.genericMaoContext.getMoRepositoryWrapper());
        Iterator attrIterator = this.moMetaDataFinderInst.getMoAttributes(instanceName).keySet().iterator();
        while (attrIterator.hasNext()) {
            String attrName = (String)attrIterator.next();
            Object attrValue = null;
            AttributeMetaData attribData = (AttributeMetaData)this.moMetaDataFinderInst.getMoAttributes(instanceName).get(attrName);
            if (!this.isMoAttribute(instanceName, attrName)) continue;
            attrValue = attribData.getData().getDefaultValue(this.moMetaDataFinderInst);
            if (attribData.getData() instanceof MoRefType) {
                ManagedObject refValue = this.genericMaoContext.getMoRepositoryWrapper().lookup((String)attrValue);
                if (refValue == null) {
                    throw new ReferenceNotYetAvailableException("The MO: " + attrValue + " needed for creation of attribute " + attrName + " could not yet be found. Waiting for this MO to be created!", (String)attrValue);
                }
                attributes.addAttribute(attrName, refValue);
                continue;
            }
            attributes.addAttribute(attrName, attrValue);
        }
        logger.traceReturn(THIS_CLASS, msg);
        return attributes;
    }

    public List getDetectors() {
        String entMsg = "getDetectors() - MO Type: " + this.moType;
        logger.traceEnter(THIS_CLASS, entMsg);
        ArrayList<String> parentTypes = new ArrayList<String>();
        String parentName = "";
        String parentType = "";
        try {
            List instances = this.findInstances();
            Iterator iter = instances.iterator();
            while (iter.hasNext()) {
                parentName = this.getParentName(iter.next().toString());
                parentType = parentName.substring(0, parentName.indexOf("--"));
                if ("".equals(parentType) || !this.isGoamType(parentType) || !this.moMetaDataFinderMom.getMoData(parentType).isSystemCreated() || parentTypes.contains(parentType)) continue;
                parentTypes.add(parentType);
            }
        }
        catch (MoAccessException e) {
            String errMsg = "List of parent types could not be created since MoData was not retrieved!";
            logger.traceError(THIS_CLASS, "List of parent types could not be created since MoData was not retrieved!", e);
        }
        String retMsg = "getDetectors() = " + ((Object)parentTypes).toString() + " - Mo Type: " + this.moType;
        logger.traceReturn(THIS_CLASS, retMsg);
        return parentTypes;
    }

    private ManagedObject getManagedObject(String instanceName) throws MoAccessException {
        String msg = "getManagedObject(instanceName), instanceName = " + instanceName;
        logger.traceEnter(THIS_CLASS, msg);
        ManagedObject result = null;
        String rdnId = this.getRdnId(instanceName);
        String type = instanceName.substring(0, instanceName.indexOf(45));
        MoIterator moIterator = this.genericMaoContext.getMoRepositoryWrapper().lookupType(type);
        if (moIterator != null) {
            if (this.isGoamType(type)) {
                String parentRdnId = this.getRdnId(this.getParentName(instanceName));
                while (moIterator.hasMoreElements()) {
                    ManagedObject nextMo = moIterator.nextMo();
                    if (!nextMo.getNamingAttributeValue().equals(rdnId) || !nextMo.getParent().getNamingAttributeValue().equals(parentRdnId) && !"*".equals(parentRdnId)) continue;
                    result = nextMo;
                    break;
                }
            } else {
                while (moIterator.hasMoreElements()) {
                    ManagedObject nextMo = moIterator.nextMo();
                    if (!nextMo.getNamingAttributeValue().equals(rdnId)) continue;
                    result = nextMo;
                    break;
                }
            }
        }
        logger.traceReturn(THIS_CLASS, msg);
        return result;
    }

    private MoInstanceData getMoInstanceData(String instanceName) throws MoAccessException {
        String msg = "getMoInstanceData(instanceName), instanceName = " + instanceName;
        logger.traceEnter(THIS_CLASS, msg);
        AttrList attributes = this.getAttributes(instanceName);
        String rdnId = this.getRdnId(instanceName);
        ManagedObject parentMo = null;
        parentMo = this.parent == null ? this.getParent(instanceName) : this.parent;
        if (parentMo == null) {
            String errMsg = "Parent object for " + this.moType + "=" + rdnId + " can not be found.";
            logger.traceAbnormal(THIS_CLASS, errMsg);
            throw new ProcessingFailureException(errMsg);
        }
        logger.traceReturn(THIS_CLASS, msg);
        return new MoInstanceData(attributes, parentMo, rdnId);
    }

    public List getMoInstanceDataList() throws MoAccessException {
        String msg = "getMoInstanceDataList() - MO Type: " + this.moType;
        logger.traceEnter(THIS_CLASS, msg);
        ArrayList<MoInstanceData> maoDataList = new ArrayList<MoInstanceData>();
        Iterator moInstanceIterator = this.findInstances().iterator();
        while (moInstanceIterator.hasNext()) {
            maoDataList.add(this.getMoInstanceData((String)moInstanceIterator.next()));
        }
        logger.traceReturn(THIS_CLASS, msg);
        return maoDataList;
    }

    private ManagedObject getParent(String instanceName) throws MoAccessException {
        String msg = "getParent(instanceName), instanceName = " + instanceName;
        logger.traceEnter(THIS_CLASS, msg);
        String parentInstanceName = this.getParentName(instanceName);
        ManagedObject instanceParent = this.getManagedObject(parentInstanceName);
        logger.traceReturn(THIS_CLASS, msg);
        return instanceParent;
    }

    private String getParentName(String instanceName) throws MoAccessException {
        String entMsg = "getParentName(instanceName), instanceName = " + instanceName;
        logger.traceEnter(THIS_CLASS, entMsg);
        String parentInstanceName = "";
        if (this.moMetaDataFinderInst.getChildMetaData(instanceName).size() != 1) {
            String errMsg = "MoAccessException in XML processing for " + this.moType + " Child/Parent relationship is not correct.";
            logger.traceAbnormal(THIS_CLASS, errMsg);
            throw new ProcessingFailureException(errMsg);
        }
        Iterator listIterator = this.moMetaDataFinderInst.getChildMetaData(instanceName).iterator();
        while (listIterator.hasNext()) {
            ChildMetaData child = (ChildMetaData)listIterator.next();
            if (child == null) continue;
            parentInstanceName = child.getParentName();
            break;
        }
        String retMsg = "getParentName() = " + parentInstanceName;
        logger.traceReturn(THIS_CLASS, retMsg);
        return parentInstanceName;
    }

    public String getParentType() {
        return this.parentMoType;
    }

    private String getRdnId(String instanceName) throws MoAccessException {
        String rdnId = (String)this.moMetaDataFinderInst.getMoAttributes(instanceName, RDN_ID).getData().getDefaultValue(this.moMetaDataFinderInst);
        return rdnId;
    }

    private boolean isMoAttribute(String instanceName, String attribName) {
        boolean result = !attribName.equals(RDN_ID) && !attribName.equals(RESERVED_BY) && !attribName.equals(instanceName + ID_FIELD);
        return result;
    }

    private boolean isSystemCreated(String instanceName) {
        return this.moMetaDataFinderInst.getMoData(instanceName).isSystemCreated();
    }

    protected boolean isGoamType(String typeName) {
        MoMetaData metaData = (MoMetaData)this.moMetaDataFinderMom.getMoMap().get(typeName);
        return metaData == null ? false : metaData.isImplementedAsGenericMAO();
    }
}

