/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.mao.genericmo.xml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xerces.jaxp.DocumentBuilderFactoryImpl;
import org.apache.xerces.jaxp.DocumentBuilderImpl;
import org.apache.xerces.parsers.SAXParser;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import se.ericsson.cello.maofro.framework.IllegalParameterValueException;
import se.ericsson.cello.maofro.framework.Parameter;
import se.ericsson.cello.maofro.framework.StringParameter;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.cello.moframework.NotHandledAttributeTypeException;
import se.ericsson.cello.moframework.SoftwareErrorException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.ProcessingFailureException;
import se.ericsson.crbs.omf.mao.commonmo.mo.FroIdFinder;
import se.ericsson.crbs.omf.mao.genericmo.NullManagedObject;
import se.ericsson.crbs.omf.mao.genericmo.xml.AbstractXmlHandler;
import se.ericsson.crbs.omf.mao.genericmo.xml.XmlHandlerImplR1A;
import se.ericsson.crbs.omf.mao.genericmo.xml.XmlHandlerImplR1B;
import se.ericsson.crbs.omf.mao.genericmo.xml.XmlPack;

public class XmlPackImpl
implements XmlPack {
    private static final String UTF_8 = "UTF-8";
    private static final String XML = "XML";
    private static final String ACTION = "action";
    private static final String DATA = "data";
    private static final String ZIPDATA = "zipData";
    private static final String INTEGER = "Integer";
    private static final String BOOLEAN = "Boolean";
    private static final String LONG = "Long";
    private static final String MANAGED_OBJECT = "ManagedObject";
    private static final String STRUCT_IMPL = "StructImpl";
    private static final String CLASS = "class";
    private static final String VERSION = "version";
    private static final String MIM = "mim";
    private static final String STRING = "STRING";
    private static final String REF = "Ref";
    private static final String REF_PRIO = "RefPrio";
    private static final String FRO_ID = "froId";
    private static final String FRO_TYPE = "froType";
    private static final String LDN = "ldn";
    private static final String MOREF = "moref";
    private static final String S32 = "S32";
    private static final String S64 = "S64";
    private static final String MIM_REVISION = "R1A";
    private static final String ARRAY = "array";
    private static final String STRUCT = "struct";
    private static final String STRCT = "strct";
    private static final String VALUE = "value";
    private static final String TYPE = "type";
    private static final String NAME = "name";
    private static final String ATTR = "attr";
    private static final String PV_R1A = "R1A";
    private static final String PV_R1B = "R1B";
    private static final String COMPLEX = "complex";
    private static final String SEQ = "seq";
    private static final int XML_STRING_MAX_SIZE = 60000;
    private static final Class THIS_CLASS = XmlPackImpl.class;
    private static AbstractLogger logger = LoggingService.getLogger(THIS_CLASS.getName());
    private final SAXParser saxParser;
    private final AbstractXmlHandler xmlHandlerImplR1A;
    private final AbstractXmlHandler xmlHandlerImplR1B;
    private final Object extractSync = new Object();
    private final DocumentBuilderImpl builder;
    private final Object packSync = new Object();
    private static final char[] ALPHABET = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();
    private static int[] toInt = new int[128];

    public XmlPackImpl() throws ProcessingFailureException {
        String msg = "XmlPackImpl()";
        logger.traceEnter(THIS_CLASS, "XmlPackImpl()");
        try {
            this.builder = (DocumentBuilderImpl)DocumentBuilderFactoryImpl.newInstance().newDocumentBuilder();
            this.saxParser = new SAXParser();
            this.xmlHandlerImplR1A = new XmlHandlerImplR1A();
            this.xmlHandlerImplR1B = new XmlHandlerImplR1B();
        }
        catch (ParserConfigurationException pce) {
            throw new ProcessingFailureException("Could not instanciate XmlPackImpl due to" + pce);
        }
        logger.traceReturn(THIS_CLASS, "XmlPackImpl()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document createDocument() {
        Object object = this.packSync;
        synchronized (object) {
            this.builder.reset();
            return this.builder.newDocument();
        }
    }

    private Element createClass(String mimVersion, String ldn, Document document) {
        Element mim = document.createElement(MIM);
        mim.setAttribute(VERSION, mimVersion);
        document.appendChild(mim);
        Element class1 = document.createElement(CLASS);
        class1.setAttribute(LDN, ldn);
        mim.appendChild(class1);
        return class1;
    }

    private Integer booleanToInteger(Boolean boolean1) {
        return new Integer(boolean1 != false ? 1 : 0);
    }

    private String convertToGenericMAOFROTypeR1A(String attributeType) {
        String result = null;
        if (INTEGER.equalsIgnoreCase(attributeType)) {
            result = S32;
        } else if (BOOLEAN.equalsIgnoreCase(attributeType)) {
            result = S32;
        } else if (MANAGED_OBJECT.equalsIgnoreCase(attributeType)) {
            result = MOREF;
        } else if (LONG.equalsIgnoreCase(attributeType)) {
            result = S64;
        } else if (STRING.equalsIgnoreCase(attributeType)) {
            result = STRING;
        } else if (STRUCT_IMPL.equalsIgnoreCase(attributeType) || STRUCT.equalsIgnoreCase(attributeType)) {
            result = STRUCT;
        } else if (attributeType.endsWith("[]")) {
            result = ARRAY;
        } else {
            result = "UNSUPPORTED:" + attributeType;
            logger.traceDebug(THIS_CLASS, "Cannot convert to generic MAOFRO type, unsupported type=" + attributeType);
        }
        return result;
    }

    private String convertToGenericMAOFROTypeR1B(String attributeType) {
        String result = null;
        if (INTEGER.equalsIgnoreCase(attributeType)) {
            result = S32;
        } else if (BOOLEAN.equalsIgnoreCase(attributeType)) {
            result = S32;
        } else if (MANAGED_OBJECT.equalsIgnoreCase(attributeType)) {
            result = MOREF;
        } else if (LONG.equalsIgnoreCase(attributeType)) {
            result = S64;
        } else if (STRING.equalsIgnoreCase(attributeType)) {
            result = STRING;
        } else if (STRUCT_IMPL.equalsIgnoreCase(attributeType) || STRUCT.equalsIgnoreCase(attributeType)) {
            result = STRCT;
        } else if (attributeType.endsWith("[]")) {
            result = SEQ;
        } else {
            result = "UNSUPPORTED:" + attributeType;
            logger.traceDebug(THIS_CLASS, "Cannot convert to generic MAOFRO type, unsupported type=" + attributeType);
        }
        return result;
    }

    private List createDataAttribute(String str) {
        ArrayList<StringParameter> parameter = new ArrayList<StringParameter>();
        try {
            StringParameter data;
            if (str.length() > 60000) {
                String result = XmlPackImpl.encodeBase64(this.zipXml(str.getBytes()));
                data = new StringParameter(ZIPDATA, result);
                String genMsg = "Zipped XML string created with size: " + result.length() + " and data:\n" + result;
                logger.traceGeneral(THIS_CLASS, genMsg);
            } else {
                data = new StringParameter(DATA, str);
            }
            parameter.add(data);
        }
        catch (IllegalParameterValueException e) {
            String msg = "Illegal Parameter! " + e.getMessage();
            logger.traceAbnormal(THIS_CLASS, msg);
        }
        catch (IOException e) {
            String msg = "Illegal Parameter! " + e.getMessage();
            logger.traceAbnormal(THIS_CLASS, msg);
        }
        return parameter;
    }

    private byte[] zipXml(byte[] data) throws IOException {
        int len;
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        ByteArrayOutputStream zipped = new ByteArrayOutputStream();
        DeflaterOutputStream out = new DeflaterOutputStream(zipped);
        byte[] buf = new byte[1024];
        while ((len = in.read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        ((OutputStream)out).close();
        ((InputStream)in).close();
        return zipped.toByteArray();
    }

    private String unzipXml(byte[] data) throws IOException {
        int len;
        ByteArrayInputStream zipped = new ByteArrayInputStream(data);
        ByteArrayOutputStream unzipped = new ByteArrayOutputStream();
        InflaterInputStream in = new InflaterInputStream(zipped);
        byte[] buf = new byte[1024];
        while ((len = ((InputStream)in).read(buf)) > 0) {
            unzipped.write(buf, 0, len);
        }
        unzipped.close();
        ((InputStream)in).close();
        return unzipped.toString();
    }

    public static String encodeBase64(byte[] buf) {
        int size = buf.length;
        char[] ar = new char[(size + 2) / 3 * 4];
        int a = 0;
        int i = 0;
        while (i < size) {
            byte b0 = buf[i++];
            byte b1 = i < size ? buf[i++] : (byte)0;
            byte b2 = i < size ? buf[i++] : (byte)0;
            int mask = 63;
            ar[a++] = ALPHABET[b0 >> 2 & 0x3F];
            ar[a++] = ALPHABET[(b0 << 4 | (b1 & 0xFF) >> 4) & 0x3F];
            ar[a++] = ALPHABET[(b1 << 2 | (b2 & 0xFF) >> 6) & 0x3F];
            ar[a++] = ALPHABET[b2 & 0x3F];
        }
        switch (size % 3) {
            case 1: {
                ar[--a] = 61;
            }
            case 2: {
                ar[--a] = 61;
            }
        }
        return new String(ar);
    }

    public static byte[] decodeBase64(String s) {
        int delta = s.endsWith("==") ? 2 : (s.endsWith("=") ? 1 : 0);
        byte[] buffer = new byte[s.length() * 3 / 4 - delta];
        int mask = 255;
        int index = 0;
        for (int i = 0; i < s.length(); i += 4) {
            int c0 = toInt[s.charAt(i)];
            int c1 = toInt[s.charAt(i + 1)];
            buffer[index++] = (byte)((c0 << 2 | c1 >> 4) & 0xFF);
            if (index >= buffer.length) break;
            int c2 = toInt[s.charAt(i + 2)];
            buffer[index++] = (byte)((c1 << 4 | c2 >> 2) & 0xFF);
            if (index >= buffer.length) break;
            int c3 = toInt[s.charAt(i + 3)];
            buffer[index++] = (byte)((c2 << 6 | c3) & 0xFF);
        }
        return buffer;
    }

    public Parameter extractAttribute(StringParameter froData, String attributeName) throws MoAccessException {
        return this.extractAttribute(froData, attributeName, "R1A");
    }

    public Parameter extractAttribute(StringParameter froData, String attributeName, String protocolVersion) throws MoAccessException {
        String msg = "extractAttribute(froData, attributeName, protocolVersion)";
        logger.traceEnter(THIS_CLASS, "extractAttribute(froData, attributeName, protocolVersion), protocolVersion=" + protocolVersion);
        Parameter result = null;
        List attributes = this.extractAttributes(froData, protocolVersion);
        Iterator iterator = attributes.iterator();
        while (iterator.hasNext()) {
            Parameter parameter = (Parameter)iterator.next();
            if (!parameter.getName().equals(attributeName)) continue;
            result = parameter;
            break;
        }
        if (result == null) {
            String errMsg = "Attribute not found!";
            logger.traceError(THIS_CLASS, "Attribute not found!" + attributeName);
        }
        logger.traceReturn(THIS_CLASS, "extractAttribute(froData, attributeName, protocolVersion)");
        return result;
    }

    public List extractAttributes(StringParameter froData) throws MoAccessException {
        return this.extractAttributes(froData, "R1A");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List extractAttributes(StringParameter froData, String protocolVersion) throws MoAccessException {
        String msg = "extractAttributes(froData, protocolVersion)";
        logger.traceEnter(THIS_CLASS, "extractAttributes(froData, protocolVersion), protocolVersion=" + protocolVersion);
        String froDataValue = null;
        if (froData.getName().equals(ZIPDATA)) {
            String zipMsg = "Received zipped XML string";
            logger.traceGeneral(THIS_CLASS, "Received zipped XML string");
            try {
                froDataValue = this.unzipXml(XmlPackImpl.decodeBase64(froData.getValue()));
            }
            catch (IOException e) {
                logger.traceAbnormal(THIS_CLASS, "Failed to unzip XML, reason: " + e);
            }
        } else {
            froDataValue = froData.getValue();
        }
        ArrayList result = null;
        CharArrayReader reader = null;
        try {
            reader = new CharArrayReader(froDataValue.toCharArray());
            InputSource input = new InputSource(reader);
            try {
                Object object = this.extractSync;
                synchronized (object) {
                    this.saxParser.reset();
                    if (protocolVersion.equals("R1A")) {
                        logger.traceDebug(THIS_CLASS, "Choosing XmlHandler for pvVersion=R1A");
                        this.xmlHandlerImplR1A.reset();
                        this.saxParser.setContentHandler(this.xmlHandlerImplR1A);
                        this.saxParser.setErrorHandler(this.xmlHandlerImplR1A);
                        this.saxParser.parse(input);
                        result = new ArrayList(this.xmlHandlerImplR1A.getAttributeList());
                    } else if (protocolVersion.equals(PV_R1B)) {
                        logger.traceDebug(THIS_CLASS, "Choosing XmlHandler for pvVersion=R1B");
                        this.xmlHandlerImplR1B.reset();
                        this.saxParser.setContentHandler(this.xmlHandlerImplR1B);
                        this.saxParser.setErrorHandler(this.xmlHandlerImplR1B);
                        this.saxParser.parse(input);
                        result = new ArrayList(this.xmlHandlerImplR1B.getAttributeList());
                    } else {
                        throw new IllegalParameterValueException("Illegal pvVersion. No possibility to handle pvVersion=" + protocolVersion);
                    }
                }
            }
            catch (SAXException saxe) {
                throw new ProcessingFailureException("Could not extract attributes due to: " + saxe);
            }
            catch (IOException ioe) {
                throw new ProcessingFailureException("Could not extract attributes due to: " + ioe);
            }
        }
        finally {
            if (reader != null) {
                try {
                    ((Reader)reader).close();
                }
                catch (IOException ioe) {
                    logger.traceError(THIS_CLASS, "extractAttributes(froData, protocolVersion) catch IOException: ", ioe);
                }
            }
        }
        logger.traceReturn(THIS_CLASS, "extractAttributes(froData, protocolVersion)");
        return result;
    }

    public List packAction(String actionName, Map parameters, String ldn) throws IllegalParameterValueException, SoftwareErrorException {
        return this.packAction(actionName, parameters, ldn, "R1A");
    }

    public List packAction(String actionName, Map parameters, String ldn, String protocolRevision) throws IllegalParameterValueException, SoftwareErrorException {
        String msg = "packAction(actionName, parameters, ldn, protocolRevision)";
        logger.traceEnter(THIS_CLASS, "packAction(actionName, parameters, ldn, protocolRevision), protocolRevision=" + protocolRevision);
        Document document = this.createDocument();
        Element class1 = this.createClass("R1A", ldn, document);
        Element action = document.createElement(ACTION);
        action.setAttribute(NAME, actionName);
        class1.appendChild(action);
        if (parameters != null) {
            Map.Entry param;
            Iterator iterator = parameters.entrySet().iterator();
            if (protocolRevision.equalsIgnoreCase("R1A")) {
                while (iterator.hasNext()) {
                    param = iterator.next();
                    action.appendChild(this.packParameterR1A(param, document));
                }
            } else if (protocolRevision.equalsIgnoreCase(PV_R1B)) {
                while (iterator.hasNext()) {
                    param = iterator.next();
                    DataHolder dataHolder = new DataHolder();
                    Element element = this.packParameterR1B(param, document, dataHolder);
                    if (dataHolder.isComplex()) {
                        Element complex = document.createElement(COMPLEX);
                        action.appendChild(complex);
                        complex.appendChild(element);
                        Element data = document.createElement(DATA);
                        int size = dataHolder.getData().length() - 1;
                        data.appendChild(document.createTextNode(dataHolder.getData().substring(0, size < 0 ? 0 : size)));
                        complex.appendChild(data);
                        continue;
                    }
                    action.appendChild(element);
                }
            } else {
                throw new IllegalParameterValueException("Illegal name of fro protocol version");
            }
        }
        String result = this.transformDocument(document);
        String genMsg = "XML string created with size: " + result.length() + " and data:\n" + result;
        logger.traceGeneral(THIS_CLASS, genMsg);
        List parameter = this.createDataAttribute(result);
        logger.traceReturn(THIS_CLASS, "packAction(actionName, parameters, ldn, protocolRevision)");
        return parameter;
    }

    public List packCreateMO(AttrList attributes, String ldn) throws IllegalParameterValueException, SoftwareErrorException {
        return this.packCreateMO(attributes, ldn, "R1A");
    }

    public List packCreateMO(AttrList attributes, String ldn, String protocolVersion) throws IllegalParameterValueException, SoftwareErrorException {
        String msg = "packCreateMO(attributes, ldn, protocolVersion)";
        logger.traceEnter(THIS_CLASS, "packCreateMO(attributes, ldn, protocolVersion), protocolVersion=" + protocolVersion);
        Document document = this.createDocument();
        Element class1 = this.createClass("R1A", ldn, document);
        if (attributes != null) {
            int len = attributes.size();
            for (int i = 0; i < len; ++i) {
                String errMsg;
                String name = attributes.getName(i);
                Object value = null;
                try {
                    value = attributes.getValue(i);
                }
                catch (NotHandledAttributeTypeException e) {
                    errMsg = "Error in packCreateMO()";
                    logger.traceError(THIS_CLASS, "Error in packCreateMO()", e);
                }
                catch (MoNotFoundException e) {
                    errMsg = "Error in packCreateMO()";
                    logger.traceError(THIS_CLASS, "Error in packCreateMO()", e);
                }
                if (protocolVersion.equalsIgnoreCase("R1A")) {
                    class1.appendChild(this.packParameterR1A(name, value, document));
                    continue;
                }
                if (protocolVersion.equalsIgnoreCase(PV_R1B)) {
                    class1.appendChild(this.packCreateMOForR1B(name, value, document));
                    continue;
                }
                throw new IllegalParameterValueException("Illegal name of fro protocol version");
            }
        }
        String result = this.transformDocument(document);
        String genMsg = "Nice XML string created with size: " + result.length() + " and data:\n" + result;
        logger.traceGeneral(THIS_CLASS, genMsg);
        List parameter = this.createDataAttribute(result);
        logger.traceReturn(THIS_CLASS, "packCreateMO(attributes, ldn, protocolVersion)");
        return parameter;
    }

    private Element packCreateMOForR1B(String name, Object value, Document document) throws IllegalParameterValueException {
        DataHolder dataHolder = new DataHolder();
        Element element = this.packParameterR1B(name, value, document, dataHolder);
        if (dataHolder.isComplex()) {
            Element complex = document.createElement(COMPLEX);
            complex.appendChild(element);
            Element data = document.createElement(DATA);
            int size = dataHolder.getData().length() - 1;
            data.appendChild(document.createTextNode(dataHolder.getData().substring(0, size < 0 ? 0 : size)));
            complex.appendChild(data);
            return complex;
        }
        return element;
    }

    public List packGetAttributes(String[] attributeNames, String[] attributeTypes, String ldn) throws SoftwareErrorException, IllegalParameterValueException {
        return this.packGetAttributes(attributeNames, attributeTypes, ldn, "R1A");
    }

    public List packGetAttributes(String[] attributeNames, String[] attributeTypes, String ldn, String protocolVersion) throws SoftwareErrorException, IllegalParameterValueException {
        String msg = "packGetAttributes(attributeNames, attributeTypes, ldn, protocolVersion)";
        logger.traceEnter(THIS_CLASS, "packGetAttributes(attributeNames, attributeTypes, ldn, protocolVersion), protocolVersion=" + protocolVersion);
        Document document = this.createDocument();
        Element class1 = this.createClass("R1A", ldn, document);
        if (protocolVersion.equalsIgnoreCase("R1A")) {
            this.packGetAttributesR1A(attributeNames, attributeTypes, document, class1);
        } else if (protocolVersion.equalsIgnoreCase(PV_R1B)) {
            this.packGetAttributesR1B(attributeNames, attributeTypes, document, class1);
        } else {
            throw new IllegalParameterValueException("Illegal name of fro protocol version, protocolVersion=" + protocolVersion);
        }
        String result = this.transformDocument(document);
        String genMsg = "XML string created with size: " + result.length() + " and data:\n" + result;
        logger.traceGeneral(THIS_CLASS, genMsg);
        List parameter = this.createDataAttribute(result);
        logger.traceReturn(THIS_CLASS, "packGetAttributes(attributeNames, attributeTypes, ldn, protocolVersion)");
        return parameter;
    }

    private void packGetAttributesR1A(String[] attributeNames, String[] attributeTypes, Document document, Element class1) {
        for (int i = 0; i < attributeTypes.length; ++i) {
            String type = this.convertToGenericMAOFROTypeR1A(attributeTypes[i]);
            if (ARRAY.equalsIgnoreCase(type)) {
                Element array = document.createElement(ARRAY);
                array.setAttribute(NAME, attributeNames[i]);
                class1.appendChild(array);
                continue;
            }
            if (STRUCT.equalsIgnoreCase(type)) {
                Element struct = document.createElement(STRUCT);
                struct.setAttribute(NAME, attributeNames[i]);
                class1.appendChild(struct);
                continue;
            }
            if (MOREF.equalsIgnoreCase(type)) {
                Element moref = document.createElement(MOREF);
                moref.setAttribute(NAME, attributeNames[i]);
                class1.appendChild(moref);
                continue;
            }
            Element attr = document.createElement(ATTR);
            attr.setAttribute(NAME, attributeNames[i]);
            attr.setAttribute(TYPE, type);
            class1.appendChild(attr);
        }
    }

    private void packGetAttributesR1B(String[] attributeNames, String[] attributeTypes, Document document, Element class1) {
        logger.traceEnter(THIS_CLASS, "packGetAttributesR1B()");
        for (int i = 0; i < attributeTypes.length; ++i) {
            String type = this.convertToGenericMAOFROTypeR1B(attributeTypes[i]);
            Element element = null;
            if (type.equalsIgnoreCase(SEQ)) {
                element = document.createElement(SEQ);
                element.setAttribute(NAME, attributeNames[i]);
                int size = attributeTypes[i].length() - 2;
                element.setAttribute(TYPE, this.convertToGenericMAOFROTypeR1B(attributeTypes[i].substring(0, size < 0 ? 0 : size)));
            } else if (type.equalsIgnoreCase(STRCT)) {
                element = document.createElement(STRCT);
                element.setAttribute(NAME, attributeNames[i]);
            } else if (type.equalsIgnoreCase(MOREF)) {
                element = document.createElement(MOREF);
                element.setAttribute(NAME, attributeNames[i]);
            } else {
                Element attr = document.createElement(ATTR);
                attr.setAttribute(NAME, attributeNames[i]);
                attr.setAttribute(TYPE, type);
                class1.appendChild(attr);
                continue;
            }
            Element complex = document.createElement(COMPLEX);
            complex.appendChild(element);
            Element data = document.createElement(DATA);
            data.appendChild(document.createTextNode(""));
            complex.appendChild(data);
            class1.appendChild(complex);
        }
        logger.traceReturn(THIS_CLASS, "packGetAttributesR1B()");
    }

    public List packSetAttributes(Map parameters, String ldn) throws IllegalParameterValueException, SoftwareErrorException {
        return this.packSetAttributes(parameters, ldn, "R1A");
    }

    public List packSetAttributes(Map attributes, String ldn, String protocolVersion) throws IllegalParameterValueException, SoftwareErrorException {
        if (protocolVersion.equals("R1A")) {
            return this.packSetAttributesR1A(attributes, ldn);
        }
        if (protocolVersion.equals(PV_R1B)) {
            return this.packSetAttributesR1B(attributes, ldn);
        }
        throw new IllegalParameterValueException("Illegal name of fro protocol version, protocolVersion=" + protocolVersion);
    }

    private List packSetAttributesR1A(Map parameters, String ldn) throws IllegalParameterValueException, SoftwareErrorException {
        String msg = "packSetAttributesR1A()";
        logger.traceEnter(THIS_CLASS, "packSetAttributesR1A()");
        Document document = this.createDocument();
        Element class1 = this.createClass("R1A", ldn, document);
        if (parameters != null) {
            Iterator iterator = parameters.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry param = iterator.next();
                class1.appendChild(this.packParameterR1A(param, document));
            }
        }
        String result = this.transformDocument(document);
        String genMsg = "XML string created with size: " + result.length() + " and data:\n" + result;
        logger.traceGeneral(THIS_CLASS, genMsg);
        List parameter = this.createDataAttribute(result);
        logger.traceReturn(THIS_CLASS, "packSetAttributesR1A()");
        return parameter;
    }

    private List packSetAttributesR1B(Map parameters, String ldn) throws IllegalParameterValueException, SoftwareErrorException {
        String msg = "packSetAttributesR1B()";
        logger.traceEnter(THIS_CLASS, "packSetAttributesR1B()");
        Document document = this.createDocument();
        Element class1 = this.createClass("R1A", ldn, document);
        if (parameters != null) {
            Iterator iterator = parameters.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry param = iterator.next();
                DataHolder dataHolder = new DataHolder();
                Element element = this.packParameterR1B(param, document, dataHolder);
                if (dataHolder.isComplex()) {
                    Element complex = document.createElement(COMPLEX);
                    complex.appendChild(element);
                    Element data = document.createElement(DATA);
                    int size = dataHolder.getData().length() - 1;
                    data.appendChild(document.createTextNode(dataHolder.getData().substring(0, size < 0 ? 0 : size)));
                    complex.appendChild(data);
                    class1.appendChild(complex);
                    continue;
                }
                class1.appendChild(element);
            }
            logger.traceReturn(THIS_CLASS, "packSetAttributesR1B()");
        }
        String result = this.transformDocument(document);
        String genMsg = "XML string created with size: " + result.length() + " and data:\n" + result;
        logger.traceGeneral(THIS_CLASS, genMsg);
        List parameter = this.createDataAttribute(result);
        logger.traceReturn(THIS_CLASS, "packSetAttributesR1B()");
        return parameter;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Element packParameterR1A(String name, Object value, Document document) throws IllegalParameterValueException {
        if (value == null) {
            if (name.endsWith(REF)) return this.packManagedObject(name, null, document);
            if (name.indexOf(REF_PRIO) == -1) throw new IllegalParameterValueException("NULL value not permitted in parameter. Parameter = " + name + ".");
            return this.packManagedObject(name, null, document);
        }
        if (value instanceof Struct) {
            return this.packStruct(name, (Struct)value, document);
        }
        if (value instanceof int[]) {
            return this.packIntArray(name, (int[])value, document);
        }
        if (value instanceof boolean[]) {
            return this.packBooleanArray(name, (boolean[])value, document);
        }
        if (value instanceof Boolean[]) {
            return this.packBooleanArray(name, (Boolean[])value, document);
        }
        if (value instanceof long[]) {
            return this.packLongArray(name, (long[])value, document);
        }
        if (value.getClass().isArray()) {
            return this.packArray(name, (Object[])value, document);
        }
        if (!(value instanceof ManagedObject)) return this.packPrimitiveParameter(name, value, document);
        return this.packManagedObject(name, (ManagedObject)value, document);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Element packParameterR1B(String name, Object value, Document document, DataHolder dataHolder) throws IllegalParameterValueException {
        if (value == null) {
            dataHolder.setComplex(true);
            if (name.endsWith(REF)) return this.packManagedObjectR1B(name, null, document, dataHolder);
            if (name.indexOf(REF_PRIO) == -1) throw new IllegalParameterValueException("NULL value not permitted in parameter. Parameter = " + name);
            return this.packManagedObjectR1B(name, null, document, dataHolder);
        }
        if (value instanceof Struct) {
            dataHolder.setComplex(true);
            return this.packStrctR1B(name, (Struct)value, document, dataHolder, null);
        }
        if (value.getClass().isArray()) {
            dataHolder.setComplex(true);
            return this.packSeqR1B(name, value, document, dataHolder);
        }
        if (value instanceof ManagedObject) {
            dataHolder.setComplex(true);
            return this.packManagedObjectR1B(name, (ManagedObject)value, document, dataHolder);
        }
        if (!dataHolder.isComplex()) return this.packPrimitiveParameter(name, value, document);
        return this.packAttrForComplex(name, value, document, dataHolder);
    }

    public Element packInt(String name, Object value, Document document) {
        Element integer = document.createElement(ATTR);
        if (name != null) {
            integer.setAttribute(NAME, name);
        }
        integer.setAttribute(TYPE, S32);
        integer.setAttribute(VALUE, value.toString());
        return integer;
    }

    public Element packIntArray(String name, int[] attr, Document document) {
        Element intArray = document.createElement(ARRAY);
        if (name != null) {
            intArray.setAttribute(NAME, name);
        }
        for (int i = 0; i < attr.length; ++i) {
            Element integer = document.createElement(ATTR);
            integer.setAttribute(TYPE, S32);
            integer.setAttribute(VALUE, Integer.toString(attr[i]));
            intArray.appendChild(integer);
        }
        return intArray;
    }

    private Element packIntArrayR1B(String name, Integer[] attr, Document document, DataHolder dataHolder) {
        int[] intArray = new int[attr.length];
        for (int i = 0; i < intArray.length; ++i) {
            intArray[i] = attr[i];
        }
        return this.packIntArrayR1B(name, intArray, document, dataHolder);
    }

    private Element packIntArrayR1B(String name, int[] attr, Document document, DataHolder dataHolder) {
        Element intArrayElement = document.createElement(SEQ);
        String attrName = name != null ? name : "";
        intArrayElement.setAttribute(NAME, attrName);
        intArrayElement.setAttribute(TYPE, S32);
        dataHolder.getData().append(attr.length + ",");
        for (int i = 0; i < attr.length; ++i) {
            dataHolder.getData().append(attr[i] + ",");
        }
        return intArrayElement;
    }

    public Element packString(String name, Object value, Document document) {
        Element string = document.createElement(ATTR);
        if (name != null) {
            string.setAttribute(NAME, name);
        }
        string.setAttribute(TYPE, STRING);
        string.setAttribute(VALUE, value.toString());
        return string;
    }

    public Element packBooleanArray(String name, Boolean[] attr, Document document) {
        boolean[] boolArray = new boolean[attr.length];
        for (int i = 0; i < boolArray.length; ++i) {
            boolArray[i] = attr[i];
        }
        return this.packBooleanArray(name, boolArray, document);
    }

    private Element packBooleanArrayR1B(String name, Boolean[] attr, Document document, DataHolder dataHolder) {
        boolean[] boolArray = new boolean[attr.length];
        for (int i = 0; i < boolArray.length; ++i) {
            boolArray[i] = attr[i];
        }
        return this.packBooleanArrayR1B(name, boolArray, document, dataHolder);
    }

    public Element packBooleanArray(String name, boolean[] attr, Document document) {
        Element intArray = document.createElement(ARRAY);
        if (name != null) {
            intArray.setAttribute(NAME, name);
        }
        for (int i = 0; i < attr.length; ++i) {
            Element booleanatt = document.createElement(ATTR);
            booleanatt.setAttribute(TYPE, S32);
            booleanatt.setAttribute(VALUE, this.booleanToInteger(attr[i]).toString());
            intArray.appendChild(booleanatt);
        }
        return intArray;
    }

    private Element packBooleanArrayR1B(String name, boolean[] attr, Document document, DataHolder dataHolder) {
        Element booleanArrayElement = document.createElement(SEQ);
        String attrName = name != null ? name : "";
        booleanArrayElement.setAttribute(NAME, attrName);
        booleanArrayElement.setAttribute(TYPE, S32);
        dataHolder.getData().append(attr.length + ",");
        for (int i = 0; i < attr.length; ++i) {
            dataHolder.getData().append(this.booleanToInteger(attr[i]) + ",");
        }
        return booleanArrayElement;
    }

    public Element packLong(String name, Object value, Document document) {
        Element long1 = document.createElement(ATTR);
        if (name != null) {
            long1.setAttribute(NAME, name);
        }
        long1.setAttribute(TYPE, S64);
        long1.setAttribute(VALUE, value.toString());
        return long1;
    }

    public Element packLongArray(String name, long[] attr, Document document) {
        Element longArray = document.createElement(ARRAY);
        if (name != null) {
            longArray.setAttribute(NAME, name);
        }
        for (int i = 0; i < attr.length; ++i) {
            Element integer = document.createElement(ATTR);
            integer.setAttribute(TYPE, S64);
            integer.setAttribute(VALUE, Long.toString(attr[i]));
            longArray.appendChild(integer);
        }
        return longArray;
    }

    private Element packLongArrayR1B(String name, Long[] attr, Document document, DataHolder dataHolder) {
        long[] longArray = new long[attr.length];
        for (int i = 0; i < longArray.length; ++i) {
            longArray[i] = attr[i];
        }
        return this.packLongArrayR1B(name, longArray, document, dataHolder);
    }

    private Element packFloatArrayR1B(String name, Float[] attr, Document document, DataHolder dataHolder) {
        int[] intArray = new int[attr.length];
        for (int i = 0; i < intArray.length; ++i) {
            intArray[i] = attr[i].intValue();
        }
        return this.packIntArrayR1B(name, intArray, document, dataHolder);
    }

    private Element packFloatArrayR1B(String name, float[] attr, Document document, DataHolder dataHolder) {
        int[] intArray = new int[attr.length];
        for (int i = 0; i < intArray.length; ++i) {
            intArray[i] = (int)attr[i];
        }
        return this.packIntArrayR1B(name, intArray, document, dataHolder);
    }

    private Element packLongArrayR1B(String name, long[] attr, Document document, DataHolder dataHolder) {
        Element longArrayElement = document.createElement(SEQ);
        String attrName = name != null ? name : "";
        longArrayElement.setAttribute(NAME, attrName);
        longArrayElement.setAttribute(TYPE, S64);
        dataHolder.getData().append(attr.length + ",");
        for (int i = 0; i < attr.length; ++i) {
            dataHolder.getData().append(attr[i] + ",");
        }
        return longArrayElement;
    }

    private Element packStringArrayR1B(String name, String[] attr, Document document, DataHolder dataHolder) {
        Element stringArrayElement = document.createElement(SEQ);
        String attrName = name != null ? name : "";
        stringArrayElement.setAttribute(NAME, attrName);
        stringArrayElement.setAttribute(TYPE, STRING);
        dataHolder.getData().append(attr.length + ",");
        for (int i = 0; i < attr.length; ++i) {
            dataHolder.getData().append(this.replaceForPacking(attr[i]) + ",");
        }
        return stringArrayElement;
    }

    public Element packManagedObject(String name, ManagedObject value, Document document) throws IllegalParameterValueException {
        Element moref = document.createElement(MOREF);
        moref.setAttribute(NAME, name);
        if (value == null) {
            moref.appendChild(this.packParameterR1A(LDN, "", document));
            moref.appendChild(this.packParameterR1A(FRO_TYPE, new Integer(-1), document));
            moref.appendChild(this.packParameterR1A(FRO_ID, new Integer(-1), document));
        } else {
            moref.appendChild(this.packParameterR1A(LDN, value.getLocalDistinguishedName(), document));
            try {
                Integer froType = new Integer(FroIdFinder.getManagedObjectFroType(value, null));
                moref.appendChild(this.packParameterR1A(FRO_TYPE, froType, document));
                Integer froId = new Integer(FroIdFinder.getManagedObjectFroId(value, null));
                moref.appendChild(this.packParameterR1A(FRO_ID, froId, document));
            }
            catch (MoAccessException e) {
                logger.traceDebug(THIS_CLASS, e.getMessage());
                logger.traceDebugStackTrace(THIS_CLASS, e);
                throw new IllegalParameterValueException(e.getMessage());
            }
        }
        return moref;
    }

    private Element packManagedObjectR1B(String name, ManagedObject value, Document document, DataHolder dataHolder) throws IllegalParameterValueException {
        String msg = "packManagedObjectR1B(name, value, document, dataHolder)";
        logger.traceEnter(THIS_CLASS, "packManagedObjectR1B(name, value, document, dataHolder),name=" + name + " ,value=" + value);
        Element moref = document.createElement(MOREF);
        String attrName = name != null ? name : "";
        moref.setAttribute(NAME, attrName);
        if (value == null) {
            dataHolder.getData().append(",");
            dataHolder.getData().append("-1,");
            dataHolder.getData().append("-1,");
        } else {
            dataHolder.getData().append(this.replaceForPacking(value.getLocalDistinguishedName()) + ",");
            try {
                Integer froType = new Integer(FroIdFinder.getManagedObjectFroType(value, null));
                dataHolder.getData().append(froType + ",");
                Integer froId = new Integer(FroIdFinder.getManagedObjectFroId(value, null));
                dataHolder.getData().append(froId + ",");
            }
            catch (MoAccessException e) {
                logger.traceError(THIS_CLASS, "packManagedObjectR1B(name, value, document, dataHolder) catch MoAccessException: " + (Object)((Object)e));
                throw new IllegalParameterValueException(e.getMessage());
            }
        }
        logger.traceReturn(THIS_CLASS, "packManagedObjectR1B(name, value, document, dataHolder)");
        return moref;
    }

    public Element packParameterR1A(Map.Entry param, Document document) throws IllegalParameterValueException {
        String name = (String)param.getKey();
        Object value = param.getValue();
        return this.packParameterR1A(name, value, document);
    }

    private Element packParameterR1B(Map.Entry param, Document document, DataHolder dataHolder) throws IllegalParameterValueException {
        String name = (String)param.getKey();
        Object value = param.getValue();
        return this.packParameterR1B(name, value, document, dataHolder);
    }

    private Element packPrimitiveParameter(String name, Object value, Document document) {
        Element result;
        String msg = "packPrimitiveParameter(name, value, final, document)";
        logger.traceEnter(THIS_CLASS, "packPrimitiveParameter(name, value, final, document),name=" + name + " ,value=" + value);
        if (value == null && name.endsWith(REF)) {
            result = this.packString(name, "", document);
        } else if (value instanceof String) {
            result = this.packString(name, value, document);
        } else if (value instanceof Integer) {
            result = this.packInt(name, value, document);
        } else if (value instanceof Boolean) {
            Boolean booleanValue = (Boolean)value;
            result = this.packInt(name, this.booleanToInteger(booleanValue), document);
        } else if (value instanceof Long) {
            result = this.packLong(name, value, document);
        } else if (value instanceof Float) {
            Float floatValue = (Float)value;
            result = this.packInt(name, new Integer(floatValue.intValue()), document);
        } else {
            logger.traceAbnormal(THIS_CLASS, "Unknown type of primitive parameter.");
            result = null;
        }
        logger.traceReturn(THIS_CLASS, "packPrimitiveParameter(name, value, final, document)");
        return result;
    }

    private Element packAttrForComplex(String name, Object value, Document document, DataHolder dataHolder) {
        String msg = "packAttrForComplex(name, value, document, dataHolder)";
        logger.traceEnter(THIS_CLASS, "packAttrForComplex(name, value, document, dataHolder),name=" + name + " ,value=" + value);
        Element attrForComplex = document.createElement(ATTR);
        String attrName = name != null ? name : "";
        attrForComplex.setAttribute(NAME, attrName);
        if (value == null && name.endsWith(REF)) {
            dataHolder.getData().append(",");
            return attrForComplex;
        }
        if (value instanceof String) {
            attrForComplex.setAttribute(TYPE, STRING);
            dataHolder.getData().append(this.replaceForPacking((String)value));
        } else if (value instanceof Integer) {
            attrForComplex.setAttribute(TYPE, S32);
            dataHolder.getData().append(value);
        } else if (value instanceof Boolean) {
            attrForComplex.setAttribute(TYPE, S32);
            Boolean booleanValue = (Boolean)value;
            dataHolder.getData().append(this.booleanToInteger(booleanValue));
        } else if (value instanceof Long) {
            attrForComplex.setAttribute(TYPE, S64);
            dataHolder.getData().append(value);
        } else if (value instanceof Float) {
            attrForComplex.setAttribute(TYPE, S32);
            Float floatValue = (Float)value;
            dataHolder.getData().append(new Integer(floatValue.intValue()));
        } else {
            logger.traceAbnormal(THIS_CLASS, "Method: packAttrForComplex() get unsupported type.");
            return null;
        }
        dataHolder.getData().append(",");
        logger.traceReturn(THIS_CLASS, "packAttrForComplex(name, value, document, dataHolder)");
        return attrForComplex;
    }

    public Element packArray(String name, Object[] value, Document document) throws IllegalParameterValueException {
        Element array = document.createElement(ARRAY);
        if (name != null) {
            array.setAttribute(NAME, name);
        }
        List<Object> aList = Arrays.asList(value);
        Iterator<Object> iterator = aList.iterator();
        while (iterator.hasNext()) {
            Object next = iterator.next();
            if (next == null) {
                array.appendChild(this.packArrayEntry(new NullManagedObject(), document));
                continue;
            }
            array.appendChild(this.packArrayEntry(next, document));
        }
        return array;
    }

    public Element packArrayEntry(Object next, Document document) throws IllegalParameterValueException {
        return this.packParameterR1A(null, next, document);
    }

    private Element packSeqR1B(String name, Object value, Document document, DataHolder dataHolder) throws IllegalParameterValueException {
        String msg = "packSeqR1B(name, value, document, dataHolder)";
        logger.traceEnter(THIS_CLASS, "packSeqR1B(name, value, document, dataHolder),name=" + name + " ,value=" + value);
        Element result = value instanceof int[] ? this.packIntArrayR1B(name, (int[])value, document, dataHolder) : (value instanceof Integer[] ? this.packIntArrayR1B(name, (Integer[])value, document, dataHolder) : (value instanceof boolean[] ? this.packBooleanArrayR1B(name, (boolean[])value, document, dataHolder) : (value instanceof Boolean[] ? this.packBooleanArrayR1B(name, (Boolean[])value, document, dataHolder) : (value instanceof long[] ? this.packLongArrayR1B(name, (long[])value, document, dataHolder) : (value instanceof Long[] ? this.packLongArrayR1B(name, (Long[])value, document, dataHolder) : (value instanceof float[] ? this.packFloatArrayR1B(name, (float[])value, document, dataHolder) : (value instanceof Float[] ? this.packFloatArrayR1B(name, (Float[])value, document, dataHolder) : (value instanceof String[] ? this.packStringArrayR1B(name, (String[])value, document, dataHolder) : this.packObjectSeqR1B(name, (Object[])value, document, dataHolder)))))))));
        logger.traceReturn(THIS_CLASS, "packSeqR1B(name, value, document, dataHolder)");
        return result;
    }

    private Element packObjectSeqR1B(String name, Object[] value, Document document, DataHolder dataHolder) throws IllegalParameterValueException {
        String msg = "packObjectSeqR1B(name, value, document, dataHolder)";
        logger.traceEnter(THIS_CLASS, "packObjectSeqR1B(name, value, document, dataHolder),name=" + name + " ,value=" + value);
        Element objectSeq = document.createElement(SEQ);
        String attrName = name != null ? name : "";
        objectSeq.setAttribute(NAME, attrName);
        dataHolder.getData().append(value.length + ",");
        List<Object> aList = Arrays.asList(value);
        Iterator<Object> iterator = aList.iterator();
        if (!iterator.hasNext()) {
            objectSeq.setAttribute(TYPE, "");
            return objectSeq;
        }
        Object next = iterator.next();
        if (next == null) {
            objectSeq.setAttribute(TYPE, MOREF);
            while (iterator.hasNext()) {
                this.packParameterR1B(null, new NullManagedObject(), document, dataHolder);
            }
        } else if (next instanceof ManagedObject) {
            objectSeq.setAttribute(TYPE, MOREF);
            this.packParameterR1B(null, next, document, dataHolder);
            while (iterator.hasNext()) {
                next = iterator.next();
                this.packParameterR1B(null, next, document, dataHolder);
            }
        } else if (next instanceof Struct) {
            objectSeq.setAttribute(TYPE, STRCT);
            ArrayList structElementsNames = new ArrayList();
            this.packStrctR1B(null, (Struct)next, document, dataHolder, objectSeq, structElementsNames);
            while (iterator.hasNext()) {
                next = iterator.next();
                this.packStrctR1B(null, (Struct)next, document, dataHolder, structElementsNames);
            }
        } else if (next.getClass().isArray()) {
            objectSeq.setAttribute(TYPE, SEQ);
            objectSeq.appendChild(this.packParameterR1B(null, next, document, dataHolder));
            while (iterator.hasNext()) {
                next = iterator.next();
                this.packParameterR1B(null, next, document, dataHolder);
            }
        } else {
            throw new IllegalParameterValueException("Illegal type of sequence's attribute. Sequence name = " + name);
        }
        logger.traceReturn(THIS_CLASS, "packObjectSeqR1B(name, value, document, dataHolder)");
        return objectSeq;
    }

    public Element packStruct(String name, Struct value, Document document) throws IllegalParameterValueException {
        String errMsg;
        Element strct = document.createElement(STRUCT);
        if (name != null) {
            strct.setAttribute(NAME, name);
        }
        String[] names = value.getNames();
        Object[] values = null;
        try {
            values = value.getValues();
        }
        catch (NotHandledAttributeTypeException e) {
            errMsg = "Error in packStruct()";
            logger.traceError(THIS_CLASS, "Error in packStruct()", e);
        }
        catch (MoNotFoundException e) {
            errMsg = "Error in packStruct()";
            logger.traceError(THIS_CLASS, "Error in packStruct()", e);
        }
        for (int i = 0; i < names.length; ++i) {
            String aName = names[i];
            Object aVal = values[i];
            strct.appendChild(this.packParameterR1A(aName, aVal, document));
        }
        return strct;
    }

    private Element packStrctR1B(String name, Struct value, Document document, DataHolder dataHolder, List structElementsNames) throws IllegalParameterValueException {
        return this.packStrctR1B(name, value, document, dataHolder, null, structElementsNames);
    }

    private Element packStrctR1B(String name, Struct value, Document document, DataHolder dataHolder, Element parent, List structElementsNames) throws IllegalParameterValueException {
        String errMsg;
        Element strct;
        String msg = "packStrctR1B(name, value, document, dataHolder, parent)";
        logger.traceEnter(THIS_CLASS, "packStrctR1B(name, value, document, dataHolder, parent),name=" + name + " ,value=" + value);
        if (parent != null) {
            strct = parent;
        } else {
            strct = document.createElement(STRCT);
            String attrName = name != null ? name : "";
            strct.setAttribute(NAME, attrName);
        }
        String[] names = value.getNames();
        Object[] values = null;
        try {
            values = value.getValues();
        }
        catch (NotHandledAttributeTypeException e) {
            errMsg = "Error in packStrctR1B()";
            logger.traceError(THIS_CLASS, "Error in packStrctR1B()", e);
        }
        catch (MoNotFoundException e) {
            errMsg = "Error in packStrctR1B()";
            logger.traceError(THIS_CLASS, "Error in packStrctR1B()", e);
        }
        if (structElementsNames == null) {
            for (int i = 0; i < names.length; ++i) {
                strct.appendChild(this.packParameterR1B(names[i], values[i], document, dataHolder));
            }
        } else if (structElementsNames.isEmpty()) {
            for (int i = 0; i < names.length; ++i) {
                structElementsNames.add(names[i]);
                strct.appendChild(this.packParameterR1B(names[i], values[i], document, dataHolder));
            }
        } else {
            int i;
            HashMap<String, Object> nameValues = new HashMap<String, Object>();
            for (i = 0; i < names.length; ++i) {
                nameValues.put(names[i], values[i]);
            }
            for (i = 0; i < structElementsNames.size(); ++i) {
                String aName = (String)structElementsNames.get(i);
                Object aVal = nameValues.get(aName);
                strct.appendChild(this.packParameterR1B(aName, aVal, document, dataHolder));
            }
        }
        logger.traceReturn(THIS_CLASS, "packStrctR1B(name, value, document, dataHolder, parent)");
        return strct;
    }

    public String transformDocument(Document document) throws SoftwareErrorException {
        return this.transformDocument(document, true);
    }

    public String transformDocument(Document document, boolean indent) throws SoftwareErrorException {
        String result;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OutputFormat outputFormat = new OutputFormat(XML, UTF_8, indent);
        outputFormat.setIndent(0);
        outputFormat.setIndenting(false);
        XMLSerializer serializer = new XMLSerializer(byteArrayOutputStream, outputFormat);
        try {
            serializer.asDOMSerializer();
            serializer.serialize(document);
        }
        catch (IOException e) {
            String errMsg = "Error while transforming document: " + e.getMessage();
            logger.traceError(THIS_CLASS, errMsg);
            throw new SoftwareErrorException((Throwable)e);
        }
        try {
            byteArrayOutputStream.flush();
            result = byteArrayOutputStream.toString();
            byteArrayOutputStream.close();
        }
        catch (IOException e) {
            String errMsg = "Stream error: " + e.getMessage();
            logger.traceError(THIS_CLASS, errMsg);
            throw new SoftwareErrorException((Throwable)e);
        }
        return result;
    }

    private String replaceAll(String inputString, String findWhat, String replaceTo) {
        int idx;
        int start = 0;
        StringBuffer sb = new StringBuffer();
        do {
            if ((idx = inputString.indexOf(findWhat, start)) == -1) continue;
            sb.append(inputString.substring(start, idx));
            sb.append(replaceTo);
            start = idx + findWhat.length();
        } while (idx != -1);
        sb.append(inputString.substring(start, inputString.length()));
        String ret = sb.toString();
        return ret;
    }

    private String replaceForPacking(String inputString) {
        String replacedBackslash = this.replaceAll(inputString, "\\", "\\\\");
        String replacedComma = this.replaceAll(replacedBackslash, ",", "\\,");
        return replacedComma;
    }

    static {
        for (int i = 0; i < ALPHABET.length; ++i) {
            XmlPackImpl.toInt[XmlPackImpl.ALPHABET[i]] = i;
        }
    }

    private class DataHolder {
        private boolean isComplex = false;
        private StringBuffer dataBuffer = new StringBuffer();

        private DataHolder() {
        }

        public boolean isComplex() {
            return this.isComplex;
        }

        public void setComplex(boolean isComplex) {
            this.isComplex = isComplex;
        }

        public StringBuffer getData() {
            return this.dataBuffer;
        }
    }
}

