/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.mao.indications;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.ListResourceBundle;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import se.ericsson.cello.maofro.framework.IllegalParameterValueException;
import se.ericsson.cello.maofro.framework.Parameter;
import se.ericsson.cello.maofro.framework.StringParameter;
import se.ericsson.cello.maofro.proxy.MaoFroGenericEventInd;
import se.ericsson.cello.maofro.proxy.MaoFroGenericFaultCeasedInd;
import se.ericsson.cello.maofro.proxy.MaoFroGenericFaultInd;
import se.ericsson.cello.maofro.proxy.MaoFroGenericMomDefinedEventInd;
import se.ericsson.cello.maofro.proxy.MaoFroGenericMomDefinedFaultCeaseInd;
import se.ericsson.cello.maofro.proxy.MaoFroGenericMomDefinedFaultInd;
import se.ericsson.cello.maofro.proxy.MaoFroGenericParameterChdInd;
import se.ericsson.cello.maofro.proxy.TagNameDictionaries;
import se.ericsson.cello.maofro.proxy.TagNameDictionaryException;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.cello.moframework.NoSuchFieldException;
import se.ericsson.cello.moframework.NotHandledAttributeTypeException;
import se.ericsson.cello.moframework.SequenceDiffInfo;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.metadata.AttributeMetaData;
import se.ericsson.crbs.omf.mao.commonmo.metadata.MoMetaData;
import se.ericsson.crbs.omf.mao.commonmo.mo.GenericManagedObject;
import se.ericsson.crbs.omf.mao.genericmo.DeprecatedGenericMaoHelper;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.genericmo.attributes.manager.ParameterConverter;
import se.ericsson.crbs.omf.mao.genericmo.xml.XmlPack;
import se.ericsson.crbs.omf.mao.indications.FaultHandlerImpl;
import se.ericsson.crbs.omf.mao.indications.IndicationHandlerSdn;
import se.ericsson.crbs.omf.mao.indications.ResourceAVCWrapper;
import se.ericsson.crbs.omf.mao.indications.wrappers.MaoFroGenericFaultCeasedIndWrapper;
import se.ericsson.crbs.omf.mao.indications.wrappers.MaoFroGenericFaultCeasedIndWrapperFactory;
import se.ericsson.crbs.omf.mao.indications.wrappers.MaoFroGenericFaultIndWrapper;
import se.ericsson.crbs.omf.mao.indications.wrappers.MaoFroGenericFaultIndWrapperFactory;
import se.ericsson.crbs.omf.mao.indications.wrappers.MaoFroGenericParameterChdIndWrapper;
import se.ericsson.crbs.omf.mao.indications.wrappers.MaoFroGenericParameterChdIndWrapperFactory;
import se.ericsson.crbs.omf.mao.indications.wrappers.NotificationSenderWrapper;
import se.ericsson.crbs.omf.mao.indications.wrappers.NotificationSenderWrapperFactory;
import se.ericsson.crbs.omf.mao.indications.wrappers.NotificationSenderWrapperSdn;

class IndicationHandlerImpl
implements IndicationHandlerSdn {
    private static final Class THIS_CLASS = IndicationHandlerImpl.class;
    private static AbstractLogger logger = LoggingService.getLogger(THIS_CLASS.getName());
    private static final int NO_STATUS = 0;
    private static final int IN_TEST = 1;
    private static final int FAILED = 2;
    private static final int POWER_OFF = 4;
    private static final int OFF_LINE = 8;
    private static final int OFF_DUTY = 16;
    private static final int DEGRADED = 64;
    private static final int NOT_INSTALLED = 128;
    private static final int LOG_FULL = 256;
    private static final int DEPENDENCY_LOCKED = 544;
    private static final int DEPENDENCY_FAILED = 1056;
    private static final int DEPENDENCY_SHUTTINGDOWN = 2080;
    private final int[] statusList = new int[]{128, 4, 1, 544, 2080, 1056, 2, 8, 64, 16, 256};
    private static final String NOTIFICATION_TYPE_AVC = "AVC";
    private static final String NOTIFICATION_TYPE_SDN = "SDN";
    private static final ListResourceBundle BUNDLE = new ListResourceBundle(){
        final Object[][] CONTENTS = new Object[][]{{"data", "21"}};

        protected Object[][] getContents() {
            return this.CONTENTS;
        }
    };
    private final ParameterConverter paramConv;
    private final ManagedObject managedObject;
    private final GenericMaoContext genericMaoContext;
    private final XmlPack xmlPack;
    private final FaultHandlerImpl faultHandler;
    private final String protocolVersion;
    private static final String PV_R1A = "R1A";

    IndicationHandlerImpl(ManagedObject fMo, GenericMaoContext aGenericMaoContext) {
        logger.traceEnter(THIS_CLASS, "IndicationHandlerImpl()");
        this.managedObject = fMo;
        this.genericMaoContext = aGenericMaoContext;
        this.paramConv = new ParameterConverter();
        this.xmlPack = this.genericMaoContext.getXmlPackFactory().getXmlPack();
        this.faultHandler = new FaultHandlerImpl(aGenericMaoContext);
        if (this.genericMaoContext.getMoMetaDataFinder().getMoData(this.managedObject.getType()) != null) {
            this.protocolVersion = this.genericMaoContext.getMoMetaDataFinder().getMoData(this.managedObject.getType()).getFroProtocolVersion();
        } else {
            logger.traceAbnormal(THIS_CLASS, "MoMetaData for MO type " + this.managedObject.getType() + " was not found. " + "Assuming that it is R1A.");
            this.protocolVersion = PV_R1A;
        }
        logger.traceReturn(THIS_CLASS, "IndicationHandlerImpl()");
    }

    public void alarmCeased(MaoFroGenericFaultCeasedInd maoFroGenericFaultCeasedInd) {
        logger.traceEnter(THIS_CLASS, "alarmCeased()");
        if (maoFroGenericFaultCeasedInd == null) {
            logger.traceAbnormal(THIS_CLASS, "Signal to cease alarm " + maoFroGenericFaultCeasedInd + " is null, and no alarm was ceased!");
        } else {
            MaoFroGenericFaultCeasedIndWrapper aWrapper = MaoFroGenericFaultCeasedIndWrapperFactory.createMaoFroGenericFaultCeasedIndWrapper(maoFroGenericFaultCeasedInd);
            this.faultHandler.clearAlarm(aWrapper, this.managedObject);
        }
        logger.traceReturn(THIS_CLASS, "alarmCeased()");
    }

    public void alarmCeased(MaoFroGenericMomDefinedFaultCeaseInd maofrogenericmomdefinedfaultceaseind) {
    }

    public void alarmRaised(MaoFroGenericFaultInd maoFroGenericFaultInd, String service) {
        logger.traceEnter(THIS_CLASS, "alarmRaised()");
        String eventTime = this.getTime();
        if (maoFroGenericFaultInd == null) {
            logger.traceAbnormal(THIS_CLASS, "Signal to raise alarm is null for service " + service + ", and no alarm was raised!");
        } else {
            MaoFroGenericFaultIndWrapper sig = MaoFroGenericFaultIndWrapperFactory.createMaoFroGenericFaultIndWrapper(maoFroGenericFaultInd);
            this.faultHandler.handleFault(sig, this.managedObject, service, eventTime);
        }
        logger.traceReturn(THIS_CLASS, "alarmRaised()");
    }

    public void alarmRaised(MaoFroGenericMomDefinedFaultInd maofrogenericmomdefinedfaultind, String service) {
    }

    public void ceaseAllAlarms(Coordinator coordinator) {
        logger.traceEnter(THIS_CLASS, "ceaseAllAlarms()");
        this.faultHandler.clearAllAlarms(coordinator);
        logger.traceReturn(THIS_CLASS, "ceaseAllAlarms()");
    }

    public void ceaseAllAlarms(String service) {
        logger.traceEnter(THIS_CLASS, "ceaseAllAlarms()");
        this.faultHandler.clearAllAlarms(service);
        logger.traceReturn(THIS_CLASS, "ceaseAllAlarms()");
    }

    public void eventRaised(MaoFroGenericEventInd maoFroGenericEventInd) {
    }

    public void eventRaised(MaoFroGenericMomDefinedEventInd maofrogenericmomdefinedeventind) {
    }

    public final void handleAvcNotification(String attrName, Object attrValue, Coordinator coord) {
        logger.traceEnter(THIS_CLASS, "handleAvcNotification()");
        try {
            this.handleAvcNotificationInt(attrName, attrValue, coord);
        }
        catch (Exception nothingWeCanDoAboutIt) {
            // empty catch block
        }
        logger.traceReturn(THIS_CLASS, "handleAvcNotification()");
    }

    protected final void handleAvcNotificationInt(String attrName, Object attrValue, Coordinator coord) throws NotHandledAttributeTypeException, NoSuchFieldException, MoNotFoundException {
        logger.traceEnter(THIS_CLASS, "handleAvcNotificationInt()");
        this.handleNotification(this.managedObject, attrName, attrValue, coord, NOTIFICATION_TYPE_AVC);
        this.checkIfReplacingMo(this.managedObject, attrName, attrValue, coord, NOTIFICATION_TYPE_AVC);
        logger.traceReturn(THIS_CLASS, "handleAvcNotificationInt()");
    }

    private void checkIfReplacingMo(ManagedObject mo, String attrName, Object attrValue, Coordinator coord, String notificationType) throws NotHandledAttributeTypeException, NoSuchFieldException, MoNotFoundException {
        logger.traceEnter(THIS_CLASS, "checkIfReplacingMo(), MO = " + mo.getLocalDistinguishedName() + ", attrName = " + attrName + ", attrValue = " + attrValue);
        boolean checkReplacingMo = true;
        ManagedObject moToCheck = mo;
        while (checkReplacingMo) {
            ManagedObject replacedMo = DeprecatedGenericMaoHelper.lookupReplacedMo(moToCheck.getType(), moToCheck.getNamingAttributeValue(), moToCheck.getLocalDistinguishedName(), moToCheck.getParent().getLocalDistinguishedName(), this.genericMaoContext);
            if (replacedMo == null) {
                checkReplacingMo = false;
                continue;
            }
            moToCheck = replacedMo;
            this.handleNotification(replacedMo, attrName, attrValue, coord, notificationType);
        }
        logger.traceReturn(THIS_CLASS, "checkIfReplacingMo()");
    }

    private void handleNotification(ManagedObject mo, String attrName, Object attrValue, Coordinator coord, String notificationType) throws NotHandledAttributeTypeException, NoSuchFieldException, MoNotFoundException {
        logger.traceEnter(THIS_CLASS, "handleNotification(), MO = " + mo.getLocalDistinguishedName() + ", attrName = " + attrName + ", attrValue = " + attrValue);
        MoMetaData moMetaData = this.genericMaoContext.getMoMetaDataFinder().getMoData(mo.getType());
        Map attributes = moMetaData.getAttributes();
        AttributeMetaData attributeMetaData = (AttributeMetaData)attributes.get(attrName);
        if (attributeMetaData != null) {
            String replacedAttrName;
            if (!attributeMetaData.isNoNotification()) {
                this.pushNotification(mo, attrName, attrValue, coord, notificationType);
            }
            if ((replacedAttrName = DeprecatedGenericMaoHelper.getReplacedAttributeName(attributeMetaData, mo.getType())) != null) {
                this.handleNotification(mo, replacedAttrName, attrValue, coord, notificationType);
            }
        }
        logger.traceReturn(THIS_CLASS, "handleNotification()");
    }

    private void pushNotification(ManagedObject mo, String attrName, Object attrValue, Coordinator coord, String notificationType) {
        logger.traceEnter(THIS_CLASS, "pushNotification()");
        String[] attrNames = new String[]{attrName};
        if (NOTIFICATION_TYPE_SDN.equals(notificationType)) {
            SequenceDiffInfo[] newValues = new SequenceDiffInfo[]{(SequenceDiffInfo)attrValue};
            NotificationSenderWrapper notificationSenderWrapper = NotificationSenderWrapperFactory.getNotificationSender();
            if (notificationSenderWrapper instanceof NotificationSenderWrapperSdn) {
                if (coord == null) {
                    ((NotificationSenderWrapperSdn)notificationSenderWrapper).pushSdn(mo, attrNames, newValues);
                } else {
                    ((NotificationSenderWrapperSdn)notificationSenderWrapper).pushSdn(mo, attrNames, newValues, coord);
                }
            }
        } else {
            Object[] newValues = new Object[]{attrValue};
            if (coord == null) {
                logger.traceGeneral(THIS_CLASS, "pushAvc() Mo" + mo.getLocalDistinguishedName() + "attrName" + attrName + "attrValue" + attrValue + "coord == null");
                NotificationSenderWrapperFactory.getNotificationSender().pushAvc(mo, attrNames, newValues);
            } else {
                ResourceAVCWrapper resorceAVCElement = ResourceAVCWrapper.getInstance(mo, coord);
                resorceAVCElement.storeAttribute(attrName, attrValue);
            }
        }
        logger.traceReturn(THIS_CLASS, "pushNotification()");
    }

    public void parameterChanged(MaoFroGenericParameterChdInd maoFroGenericParameterChdInd) {
        logger.traceEnter(THIS_CLASS, "parameterChanged()");
        logger.traceGeneral(THIS_CLASS, "State Change Indication Received " + maoFroGenericParameterChdInd + " received");
        MaoFroGenericParameterChdIndWrapper aWrapper = MaoFroGenericParameterChdIndWrapperFactory.createMaoFroGenericParameterChdIndWrapper(maoFroGenericParameterChdInd);
        StringParameter froData = null;
        try {
            Map parameters = aWrapper.getParameters(TagNameDictionaries.create((ResourceBundle)BUNDLE));
            if (parameters.get("data") != null) {
                froData = (StringParameter)parameters.get("data");
            }
            String debMsg = "Returned data is: " + froData.toString();
            logger.traceDebug(THIS_CLASS, debMsg);
            List attributeValues = this.xmlPack.extractAttributes(froData, this.protocolVersion);
            Iterator iterator = attributeValues.iterator();
            while (iterator.hasNext()) {
                Parameter param = (Parameter)iterator.next();
                String attrName = param.getName();
                Object attrValue = this.paramConv.convertFroParameterToJavaType(this.managedObject.getType(), this.managedObject.getId(), param, this.genericMaoContext.getMoRepositoryWrapper(), this.genericMaoContext, attrName, this.getAttributeType(attrName));
                if (attrName.equalsIgnoreCase("availabilityStatus")) {
                    if (attrValue instanceof String) {
                        attrValue = this.handleAvailabilityStatus(new Integer((String)attrValue));
                    } else if (attrValue instanceof Integer) {
                        attrValue = this.handleAvailabilityStatus((Integer)attrValue);
                    }
                }
                this.handleAvcNotification(attrName, attrValue, null);
                if (!(this.managedObject instanceof GenericManagedObject)) continue;
                ((GenericManagedObject)this.managedObject).parameterChanged(attrName, attrValue);
            }
        }
        catch (TagNameDictionaryException ex) {
            logger.traceError(THIS_CLASS, "no parameters found for: " + this.managedObject.toString(), ex);
        }
        catch (IllegalParameterValueException ex) {
            logger.traceError(THIS_CLASS, "error in getting parameters for : " + this.managedObject.toString(), ex);
        }
        catch (MoAccessException e) {
            logger.traceError(THIS_CLASS, "error in getting parameters for : " + this.managedObject.toString(), e);
        }
        logger.traceReturn(THIS_CLASS, "parameterChanged()");
    }

    private String getAttributeType(String attributeName) {
        String result = "Unknown";
        AttributeMetaData attributeMetaData = this.genericMaoContext.getMoMetaDataFinder().getMoAttributes(this.managedObject.getType(), attributeName);
        if (attributeMetaData != null) {
            result = attributeMetaData.getData().getJavaReturnType();
        }
        return result;
    }

    private Integer handleAvailabilityStatus(Integer availabilityStatus) {
        logger.traceEnter(THIS_CLASS, "handleAvailabilityStatus()");
        int values = availabilityStatus;
        int returnValue = 0;
        boolean returnValueSet = false;
        StringBuffer activeValues = new StringBuffer();
        for (int i = 0; i < this.statusList.length; ++i) {
            if (!this.containsBit(values, this.statusList[i])) continue;
            if (!returnValueSet) {
                returnValue = this.statusList[i];
                returnValueSet = true;
            }
            activeValues.append(this.statusList[i]);
            activeValues.append(',');
        }
        logger.traceDebug(THIS_CLASS, "Current active availabilityStatus values are " + activeValues + " the returned value is " + returnValue);
        logger.traceReturn(THIS_CLASS, "handleAvailabilityStatus()");
        return new Integer(returnValue);
    }

    private boolean containsBit(int bitmask, int bit) {
        boolean result = false;
        if ((bitmask & bit) == bit) {
            result = true;
        }
        return result;
    }

    private String getTime() {
        Locale locale = Locale.getDefault();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss", locale);
        Date date = new Date();
        return dateFormat.format(date);
    }

    public void handleSdnNotification(String attrName, SequenceDiffInfo sequenceDiffInfo, Coordinator coord) {
        logger.traceEnter(THIS_CLASS, "handleSdnNotification()");
        try {
            this.handleSdnNotificationInt(attrName, sequenceDiffInfo, coord);
        }
        catch (Exception nothingWeCanDoAboutIt) {
            // empty catch block
        }
        logger.traceReturn(THIS_CLASS, "handleSdnNotification()");
    }

    private void handleSdnNotificationInt(String attrName, SequenceDiffInfo sequenceDiffInfo, Coordinator coord) throws NotHandledAttributeTypeException, NoSuchFieldException, MoNotFoundException {
        logger.traceEnter(THIS_CLASS, "handleSdnNotificationInt()");
        this.handleNotification(this.managedObject, attrName, sequenceDiffInfo, coord, NOTIFICATION_TYPE_SDN);
        this.checkIfReplacingMo(this.managedObject, attrName, sequenceDiffInfo, coord, NOTIFICATION_TYPE_SDN);
        logger.traceReturn(THIS_CLASS, "handleSdnNotificationInt()");
    }
}

