/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.antennasystem;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.BemLog;
import se.ericsson.wcdma.rbs.bem.common.config.check.ConfigurationCheckReport;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.AbstractConfigurationItem;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.antennasystem.AntennaBranchRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.antennasystem.AntennaFeederConversion;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.antennasystem.AntennaFeederRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.antennasystem.AscRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.antennasystem.BeamDirectionConversion;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.antennasystem.DcVoltageConversion;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.antennasystem.ExternalAntennaRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.antennasystem.HeightRange;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.antennasystem.InternalPowerConversion;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.antennasystem.LatHemisphereConversion;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.antennasystem.LmtPortsConversion;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.antennasystem.LowCurrentSupervisionConversion;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.antennasystem.OilRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.antennasystem.RadioDotRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.antennasystem.RdiCableRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.antennasystem.RetCIComponent;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.antennasystem.SectorAntennaRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.antennasystem.SectorRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.antennasystem.SiteDataRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.antennasystem.TmaDegradedSupportedConversion;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.antennasystem.TmaRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.antennasystem.custparam.LmtPortsParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.antennasystem.resource.AtmauRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.antennasystem.resource.TmfRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.antennasystem.util.RadioDotSystemUtil;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.AntennaSystemProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.CellAndCarrierProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.PowerSupplyProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.RadioEquipmentListener;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.RadioEquipmentProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.RadioEquipmentProviderWithRbb;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.rbbmgmt.RbbManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.util.AIRUtil;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.RbsUtil;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.SectorUtil;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.BooleanCustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterException;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterImpl;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterListener;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterServer;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.EnumeratedRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.Enumeration;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IntegerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IntegerRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ListParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ListRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.OnOffCustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.OutOfRangeException;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterEvent;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterRestriction;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.StringParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.StringRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.TrueFalseCustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.YesNoCustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.AtfProvider;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractDbControlledAuxillaryUnitRI;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractResourceItem;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractRuRI;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimAntFeederCable;
import se.ericsson.wcdma.rbs.bem.common.mim.MimAntennaBranch;
import se.ericsson.wcdma.rbs.bem.common.mim.MimAscDeviceGroup;
import se.ericsson.wcdma.rbs.bem.common.mim.MimAuxPlugInUnit;
import se.ericsson.wcdma.rbs.bem.common.mim.MimDeviceGroup;
import se.ericsson.wcdma.rbs.bem.common.mim.MimExternalAntenna;
import se.ericsson.wcdma.rbs.bem.common.mim.MimExternalTma;
import se.ericsson.wcdma.rbs.bem.common.mim.MimManagedElement;
import se.ericsson.wcdma.rbs.bem.common.mim.MimPositionStruct;
import se.ericsson.wcdma.rbs.bem.common.mim.MimSector;
import se.ericsson.wcdma.rbs.bem.common.mim.MimSectorAntenna;
import se.ericsson.wcdma.rbs.bem.common.mim.MimTmaDeviceSet;
import se.ericsson.wcdma.rbs.bem.common.mim.MimTpaDevice;
import se.ericsson.wcdma.rbs.bem.common.mim.nonautogenerated.MimAntennaBranchDef;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandler;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerException;
import se.ericsson.wcdma.rbs.bem.common.moi.ChildWithAttributeValues;
import se.ericsson.wcdma.rbs.bem.common.moi.FixedRdnMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.moi.SectorAntennaMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.SingleChildMoi;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;
import se.ericsson.wcdma.rbs.bem.common.service.PrefixUtil;
import se.ericsson.wcdma.rbs.bem.common.service.ServiceCommon;
import se.ericsson.wcdma.rbs.bem.common.service.ServiceNameValue;
import se.ericsson.wcdma.rbs.bem.common.service.ServiceValue;
import se.ericsson.wcdma.rbs.bem.common.util.BemUtil;

public abstract class AbstractAntennaSystemCI
extends AbstractConfigurationItem
implements AntennaSystemProvider {
    private static final int WANTED_POSITION_MAX_VALUE = 50;
    private static final int WANTED_POSITION_MIN_VALUE = 0;
    public static final String name = "AntennaSystemCI";
    private static final String FQBAND_HIGH_EDGE_CONSISTENT_ERROR = "FQ band high edge must be higher then FQ band low edge";
    private static final String FQBAND_HIGH_EDGE_WRONG_RANGE_CONSISTENT_ERROR = "FQ band high edge must be in the same range as FQ band low edge";
    private static final String AUTO_CREATED_RDNID_1 = "1";
    private static final String NOT_POSSIBLE_TO_CHANGE_SECTOR = "Not possible to change sector ";
    private static final String CELLS_OFFLINE = "All cells in sector must be offline";
    protected static final String NONE_STRING = "NONE";
    protected static final String ASC_STRING = "ASC";
    protected static final String TMA_STRING = "TMA";
    protected static final String ATMA_STRING = "ATMA";
    protected static final String ATMA_AND_TMA_STRING = "ATMA_AND_TMA";
    protected static final String ATMAU_STRING = "ATMAU";
    protected static final String TMF_STRING = "TMF";
    protected static final String DC_17V_OR_DC_30V = "DC_17V_OR_DC_30V";
    protected static final String DC_12V = "DC_12V";
    protected final int maxNoOfSectors;
    protected final int maxNumberInRangeOfCarriers = 8;
    protected static final int MAX_NO_OF_ANTFEEDERCABLE_PER_BRANCH = 2;
    protected static final int DEFAULT_NO_OF_BRANCHES_PER_SECTOR_ANTENNA = 2;
    protected int startingSectorNumber;
    private final int maxSequenceNumber;
    public static final int NO_INPUT = 1;
    private static final int VALID_INPUT = 2;
    private static final int INVALID_INPUT = 3;
    private static final String MODIFICATION_TYPE_ADD = "ADD";
    private static final String MODIFICATION_TYPE_CHANGE = "CHANGE";
    private static final String MODIFICATION_TYPE_DELETE = "DELETE";
    public static final int maxNoOfSectorAntennasPerSector = 3;
    public static final int MAX_NO_OF_RADIO_DOT_PER_SECTOR = RadioDotSystemUtil.getMaxNoOfRadioDotPerIRU();
    private static final int numberOfLimDelayAttrTma = 2;
    private final Vector[][] uninitiateAntennaBranchVector;
    private final Vector[][] initiateAntennaBranchVector;
    private final Vector[][] uninitiateAntFeederCableVector;
    private final Vector[][] initiateAntFeederCableVector;
    private final Vector[][] antennaBranchAttr;
    private final Vector[][] antFeederCableAttr;
    private final boolean canHaveTma;
    private final boolean canHaveRet;
    protected final RetCIComponent retCic;
    private String bandType32 = "32";
    private String ulCPDefaultValue = "0";
    private final IntegerRange BAND1_RANGE_LOW_EDGE = new IntegerRange(21100, 21650);
    private final IntegerRange BAND2_RANGE_LOW_EDGE = new IntegerRange(19300, 19850);
    private final IntegerRange BAND3_RANGE_LOW_EDGE = new IntegerRange(18050, 18750);
    private final IntegerRange BAND4_RANGE_LOW_EDGE = new IntegerRange(21100, 21500);
    private final IntegerRange BAND5_RANGE_LOW_EDGE = new IntegerRange(8690, 8890);
    private final IntegerRange BAND6_RANGE_LOW_EDGE = new IntegerRange(8750, 8800);
    private final IntegerRange BAND7_RANGE_LOW_EDGE = new IntegerRange(26200, 26850);
    private final IntegerRange BAND8_RANGE_LOW_EDGE = new IntegerRange(9250, 9550);
    private final IntegerRange BAND9_RANGE_LOW_EDGE = new IntegerRange(18449, 18759);
    private final IntegerRange BAND10_RANGE_LOW_EDGE = new IntegerRange(21100, 21650);
    private final IntegerRange BAND11_RANGE_LOW_EDGE = new IntegerRange(14759, 14909);
    private final IntegerRange BAND12_RANGE_LOW_EDGE = new IntegerRange(7280, 7410);
    private final IntegerRange BAND13_RANGE_LOW_EDGE = new IntegerRange(7460, 7510);
    private final IntegerRange BAND14_RANGE_LOW_EDGE = new IntegerRange(7580, 7630);
    private final IntegerRange BAND19_RANGE_LOW_EDGE = new IntegerRange(8750, 8850);
    private final IntegerRange BAND20_RANGE_LOW_EDGE = new IntegerRange(7910, 8160);
    private final IntegerRange BAND21_RANGE_LOW_EDGE = new IntegerRange(14959, 15059);
    private final IntegerRange BAND32_RANGE_LOW_EDGE = new IntegerRange(14520, 14910);
    private final IntegerRange BAND1_RANGE_HIGH_EDGE = new IntegerRange(21150, 21700);
    private final IntegerRange BAND2_RANGE_HIGH_EDGE = new IntegerRange(19350, 19900);
    private final IntegerRange BAND3_RANGE_HIGH_EDGE = new IntegerRange(18100, 18800);
    private final IntegerRange BAND4_RANGE_HIGH_EDGE = new IntegerRange(21150, 21550);
    private final IntegerRange BAND5_RANGE_HIGH_EDGE = new IntegerRange(8740, 8940);
    private final IntegerRange BAND6_RANGE_HIGH_EDGE = new IntegerRange(8800, 8850);
    private final IntegerRange BAND7_RANGE_HIGH_EDGE = new IntegerRange(26250, 26900);
    private final IntegerRange BAND8_RANGE_HIGH_EDGE = new IntegerRange(9300, 9600);
    private final IntegerRange BAND9_RANGE_HIGH_EDGE = new IntegerRange(18499, 18799);
    private final IntegerRange BAND10_RANGE_HIGH_EDGE = new IntegerRange(21150, 21700);
    private final IntegerRange BAND11_RANGE_HIGH_EDGE = new IntegerRange(14809, 14959);
    private final IntegerRange BAND12_RANGE_HIGH_EDGE = new IntegerRange(7330, 7460);
    private final IntegerRange BAND13_RANGE_HIGH_EDGE = new IntegerRange(7510, 7560);
    private final IntegerRange BAND14_RANGE_HIGH_EDGE = new IntegerRange(7630, 7680);
    private final IntegerRange BAND19_RANGE_HIGH_EDGE = new IntegerRange(8800, 8900);
    private final IntegerRange BAND20_RANGE_HIGH_EDGE = new IntegerRange(7960, 8210);
    private final IntegerRange BAND21_RANGE_HIGH_EDGE = new IntegerRange(15009, 15109);
    private final IntegerRange BAND32_RANGE_HIGH_EDGE = new IntegerRange(14570, 14960);
    private final String[] bandRange = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "19", "20", "21", "32"};
    private static final String[] branch = new String[]{MimAntennaBranchDef.BRANCH_A, MimAntennaBranchDef.BRANCH_B, MimAntennaBranchDef.BRANCH_C, MimAntennaBranchDef.BRANCH_D, MimAntennaBranchDef.BRANCH_E, MimAntennaBranchDef.BRANCH_F};
    private static final int IndexOfBranchA = 0;
    protected ParameterRestriction[] requiredRestriction;
    protected ParameterRestriction[] sectorUsedRestriction;
    protected ParameterRestriction[] sectorNotEquippedRestriction;
    protected ParameterRestriction[][] antennaTypeRestriction;
    protected ParameterRestriction[][] meTiltRestriction;
    protected ParameterRestriction[][][] aretCascadedRestriction;
    protected ParameterRestriction[] sectorAntennaRestriction;
    protected ParameterRestriction[] fqBandHighEdgeRangeRestriction;
    protected ParameterRestriction[] fqBandLowEdgeRangeRestriction;
    protected ParameterRestriction[][] tmaTypeRangeRestriction;
    public AscRI[][] asc;
    public AtmauRI[][] atmau;
    public TmfRI[][] tmf;
    public AntennaBranchRI[][] antennaBranch;
    public AntennaFeederRI[][][] antennaFeeder;
    public RadioDotRI[][] radioDot;
    public RdiCableRI[][] rdiCable;
    private IntegerParameter[][] meTiltParam;
    private IntegerParameter[][][] meTiltCascadedParam;
    private IntegerParameter[][] antennaSupParam;
    protected IntegerParameter[][] antennaTypeParam;
    private IntegerParameter[][][] antennaTypeCascadedParam;
    private StringParameter[][] userlabelParam;
    private StringParameter[][][] userlabelCascadedParam;
    private Enumeration[][][] modificationTypeCascadedParam;
    private Enumeration[] bandParam;
    private IntegerParameter[][] fqHiEdgeParam;
    private IntegerParameter[][] fqLoEdgeParam;
    private ListParameter[][] dlFeederAttParam;
    private ListParameter[][] ulFeederAttParam;
    private ListParameter[][] dlFeederDelayParam;
    private ListParameter[][] ulFeederDelayParam;
    protected Enumeration[][] tmaParam;
    private IntegerParameter[][] dlAttParam;
    private IntegerParameter[][] ulGainParam;
    private TrueFalseCustomerParameter[] modifyTmfFileParam;
    private IntegerParameter[][][] dlDelayParam;
    private IntegerParameter[][][] ulDelayParam;
    private YesNoCustomerParameter[][] tmaDegradedSupported;
    private BooleanCustomerParameter[][] lowCurrentSupervision;
    private YesNoCustomerParameter[][] riuInstalled;
    private IntegerParameter[][][] currentLowLim;
    private IntegerParameter[][][] currentHighLim;
    private YesNoCustomerParameter[][] internalPowerParam;
    private Enumeration[][] dcVoltageParam;
    private IntegerParameter[][] dlAttATMAParam;
    private IntegerParameter[][] dlTrafficDelayParam;
    private IntegerParameter[][] ulTrafficDelayParam;
    private IntegerParameter[] sectorOutputPower;
    private IntegerParameter[] sectorOutputPowerLow;
    private BooleanCustomerParameter[] lockSectorOutputPowerLow;
    private ParameterRestriction[][] tmaRestriction;
    private ParameterRestriction[][] tmaAndAtmaRestriction;
    private ParameterRestriction[][] riuInstalledRestriction;
    private ParameterRestriction[][] atmaRestriction;
    private ParameterRestriction[][] tmaDegradedSupportedRestriction;
    private ParameterRestriction[][] tmaDegradedSupportedActivationRestriction;
    private ParameterRestriction[][] internalPowerSupportedRestriction;
    private ParameterRestriction[][] dcVoltageRestriction;
    private ParameterRestriction[] sectorOutputPowerRestriction;
    private ParameterRestriction[] sectorOutputPowerLowRestriction;
    private ParameterRestriction[] lockSectorOutputPowerLowRestriction;
    private NumberOfRxBranchesListener[][] numberOfRxBranchesListeners;
    protected OilRI[] oilDl;
    protected OilRI[] oilUl;
    protected AbstractDbControlledAuxillaryUnitRI[] rru;
    public final SectorAntennaRI[][] sectorAntenna;
    private final SectorRI[] sectors;
    private SiteDataRI siteData;
    private TmaRI[][] tma;
    private final ExternalAntennaRI[][][] externalAntenna;
    protected boolean isOpen = false;
    private boolean isProviderOpen = false;
    protected RadioEquipmentProvider radioEP;
    protected CellAndCarrierProvider cellCarrP;
    protected Properties cascadedAretActions = new Properties();
    protected boolean[] unInitSectorsExternalAntenna;
    private static final String[] modificationTypes = new String[]{"ADD", "CHANGE", "DELETE"};
    private MoInstance[] sectorMois;
    protected MoInstance[][] sectorAntennaMois;
    protected MoInstance[][][] externalAntennaMois;
    private MoInstance[][] tmaMois;
    protected MoInstance[] rruMois;
    protected MoInstance[] rruAuxPiuMois;
    private MoInstance[][] ascMois;
    private MoInstance[][] ascAuxPiuMois;
    private MoInstance[][] atmauAuxPiuMois;
    private MoInstance[][] atmauMois;
    private MoInstance[][] tmfMois;
    private MoInstance[][] tmfDeviceSetMois;
    private MoInstance[][] tmfAuxPiuMois;
    private MoInstance[][] tmaDeviceSetMois;
    private MoInstance[][] antennaBranchMois;
    protected MoInstance[][][] antFeederMois;
    protected MoInstance[] optLinkDlMois;
    protected MoInstance[] optLinkUlMois;
    protected String[] sectorRdns = SectorUtil.getSectorRdn();
    private static final String[] pseudos = new String[]{"beamDirection", "beamDirection2", "beamDirection3", "geoDatum", "height", "latHemisphere", "latitude", "longitude", "noiseFigure", "sectorGroup", "antennaType", "antennaType2", "antennaType3", "mechanicalTilt", "mechanicalTilt2", "mechanicalTilt3", "band", "fqBandHighEdgeBranch" + branch[0], "fqBandHighEdgeBranch" + branch[1], "fqBandHighEdgeBranch" + branch[2], "fqBandHighEdgeBranch" + branch[3], "fqBandHighEdgeBranch" + branch[4], "fqBandHighEdgeBranch" + branch[5], "fqBandLowEdgeBranch" + branch[0], "fqBandLowEdgeBranch" + branch[1], "fqBandLowEdgeBranch" + branch[2], "fqBandLowEdgeBranch" + branch[3], "fqBandLowEdgeBranch" + branch[4], "fqBandLowEdgeBranch" + branch[5], "antennaSupervisionBranch" + branch[0], "antennaSupervisionBranch" + branch[1], "antennaSupervisionBranch" + branch[2], "antennaSupervisionBranch" + branch[3], "antennaSupervisionBranch" + branch[4], "antennaSupervisionBranch" + branch[5], "currentLowSupervision_" + branch[0], "currentLowSupervision_" + branch[1], "currentLowSupervision_" + branch[2], "currentLowSupervision_" + branch[3], "currentLowSupervision_" + branch[4], "currentLowSupervision_" + branch[5], "sectorOutputPower", "sectorOutputPowerLow", "lockSectorOutputPowerLow", "maxTilt", "maxTilt2", "maxTilt3", "minTilt", "minTilt2", "minTilt3"};
    private static final String[] retCascadedpseudos = new String[]{"antennaType", "uniqueHwId", "electricalTilt", "mechanicalTilt", "userLabel"};
    private static final String[] modelPseudosRet = new String[]{"typeOfRet", "typeOfRet2", "typeOfRet3", "configureRet", "uniqueHwId", "electricalTilt", "electricalTilt2", "electricalTilt3"};
    private static final String[] modelPseudosTma = new String[]{"tmaType", "tmaType2", "tmaType3", "internalPower", "internalPower2", "internalPower3", "dcVoltage", "dcVoltage2", "dlAttenuation", "dlAttenuation2", "dlAttenuation3", "ulGain", "ulGain2", "ulGain3", "dlTrafficDelay" + branch[0], "dlTrafficDelay" + branch[1], "dlTrafficDelay" + branch[2], "dlTrafficDelay" + branch[3], "dlTrafficDelay" + branch[4], "dlTrafficDelay" + branch[5], "ulTrafficDelay" + branch[0], "ulTrafficDelay" + branch[1], "ulTrafficDelay" + branch[2], "ulTrafficDelay" + branch[3], "ulTrafficDelay" + branch[4], "ulTrafficDelay" + branch[5], "tmaDegradedSupported", "tmaDegradedSupported2", "tmaDegradedSupported3", "currentLowSupervision_" + branch[0], "currentLowSupervision_" + branch[1], "currentLowSupervision_" + branch[2], "currentLowSupervision_" + branch[3], "currentLowSupervision_" + branch[4], "currentLowSupervision_" + branch[5], "currentLowLim" + branch[0], "currentLowLim" + branch[1], "currentLowLim" + branch[2], "currentLowLim" + branch[3], "currentLowLim" + branch[4], "currentLowLim" + branch[5], "currentHighLim" + branch[0], "currentHighLim" + branch[1], "currentHighLim" + branch[2], "currentHighLim" + branch[3], "currentHighLim" + branch[4], "currentHighLim" + branch[5], "dlAttenuation_ATMA", "dlAttenuation_ATMA2", "dlAttenuation_ATMA3", "dlTrafficDelay", "dlTrafficDelay2", "dlTrafficDelay3", "ulTrafficDelay", "ulTrafficDelay2", "ulTrafficDelay3"};
    private static final String[] modelPseudosFeeder = new String[]{"dlFeederAttenuationBranch" + branch[0], "dlFeederAttenuationBranch" + branch[1], "dlFeederAttenuationBranch" + branch[2], "dlFeederAttenuationBranch" + branch[3], "dlFeederAttenuationBranch" + branch[4], "dlFeederAttenuationBranch" + branch[5], "ulFeederAttenuationBranch" + branch[0], "ulFeederAttenuationBranch" + branch[1], "ulFeederAttenuationBranch" + branch[2], "ulFeederAttenuationBranch" + branch[3], "ulFeederAttenuationBranch" + branch[4], "ulFeederAttenuationBranch" + branch[5], "dlFeederDelayBranch" + branch[0], "dlFeederDelayBranch" + branch[1], "dlFeederDelayBranch" + branch[2], "dlFeederDelayBranch" + branch[3], "dlFeederDelayBranch" + branch[4], "dlFeederDelayBranch" + branch[5], "ulFeederDelayBranch" + branch[0], "ulFeederDelayBranch" + branch[1], "ulFeederDelayBranch" + branch[2], "ulFeederDelayBranch" + branch[3], "ulFeederDelayBranch" + branch[4], "ulFeederDelayBranch" + branch[5], "riuInstalled", "riuInstalled2", "riuInstalled3"};
    private static final String[] MANDATORY_ATTRIBUTES_FOR_MODIFY = new String[]{"dlAttenuation", "ulAttenuation", "dlDelay", "ulDelay"};
    private static final String[] FEEDER_ATTRIBUTES_FOR_AIR = new String[]{"dlFeederAttenuationBranch", "ulFeederAttenuationBranch", "dlFeederDelayBranch", "ulFeederDelayBranch"};
    private static final String[] RADIO_DOT_PSEUDOS = new String[]{"longitude", "latitude", "altitude", "geoDatum"};

    public AbstractAntennaSystemCI(Rbs rbs, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this(rbs, bl, bl2, bl3, bl4, 1);
    }

    public AbstractAntennaSystemCI(Rbs rbs, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n) {
        super(rbs);
        this.maxNoOfSectors = rbs.isPantherHybridRbs() ? rbs.getMaxNumberOfSectors() / 2 : rbs.getMaxNumberOfSectors();
        this.startingSectorNumber = n;
        this.maxSequenceNumber = rbs.getMaxNumberOfSequences();
        this.sectorAntenna = new SectorAntennaRI[this.maxNoOfSectors][3];
        this.sectors = new SectorRI[this.maxNoOfSectors];
        this.externalAntenna = new ExternalAntennaRI[this.maxNoOfSectors][3][this.maxSequenceNumber];
        this.canHaveTma = bl;
        this.canHaveRet = bl2;
        this.initCustomerParams();
        this.uninitiateAntennaBranchVector = new Vector[this.maxNoOfSectors][branch.length];
        this.initiateAntennaBranchVector = new Vector[this.maxNoOfSectors][branch.length];
        this.uninitiateAntFeederCableVector = new Vector[this.maxNoOfSectors][branch.length];
        this.initiateAntFeederCableVector = new Vector[this.maxNoOfSectors][branch.length];
        this.antennaBranchAttr = new Vector[this.maxNoOfSectors][branch.length];
        this.antFeederCableAttr = new Vector[this.maxNoOfSectors][branch.length];
        this.initiateVectorArrays();
        this.retCic = this.getRetCIComponent(this, bl2);
    }

    protected RetCIComponent getRetCIComponent(AbstractAntennaSystemCI abstractAntennaSystemCI, boolean bl) {
        return new RetCIComponent(abstractAntennaSystemCI, bl, this.startingSectorNumber);
    }

    private void initCustomerParams() {
        this.tmaParam = new Enumeration[this.maxNoOfSectors][3];
        this.dlAttParam = new IntegerParameter[this.maxNoOfSectors][3];
        this.ulGainParam = new IntegerParameter[this.maxNoOfSectors][3];
        this.modifyTmfFileParam = new TrueFalseCustomerParameter[this.maxNoOfSectors];
        this.dlDelayParam = new IntegerParameter[this.maxNoOfSectors][3][2];
        this.ulDelayParam = new IntegerParameter[this.maxNoOfSectors][3][2];
        this.internalPowerParam = new YesNoCustomerParameter[this.maxNoOfSectors][3];
        this.dcVoltageParam = new Enumeration[this.maxNoOfSectors][3];
        this.tmaDegradedSupported = new YesNoCustomerParameter[this.maxNoOfSectors][3];
        this.riuInstalled = new YesNoCustomerParameter[this.maxNoOfSectors][3];
        this.lowCurrentSupervision = new BooleanCustomerParameter[this.maxNoOfSectors][branch.length];
        this.currentLowLim = new IntegerParameter[this.maxNoOfSectors][3][2];
        this.currentHighLim = new IntegerParameter[this.maxNoOfSectors][3][2];
        this.tmaRestriction = new ParameterRestriction[this.maxNoOfSectors][3];
        this.tmaAndAtmaRestriction = new ParameterRestriction[this.maxNoOfSectors][3];
        this.riuInstalledRestriction = new ParameterRestriction[this.maxNoOfSectors][3];
        this.sectorOutputPower = new IntegerParameter[this.maxNoOfSectors];
        this.sectorOutputPowerLow = new IntegerParameter[this.maxNoOfSectors];
        this.lockSectorOutputPowerLow = new BooleanCustomerParameter[this.maxNoOfSectors];
        this.atmaRestriction = new ParameterRestriction[this.maxNoOfSectors][3];
        this.tmaDegradedSupportedRestriction = new ParameterRestriction[this.maxNoOfSectors][3];
        this.tmaDegradedSupportedActivationRestriction = new ParameterRestriction[this.maxNoOfSectors][3];
        this.internalPowerSupportedRestriction = new ParameterRestriction[this.maxNoOfSectors][3];
        this.dcVoltageRestriction = new ParameterRestriction[this.maxNoOfSectors][3];
        this.sectorOutputPowerRestriction = new ParameterRestriction[this.maxNoOfSectors];
        this.sectorOutputPowerLowRestriction = new ParameterRestriction[this.maxNoOfSectors];
        this.lockSectorOutputPowerLowRestriction = new ParameterRestriction[this.maxNoOfSectors];
        this.sectorUsedRestriction = new ParameterRestriction[this.maxNoOfSectors];
        this.sectorNotEquippedRestriction = new ParameterRestriction[this.maxNoOfSectors];
        this.antennaTypeRestriction = new ParameterRestriction[this.maxNoOfSectors][3];
        this.meTiltRestriction = new ParameterRestriction[this.maxNoOfSectors][3];
        this.aretCascadedRestriction = new ParameterRestriction[this.maxNoOfSectors][3][this.maxSequenceNumber];
        this.requiredRestriction = new ParameterRestriction[this.maxNoOfSectors];
        this.sectorAntennaRestriction = new ParameterRestriction[this.maxNoOfSectors];
        this.fqBandHighEdgeRangeRestriction = new ParameterRestriction[this.maxNoOfSectors];
        this.fqBandLowEdgeRangeRestriction = new ParameterRestriction[this.maxNoOfSectors];
        this.tmaTypeRangeRestriction = new ParameterRestriction[this.maxNoOfSectors][3];
        this.dlAttATMAParam = new IntegerParameter[this.maxNoOfSectors][3];
        this.dlTrafficDelayParam = new IntegerParameter[this.maxNoOfSectors][3];
        this.ulTrafficDelayParam = new IntegerParameter[this.maxNoOfSectors][3];
        this.numberOfRxBranchesListeners = new NumberOfRxBranchesListener[this.maxNoOfSectors][8];
        for (int i = 0; i < this.maxNoOfSectors; ++i) {
            int n;
            int n2;
            this.sectorUsedRestriction[i] = new ParameterRestriction("Sector Not used", 1);
            this.sectorNotEquippedRestriction[i] = new ParameterRestriction("Sector Not equipped", 3);
            this.requiredRestriction[i] = new ParameterRestriction("Attribute are mandatory in xml file", 2);
            this.sectorAntennaRestriction[i] = new ParameterRestriction("SectorAntenna Not used", 1);
            IntegerRange integerRange = new IntegerRange(MimAntennaBranch.MIN_FQBANDHIGHEDGE, MimAntennaBranch.MAX_FQBANDHIGHEDGE);
            IntegerRange integerRange2 = new IntegerRange(MimAntennaBranch.MIN_FQBANDLOWEDGE, MimAntennaBranch.MAX_FQBANDLOWEDGE);
            this.fqBandHighEdgeRangeRestriction[i] = new ParameterRestriction("Out Of Range", integerRange, true);
            this.fqBandLowEdgeRangeRestriction[i] = new ParameterRestriction("Out Of Range", integerRange2, true);
            for (n2 = 0; n2 < 3; ++n2) {
                this.tmaRestriction[i][n2] = new ParameterRestriction("TMA does not exist", 1);
                this.tmaAndAtmaRestriction[i][n2] = new ParameterRestriction("TMA and ATMA is optional", 2);
                this.antennaTypeRestriction[i][n2] = new ParameterRestriction("Should not be used when ARET_CASCADE is in use", 3);
                this.meTiltRestriction[i][n2] = new ParameterRestriction("Should not be used when ARET_CASCADE is in use", 3);
                this.riuInstalledRestriction[i][n2] = new ParameterRestriction("RIU is restricted", 2);
                this.tmaDegradedSupportedRestriction[i][n2] = new ParameterRestriction("TMA degraded is not supported", 1);
                this.tmaDegradedSupportedActivationRestriction[i][n2] = new ParameterRestriction("TMA degraded is not supported", 1);
                this.atmaRestriction[i][n2] = new ParameterRestriction("ATMA does not exist", 1);
                this.internalPowerSupportedRestriction[i][n2] = new ParameterRestriction("Internal power is mandatory", new EnumeratedRange("YES"), true);
                this.dcVoltageRestriction[i][n2] = new ParameterRestriction("DC Voltage is restricted", 1);
                this.tmaTypeRangeRestriction[i][n2] = new ParameterRestriction("Range of TMA Type is restricted");
                for (n = 1; n <= this.maxSequenceNumber; ++n) {
                    this.aretCascadedRestriction[i][n2][n - 1] = new ParameterRestriction("Cascaded ARET does not exist", 1);
                }
            }
            for (n2 = 0; n2 < 8; ++n2) {
                n = SectorUtil.getSectorNumberFromSectorIndex(i, this.startingSectorNumber);
                this.numberOfRxBranchesListeners[i][n2] = new NumberOfRxBranchesListener(n, n2 + 1);
            }
            n2 = SectorUtil.getSectorNumberFromSectorIndex(i, this.startingSectorNumber);
            this.sectorOutputPowerRestriction[i] = new ParameterRestriction("Sector" + n2 + ": sectorOutputPower cannot be change when loaded value of lockSectorOutputPowerLow is true!", 2);
            this.sectorOutputPowerLowRestriction[i] = new ParameterRestriction("Sector" + n2 + ": sectorOutputPowerLow cannot be change when loaded value of lockSectorOutputPowerLow is true!", 2);
            this.lockSectorOutputPowerLowRestriction[i] = new ParameterRestriction("Sector" + n2 + ": lockSectorOutputPowerLow cannot be change when loaded value of lockSectorOutputPowerLow is true!", 2);
        }
        this.antennaSupParam = new IntegerParameter[this.maxNoOfSectors][branch.length];
        this.antennaTypeParam = new IntegerParameter[this.maxNoOfSectors][3];
        this.antennaTypeCascadedParam = new IntegerParameter[this.maxNoOfSectors][3][this.maxSequenceNumber];
        this.modificationTypeCascadedParam = new Enumeration[this.maxNoOfSectors][3][this.maxSequenceNumber];
        this.meTiltParam = new IntegerParameter[this.maxNoOfSectors][3];
        this.meTiltCascadedParam = new IntegerParameter[this.maxNoOfSectors][3][this.maxSequenceNumber];
        this.userlabelParam = new StringParameter[this.maxNoOfSectors][3];
        this.userlabelCascadedParam = new StringParameter[this.maxNoOfSectors][3][this.maxSequenceNumber];
        this.bandParam = new Enumeration[this.maxNoOfSectors];
        this.fqHiEdgeParam = new IntegerParameter[this.maxNoOfSectors][branch.length];
        this.fqLoEdgeParam = new IntegerParameter[this.maxNoOfSectors][branch.length];
        this.dlFeederAttParam = new ListParameter[this.maxNoOfSectors][branch.length];
        this.ulFeederAttParam = new ListParameter[this.maxNoOfSectors][branch.length];
        this.dlFeederDelayParam = new ListParameter[this.maxNoOfSectors][branch.length];
        this.ulFeederDelayParam = new ListParameter[this.maxNoOfSectors][branch.length];
    }

    private void initiateVectorArrays() {
        for (int i = 0; i < this.maxNoOfSectors; ++i) {
            for (int j = 0; j < branch.length; ++j) {
                this.uninitiateAntennaBranchVector[i][j] = new Vector();
                this.initiateAntennaBranchVector[i][j] = new Vector();
                this.uninitiateAntFeederCableVector[i][j] = new Vector();
                this.initiateAntFeederCableVector[i][j] = new Vector();
                this.antennaBranchAttr[i][j] = new Vector();
                this.antFeederCableAttr[i][j] = new Vector();
            }
        }
    }

    public boolean openProvider() throws BemException {
        if (this.isProviderOpen) {
            return true;
        }
        this.radioEP = this.rbs.getRadioEquipmentProvider(this.getDuwSlotNumbers());
        this.sectorRdns = this.getSectorRdns();
        this.isProviderOpen = true;
        return true;
    }

    public boolean open() throws BemException {
        int n;
        if (this.isOpen) {
            return true;
        }
        this.cellCarrP = this.rbs.getCellAndCarrierProvider(this.getDuwSlotNumbers());
        if (!this.isProviderOpen) {
            this.openProvider();
        }
        this.initialiseMoiResources();
        this.createCustomerParameters();
        int[] nArray = this.radioEP.getEquippedSectors();
        for (n = 0; n < nArray.length; ++n) {
            this.createSectorRI(nArray[n]);
            this.createSectorAntennaRI(nArray[n], false);
            this.createExternalAntennaRI(nArray[n]);
            this.createAntennaBranchRI(nArray[n], false);
            if (this.canHaveTma) {
                this.createTmaRI(nArray[n]);
                this.createAscRI(nArray[n]);
                this.createAtmauRI(nArray[n]);
                this.createTmfRI(nArray[n]);
            }
            if (this.canHaveRet) {
                this.retCic.createRetRI(nArray[n]);
            }
            if (this.canHaveRadioDot(nArray[n])) {
                this.createRadioDotRI(nArray[n]);
                this.createRdiCableRI(nArray[n]);
            }
            this.loadRadioPositionInfo(nArray[n]);
        }
        if (this.startingSectorNumber == 1) {
            this.retCic.createRetProfileRI();
        }
        this.createSiteDataRI();
        for (n = 0; n < nArray.length; ++n) {
            int n2 = SectorUtil.getSectorIndexFromSectorNumber(nArray[n], this.startingSectorNumber);
            if (this.cellCarrP.isSectorInUse(nArray[n])) {
                this.sectorUsedRestriction[n2].setAccessLevel(3);
                continue;
            }
            this.sectorUsedRestriction[n2].setAccessLevel(1);
        }
        this.radioEP.addListener(new SectorChangedListener());
        this.updateRiuRestrictions();
        this.isOpen = true;
        return true;
    }

    protected void setAntennaTypeRestriction(int n, int n2, int n3) {
        this.antennaTypeRestriction[n][n2].setAccessLevel(n3);
    }

    protected void setMechanicalTiltRestriction(int n, int n2, int n3) {
        this.meTiltRestriction[n][n2].setAccessLevel(n3);
    }

    public boolean open(ServiceValue serviceValue) throws BemException {
        this.open();
        this.checkConsistency();
        return true;
    }

    public ArrayList getNeededRIs() throws BemException {
        AbstractResourceItem abstractResourceItem;
        ArrayList<AbstractResourceItem> arrayList = new ArrayList<AbstractResourceItem>();
        this.updateSectorAntennaParameters();
        if (!this.isOpen) {
            throw new BemException("AntennaSystemCI is not open.");
        }
        this.addExternalAntennas();
        int[] nArray = this.radioEP.getEquippedSectors();
        for (int i = 0; i < nArray.length; ++i) {
            int n;
            int n2;
            int n3;
            int n4 = SectorUtil.getSectorIndexFromSectorNumber(nArray[i], this.startingSectorNumber);
            abstractResourceItem = this.sectors[n4];
            arrayList.add(abstractResourceItem);
            int n5 = this.getNumOfSectorAntennas(nArray[i]);
            if (this.cellCarrP.isSectorInUse(nArray[i])) {
                for (n3 = 0; n3 < n5; ++n3) {
                    abstractResourceItem = this.sectorAntenna[n4][n3];
                    arrayList.add(abstractResourceItem);
                }
                n3 = this.getNumOfSupportedAntennaBranches(nArray[i]);
                for (n2 = 0; n2 < n3; ++n2) {
                    abstractResourceItem = this.antennaBranch[n4][n2];
                    arrayList.add(abstractResourceItem);
                }
                for (n2 = 0; n2 < n5; ++n2) {
                    for (n = 2; n <= this.maxSequenceNumber; ++n) {
                        if (this.checkExternalAntennaValidation(nArray[i], n, n2) == 1 || !this.retCic.typeOfRetParam[n4][n2].getValue().equals("ARETU_CASCADE")) continue;
                        abstractResourceItem = this.externalAntenna[n4][n2][n - 2];
                        arrayList.add(abstractResourceItem);
                    }
                }
            }
            n3 = this.getNumberOfBranchesPerSectorAntenna(nArray[i], false);
            for (n2 = 0; n2 < n5; ++n2) {
                for (n = 0; n < n3; ++n) {
                    if (this.getNumOfSupportedAntennaBranches(nArray[i]) <= n2 * n3 + n) continue;
                    Iterator iterator = this.initiateAntennaBranchVector[n4][n2 * n3 + n].iterator();
                    while (iterator.hasNext()) {
                        iterator.next();
                        if (arrayList.contains(this.antennaBranch[n4][n2 * n3 + n])) continue;
                        arrayList.add(this.antennaBranch[n4][n2 * n3 + n]);
                    }
                }
            }
        }
        abstractResourceItem = this.siteData;
        arrayList.add(abstractResourceItem);
        arrayList.addAll(this.getRIsToInstall());
        arrayList.addAll(this.retCic.getRIsToInstall());
        return arrayList;
    }

    public List getRIsToUninstall() throws BemException {
        int n;
        int n2;
        AbstractResourceItem abstractResourceItem;
        int n3;
        int n4;
        int n5;
        ArrayList<AbstractResourceItem> arrayList = new ArrayList<AbstractResourceItem>();
        boolean bl = false;
        if (!this.isOpen) {
            throw new BemException("AntennaSystemCI is not open.");
        }
        arrayList.addAll(this.getDeleteAndChangeExternalAntennasRIs());
        for (n5 = 0; n5 < this.maxNoOfSectors; ++n5) {
            int n6;
            n4 = SectorUtil.getSectorNumberFromSectorIndex(n5, this.startingSectorNumber);
            if (this.sectorExist(n4) && !this.sectorEquipped(n4)) {
                int n7;
                n6 = this.getLoadedNumOfSectorAntennas(n4);
                for (n3 = 0; n3 < n6; ++n3) {
                    if (this.sectorAntenna[n5][n3] == null) continue;
                    abstractResourceItem = this.sectorAntenna[n5][n3];
                    arrayList.add(abstractResourceItem);
                    n7 = this.getLoadedNumOfSupportedAntennaBranches(n4);
                    n2 = this.getNumberOfBranchesPerSectorAntenna(n4, true);
                    for (n = 0; n < n2; ++n) {
                        if (n7 <= n3 * n2 + n) continue;
                        arrayList.add(this.antennaBranch[n5][n3 * n2 + n]);
                    }
                }
                if (this.canHaveTma) {
                    for (n3 = 0; n3 < this.sectorAntenna[n5].length; ++n3) {
                        if (this.sectorAntenna[n5][n3] == null || this.tmaParam[n5][n3] == null) continue;
                        String string = this.tmaParam[n5][n3].getLoadedValue();
                        if (string.equals(TMA_STRING)) {
                            abstractResourceItem = this.tma[n5][n3];
                            arrayList.add(abstractResourceItem);
                            continue;
                        }
                        if (string.equals(ASC_STRING)) {
                            abstractResourceItem = this.asc[n5][n3];
                            arrayList.add(abstractResourceItem);
                            continue;
                        }
                        if (string.equals(ATMA_STRING)) {
                            abstractResourceItem = this.atmau[n5][n3];
                            arrayList.add(abstractResourceItem);
                            continue;
                        }
                        if (string.equals(ATMA_AND_TMA_STRING)) {
                            abstractResourceItem = this.tma[n5][n3];
                            arrayList.add(abstractResourceItem);
                            abstractResourceItem = this.atmau[n5][n3];
                            arrayList.add(abstractResourceItem);
                            continue;
                        }
                        if (!string.equals(TMF_STRING)) continue;
                        abstractResourceItem = this.tmf[n5][n3];
                        arrayList.add(abstractResourceItem);
                    }
                }
                if (this.retCic.typeOfRetParam == null) continue;
                for (n3 = 0; n3 < this.sectorAntenna[n5].length; ++n3) {
                    if (!"ARETU_CASCADE".equalsIgnoreCase(this.retCic.typeOfRetParam[n5][n3].getValue()) || !this.cascadedAretActions.isEmpty()) continue;
                    for (n7 = 0; n7 < this.maxSequenceNumber; ++n7) {
                        if (null == this.externalAntenna[n5][n3][n7]) continue;
                        arrayList.add(this.externalAntenna[n5][n3][n7]);
                    }
                }
                continue;
            }
            if (!this.sectorExist(n4) || !this.sectorEquipped(n4)) continue;
            n6 = this.getLoadedNumOfSectorAntennas(n4);
            for (n3 = 0; n3 < n6; ++n3) {
                if (this.sectorAntenna[n5][n3] == null || this.tmaParam[n5][n3] == null) continue;
                String string = this.tmaParam[n5][n3].getValue();
                String string2 = this.tmaParam[n5][n3].getLoadedValue();
                if (string2.equals(TMA_STRING) && !string.equals(TMA_STRING) && !string.equals(ATMA_AND_TMA_STRING)) {
                    abstractResourceItem = this.tma[n5][n3];
                    arrayList.add(abstractResourceItem);
                } else if (string2.equals(ASC_STRING) && !string.equals(ASC_STRING)) {
                    abstractResourceItem = this.asc[n5][n3];
                    arrayList.add(abstractResourceItem);
                } else if (string2.equals(ATMA_STRING) && !string.equals(ATMA_STRING) && !string.equals(ATMA_AND_TMA_STRING)) {
                    abstractResourceItem = this.atmau[n5][n3];
                    arrayList.add(abstractResourceItem);
                } else if (string2.equals(TMF_STRING) && !string.equals(TMF_STRING)) {
                    abstractResourceItem = this.tmf[n5][n3];
                    arrayList.add(abstractResourceItem);
                } else if (string2.equals(ATMA_AND_TMA_STRING)) {
                    if (!string.equals(TMA_STRING)) {
                        abstractResourceItem = this.tma[n5][n3];
                        arrayList.add(abstractResourceItem);
                    }
                    if (!string.equals(ATMA_STRING)) {
                        abstractResourceItem = this.atmau[n5][n3];
                        arrayList.add(abstractResourceItem);
                    }
                }
                if (string2.equals(string)) continue;
                bl = true;
            }
            if (this.existingRadioDot(n4)) {
                for (n3 = 0; n3 < MAX_NO_OF_RADIO_DOT_PER_SECTOR; ++n3) {
                    CustomerParameter customerParameter;
                    String string;
                    if (!this.rbs.isModifyWiz() || !this.isParameterSupported((string = PrefixUtil.getRadioDotPrefix(n4, n3 + 1)) + "DeleteRadioDot") || !(customerParameter = this.rbs.getCustomerParameterObject(string + "DeleteRadioDot")).getValue().equals("YES")) continue;
                    abstractResourceItem = this.radioDot[n5][n3];
                    arrayList.add(abstractResourceItem);
                    abstractResourceItem = this.rdiCable[n5][n3];
                    arrayList.add(abstractResourceItem);
                }
            }
            if (!bl && !this.unInitSectorsExternalAntenna[n5]) continue;
            this.cellCarrP.requestUninitiateSector(n4, this);
            this.cellCarrP.requestInitiateSector(n4, this);
            bl = false;
        }
        arrayList.addAll(this.getUninstallRIs());
        for (n5 = 0; n5 < this.maxNoOfSectors; ++n5) {
            n4 = SectorUtil.getSectorNumberFromSectorIndex(n5, this.startingSectorNumber);
            CustomerParameterImpl[] customerParameterImplArray = (CustomerParameterImpl[])this.cellCarrP.getNumOfRxBranchesPerCarrierParameter(n4);
            for (n3 = 0; n3 < customerParameterImplArray.length; ++n3) {
                int n8;
                int n9;
                CustomerParameterImpl cfr_ignored_0 = customerParameterImplArray[n3];
                if (customerParameterImplArray[n3].getLoadedValue().equals("##UNDEFINED")) continue;
                int n10 = Integer.parseInt(customerParameterImplArray[n3].getLoadedValue());
                n2 = Integer.parseInt(customerParameterImplArray[n3].getValue());
                n = this.getNumberOfBranchesPerSectorAntenna(n4, true);
                int n11 = this.getNumberOfBranchesPerSectorAntenna(n4, false);
                if (n10 <= n2) continue;
                for (n9 = n2 / n11; n9 < n10 / n; ++n9) {
                    if (this.sectorAntenna[n5][n9] == null) continue;
                    abstractResourceItem = this.sectorAntenna[n5][n9];
                    if (abstractResourceItem != null && !arrayList.contains(abstractResourceItem)) {
                        arrayList.add(abstractResourceItem);
                    }
                    for (n8 = 0; n8 < n11; ++n8) {
                        if (this.antennaBranch[n5][n9 * n11 + n8] == null || arrayList.contains(this.antennaBranch[n5][n9 * n11 + n8])) continue;
                        arrayList.add(this.antennaBranch[n5][n9 * n11 + n8]);
                    }
                    if (this.tmaParam[n5][n9] == null) continue;
                    String string = this.tmaParam[n5][n9].getLoadedValue();
                    if (string.equals(TMA_STRING)) {
                        abstractResourceItem = this.tma[n5][n9];
                        arrayList.add(abstractResourceItem);
                        continue;
                    }
                    if (string.equals(ASC_STRING)) {
                        abstractResourceItem = this.asc[n5][n9];
                        arrayList.add(abstractResourceItem);
                        continue;
                    }
                    if (string.equals(ATMA_STRING)) {
                        abstractResourceItem = this.atmau[n5][n9];
                        arrayList.add(abstractResourceItem);
                        continue;
                    }
                    if (string.equals(ATMA_AND_TMA_STRING)) {
                        abstractResourceItem = this.tma[n5][n9];
                        arrayList.add(abstractResourceItem);
                        abstractResourceItem = this.atmau[n5][n9];
                        arrayList.add(abstractResourceItem);
                        continue;
                    }
                    if (!string.equals(TMF_STRING)) continue;
                    abstractResourceItem = this.tmf[n5][n9];
                    arrayList.add(abstractResourceItem);
                }
                if (n <= n11) continue;
                for (n9 = n11; n9 < n; ++n9) {
                    if (this.antennaBranch[n5][n9] == null || arrayList.contains(this.antennaBranch[n5][n9])) continue;
                    arrayList.add(this.antennaBranch[n5][n9]);
                }
                for (n9 = 1; n9 < n2 / n11; ++n9) {
                    for (n8 = 0; n8 < n11; ++n8) {
                        if (this.antennaBranch[n5][n9 * n11 + n8] == null || arrayList.contains(this.antennaBranch[n5][n9 * n11 + n8])) continue;
                        arrayList.add(this.antennaBranch[n5][n9 * n11 + n8]);
                    }
                }
            }
        }
        return arrayList;
    }

    public boolean sectorExist(int n) throws BemException {
        boolean bl = false;
        int n2 = SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber);
        if (this.sectors[n2] != null && this.sectors[n2].isInstalled()) {
            if (this.radioEP instanceof RadioEquipmentProviderWithRbb) {
                BemMo bemMo = this.rbs.getMoHandler().getMo(this.sectorMois[n2].getLdn());
                Integer n3 = (Integer)bemMo.getAttribute("radioBuildingBlock");
                int n4 = n3;
                if (n4 != 0) {
                    bl = true;
                }
            } else {
                bl = true;
            }
        }
        return bl;
    }

    public boolean sectorEquipped(int n) {
        boolean bl = false;
        int[] nArray = this.radioEP.getEquippedSectors();
        for (int i = 0; i < nArray.length; ++i) {
            if (n != nArray[i]) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public String getName() {
        return name;
    }

    protected void setCustomerParametersFromSV(String[] stringArray, ServiceValue serviceValue) throws BemException {
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            String string2 = serviceValue.getValue(string);
            if (string2 == null) continue;
            this.setCustomerParameter(string, string2);
        }
    }

    public void setCustomerParameters(ServiceValue serviceValue) throws OutOfRangeException, CustomerParameterException, BemException {
        int n;
        String[] stringArray = this.getModelPseudos();
        int[] nArray = this.radioEP.getEquippedSectors();
        String[] stringArray2 = new String[pseudos.length + 3 * this.maxSequenceNumber * retCascadedpseudos.length + MAX_NO_OF_RADIO_DOT_PER_SECTOR * RADIO_DOT_PSEUDOS.length];
        for (int i = 0; i < nArray.length; ++i) {
            int n2;
            String string = AbstractAntennaSystemCI.getSectorPrefix(nArray[i]);
            for (n2 = 0; n2 < pseudos.length; ++n2) {
                stringArray2[n2] = string + pseudos[n2];
            }
            n2 = pseudos.length;
            for (n = 1; n <= 3; ++n) {
                for (int j = 1; j <= this.maxSequenceNumber; ++j) {
                    String string2 = string + AbstractAntennaSystemCI.getSequencePrefix(j);
                    for (int k = 0; k < retCascadedpseudos.length; ++k) {
                        stringArray2[n2] = string2 + retCascadedpseudos[k] + (n > 1 ? String.valueOf(n) : "");
                        ++n2;
                    }
                }
            }
            for (n = 1; n <= MAX_NO_OF_RADIO_DOT_PER_SECTOR; ++n) {
                String string3 = PrefixUtil.getRadioDotPrefix(nArray[i], n);
                for (int j = 0; j < RADIO_DOT_PSEUDOS.length; ++j) {
                    stringArray2[n2] = string3 + RADIO_DOT_PSEUDOS[j];
                    ++n2;
                }
            }
            this.setCustomerParametersFromSV(stringArray2, serviceValue);
        }
        this.setCascadedAretCustomerParameter(serviceValue);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < nArray.length; ++i) {
            String string = AbstractAntennaSystemCI.getSectorPrefix(nArray[i]);
            for (n = 0; n < stringArray.length; ++n) {
                arrayList.add(string + stringArray[n]);
            }
        }
        stringArray2 = arrayList.toArray(new String[0]);
        if (this.rbs.isModifyWiz()) {
            String[] stringArray3 = serviceValue.getPseudoNames();
            for (int i = 0; i < stringArray3.length; ++i) {
                String string = stringArray3[i];
                if (string.endsWith("tmaType")) {
                    int n3 = Integer.parseInt(string.substring(1, string.indexOf("_tmaType")));
                    int n4 = this.getNumOfSectorAntennas(n3);
                    if (n4 <= 1) continue;
                    for (int j = 1; j < n4; ++j) {
                        if (this.getNumOfRxBranchesOnAntenna(n3, j) <= 0) continue;
                        super.setCustomerParameter(string + (j + 1), serviceValue.getValue(string));
                    }
                    continue;
                }
                if (!string.endsWith("DeleteRadioDot") && !string.endsWith("AddRadioDot")) continue;
                ParameterRestriction parameterRestriction = new ParameterRestriction("", 2);
                String string4 = string;
                YesNoCustomerParameter yesNoCustomerParameter = new YesNoCustomerParameter(string4);
                yesNoCustomerParameter.addRestriction(parameterRestriction);
                this.addParameter(yesNoCustomerParameter);
                super.setCustomerParameter(string4, yesNoCustomerParameter.getTrueValue());
            }
        }
        this.setCustomerParametersFromSV(stringArray2, serviceValue);
        stringArray2 = new String[]{"siteName", "logicalName", "lmtPorts", "altitude", "latitude", "longitude", "tolerance"};
        this.setCustomerParametersFromSV(stringArray2, serviceValue);
        if (this.retCic != null) {
            this.retCic.importRetProfiles(serviceValue);
        }
        this.setPositionCustomerParameters(serviceValue);
        this.updateCustomerParametersRestrictionAccordingToNumberOfRxBranch();
        this.validateServiceValueInput(serviceValue, nArray);
        this.checkConsistency(arrayList);
    }

    private void validateServiceValueInput(ServiceValue serviceValue, int[] nArray) throws BemException {
        this.validateServiceValueInputModifyAddAntennaEquipment(serviceValue, nArray);
        this.validateServiceValueInputForAIR(serviceValue, nArray);
        this.validateServiceValueInputForPosition(serviceValue, nArray);
    }

    private void validateServiceValueInputModifyAddAntennaEquipment(ServiceValue serviceValue, int[] nArray) throws BemException {
        if (this.rbs.getRbsStep().equals("STEP_EXPANSION")) {
            for (int i = 0; i < nArray.length; ++i) {
                String string = AbstractAntennaSystemCI.getSectorPrefix(nArray[i]);
                for (int j = 0; j < branch.length; ++j) {
                    String string2;
                    String string3 = string + branch[j];
                    String string4 = string3 + "_" + "branch";
                    ServiceNameValue serviceNameValue = serviceValue.getAttribute(string4);
                    if (serviceNameValue == null || AIRUtil.getInstance(this.rbs).isAirConfigured(nArray[i]) || !(string2 = serviceNameValue.getServiceName()).equalsIgnoreCase("AddSector")) continue;
                    for (int k = 0; k < MANDATORY_ATTRIBUTES_FOR_MODIFY.length; ++k) {
                        if (this.isAttributeGiven(serviceValue, string3, MANDATORY_ATTRIBUTES_FOR_MODIFY[k])) continue;
                        throw new BemException("Mandatory attribute " + MANDATORY_ATTRIBUTES_FOR_MODIFY[k] + " is not entered for sector number " + nArray[i] + " and branch " + branch[j] + ".");
                    }
                }
            }
        }
    }

    private boolean isAttributeGiven(ServiceValue serviceValue, String string, String string2) {
        boolean bl = false;
        String string3 = string + "_" + string2;
        ServiceNameValue serviceNameValue = serviceValue.getAttribute(string3);
        if (serviceNameValue != null) {
            bl = true;
        }
        return bl;
    }

    private void validateServiceValueInputForAIR(ServiceValue serviceValue, int[] nArray) throws BemException {
        if (this.rbs.getRbsStep().equals("STEP_EXPANSION") || this.rbs.getRbsStep().equals("STEP_SITE")) {
            for (int i = 0; i < nArray.length; ++i) {
                int n = nArray[i];
                String string = AbstractAntennaSystemCI.getSectorPrefix(n);
                if (!AIRUtil.getInstance(this.rbs).isAirConfigured(n)) continue;
                for (int j = 0; j < this.sectorAntenna[n - 1].length; ++j) {
                    if (this.sectorAntenna[n - 1][j] != null && this.tmaParam[n - 1][j] != null && !this.tmaParam[n - 1][j].getValue().equals(NONE_STRING)) {
                        throw new BemException("Can not configure TMA for AIR in sector " + n);
                    }
                    if (this.sectorAntenna[n - 1][j] == null || this.antennaTypeParam[n - 1][j] == null || this.antennaTypeParam[n - 1][j].getValue().equals(MimSectorAntenna.MIN_ANTENNATYPE.toString())) continue;
                    throw new BemException("AntennaType should be " + MimSectorAntenna.MIN_ANTENNATYPE.toString() + " for AIR in sector " + n);
                }
                String string2 = string + "radioBuildingBlock";
                CustomerParameterServer customerParameterServer = this.rbs.getCustomerParameterServerObject(string2);
                String string3 = (String)customerParameterServer.getValueMom();
                string2 = string + "band";
                customerParameterServer = this.rbs.getCustomerParameterServerObject(string2);
                String string4 = (String)customerParameterServer.getValueMom();
                for (int j = 0; j < ServiceCommon.BRANCH_NAMES.length; ++j) {
                    if (AIRUtil.getInstance(this.rbs).isRbb111AWithAir(n) && (!AIRUtil.getInstance(this.rbs).isRbb111AWithAir(n) || j != 0)) continue;
                    for (int k = 0; k < FEEDER_ATTRIBUTES_FOR_AIR.length; ++k) {
                        string2 = string + FEEDER_ATTRIBUTES_FOR_AIR[k] + ServiceCommon.BRANCH_NAMES[j];
                        if (!this.rbs.isParameterSupported(string2)) continue;
                        customerParameterServer = this.rbs.getCustomerParameterServerObject(string2);
                        if (((CustomerParameterImpl)customerParameterServer).isValidValue()) {
                            int[] nArray2 = AntennaFeederConversion.freqBandConverter(string4, (int[])customerParameterServer.getValueMom());
                            int[] nArray3 = AntennaFeederConversion.freqBandConverter(string4, (int[])new AntennaFeederConversion().convertToMomValue("0"));
                            if (!(nArray2 instanceof int[]) || !(nArray3 instanceof int[]) || Arrays.equals(nArray2, nArray3)) continue;
                            throw new BemException("Could not set attribute " + FEEDER_ATTRIBUTES_FOR_AIR[k] + ServiceCommon.BRANCH_NAMES[j] + " values except 0 in sector " + n + " with " + string3 + " for AIR");
                        }
                        throw new BemException("Value configured for attribute " + FEEDER_ATTRIBUTES_FOR_AIR[k] + ServiceCommon.BRANCH_NAMES[j] + " is not valid!");
                    }
                }
            }
        }
    }

    private void checkSectorNumber(int n, String string, int n2) throws BemException {
        if (!this.sectorEquipped(n)) {
            throw new BemException("Invalid sector number configured for " + string + " " + n2 + " of Sector " + n + " because Sector " + n + " does not exist.");
        }
    }

    private void checkUnitTypeAndUnitNumber(int n, String string, int n2) throws BemException {
        int n3 = this.getNumOfSectorAntennas(n);
        if ("RadioUnit".equals(string)) {
            AbstractRuRI[] abstractRuRIArray = this.radioEP.getSectorRadioUnits(n);
            if (n2 > abstractRuRIArray.length) {
                throw new BemException("Invalid radio number configured for RadioUnit " + n2 + " of Sector " + n + " because Sector " + n + " contains only " + abstractRuRIArray.length + " radio unit(s).");
            }
        } else if ("Antenna".equals(string)) {
            if (n2 > n3) {
                throw new BemException("Invalid antenna number configured for Antenna " + n2 + " of Sector " + n + " because Sector " + n + " contains only " + n3 + " antenna(s).");
            }
        } else {
            throw new BemException("Invalid unit type(" + string + ") for PositionConfiguration.");
        }
    }

    private void checkHwGroupExistence(int n, String string, int n2, String string2) throws BemException {
        if (string2.equals("")) {
            return;
        }
        PowerSupplyProvider powerSupplyProvider = (PowerSupplyProvider)this.rbs.getProvider(PowerSupplyProvider.class);
        int n3 = powerSupplyProvider.getNumberOfHwGroup();
        for (int i = 0; i < n3; ++i) {
            String string3 = PrefixUtil.getHwGroupPrefix(i) + "hwGroupId";
            CustomerParameter customerParameter = this.rbs.getCustomerParameterObject(string3);
            if (!customerParameter.getValue().equals(string2)) continue;
            return;
        }
        throw new BemException("Invalid hwGroupId configured for " + string + " " + n2 + " of Sector " + n + " because HwGroup " + string2 + " does not exist.");
    }

    private void checkConsistencyForPositionRef() throws BemException {
        if (!RbsUtil.isApcLightSupported(this.rbs)) {
            return;
        }
        int[] nArray = this.radioEP.getEquippedSectors();
        for (int i = 0; i < nArray.length; ++i) {
            AbstractRuRI[] abstractRuRIArray = this.radioEP.getSectorRadioUnits(nArray[i]);
            if (null == abstractRuRIArray || 0 == abstractRuRIArray.length) continue;
            block1: for (int j = 0; j < abstractRuRIArray.length; ++j) {
                BemMo bemMo;
                BemMo bemMo2;
                String string = abstractRuRIArray[j].getPosPrefix() + "hwGroupId";
                String string2 = this.rbs.getCustomerParameter(string);
                if (string2.equals("") || string2.equals("##UNDEFINED") || null == (bemMo2 = (bemMo = this.rbs.getMoHandler().getMo(abstractRuRIArray[j].getLdn())).getFirstAncestorOfType(MimSectorAntenna.MOTYPENAME))) continue;
                for (int k = 0; k < this.getNumOfSectorAntennas(nArray[i]); ++k) {
                    if (!this.sectorAntennaMois[i][k].getLdn().equals(bemMo2.getDN())) continue;
                    String string3 = PrefixUtil.getPosPrefix(nArray[i], "Antenna", k + 1);
                    string = string3 + "hwGroupId";
                    String string4 = this.rbs.getCustomerParameter(string);
                    if (string4.equals("") || string4.equals("##UNDEFINED") || string2.equals(string4)) continue block1;
                    throw new BemException("Invalid hwGroupId configured for RadioUnit " + (j + 1) + " of Sector " + nArray[i] + ", hwGroupId of RadioUnit " + (j + 1) + " must be the same as Antenna " + (k + 1) + ".");
                }
            }
        }
    }

    private void checkPositionConfigurationForRadioShared(int n, String string, int n2) throws BemException {
        if (!RbsUtil.isApcLightSupported(this.rbs)) {
            return;
        }
        if (!(this.radioEP instanceof RbbManager)) {
            return;
        }
        RbbManager rbbManager = (RbbManager)this.radioEP;
        String string2 = rbbManager.getRadioBuildingBlock(n).getRadioSharedBySector();
        if (!SectorUtil.isPositionConfigurationSupported(this.rbs, n)) {
            throw new BemException("RadioUnit " + n2 + " can be configured on Sector " + string2 + " only" + " because Sector " + n + " and Sector " + string2 + " share RadioUnit " + n2 + ".");
        }
    }

    private void validateServiceValueInputForPosition(ServiceValue serviceValue, int[] nArray) throws BemException {
        String string;
        ServiceNameValue serviceNameValue;
        Vector vector = serviceValue.getAllAttributes();
        int n = 0;
        for (n = 0; n < vector.size() && null != (serviceNameValue = serviceValue.getAttribute((string = MessageFormat.format("POS_CONFIG{0}_", String.valueOf(n + 1))) + "sectorNumber")); ++n) {
            int n2 = Integer.parseInt(serviceNameValue.getValueAsString());
            serviceNameValue = serviceValue.getAttribute(string + "unitType");
            String string2 = serviceNameValue.getValueAsString();
            serviceNameValue = serviceValue.getAttribute(string + "unitNumber");
            int n3 = Integer.parseInt(serviceNameValue.getValueAsString());
            serviceNameValue = serviceValue.getAttribute(string + "hwGroupId");
            String string3 = "";
            if (null != serviceNameValue && serviceNameValue.getValueAsString().length() > 0) {
                string3 = serviceNameValue.getValueAsString();
            }
            this.checkSectorNumber(n2, string2, n3);
            this.checkUnitTypeAndUnitNumber(n2, string2, n3);
            this.checkHwGroupExistence(n2, string2, n3, string3);
            if (!string2.equals("RadioUnit")) continue;
            this.checkPositionConfigurationForRadioShared(n2, string2, n3);
        }
    }

    public void setCascadedAretCustomerParameter(ServiceValue serviceValue) throws OutOfRangeException, CustomerParameterException, BemException {
        int[] nArray = this.radioEP.getEquippedSectors();
        for (int i = 0; i < nArray.length; ++i) {
            String string = AbstractAntennaSystemCI.getSectorPrefix(nArray[i]);
            for (int j = 1; j <= this.maxSequenceNumber; ++j) {
                String string2 = string + AbstractAntennaSystemCI.getSequencePrefix(j);
                for (int k = 0; k < modificationTypes.length; ++k) {
                    if (this.isRetCascadingSequenceNumberEmpty(serviceValue, string2, modificationTypes[k])) continue;
                    if (this.isAllUniqueHwIdEmptyForCurrentRetCascadingsequence(serviceValue, string2, modificationTypes[k])) {
                        String string3 = "UniqueHwId can't be empty!";
                        throw new BemException(string3);
                    }
                    for (int i2 = 1; i2 < 4; ++i2) {
                        if (!this.isRetCascadeforSANeedtobeChanged(serviceValue, string2, i2, modificationTypes[k])) continue;
                        for (int i3 = 0; i3 < retCascadedpseudos.length; ++i3) {
                            String string4 = string2 + retCascadedpseudos[i3] + (i2 > 1 ? String.valueOf(i2) : "");
                            String string5 = serviceValue.getValue(modificationTypes[k] + "_" + string4);
                            if (string5 == null) continue;
                            String string6 = string2 + "SA" + i2;
                            this.cascadedAretActions.setProperty(string6, modificationTypes[k]);
                            this.setCustomerParameter(string4, string5);
                            this.setCustomerParameter(string2 + "modificationType", modificationTypes[k]);
                        }
                    }
                }
            }
        }
    }

    private boolean isRetCascadeforSANeedtobeChanged(ServiceValue serviceValue, String string, int n, String string2) throws BemException {
        boolean bl = false;
        String string3 = string2 + "_" + string + "uniqueHwId" + (n > 1 ? String.valueOf(n) : "");
        if (serviceValue.getValue(string3) != null) {
            bl = true;
        }
        return bl;
    }

    private boolean isAllUniqueHwIdEmptyForCurrentRetCascadingsequence(ServiceValue serviceValue, String string, String string2) {
        boolean bl = false;
        String string3 = string2 + "_" + string + "uniqueHwId";
        String string4 = string2 + "_" + string + "uniqueHwId2";
        if (serviceValue.getValue(string3) == null && serviceValue.getValue(string4) == null) {
            bl = true;
        }
        return bl;
    }

    private boolean isRetCascadingSequenceNumberEmpty(ServiceValue serviceValue, String string, String string2) {
        String string3 = string2 + "_" + string + "sequenceNumber";
        boolean bl = true;
        if (serviceValue.getValue(string3) != null) {
            bl = false;
        }
        return bl;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public void checkConsistency() throws BemException {
        super.checkConsistency();
        int[] nArray = this.radioEP.getEquippedSectors();
        String string = null;
        for (int i = 0; i < nArray.length; ++i) {
            if (!this.checkConsistency(nArray[i])) {
                string = NOT_POSSIBLE_TO_CHANGE_SECTOR + nArray[i] + ". " + CELLS_OFFLINE;
                throw new BemException(string);
            }
            this.checkCascadedAretConsistency(nArray[i]);
        }
        this.retCic.checkUniqueHwIdConsistency();
        this.checkFqBandLowEdgeHighEdge();
        this.checkTmaTypeInSectors();
        this.checkOutputPowerInSectors();
        this.checkConsistencyForPositionRef();
    }

    public void checkConsistency(List list) throws CustomerParameterException, BemException {
        super.checkConsistency(list);
        this.retCic.checkConsistency(list);
        this.checkFqBandLowEdgeHighEdge(list);
        this.checkTmaTypeInSectors(list);
        this.checkDcVoltage(list);
        this.checkOutputPowerInSectors(list);
        int[] nArray = this.radioEP.getEquippedSectors();
        this.checkULFeederParams(nArray, list);
        this.checkConsistencyForPositionRef();
    }

    private void checkFqBandLowEdgeHighEdge() throws BemException {
        int[] nArray = this.radioEP.getEquippedSectors();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < nArray.length; ++i) {
            if (!this.cellCarrP.isSectorInUse(nArray[i])) continue;
            String string = AbstractAntennaSystemCI.getSectorPrefix(nArray[i]);
            int n = this.getNumOfSupportedAntennaBranches(nArray[i]);
            for (int j = 0; j < n; ++j) {
                String string2 = string + "fqBandLowEdgeBranch" + branch[j];
                arrayList.add(string2);
                String string3 = string + "fqBandHighEdgeBranch" + branch[j];
                arrayList.add(string3);
            }
        }
        if (arrayList.size() > 0) {
            super.checkConsistency(arrayList);
            this.checkFqBandLowEdgeHighEdge(arrayList);
        }
    }

    public void checkFqBandLowEdgeHighEdge(List list) throws BemException {
        CustomerParameterServer customerParameterServer = null;
        int[] nArray = this.radioEP.getEquippedSectors();
        for (int i = 0; i < nArray.length; ++i) {
            if (!this.cellCarrP.isSectorInUse(nArray[i])) continue;
            String string = AbstractAntennaSystemCI.getSectorPrefix(nArray[i]);
            for (int j = 0; j < branch.length; ++j) {
                int n;
                String string2 = string + "fqBandLowEdgeBranch" + branch[j];
                String string3 = string + "fqBandHighEdgeBranch" + branch[j];
                if (!list.contains(string2)) continue;
                customerParameterServer = this.rbs.getCustomerParameterServerObject(string2);
                Integer n2 = Integer.valueOf((String)customerParameterServer.getValueMom());
                customerParameterServer = this.rbs.getCustomerParameterServerObject(string3);
                Integer n3 = Integer.valueOf((String)customerParameterServer.getValueMom());
                if (n2 >= n3) {
                    throw new CustomerParameterException(FQBAND_HIGH_EDGE_CONSISTENT_ERROR, (CustomerParameter)((Object)customerParameterServer));
                }
                int n4 = this.getRangeIndex("LOW", n2);
                if (n4 == (n = this.getRangeIndex("HIGH", n3))) continue;
                throw new CustomerParameterException(FQBAND_HIGH_EDGE_WRONG_RANGE_CONSISTENT_ERROR, (CustomerParameter)((Object)customerParameterServer));
            }
        }
    }

    private void checkDcVoltage(List list) throws BemException {
        if (!this.canHaveTma) {
            return;
        }
        int[] nArray = this.radioEP.getEquippedSectors();
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            int n2 = SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber);
            if (!this.cellCarrP.isSectorInUse(nArray[i])) continue;
            for (int j = 0; j < this.getNumOfSectorAntennas(n); ++j) {
                String string;
                if (!list.contains(this.dcVoltageParam[n2][j].getName()) || !(string = this.tmaParam[n2][j].getValue()).equals(TMA_STRING) && !string.equals(ATMA_AND_TMA_STRING) || !list.contains(this.internalPowerParam[n2][j].getName()) || !this.internalPowerParam[n2][j].getBooleanValue() || !this.internalPowerParam[n2][j].getBooleanValue() || !this.dcVoltageParam[n2][j].getValue().equals("")) continue;
                throw new BemException("DC Voltage must be configured when internal power is used for sector antenna: " + n + "-" + (j + 1));
            }
        }
    }

    private void checkTmaTypeInSectors() throws BemException {
        int[] nArray = this.radioEP.getEquippedSectors();
        for (int i = 0; i < nArray.length; ++i) {
            if (!this.cellCarrP.isSectorInUse(nArray[i])) continue;
            int n = nArray[i];
            String string = AbstractAntennaSystemCI.getSectorPrefix(n);
            int n2 = this.getNumOfSectorAntennas(n);
            if (n2 <= 1) continue;
            for (int j = 0; j < this.getNumOfSectorAntennas(n) - 1; ++j) {
                int n3 = j + 1;
                int n4 = this.getNumOfRxBranchesOnAntenna(n, n3);
                boolean bl = n4 == 0;
                String string2 = j == 0 ? "" : String.valueOf(j + 1);
                String string3 = this.rbs.getCustomerParameterObject(string + "tmaType" + string2).getValue();
                String string4 = n3 == 0 ? "" : String.valueOf(n3 + 1);
                String string5 = this.rbs.getCustomerParameterObject(string + "tmaType" + string4).getValue();
                if ((!bl || string5.equals(NONE_STRING)) && (bl || string3.equals(string5))) continue;
                throw new BemException("Sector" + n + ":Value must be the same as tmaType parameter in SectorAntenna=1 or NONE if SectorAntenna have no RX-branch");
            }
        }
    }

    private void checkTmaTypeInSectors(List list) throws BemException {
        int[] nArray = this.radioEP.getEquippedSectors();
        for (int i = 0; i < nArray.length; ++i) {
            if (!this.cellCarrP.isSectorInUse(nArray[i])) continue;
            int n = nArray[i];
            String string = AbstractAntennaSystemCI.getSectorPrefix(n);
            int n2 = this.getNumOfSectorAntennas(n);
            if (n2 <= 1) continue;
            for (int j = 0; j < n2 - 1; ++j) {
                String string2 = j == 0 ? "" : String.valueOf(j + 1);
                String string3 = string + "tmaType" + string2;
                if (!list.contains(string3)) continue;
                String string4 = this.rbs.getCustomerParameterObject(string3).getValue();
                int n3 = j + 1;
                int n4 = this.getNumOfRxBranchesOnAntenna(n, n3);
                boolean bl = n4 == 0;
                String string5 = n3 == 0 ? "" : String.valueOf(n3 + 1);
                String string6 = this.rbs.getCustomerParameterObject(string + "tmaType" + string5).getValue();
                if ((!bl || string6.equals(NONE_STRING)) && (bl || string4.equals(string6))) continue;
                throw new BemException("Sector" + n + ":Value must be the same as tmaType parameter in SectorAntenna=1 or NONE if SectorAntenna have no RX-branch");
            }
        }
    }

    private void checkOutputPowerInSectors() throws BemException {
        int[] nArray = this.radioEP.getEquippedSectors();
        for (int i = 0; i < nArray.length; ++i) {
            if (!this.cellCarrP.isSectorInUse(nArray[i])) continue;
            int n = nArray[i];
            String string = AbstractAntennaSystemCI.getSectorPrefix(n);
            String string2 = string + "sectorOutputPower";
            String string3 = string + "sectorOutputPowerLow";
            String string4 = string + "lockSectorOutputPowerLow";
            int n2 = Integer.parseInt(this.rbs.getCustomerParameterObject(string2).getValue());
            int n3 = Integer.parseInt(this.rbs.getCustomerParameterObject(string3).getValue());
            boolean bl = Boolean.valueOf(this.rbs.getCustomerParameterObject(string4).getValue());
            if (n2 != -1 && n3 != -1) {
                throw new BemException("Sector" + n + ": sectorOutputPower and sectorOutputPowerLow could not be defined value at same time!");
            }
            if (n3 != -1 || !bl) continue;
            throw new BemException("Sector" + n + ": lockSectorOutputPowerLow cannot be set as true, when sectorOutputPowerLow has default value!");
        }
    }

    private void checkOutputPowerInSectors(List list) throws BemException {
        int[] nArray = this.radioEP.getEquippedSectors();
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            String string = AbstractAntennaSystemCI.getSectorPrefix(n);
            String string2 = string + "sectorOutputPower";
            String string3 = string + "sectorOutputPowerLow";
            String string4 = string + "lockSectorOutputPowerLow";
            if (!list.contains(string2) || !list.contains(string3)) continue;
            int n2 = Integer.parseInt(this.rbs.getCustomerParameterObject(string2).getValue());
            int n3 = Integer.parseInt(this.rbs.getCustomerParameterObject(string3).getValue());
            if (n2 != -1 && n3 != -1) {
                throw new BemException("Sector" + n + ": sectorOutputPower and sectorOutputPowerLow could not be defined value at same time!");
            }
            if (!list.contains(string4)) continue;
            boolean bl = Boolean.valueOf(this.rbs.getCustomerParameterObject(string4).getValue());
            if (n3 != -1 || !bl) continue;
            throw new BemException("Sector" + n + ": lockSectorOutputPowerLow cannot be set as true, when sectorOutputPowerLow has default value!");
        }
    }

    private int getNumOfRxBranchesOnAntenna(int n, int n2) {
        int n3 = 0;
        int[] nArray = this.radioEP.getNumberOfRxBranchesPerAntenna(n);
        if (n2 < nArray.length) {
            n3 = nArray[n2];
        }
        return n3;
    }

    private int getNumberOfBranchesPerSectorAntenna(int n, boolean bl) {
        int n2 = 2;
        if (bl && AIRUtil.getInstance(this.rbs).isNodeConfiguredWithAir(n) || !bl && AIRUtil.getInstance(this.rbs).isAirConfigured(n)) {
            n2 = AIRUtil.getInstance(this.rbs).getMaxNumOfBranchesPerSectorAntennaForAir(n, bl);
        }
        return n2;
    }

    private void checkCascadedAretConsistency(int n) throws BemException {
        int n2 = 0;
        int n3 = 1;
        for (int i = 0; i == 0 || i == 1 && SectorUtil.isRrus32WithRbb441d(this.rbs, n); ++i) {
            int n4;
            for (n4 = 1; n4 <= this.maxSequenceNumber; ++n4) {
                int n5 = this.checkExternalAntennaValidation(n, n4, i);
                if (n5 == 2) {
                    ++n2;
                }
                if (n4 != 1) continue;
                n3 = n5;
            }
            n4 = SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber);
            if (this.retCic.typeOfRetParam == null || !this.retCic.typeOfRetParam[n4][i].getValue().equals("ARETU_CASCADE")) continue;
            String string = null;
            if (n3 != 2) {
                string = "The external antenna in sequence 1 needs to be configured for sector " + n + ".";
                throw new BemException(string);
            }
            if (n2 >= 2) continue;
            string = "At least two external antennas needs to be configured for sector " + n + ".";
            throw new BemException(string);
        }
    }

    public int checkExternalAntennaValidation(int n, int n2, int n3) {
        String string = MessageFormat.format("S{0}_", new Integer(n));
        string = string + MessageFormat.format("SEQ{0}_", new Integer(n2));
        String string2 = n3 > 0 ? String.valueOf(n3 + 1) : "";
        String[] stringArray = n2 == 1 ? new String[]{string + "antennaType" + string2, string + "uniqueHwId" + string2, string + "electricalTilt" + string2, string + "mechanicalTilt" + string2} : new String[]{string + "antennaType" + string2, string + "uniqueHwId" + string2, string + "electricalTilt" + string2};
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!this.rbs.isParameterSupported(stringArray[i])) {
                    return 1;
                }
                CustomerParameter customerParameter = this.rbs.getCustomerParameterObject(stringArray[i]);
                if (customerParameter == null) {
                    return 1;
                }
                if (customerParameter.isDefault()) continue;
                for (int j = 0; j < stringArray.length; ++j) {
                    if (!this.rbs.isParameterSupported(stringArray[j])) {
                        return 3;
                    }
                    customerParameter = this.rbs.getCustomerParameterObject(stringArray[j]);
                    if (customerParameter.isValidValue()) continue;
                    return 3;
                }
                return 2;
            }
        }
        catch (BemException bemException) {
            BemLog.log(5, "Customer Parameter is not created because cascaded ARET is not installed for sector " + n + ", sequence " + n2 + ".\n" + bemException.getMessage());
            return 1;
        }
        return 1;
    }

    private int getRangeIndex(String string, Integer n) {
        int n2;
        block2: {
            Integer[] integerArray;
            Integer[] integerArray2;
            block3: {
                Integer[] integerArray3 = new Integer[]{MimAntennaBranch.MIN_FQBANDLOWEDGE};
                Integer[] integerArray4 = new Integer[]{MimAntennaBranch.MAX_FQBANDLOWEDGE};
                integerArray2 = new Integer[]{MimAntennaBranch.MIN_FQBANDHIGHEDGE};
                integerArray = new Integer[]{MimAntennaBranch.MAX_FQBANDHIGHEDGE};
                n2 = -1;
                if (!string.equals("LOW")) break block3;
                for (int i = 0; i < integerArray3.length; ++i) {
                    if (n < integerArray3[i] || n > integerArray4[i]) continue;
                    n2 = i;
                    break block2;
                }
                break block2;
            }
            if (!string.equals("HIGH")) break block2;
            for (int i = 0; i < integerArray2.length; ++i) {
                if (n < integerArray2[i] || n > integerArray[i]) continue;
                n2 = i;
                break;
            }
        }
        return n2;
    }

    private void createCustomerParameters() throws BemException {
        int[] nArray = this.radioEP.getEquippedSectors();
        if (this.startingSectorNumber == 1) {
            this.createSiteDataCP();
        }
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            int n2 = SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber);
            String string = AbstractAntennaSystemCI.getSectorPrefix(n);
            this.createSectorCP(string, n2);
            for (int j = 0; j < 3; ++j) {
                this.createAntennaTypeCP(nArray[i], j + 1, false);
                this.createAntennaTypeCP(nArray[i], j + 1, true);
                this.createUserLabelAretuCP(nArray[i], j + 1, true);
                this.createUserLabelAretuCP(nArray[i], j + 1, false);
                this.createSectorAntennaCP(string, n, j + 1);
                this.createModificationTypeCP(nArray[i], j);
            }
            this.createAntennaBranchCP(string, n2);
            this.createAntennaFeederCP(string, n2);
            this.createExternalTpaCP(string, n2);
            this.addNumberOfRxBranchesListener(n);
            if (this.canHaveTma) {
                this.setTmaTypeRangeRestriction(n);
                this.createTmaCP(string, n);
                this.createAtmaCP(string, n2);
                this.createExternalTmaCP(string, n2);
                this.createModifyTmfFileCP(string, n2);
            } else {
                String[] stringArray = new String[]{NONE_STRING};
                for (int j = 0; j < 3; ++j) {
                    this.tmaTypeRangeRestriction[n2][j].setRange(Enumeration.newEnumeratedValueRange(stringArray), true);
                }
                this.createTmaCP(string, n);
            }
            if (this.canHaveRadioDot(n)) {
                this.createRadioDotCP(n);
            }
            this.createPositionConfigurationCP(n);
            this.createCustomerParameters(string, n2);
        }
    }

    private void updateCustomerParametersRestrictionAccordingToNumberOfRxBranch() {
        int[] nArray = this.radioEP.getEquippedSectors();
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            this.updateCustomerParametersRestrictionAccordingToNumberOfRxBranch(n);
        }
    }

    private void updateCustomerParametersRestrictionAccordingToNumberOfRxBranch(int n) {
        int[] nArray = this.radioEP.getEquippedSectors();
        if (this.canHaveTma) {
            this.setTmaTypeRangeRestriction(n);
        } else {
            String[] stringArray = new String[]{NONE_STRING};
            int n2 = this.getNumOfSectorAntennas(n);
            for (int i = 0; i < n2; ++i) {
                this.setTmaTypeRangeRestriction(n, i + 1, Enumeration.newEnumeratedValueRange(stringArray));
            }
        }
        this.retCic.setRetTypeRangeRestriction(n);
        for (int i = 0; i < nArray.length; ++i) {
            this.setAntennaFeederCPsRestriction(nArray[i]);
        }
    }

    protected void createSectorCP(String string, int n) {
        String string2 = "";
        string2 = string + "latitude";
        IntegerRange integerRange = new IntegerRange(MimSector.MIN_LATITUDE, MimSector.MAX_LATITUDE);
        IntegerParameter integerParameter = new IntegerParameter(string2, integerRange);
        integerParameter.setDefaultValue(MimSector.DEFAULT_LATITUDE.toString());
        integerParameter.addRestriction(this.sectorNotEquippedRestriction[n]);
        this.addParameter(integerParameter);
        string2 = string + "geoDatum";
        StringRange stringRange = new StringRange(MimSector.MINLEN_GEODATUM, MimSector.MAXLEN_GEODATUM);
        CustomerParameterImpl customerParameterImpl = new CustomerParameterImpl(string2, stringRange);
        customerParameterImpl.setDefaultValue(MimSector.DEFAULT_GEODATUM);
        customerParameterImpl.addRestriction(this.sectorNotEquippedRestriction[n]);
        this.addParameter(customerParameterImpl);
        string2 = string + "latHemisphere";
        String[] stringArray = new String[]{"NORTH", "SOUTH", "N", "S"};
        EnumeratedRange enumeratedRange = new EnumeratedRange(stringArray);
        Enumeration enumeration = new Enumeration(string2, enumeratedRange);
        LatHemisphereConversion latHemisphereConversion = new LatHemisphereConversion();
        enumeration.setMomConverter(latHemisphereConversion);
        enumeration.setDefaultValue(latHemisphereConversion.convertToParameterValue(MimSector.DEFAULT_LATHEMISPHERE));
        enumeration.addRestriction(this.sectorNotEquippedRestriction[n]);
        this.addParameter(enumeration);
        string2 = string + "longitude";
        integerRange = new IntegerRange(MimSector.MIN_LONGITUDE, MimSector.MAX_LONGITUDE);
        integerParameter = new IntegerParameter(string2, integerRange);
        integerParameter.setDefaultValue(MimSector.DEFAULT_LONGITUDE.toString());
        integerParameter.addRestriction(this.sectorNotEquippedRestriction[n]);
        this.addParameter(integerParameter);
        string2 = string + "height";
        HeightRange heightRange = new HeightRange(new Integer(0), new Integer(999999));
        integerParameter = new IntegerParameter(string2, heightRange);
        integerParameter.setDefaultValue(MimSector.DEFAULT_HEIGHT);
        integerParameter.addRestriction(this.sectorNotEquippedRestriction[n]);
        this.addParameter(integerParameter);
        string2 = string + "sectorGroup";
        integerRange = new IntegerRange(MimSector.MIN_SECTORGROUP, MimSector.MAX_SECTORGROUP);
        integerParameter = new IntegerParameter(string2, integerRange);
        integerParameter.setDefaultValue(MimSector.DEFAULT_SECTORGROUP.toString());
        integerParameter.addRestriction(this.sectorNotEquippedRestriction[n]);
        this.addParameter(integerParameter);
        string2 = string + "beamDirection";
        integerRange = new IntegerRange(new Integer(0), new Integer(359));
        integerParameter = new IntegerParameter(string2, integerRange);
        BeamDirectionConversion beamDirectionConversion = new BeamDirectionConversion();
        integerParameter.setMomConverter(beamDirectionConversion);
        integerParameter.setDefaultValue(MimSector.DEFAULT_BEAMDIRECTION);
        integerParameter.addRestriction(this.sectorNotEquippedRestriction[n]);
        this.addParameter(integerParameter);
        string2 = string + "noiseFigure";
        integerRange = new IntegerRange(MimSector.MIN_NOISEFIGURE, MimSector.MAX_NOISEFIGURE);
        integerParameter = new IntegerParameter(string2, integerRange);
        integerParameter.setDefaultValue(MimSector.DEFAULT_NOISEFIGURE.toString());
        integerParameter.addRestriction(this.sectorNotEquippedRestriction[n]);
        this.addParameter(integerParameter);
    }

    public void createSectorAntennaCP(String string, int n, int n2) {
        String string2 = "";
        IntegerRange integerRange = null;
        IntegerParameter integerParameter = null;
        if (n2 == 1) {
            return;
        }
        string2 = string + "beamDirection" + String.valueOf(n2);
        integerRange = new IntegerRange(new Integer(0), new Integer(359));
        integerParameter = new IntegerParameter(string2, integerRange);
        BeamDirectionConversion beamDirectionConversion = new BeamDirectionConversion();
        integerParameter.setMomConverter(beamDirectionConversion);
        integerParameter.setDefaultValue(beamDirectionConversion.convertToParameterValue(MimSectorAntenna.DEFAULT_BEAMDIRECTION));
        integerParameter.addRestriction(this.sectorNotEquippedRestriction[SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber)]);
        this.addParameter(integerParameter);
    }

    protected void createAntennaTypeCP(int n, int n2, boolean bl) {
        String string = "";
        String string2 = AbstractAntennaSystemCI.getSectorPrefix(n);
        int n3 = 1;
        int n4 = SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber);
        boolean bl2 = AIRUtil.getInstance(this.rbs).isAirConfigured(n);
        String string3 = null;
        string3 = bl2 ? MimSectorAntenna.MIN_ANTENNATYPE.toString() : MimSectorAntenna.DEFAULT_ANTENNATYPE.toString();
        if (!bl) {
            IntegerRange integerRange = new IntegerRange(MimSectorAntenna.MIN_ANTENNATYPE, MimSectorAntenna.MAX_ANTENNATYPE);
            string = string2 + "antennaType" + (n2 > 1 ? String.valueOf(n2) : "");
            this.antennaTypeParam[n4][n2 - 1] = new IntegerParameter(string, integerRange);
            this.antennaTypeParam[n4][n2 - 1].addRestriction(this.sectorUsedRestriction[n4]);
            this.antennaTypeParam[n4][n2 - 1].addRestriction(this.antennaTypeRestriction[n4][n2 - 1]);
            this.antennaTypeParam[n4][n2 - 1].addCustomerParameterListener(new AntennaTypeListener(n4, n2 - 1));
            this.antennaTypeParam[n4][n2 - 1].setDefaultValue(string3);
            this.addParameter(this.antennaTypeParam[n4][n2 - 1]);
        } else {
            if (n2 > 1 && !SectorUtil.isRrus32WithRbb441d(this.rbs, n) || n2 > 2) {
                return;
            }
            for (n3 = 1; n3 <= this.maxSequenceNumber; ++n3) {
                string = string2 + AbstractAntennaSystemCI.getSequencePrefix(n3) + "antennaType" + (n2 > 1 ? String.valueOf(n2) : "");
                IntegerRange integerRange = new IntegerRange(MimSectorAntenna.MIN_ANTENNATYPE, MimSectorAntenna.MAX_ANTENNATYPE);
                this.antennaTypeCascadedParam[n4][n2 - 1][n3 - 1] = new IntegerParameter(string, integerRange);
                this.antennaTypeCascadedParam[n4][n2 - 1][n3 - 1].addRestriction(this.sectorUsedRestriction[n4]);
                if (n3 == 1) {
                    this.antennaTypeCascadedParam[n4][n2 - 1][n3 - 1].setDefaultValue(string3);
                }
                this.addParameter(this.antennaTypeCascadedParam[n4][n2 - 1][n3 - 1]);
            }
        }
    }

    protected void createUserLabelAretuCP(int n, int n2, boolean bl) {
        String string = "";
        String string2 = AbstractAntennaSystemCI.getSectorPrefix(n);
        int n3 = 1;
        int n4 = SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber);
        if (!bl) {
            string = string2 + "userLabel" + (n2 > 1 ? String.valueOf(n2 - 1) : "");
            StringRange stringRange = new StringRange(MimSectorAntenna.MINLEN_USERLABEL, MimSectorAntenna.MAXLEN_USERLABEL);
            this.userlabelParam[n4][n2 - 1] = new StringParameter(string, stringRange);
            this.userlabelParam[n4][n2 - 1].addRestriction(this.sectorUsedRestriction[n4]);
            this.userlabelParam[n4][n2 - 1].addRestriction(this.antennaTypeRestriction[n4][n2 - 1]);
            this.userlabelParam[n4][n2 - 1].addCustomerParameterListener(new UserLabelListener(n4));
            this.userlabelParam[n4][n2 - 1].setDefaultValue(MimSectorAntenna.DEFAULT_USERLABEL);
            this.addParameter(this.userlabelParam[n4][n2 - 1]);
        } else {
            if (n2 > 1 && !SectorUtil.isRrus32WithRbb441d(this.rbs, n) || n2 > 2) {
                return;
            }
            for (n3 = 1; n3 <= this.maxSequenceNumber; ++n3) {
                string = string2 + AbstractAntennaSystemCI.getSequencePrefix(n3) + "userLabel" + (n2 > 1 ? String.valueOf(n2) : "");
                StringRange stringRange = new StringRange(MimExternalAntenna.MINLEN_USERLABEL, MimExternalAntenna.MAXLEN_USERLABEL);
                this.userlabelCascadedParam[n4][n2 - 1][n3 - 1] = new StringParameter(string, stringRange);
                this.userlabelCascadedParam[n4][n2 - 1][n3 - 1].addRestriction(this.sectorUsedRestriction[n4]);
                this.userlabelCascadedParam[n4][n2 - 1][n3 - 1].setDefaultValue(MimExternalAntenna.DEFAULT_USERLABEL);
                this.addParameter(this.userlabelCascadedParam[n4][n2 - 1][n3 - 1]);
            }
        }
    }

    private void createModificationTypeCP(int n, int n2) {
        String string = "";
        String string2 = AbstractAntennaSystemCI.getSectorPrefix(n);
        int n3 = SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber);
        for (int i = 1; i <= this.maxSequenceNumber; ++i) {
            string = string2 + AbstractAntennaSystemCI.getSequencePrefix(i) + "modificationType" + (n2 > 0 ? String.valueOf(n2) : "");
            EnumeratedRange enumeratedRange = new EnumeratedRange(modificationTypes);
            this.modificationTypeCascadedParam[n3][n2][i - 1] = new Enumeration(string, enumeratedRange);
            this.modificationTypeCascadedParam[n3][n2][i - 1].addRestriction(this.sectorUsedRestriction[n3]);
            this.addParameter(this.modificationTypeCascadedParam[n3][n2][i - 1]);
        }
    }

    protected void deleteAntennaTypeCP(int n, int n2, boolean bl) {
        int n3 = 1;
        int n4 = SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber);
        if (!bl) {
            if (this.antennaTypeCascadedParam[n4][n2 - 1][n3 - 1] != null) {
                this.removeParameter(this.antennaTypeCascadedParam[n4][n2 - 1][n3 - 1]);
                this.antennaTypeCascadedParam[n4][n2 - 1][n3 - 1] = null;
            }
        } else {
            for (n3 = 2; n3 <= this.maxSequenceNumber; ++n3) {
                if (this.antennaTypeCascadedParam[n4][n2 - 1][n3 - 1] == null) continue;
                this.removeParameter(this.antennaTypeCascadedParam[n4][n2 - 1][n3 - 1]);
                this.antennaTypeCascadedParam[n4][n2 - 1][n3 - 1] = null;
            }
        }
    }

    private void createAntennaBranchCP(String string, int n) {
        String string2 = "";
        IntegerRange integerRange = new IntegerRange(MimAntennaBranch.MIN_MECHANICALANTENNATILT, MimAntennaBranch.MAX_MECHANICALANTENNATILT);
        for (int i = 0; i < 3; ++i) {
            string2 = string + "mechanicalTilt" + (i > 0 ? String.valueOf(i + 1) : "");
            this.meTiltParam[n][i] = new IntegerParameter(string2, integerRange);
            this.meTiltParam[n][i].addRestriction(this.sectorUsedRestriction[n]);
            this.meTiltParam[n][i].addRestriction(this.meTiltRestriction[n][i]);
            this.meTiltParam[n][i].setDefaultValue(MimAntennaBranch.DEFAULT_MECHANICALANTENNATILT.toString());
            this.addParameter(this.meTiltParam[n][i]);
            string2 = string + "riuInstalled" + (i > 0 ? String.valueOf(i + 1) : "");
            this.riuInstalled[n][i] = new YesNoCustomerParameter(string2);
            this.riuInstalled[n][i].addRestriction(this.riuInstalledRestriction[n][i]);
            this.riuInstalled[n][i].addRestriction(this.sectorUsedRestriction[n]);
            this.addParameter(this.riuInstalled[n][i]);
            for (int j = 1; j <= this.maxSequenceNumber; ++j) {
                string2 = string + AbstractAntennaSystemCI.getSequencePrefix(j) + "mechanicalTilt" + (i > 0 ? String.valueOf(i + 1) : "");
                this.meTiltCascadedParam[n][i][j - 1] = new IntegerParameter(string2, integerRange);
                this.meTiltCascadedParam[n][i][j - 1].addRestriction(this.sectorUsedRestriction[n]);
                this.addParameter(this.meTiltCascadedParam[n][i][j - 1]);
            }
        }
        string2 = string + "band";
        this.bandParam[n] = new Enumeration(string2, this.bandRange);
        BandListener bandListener = new BandListener(n);
        this.bandParam[n].addCustomerParameterListener(bandListener);
        this.bandParam[n].addRestriction(this.sectorUsedRestriction[n]);
        this.bandParam[n].setDefaultValue(AUTO_CREATED_RDNID_1);
        this.addParameter(this.bandParam[n]);
        LowCurrentSupervisionConversion lowCurrentSupervisionConversion = new LowCurrentSupervisionConversion();
        for (int i = 0; i < branch.length; ++i) {
            string2 = string + "fqBandHighEdgeBranch" + branch[i];
            integerRange = new IntegerRange(MimAntennaBranch.MIN_FQBANDHIGHEDGE, MimAntennaBranch.MAX_FQBANDHIGHEDGE);
            this.fqHiEdgeParam[n][i] = new IntegerParameter(string2, integerRange);
            this.fqHiEdgeParam[n][i].addRestriction(this.sectorUsedRestriction[n]);
            this.fqHiEdgeParam[n][i].addRestriction(this.fqBandHighEdgeRangeRestriction[n]);
            this.addParameter(this.fqHiEdgeParam[n][i]);
            string2 = string + "fqBandLowEdgeBranch" + branch[i];
            integerRange = new IntegerRange(MimAntennaBranch.MIN_FQBANDLOWEDGE, MimAntennaBranch.MAX_FQBANDLOWEDGE);
            this.fqLoEdgeParam[n][i] = new IntegerParameter(string2, integerRange);
            this.fqLoEdgeParam[n][i].addRestriction(this.sectorUsedRestriction[n]);
            this.fqLoEdgeParam[n][i].addRestriction(this.fqBandLowEdgeRangeRestriction[n]);
            this.addParameter(this.fqLoEdgeParam[n][i]);
            string2 = string + "antennaSupervisionBranch" + branch[i];
            integerRange = new IntegerRange(MimAntennaBranch.MIN_ANTENNASUPERVISIONTHRESHOLD, MimAntennaBranch.MAX_ANTENNASUPERVISIONTHRESHOLD);
            this.antennaSupParam[n][i] = new IntegerParameter(string2, integerRange);
            this.antennaSupParam[n][i].addRestriction(this.sectorUsedRestriction[n]);
            this.antennaSupParam[n][i].setDefaultValue(MimAntennaBranch.DEFAULT_ANTENNASUPERVISIONTHRESHOLD.toString());
            this.addParameter(this.antennaSupParam[n][i]);
            string2 = string + "currentLowSupervision_" + branch[i];
            this.lowCurrentSupervision[n][i] = new OnOffCustomerParameter(string2);
            this.lowCurrentSupervision[n][i].setDefaultValue("ON");
            this.lowCurrentSupervision[n][i].addRestriction(this.tmaAndAtmaRestriction[n][i / 2]);
            this.lowCurrentSupervision[n][i].addRestriction(this.sectorUsedRestriction[n]);
            this.lowCurrentSupervision[n][i].setMomConverter(lowCurrentSupervisionConversion);
            this.addParameter(this.lowCurrentSupervision[n][i]);
        }
    }

    protected void createAntennaFeederCP(String string, int n) {
        String string2 = "";
        AntennaFeederConversion antennaFeederConversion = new AntennaFeederConversion();
        for (int i = 0; i < branch.length; ++i) {
            string2 = string + "dlFeederAttenuationBranch" + branch[i];
            IntegerRange integerRange = new IntegerRange(MimAntFeederCable.MIN_DLATTENUATION, MimAntFeederCable.MAX_DLATTENUATION);
            ListRange listRange = new ListRange(integerRange);
            this.dlFeederAttParam[n][i] = new ListParameter(string2, listRange, 1, 15, true, false);
            this.dlFeederAttParam[n][i].setMomConverter(antennaFeederConversion);
            this.addParameter(this.dlFeederAttParam[n][i]);
            string2 = string + "ulFeederAttenuationBranch" + branch[i];
            integerRange = new IntegerRange(MimAntFeederCable.MIN_ULATTENUATION, MimAntFeederCable.MAX_ULATTENUATION);
            listRange = new ListRange(integerRange);
            this.ulFeederAttParam[n][i] = new ListParameter(string2, listRange, 1, 15, true, false);
            this.ulFeederAttParam[n][i].setMomConverter(antennaFeederConversion);
            this.addParameter(this.ulFeederAttParam[n][i]);
            string2 = string + "dlFeederDelayBranch" + branch[i];
            integerRange = new IntegerRange(MimAntFeederCable.MIN_ELECTRICALDLDELAY, MimAntFeederCable.MAX_ELECTRICALDLDELAY);
            listRange = new ListRange(integerRange);
            this.dlFeederDelayParam[n][i] = new ListParameter(string2, listRange, 1, 15, true, false);
            this.dlFeederDelayParam[n][i].setMomConverter(antennaFeederConversion);
            this.addParameter(this.dlFeederDelayParam[n][i]);
            string2 = string + "ulFeederDelayBranch" + branch[i];
            integerRange = new IntegerRange(MimAntFeederCable.MIN_ELECTRICALULDELAY, MimAntFeederCable.MAX_ELECTRICALULDELAY);
            listRange = new ListRange(integerRange);
            this.ulFeederDelayParam[n][i] = new ListParameter(string2, listRange, 1, 15, true, false);
            this.ulFeederDelayParam[n][i].setMomConverter(antennaFeederConversion);
            this.addParameter(this.ulFeederDelayParam[n][i]);
            if (!AIRUtil.getInstance(this.rbs).isAirConfigured(n + 1) || AIRUtil.getInstance(this.rbs).isRbb111AWithAir(n + 1) && (!AIRUtil.getInstance(this.rbs).isRbb111AWithAir(n + 1) || i != 0)) continue;
            this.dlFeederAttParam[n][i].setDefaultValue("0");
            this.ulFeederAttParam[n][i].setDefaultValue("0");
            this.dlFeederDelayParam[n][i].setDefaultValue("0");
            this.ulFeederDelayParam[n][i].setDefaultValue("0");
        }
        this.setAntennaFeederCPsRestriction(SectorUtil.getSectorNumberFromSectorIndex(n, this.startingSectorNumber));
    }

    protected void createSiteDataCP() throws BemException {
        String string = "";
        string = "siteName";
        StringRange stringRange = new StringRange(MimManagedElement.MINLEN_SITE, MimManagedElement.MAXLEN_SITE);
        StringParameter stringParameter = new StringParameter(string, stringRange);
        ParameterRestriction parameterRestriction = new ParameterRestriction("", 2);
        stringParameter.addRestriction(parameterRestriction);
        this.addParameter(stringParameter);
        string = "logicalName";
        stringRange = new StringRange(MimManagedElement.MINLEN_LOGICALNAME, MimManagedElement.MAXLEN_LOGICALNAME);
        StringParameter stringParameter2 = new StringParameter(string, stringRange);
        stringParameter2.addRestriction(parameterRestriction);
        this.addParameter(stringParameter2);
        LmtPortsParameter lmtPortsParameter = new LmtPortsParameter();
        lmtPortsParameter.addRestriction(parameterRestriction);
        lmtPortsParameter.setMomConverter(new LmtPortsConversion());
        this.addParameter(lmtPortsParameter);
        this.createWantedPositionCP();
    }

    private void createWantedPositionCP() {
        ParameterRestriction parameterRestriction = new ParameterRestriction("", 2);
        StringRange stringRange = new StringRange(new Integer(0), new Integer(50));
        String string = "altitude";
        StringParameter stringParameter = new StringParameter(string, stringRange);
        stringParameter.addRestriction(parameterRestriction);
        this.addParameter(stringParameter);
        string = "latitude";
        StringParameter stringParameter2 = new StringParameter(string, stringRange);
        stringParameter2.addRestriction(parameterRestriction);
        this.addParameter(stringParameter2);
        string = "longitude";
        StringParameter stringParameter3 = new StringParameter(string, stringRange);
        stringParameter3.addRestriction(parameterRestriction);
        this.addParameter(stringParameter3);
        string = "tolerance";
        IntegerParameter integerParameter = new IntegerParameter(string, new IntegerRange(new Integer(0), new Integer(Integer.MAX_VALUE)));
        integerParameter.addRestriction(parameterRestriction);
        this.addParameter(integerParameter);
    }

    protected void createAtmaCP(String string, int n) {
        String string2 = "";
        for (int i = 0; i < 3; ++i) {
            string2 = string + "dlAttenuation_ATMA" + (i > 0 ? String.valueOf(i + 1) : "");
            IntegerRange integerRange = new IntegerRange(MimTmaDeviceSet.MIN_DLATTENUATION, MimTmaDeviceSet.MAX_DLATTENUATION);
            this.dlAttATMAParam[n][i] = new IntegerParameter(string2, integerRange);
            this.dlAttATMAParam[n][i].addRestriction(this.atmaRestriction[n][i]);
            this.dlAttATMAParam[n][i].addRestriction(this.sectorUsedRestriction[n]);
            this.addParameter(this.dlAttATMAParam[n][i]);
            string2 = string + "dlTrafficDelay" + (i > 0 ? String.valueOf(i + 1) : "");
            integerRange = new IntegerRange(MimTmaDeviceSet.MIN_DLTRAFFICDELAY, MimTmaDeviceSet.MAX_DLTRAFFICDELAY);
            this.dlTrafficDelayParam[n][i] = new IntegerParameter(string2, integerRange);
            this.dlTrafficDelayParam[n][i].addRestriction(this.atmaRestriction[n][i]);
            this.dlTrafficDelayParam[n][i].addRestriction(this.sectorUsedRestriction[n]);
            this.addParameter(this.dlTrafficDelayParam[n][i]);
            string2 = string + "ulTrafficDelay" + (i > 0 ? String.valueOf(i + 1) : "");
            integerRange = new IntegerRange(MimTmaDeviceSet.MIN_ULTRAFFICDELAY, MimTmaDeviceSet.MAX_ULTRAFFICDELAY);
            this.ulTrafficDelayParam[n][i] = new IntegerParameter(string2, integerRange);
            this.ulTrafficDelayParam[n][i].addRestriction(this.atmaRestriction[n][i]);
            this.ulTrafficDelayParam[n][i].addRestriction(this.sectorUsedRestriction[n]);
            this.addParameter(this.ulTrafficDelayParam[n][i]);
        }
    }

    protected void createTmaCP(String string, int n) {
        String string2 = "";
        int n2 = SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber);
        for (int i = 1; i <= 3; ++i) {
            string2 = string + "tmaType" + (i == 1 ? "" : String.valueOf(i));
            this.tmaParam[n2][i - 1] = new Enumeration(string2, new String[]{NONE_STRING, TMA_STRING, ASC_STRING, ATMA_STRING, ATMA_AND_TMA_STRING, TMF_STRING});
            this.tmaParam[n2][i - 1].setDefaultValue(NONE_STRING);
            this.tmaParam[n2][i - 1].addRestriction(this.sectorUsedRestriction[n2]);
            this.tmaParam[n2][i - 1].addRestriction(this.tmaTypeRangeRestriction[n2][i - 1]);
            this.tmaParam[n2][i - 1].setLoadedValue(NONE_STRING);
            this.tmaParam[n2][i - 1].addCustomerParameterListener(new TmaTypeListener(n, i));
            this.addParameter(this.tmaParam[n2][i - 1]);
        }
    }

    protected void createExternalTpaCP(String string, int n) {
        Integer[] integerArray = new Integer[]{new Integer(-1), new Integer(Integer.MAX_VALUE)};
        IntegerRange integerRange = new IntegerRange(MimTpaDevice.MIN_MAXTOTALOUTPUTPOWER, integerArray);
        this.sectorOutputPower[n] = new IntegerParameter(string + "sectorOutputPower", integerRange);
        this.sectorOutputPower[n].setDefaultValue("-1");
        this.sectorOutputPower[n].addRestriction(this.sectorUsedRestriction[n]);
        this.sectorOutputPower[n].addRestriction(this.sectorOutputPowerRestriction[n]);
        this.addParameter(this.sectorOutputPower[n]);
        IntegerRange integerRange2 = new IntegerRange(MimTpaDevice.MIN_MAXTOTALOUTPUTPOWERLOW, integerArray);
        this.sectorOutputPowerLow[n] = new IntegerParameter(string + "sectorOutputPowerLow", integerRange2);
        this.sectorOutputPowerLow[n].setDefaultValue("-1");
        this.sectorOutputPowerLow[n].addRestriction(this.sectorUsedRestriction[n]);
        this.sectorOutputPowerLow[n].addRestriction(this.sectorOutputPowerLowRestriction[n]);
        this.addParameter(this.sectorOutputPowerLow[n]);
        String string2 = string + "lockSectorOutputPowerLow";
        this.lockSectorOutputPowerLow[n] = new TrueFalseCustomerParameter(string2);
        this.lockSectorOutputPowerLow[n].setDefaultValue("FALSE");
        this.lockSectorOutputPowerLow[n].addRestriction(this.lockSectorOutputPowerLowRestriction[n]);
        this.lockSectorOutputPowerLow[n].addRestriction(this.sectorUsedRestriction[n]);
        this.addParameter(this.lockSectorOutputPowerLow[n]);
    }

    private void createRadioDotCP(int n) {
        IntegerRange integerRange = new IntegerRange(1, RadioDotSystemUtil.getMaxNoOfRadioDotPerIRU());
        IntegerRange integerRange2 = new IntegerRange(MimPositionStruct.MIN_LONGITUDE, MimPositionStruct.MAX_LONGITUDE);
        IntegerRange integerRange3 = new IntegerRange(MimPositionStruct.MIN_LATITUDE, MimPositionStruct.MAX_LATITUDE);
        IntegerRange integerRange4 = new IntegerRange(MimPositionStruct.MIN_ALTITUDE, MimPositionStruct.MAX_ALTITUDE);
        StringRange stringRange = new StringRange(MimPositionStruct.MINLEN_GEODATUM, MimPositionStruct.MAXLEN_GEODATUM);
        ParameterRestriction parameterRestriction = new ParameterRestriction("", 2);
        String string = PrefixUtil.getRadioDotPrefix(n, 1);
        String string2 = string + "longitude";
        if (!this.isParameterSupported(string2)) {
            int n2 = 1;
            while (true) {
                if (n2 > MAX_NO_OF_RADIO_DOT_PER_SECTOR) break;
                string = PrefixUtil.getRadioDotPrefix(n, n2);
                string2 = string + "radioDotNumber";
                IntegerParameter integerParameter = new IntegerParameter(string2, integerRange);
                integerParameter.addRestriction(parameterRestriction);
                this.addParameter(integerParameter);
                string2 = string + "longitude";
                IntegerParameter integerParameter2 = new IntegerParameter(string2, integerRange2);
                integerParameter2.addRestriction(parameterRestriction);
                this.addParameter(integerParameter2);
                string2 = string + "latitude";
                IntegerParameter integerParameter3 = new IntegerParameter(string2, integerRange3);
                integerParameter3.addRestriction(parameterRestriction);
                this.addParameter(integerParameter3);
                string2 = string + "altitude";
                IntegerParameter integerParameter4 = new IntegerParameter(string2, integerRange4);
                integerParameter4.addRestriction(parameterRestriction);
                this.addParameter(integerParameter4);
                string2 = string + "geoDatum";
                StringParameter stringParameter = new StringParameter(string2, stringRange);
                stringParameter.addRestriction(parameterRestriction);
                this.addParameter(stringParameter);
                if (this.rbs.isModifyWiz()) {
                    string2 = string + "sectorNumber";
                    IntegerParameter integerParameter5 = new IntegerParameter(string2, integerRange);
                    integerParameter5.addRestriction(parameterRestriction);
                    this.addParameter(integerParameter5);
                }
                ++n2;
            }
        }
    }

    private void createPositionConfigurationCP(int n, String string, int n2) {
        String string2 = PrefixUtil.getPosPrefix(n, string, n2);
        String string3 = "";
        ParameterRestriction parameterRestriction = new ParameterRestriction("", 3);
        ParameterRestriction parameterRestriction2 = new ParameterRestriction("", 2);
        string3 = string2 + "sectorNumber";
        if (!this.isParameterSupported(string3)) {
            IntegerRange integerRange = new IntegerRange(new Integer(1), new Integer(this.maxNoOfSectors));
            IntegerParameter integerParameter = new IntegerParameter(string3, integerRange);
            integerParameter.addRestriction(parameterRestriction);
            integerParameter.setLoadedValue(String.valueOf(n));
            this.addParameter(integerParameter);
            string3 = string2 + "unitType";
            EnumeratedRange enumeratedRange = new EnumeratedRange(new String[]{"RadioUnit", "Antenna"});
            Enumeration enumeration = new Enumeration(string3, enumeratedRange);
            enumeration.addRestriction(parameterRestriction);
            enumeration.setLoadedValue(string);
            this.addParameter(enumeration);
            string3 = string2 + "unitNumber";
            IntegerRange integerRange2 = new IntegerRange(new Integer(1), new Integer(3));
            IntegerParameter integerParameter2 = new IntegerParameter(string3, integerRange2);
            integerParameter2.addRestriction(parameterRestriction);
            integerParameter2.setLoadedValue(String.valueOf(n2));
            this.addParameter(integerParameter2);
            string3 = string2 + "positionInformation";
            StringRange stringRange = null;
            String string4 = null;
            if ("Antenna".equals(string)) {
                stringRange = new StringRange(MimSectorAntenna.MINLEN_POSITIONINFORMATION, MimSectorAntenna.MAXLEN_POSITIONINFORMATION);
                string4 = MimSectorAntenna.DEFAULT_POSITIONINFORMATION;
            } else {
                stringRange = new StringRange(MimAuxPlugInUnit.MINLEN_POSITIONINFORMATION, MimAuxPlugInUnit.MAXLEN_POSITIONINFORMATION);
                string4 = MimAuxPlugInUnit.DEFAULT_POSITIONINFORMATION;
            }
            StringParameter stringParameter = new StringParameter(string3, stringRange);
            stringParameter.addRestriction(parameterRestriction2);
            stringParameter.setDefaultValue(string4);
            this.addParameter(stringParameter);
            string3 = string2 + "hwGroupId";
            StringRange stringRange2 = new StringRange(new Integer(0), new Integer(Integer.MAX_VALUE));
            StringParameter stringParameter2 = new StringParameter(string3, stringRange2);
            stringParameter2.addRestriction(parameterRestriction2);
            this.addParameter(stringParameter2);
        }
    }

    private void createPositionConfigurationCP(int n) {
        for (int i = 0; i < 3; ++i) {
            this.createPositionConfigurationCP(n, "RadioUnit", i + 1);
            this.createPositionConfigurationCP(n, "Antenna", i + 1);
        }
    }

    protected void updateExternalTpaCpRestrictions(int n) throws BemException {
        String string = this.lockSectorOutputPowerLow[n].getLoadedValue();
        if (string != null && string.equals("TRUE")) {
            this.sectorOutputPowerRestriction[n].setAccessLevel(1);
            this.sectorOutputPowerLowRestriction[n].setAccessLevel(1);
            this.lockSectorOutputPowerLowRestriction[n].setAccessLevel(1);
        } else {
            this.updateSectorOutputPowerCpRestrictions(n);
        }
    }

    protected void updateSectorOutputPowerCpRestrictions(int n) {
        RadioEquipmentProviderWithRbb radioEquipmentProviderWithRbb = (RadioEquipmentProviderWithRbb)this.rbs.getProvider(RadioEquipmentProviderWithRbb.class, this.getDuwSlotNumbers());
        if (radioEquipmentProviderWithRbb != null) {
            Integer[] integerArray;
            int n2;
            if (this.sectorOutputPower[n] != null) {
                n2 = radioEquipmentProviderWithRbb.getMaxSectorOutputPower(n);
                if (n2 == 0) {
                    this.sectorOutputPowerRestriction[n].setAccessLevel(1);
                } else {
                    this.sectorOutputPowerRestriction[n].setAccessLevel(2);
                    Integer[] integerArray2 = new Integer[]{new Integer(MimTpaDevice.MAX_MAXTOTALOUTPUTPOWER[0]), new Integer(n2)};
                    integerArray = new IntegerRange(MimTpaDevice.MIN_MAXTOTALOUTPUTPOWER, integerArray2);
                    this.sectorOutputPowerRestriction[n].setRange((ParameterRange)integerArray, true);
                }
            }
            if (this.sectorOutputPowerLow[n] != null) {
                n2 = radioEquipmentProviderWithRbb.getMaxSectorOutputPowerLow(n);
                int n3 = radioEquipmentProviderWithRbb.getMinSectorOutputPowerLow(n);
                if (n2 == 0) {
                    this.sectorOutputPowerLowRestriction[n].setAccessLevel(1);
                } else {
                    this.sectorOutputPowerLowRestriction[n].setAccessLevel(2);
                    integerArray = new Integer[2];
                    Integer[] integerArray3 = new Integer[2];
                    integerArray[0] = new Integer(MimTpaDevice.MAX_MAXTOTALOUTPUTPOWERLOW[0]);
                    integerArray[1] = new Integer(n2);
                    integerArray3[0] = new Integer(MimTpaDevice.MIN_MAXTOTALOUTPUTPOWERLOW[0]);
                    integerArray3[1] = new Integer(n3);
                    IntegerRange integerRange = new IntegerRange(integerArray3, integerArray);
                    this.sectorOutputPowerLowRestriction[n].setRange(integerRange, true);
                }
            }
        }
    }

    protected void createModifyTmfFileCP(String string, int n) {
        String string2 = "";
        string2 = string + "ModifyTmFile";
        this.modifyTmfFileParam[n] = new TrueFalseCustomerParameter(string2);
        this.modifyTmfFileParam[n].setLoadedValue("FALSE");
        this.modifyTmfFileParam[n].setValue("FALSE");
        this.addParameter(this.modifyTmfFileParam[n]);
    }

    protected void createExternalTmaCP(String string, int n) {
        String string2 = "";
        for (int i = 0; i < 3; ++i) {
            string2 = string + "internalPower" + (i > 0 ? String.valueOf(i + 1) : "");
            this.internalPowerParam[n][i] = new YesNoCustomerParameter(string2);
            this.internalPowerParam[n][i].setDefaultValue("NO");
            this.internalPowerParam[n][i].addRestriction(this.tmaRestriction[n][i]);
            this.internalPowerParam[n][i].addRestriction(this.sectorUsedRestriction[n]);
            this.internalPowerParam[n][i].addRestriction(this.internalPowerSupportedRestriction[n][i]);
            InternalPowerConversion internalPowerConversion = new InternalPowerConversion();
            this.internalPowerParam[n][i].setMomConverter(internalPowerConversion);
            this.internalPowerParam[n][i].addCustomerParameterListener(new InternalPowerListener(SectorUtil.getSectorNumberFromSectorIndex(n, this.startingSectorNumber), i + 1));
            this.addParameter(this.internalPowerParam[n][i]);
            string2 = string + "dcVoltage" + (i > 0 ? String.valueOf(i + 1) : "");
            this.dcVoltageParam[n][i] = new Enumeration(string2, new String[]{"", DC_17V_OR_DC_30V, DC_12V});
            DcVoltageConversion dcVoltageConversion = new DcVoltageConversion();
            this.dcVoltageParam[n][i].setMomConverter(dcVoltageConversion);
            this.dcVoltageParam[n][i].setDefaultValue("");
            this.dcVoltageParam[n][i].addRestriction(this.dcVoltageRestriction[n][i]);
            this.dcVoltageParam[n][i].addRestriction(this.sectorUsedRestriction[n]);
            this.addParameter(this.dcVoltageParam[n][i]);
            string2 = string + "tmaDegradedSupported" + (i > 0 ? String.valueOf(i + 1) : "");
            this.tmaDegradedSupported[n][i] = new YesNoCustomerParameter(string2);
            this.tmaDegradedSupported[n][i].setDefaultValue("NO");
            this.tmaDegradedSupported[n][i].addRestriction(this.tmaRestriction[n][i]);
            this.tmaDegradedSupported[n][i].addRestriction(this.sectorUsedRestriction[n]);
            this.tmaDegradedSupported[n][i].addRestriction(this.tmaDegradedSupportedActivationRestriction[n][i]);
            this.tmaDegradedSupported[n][i].addCustomerParameterListener(new TmaDegradedSupportedListener(SectorUtil.getSectorNumberFromSectorIndex(n, this.startingSectorNumber), i + 1));
            TmaDegradedSupportedConversion tmaDegradedSupportedConversion = new TmaDegradedSupportedConversion();
            this.tmaDegradedSupported[n][i].setMomConverter(tmaDegradedSupportedConversion);
            this.addParameter(this.tmaDegradedSupported[n][i]);
            string2 = string + "dlAttenuation" + (i > 0 ? String.valueOf(i + 1) : "");
            IntegerRange integerRange = new IntegerRange(MimExternalTma.MIN_DLATTENUATION, MimExternalTma.MAX_DLATTENUATION);
            this.dlAttParam[n][i] = new IntegerParameter(string2, integerRange);
            this.dlAttParam[n][i].addRestriction(this.tmaRestriction[n][i]);
            this.dlAttParam[n][i].addRestriction(this.sectorUsedRestriction[n]);
            this.dlAttParam[n][i].addCustomerParameterListener(new DlAttenuationListener(SectorUtil.getSectorNumberFromSectorIndex(n, this.startingSectorNumber), i + 1));
            this.addParameter(this.dlAttParam[n][i]);
            string2 = string + "ulGain" + (i > 0 ? String.valueOf(i + 1) : "");
            integerRange = new IntegerRange(MimExternalTma.MIN_ULGAIN, MimExternalTma.MAX_ULGAIN);
            this.ulGainParam[n][i] = new IntegerParameter(string2, integerRange);
            this.ulGainParam[n][i].addRestriction(this.tmaRestriction[n][i]);
            this.ulGainParam[n][i].addRestriction(this.sectorUsedRestriction[n]);
            this.addParameter(this.ulGainParam[n][i]);
            for (int j = 0; j < 2; ++j) {
                string2 = string + "dlTrafficDelay" + branch[i * 2 + j % 2];
                integerRange = j == 0 ? new IntegerRange(MimExternalTma.MIN_DLTRAFFICDELAYA, MimExternalTma.MAX_DLTRAFFICDELAYA) : new IntegerRange(MimExternalTma.MIN_DLTRAFFICDELAYB, MimExternalTma.MAX_DLTRAFFICDELAYB);
                this.dlDelayParam[n][i][j] = new IntegerParameter(string2, integerRange);
                this.dlDelayParam[n][i][j].addRestriction(this.tmaRestriction[n][i]);
                this.dlDelayParam[n][i][j].addRestriction(this.sectorUsedRestriction[n]);
                if (j == 0) {
                    this.dlDelayParam[n][i][j].addCustomerParameterListener(new DlTrafficDelayListener(SectorUtil.getSectorNumberFromSectorIndex(n, this.startingSectorNumber), i + 1, j));
                }
                this.addParameter(this.dlDelayParam[n][i][j]);
                string2 = string + "ulTrafficDelay" + branch[i * 2 + j % 2];
                integerRange = j == 0 ? new IntegerRange(MimExternalTma.MIN_ULTRAFFICDELAYA, MimExternalTma.MAX_ULTRAFFICDELAYA) : new IntegerRange(MimExternalTma.MIN_ULTRAFFICDELAYB, MimExternalTma.MAX_ULTRAFFICDELAYB);
                this.ulDelayParam[n][i][j] = new IntegerParameter(string2, integerRange);
                this.ulDelayParam[n][i][j].addRestriction(this.tmaRestriction[n][i]);
                this.ulDelayParam[n][i][j].addRestriction(this.sectorUsedRestriction[n]);
                if (j == 0) {
                    this.ulDelayParam[n][i][j].addCustomerParameterListener(new UlTrafficDelayListener(SectorUtil.getSectorNumberFromSectorIndex(n, this.startingSectorNumber), i + 1, j));
                }
                this.addParameter(this.ulDelayParam[n][i][j]);
                string2 = string + "currentLowLim" + branch[i * 2 + j % 2];
                integerRange = j == 0 ? new IntegerRange(MimExternalTma.MIN_CURRENTLOWLIMA, MimExternalTma.MAX_CURRENTLOWLIMA) : new IntegerRange(MimExternalTma.MIN_CURRENTLOWLIMB, MimExternalTma.MAX_CURRENTLOWLIMB);
                this.currentLowLim[n][i][j] = new IntegerParameter(string2, integerRange);
                this.currentLowLim[n][i][j].setDefaultValue("50");
                this.currentLowLim[n][i][j].addRestriction(this.tmaRestriction[n][i]);
                if (j == 0) {
                    this.currentLowLim[n][i][j].addRestriction(this.tmaAndAtmaRestriction[n][i]);
                }
                this.currentLowLim[n][i][j].addRestriction(this.sectorUsedRestriction[n]);
                this.addParameter(this.currentLowLim[n][i][j]);
                string2 = string + "currentHighLim" + branch[i * 2 + j % 2];
                integerRange = j == 0 ? new IntegerRange(MimExternalTma.MIN_CURRENTHIGHLIMA, MimExternalTma.MAX_CURRENTHIGHLIMA) : new IntegerRange(MimExternalTma.MIN_CURRENTHIGHLIMB, MimExternalTma.MAX_CURRENTHIGHLIMB);
                this.currentHighLim[n][i][j] = new IntegerParameter(string2, integerRange);
                this.currentHighLim[n][i][j].setDefaultValue("180");
                this.currentHighLim[n][i][j].addRestriction(this.tmaRestriction[n][i]);
                if (j == 0) {
                    this.currentHighLim[n][i][j].addRestriction(this.tmaAndAtmaRestriction[n][i]);
                }
                this.currentHighLim[n][i][j].addRestriction(this.sectorUsedRestriction[n]);
                this.addParameter(this.currentHighLim[n][i][j]);
            }
        }
    }

    protected void initAntennaMois(int n, boolean bl) {
        int n2;
        int n3;
        MoInstance moInstance = this.rbs.getEquipmentMoi();
        MoInstance moInstance2 = this.rbs.getNodeBFunctionMoi();
        int n4 = SectorUtil.getSectorNumberFromSectorIndex(n, this.startingSectorNumber);
        this.sectorMois[n] = new FixedRdnMoi(moInstance2, MimSector.MOTYPENAME, this.sectorRdns[n4 - 1]);
        for (n3 = 0; n3 < 3; ++n3) {
            this.sectorAntennaMois[n][n3] = new SectorAntennaMoi(moInstance, this.sectorMois[n], n4, n3 + 1);
            for (n2 = 2; n2 <= this.maxSequenceNumber; ++n2) {
                this.externalAntennaMois[n][n3][n2 - 2] = new FixedRdnMoi(moInstance, MimExternalAntenna.MOTYPENAME, "" + n4 + "-" + (n3 + 1) + "-" + n2);
            }
        }
        n3 = this.getNumberOfBranchesPerSectorAntenna(n4, bl);
        for (n2 = 0; n2 < branch.length; ++n2) {
            this.antennaBranchMois[n][n2] = new ChildWithAttributeValues(this.sectorAntennaMois[n][n2 / n3], MimAntennaBranch.MOTYPENAME, "branchName", branch[n2], branch[n2]);
        }
        for (n2 = 0; n2 < 3; ++n2) {
            this.tmaMois[n][n2] = new SingleChildMoi(this.sectorAntennaMois[n][n2], MimExternalTma.MOTYPENAME, AUTO_CREATED_RDNID_1);
            this.ascAuxPiuMois[n][n2] = new ChildWithAttributeValues(this.sectorAntennaMois[n][n2], MimAuxPlugInUnit.MOTYPENAME, "auType", new Integer(5), AUTO_CREATED_RDNID_1);
            this.ascMois[n][n2] = new SingleChildMoi(this.ascAuxPiuMois[n][n2], MimAscDeviceGroup.MOTYPENAME, AUTO_CREATED_RDNID_1);
            this.atmauAuxPiuMois[n][n2] = new ChildWithAttributeValues(this.sectorAntennaMois[n][n2], MimAuxPlugInUnit.MOTYPENAME, "auType", new Integer(17), AUTO_CREATED_RDNID_1);
            this.atmauMois[n][n2] = new SingleChildMoi(this.atmauAuxPiuMois[n][n2], MimDeviceGroup.MOTYPENAME, ATMAU_STRING);
            this.tmfAuxPiuMois[n][n2] = new ChildWithAttributeValues(this.sectorAntennaMois[n][n2], MimAuxPlugInUnit.MOTYPENAME, "auType", new Integer(25), AUTO_CREATED_RDNID_1);
            this.tmfMois[n][n2] = new SingleChildMoi(this.tmfAuxPiuMois[n][n2], MimDeviceGroup.MOTYPENAME, TMF_STRING);
            this.tmaDeviceSetMois[n][n2] = new SingleChildMoi(this.atmauMois[n][n2], MimTmaDeviceSet.MOTYPENAME, AUTO_CREATED_RDNID_1);
            this.tmfDeviceSetMois[n][n2] = new SingleChildMoi(this.tmfMois[n][n2], MimTmaDeviceSet.MOTYPENAME, AUTO_CREATED_RDNID_1);
        }
    }

    public void addNumberOfRxBranchesListener(int n) {
        CustomerParameter[] customerParameterArray = this.cellCarrP.getNumOfRxBranchesPerCarrierParameter(n);
        for (int i = 0; i < customerParameterArray.length; ++i) {
            customerParameterArray[i].addCustomerParameterListener(this.numberOfRxBranchesListeners[SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber)][i]);
        }
    }

    public void removeAllNumberOfRxBranchesListener(int n) {
        CustomerParameter[] customerParameterArray = this.cellCarrP.getNumOfRxBranchesPerCarrierParameter(n);
        for (int i = 0; i < customerParameterArray.length; ++i) {
            customerParameterArray[i].removeCustomerParameterListener(this.numberOfRxBranchesListeners[SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber)][i]);
        }
    }

    public void initialiseMoiResources() throws BemException {
        this.antFeederMois = new MoInstance[this.maxNoOfSectors][branch.length][2];
        this.antennaBranchMois = new MoInstance[this.maxNoOfSectors][branch.length];
        this.ascAuxPiuMois = new MoInstance[this.maxNoOfSectors][3];
        this.ascMois = new MoInstance[this.maxNoOfSectors][3];
        this.optLinkDlMois = new MoInstance[this.maxNoOfSectors];
        this.optLinkUlMois = new MoInstance[this.maxNoOfSectors];
        this.rruAuxPiuMois = new MoInstance[this.maxNoOfSectors];
        this.rruMois = new MoInstance[this.maxNoOfSectors];
        this.sectorAntennaMois = new MoInstance[this.maxNoOfSectors][3];
        this.sectorMois = new MoInstance[this.maxNoOfSectors];
        this.tmaMois = new MoInstance[this.maxNoOfSectors][3];
        this.atmauAuxPiuMois = new MoInstance[this.maxNoOfSectors][3];
        this.atmauMois = new MoInstance[this.maxNoOfSectors][3];
        this.tmfMois = new MoInstance[this.maxNoOfSectors][3];
        this.tmfAuxPiuMois = new MoInstance[this.maxNoOfSectors][3];
        this.tmaDeviceSetMois = new MoInstance[this.maxNoOfSectors][3];
        this.tmfDeviceSetMois = new MoInstance[this.maxNoOfSectors][3];
        this.externalAntennaMois = new MoInstance[this.maxNoOfSectors][3][this.maxSequenceNumber];
        this.retCic.initialiseMoiResources();
        int[] nArray = this.radioEP.getEquippedSectors();
        for (int i = 0; i < nArray.length; ++i) {
            int n = SectorUtil.getSectorIndexFromSectorNumber(nArray[i], this.startingSectorNumber);
            this.initAntennaMois(n, false);
            this.initialiseMoiResources(n);
        }
    }

    protected void createCustomerParameters(String string, int n) throws BemException {
        this.retCic.createCustomerParameters(string, n);
    }

    protected abstract void updateSectorParameters(int var1, boolean var2) throws BemException;

    protected abstract void initialiseMoiResources(int var1) throws BemException;

    protected abstract void initialiseMoiResources(int var1, boolean var2) throws BemException;

    private List getRIsToInstall() throws BemException {
        ArrayList<AbstractResourceItem> arrayList = new ArrayList<AbstractResourceItem>();
        int[] nArray = this.radioEP.getEquippedSectors();
        boolean bl = false;
        for (int i = 0; i < nArray.length; ++i) {
            int n;
            int n2 = nArray[i];
            int n3 = SectorUtil.getSectorIndexFromSectorNumber(n2, this.startingSectorNumber);
            if (this.cellCarrP.isSectorInUse(n2)) {
                AbstractResourceItem abstractResourceItem;
                Object object;
                Object object2;
                String string;
                List list = this.getAntennaFeederRIs(n3, false);
                arrayList.addAll(list);
                if (this.canHaveTma) {
                    n = this.getNumOfSectorAntennas(n2);
                    for (int j = 0; j < n; ++j) {
                        string = AbstractAntennaSystemCI.getSectorPrefix(n2);
                        object2 = this.rbs.getCustomerParameterObject(BemUtil.getCustomerParameterName(string, "tmaType", j + 1));
                        object = object2.getValue();
                        if (((String)object).equals(TMA_STRING)) {
                            abstractResourceItem = this.tma[n3][j];
                            arrayList.add(abstractResourceItem);
                            continue;
                        }
                        if (((String)object).equals(ASC_STRING)) {
                            abstractResourceItem = this.asc[n3][j];
                            arrayList.add(abstractResourceItem);
                            continue;
                        }
                        if (((String)object).equals(ATMA_STRING)) {
                            abstractResourceItem = this.atmau[n3][j];
                            arrayList.add(abstractResourceItem);
                            continue;
                        }
                        if (((String)object).equals(ATMA_AND_TMA_STRING)) {
                            abstractResourceItem = this.tma[n3][j];
                            arrayList.add(abstractResourceItem);
                            abstractResourceItem = this.atmau[n3][j];
                            arrayList.add(abstractResourceItem);
                            continue;
                        }
                        if (!((String)object).equals(TMF_STRING)) continue;
                        this.tmf[n3][j].setPsiConfiguration(this.isPsiConfiguration(n3));
                        abstractResourceItem = this.tmf[n3][j];
                        arrayList.add(abstractResourceItem);
                    }
                }
                if (this.canHaveRadioDot(n2)) {
                    for (n = 0; n < MAX_NO_OF_RADIO_DOT_PER_SECTOR; ++n) {
                        String string2 = PrefixUtil.getRadioDotPrefix(n2, n + 1);
                        string = string2 + "AddRadioDot";
                        object2 = string2 + "DeleteRadioDot";
                        if (this.isParameterSupported(string) && (object = this.rbs.getCustomerParameterObject(string)) != null && object.getValue().equals("YES")) {
                            bl = true;
                            break;
                        }
                        if (!this.isParameterSupported((String)object2) || (object = this.rbs.getCustomerParameterObject((String)object2)) == null || !object.getValue().equals("YES")) continue;
                        bl = true;
                        break;
                    }
                    for (n = 0; n < MAX_NO_OF_RADIO_DOT_PER_SECTOR; ++n) {
                        String string3 = PrefixUtil.getRadioDotPrefix(n2, n + 1);
                        string = string3 + "AddRadioDot";
                        if (this.isParameterSupported(string) && (object2 = this.rbs.getCustomerParameterObject(string)) != null && object2.getValue().equals("YES")) {
                            abstractResourceItem = this.radioDot[n3][n];
                            arrayList.add(abstractResourceItem);
                            abstractResourceItem = this.rdiCable[n3][n];
                            arrayList.add(abstractResourceItem);
                        }
                        if (bl) continue;
                        abstractResourceItem = this.radioDot[n3][n];
                        arrayList.add(abstractResourceItem);
                        abstractResourceItem = this.rdiCable[n3][n];
                        arrayList.add(abstractResourceItem);
                    }
                }
            }
            int n4 = this.getNumOfSupportedAntennaBranches(n2);
            for (int j = 0; j < n4; ++j) {
                if (this.initiateAntFeederCableVector[n3][j].size() <= 0) continue;
                this.updateAntFeederParameters();
                for (n = 0; n < this.antennaFeeder[n3][j].length; ++n) {
                    AntennaFeederRI antennaFeederRI = this.antennaFeeder[n3][j][n];
                    if (antennaFeederRI == null || arrayList.contains(antennaFeederRI)) continue;
                    arrayList.add(antennaFeederRI);
                }
            }
        }
        return arrayList;
    }

    public void updateAntFeederParameters() throws BemException {
    }

    public void updateSectorAntennaParameters() throws BemException {
    }

    public void updateCustomerParametersForAIR(int n) throws BemException {
        CustomerParameter customerParameter;
        int n2;
        String string = "";
        String string2 = AbstractAntennaSystemCI.getSectorPrefix(n);
        for (n2 = 0; n2 < 3; ++n2) {
            string = BemUtil.getCustomerParameterName(string2, "antennaType", n2 + 1);
            if (this.rbs.isParameterSupported(string)) {
                customerParameter = this.rbs.getCustomerParameterObject(string);
                if (AIRUtil.getInstance(this.rbs).isAirConfigured(n)) {
                    customerParameter.setValue(MimSectorAntenna.MIN_ANTENNATYPE.toString());
                }
            }
            if (!this.rbs.isParameterSupported(string = BemUtil.getCustomerParameterName(string2, "tmaType", n2 + 1))) continue;
            customerParameter = this.rbs.getCustomerParameterObject(string);
            if (!AIRUtil.getInstance(this.rbs).isAirConfigured(n)) continue;
            customerParameter.setValue(NONE_STRING);
        }
        string = BemUtil.getCustomerParameterName(string2 + AbstractAntennaSystemCI.getSequencePrefix(1), "antennaType", 1);
        if (this.rbs.isParameterSupported(string) && null != (customerParameter = this.rbs.getCustomerParameterObject(string)) && AIRUtil.getInstance(this.rbs).isAirConfigured(n)) {
            customerParameter.setValue(MimSectorAntenna.MIN_ANTENNATYPE.toString());
        }
        if (AIRUtil.getInstance(this.rbs).isAirConfigured(n)) {
            for (n2 = 0; n2 < ServiceCommon.BRANCH_NAMES.length; ++n2) {
                if (AIRUtil.getInstance(this.rbs).isRbb111AWithAir(n) && (!AIRUtil.getInstance(this.rbs).isRbb111AWithAir(n) || n2 != 0)) continue;
                for (int i = 0; i < FEEDER_ATTRIBUTES_FOR_AIR.length; ++i) {
                    string = string2 + FEEDER_ATTRIBUTES_FOR_AIR[i] + ServiceCommon.BRANCH_NAMES[n2];
                    if (!this.rbs.isParameterSupported(string)) continue;
                    customerParameter = this.rbs.getCustomerParameterObject(string);
                    customerParameter.setValue("0");
                }
            }
        }
    }

    public List getUninstallRIsForBranch(int n, int n2) {
        ArrayList<AbstractResourceItem> arrayList = new ArrayList<AbstractResourceItem>();
        Vector vector = null;
        Vector vector2 = null;
        AntennaBranchRI antennaBranchRI = null;
        AntennaFeederRI[] antennaFeederRIArray = null;
        int n3 = SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber);
        vector = this.uninitiateAntennaBranchVector[n3][n2];
        vector2 = this.uninitiateAntFeederCableVector[n3][n2];
        antennaBranchRI = this.antennaBranch[n3][n2];
        antennaFeederRIArray = this.antennaFeeder[n3][n2];
        if (vector.size() > 0) {
            arrayList.add(antennaBranchRI);
        }
        if (vector2.size() > 0) {
            for (int i = 0; i < antennaFeederRIArray.length; ++i) {
                if (antennaFeederRIArray[i] == null) continue;
                arrayList.add(antennaFeederRIArray[i]);
            }
        }
        return arrayList;
    }

    private List getUninstallRIs() throws BemException {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.retCic.getRIsToUninstall());
        int[] nArray = this.radioEP.getEquippedSectors();
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            int n2 = this.getLoadedNumOfSupportedAntennaBranches(n);
            for (int j = 0; j < n2; ++j) {
                arrayList.addAll(this.getUninstallRIsForBranch(n, j));
            }
        }
        return arrayList;
    }

    private void addExternalAntennas() throws BemException {
        if (this.cascadedAretActions.isEmpty()) {
            return;
        }
        Iterator<Object> iterator = this.cascadedAretActions.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = this.cascadedAretActions.getProperty(string);
            if (!string2.equals(MODIFICATION_TYPE_ADD)) continue;
            int[] nArray = this.extractSectorAndSequenceAndSA(string);
            int n = nArray[0];
            int n2 = nArray[1];
            int n3 = nArray[2];
            int n4 = SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber);
            if (n2 <= 1 || this.antennaTypeCascadedParam[n4][n3 - 1][n2 - 1].getLoadedValue().equals("##UNDEFINED") && this.retCic.uniqueHwIdCascadedParam[n4][n3 - 1][n2 - 1].getLoadedValue().equals("##UNDEFINED") && this.retCic.elTiltCascadedParam[n4][n3 - 1][n2 - 1].getLoadedValue().equals("##UNDEFINED")) continue;
            throw new BemException("External Antenna in sector " + n + ", sequence " + n2 + " can not be added since an External Antenna already exists in that position.");
        }
    }

    private List getDeleteAndChangeExternalAntennasRIs() throws BemException {
        ArrayList<AbstractResourceItem> arrayList = new ArrayList<AbstractResourceItem>();
        this.unInitSectorsExternalAntenna = new boolean[this.maxNoOfSectors];
        for (int i = 0; i < this.maxNoOfSectors; ++i) {
            this.unInitSectorsExternalAntenna[i] = false;
        }
        if (this.cascadedAretActions.isEmpty()) {
            return arrayList;
        }
        String[] stringArray = new String[]{"antennaType", "uniqueHwId", "electricalTilt", "userLabel"};
        Iterator<Object> iterator = this.cascadedAretActions.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = this.cascadedAretActions.getProperty(string);
            int[] nArray = this.extractSectorAndSequenceAndSA(string);
            int n = nArray[0];
            int n2 = nArray[2] - 1;
            int n3 = SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber);
            if (!string2.equals(MODIFICATION_TYPE_ADD)) {
                int n4 = nArray[1];
                boolean bl = true;
                if (this.antennaTypeCascadedParam[n3][n2][n4 - 1].getLoadedValue().equals("##UNDEFINED") && this.retCic.uniqueHwIdCascadedParam[n3][n2][n4 - 1].getLoadedValue().equals("##UNDEFINED") && this.retCic.elTiltCascadedParam[n3][n2][n4 - 1].getLoadedValue().equals("##UNDEFINED")) {
                    bl = false;
                }
                if (string2.equals(MODIFICATION_TYPE_DELETE)) {
                    if (!bl) {
                        throw new BemException("External Antenna in sector " + n + ", sequence " + n4 + " can not be deleted since no External Antenna can be found in that position.");
                    }
                    String string3 = string.substring(0, string.indexOf("SA"));
                    String string4 = n2 > 0 ? Integer.toString(n2 + 1) : "";
                    CustomerParameter customerParameter = this.rbs.getCustomerParameterObject(string3 + stringArray[0] + string4);
                    this.rbs.unRegisterCustomerParameter(customerParameter);
                    customerParameter = this.rbs.getCustomerParameterObject(string3 + stringArray[1] + string4);
                    this.rbs.unRegisterCustomerParameter(customerParameter);
                    customerParameter = this.rbs.getCustomerParameterObject(string3 + stringArray[2] + string4);
                    this.rbs.unRegisterCustomerParameter(customerParameter);
                    if (n4 > 1) {
                        arrayList.add(this.externalAntenna[n3][n2][n4 - 2]);
                    }
                    arrayList.add(this.retCic.aretuCascade[n3][n2][n4 - 1]);
                    this.unInitSectorsExternalAntenna[n3] = true;
                    continue;
                }
                if (!string2.equals(MODIFICATION_TYPE_CHANGE)) continue;
                if (!bl) {
                    throw new BemException("External Antenna in sector " + n + ", sectorAntenna" + n2 + ", sequence " + n4 + " can not be changed since no External Antenna can be found in that position.");
                }
                if (n4 > 1) {
                    arrayList.add(this.externalAntenna[n3][n2][n4 - 2]);
                }
                arrayList.add(this.retCic.aretuCascade[n3][n2][n4 - 1]);
                this.unInitSectorsExternalAntenna[n3] = true;
                continue;
            }
            this.unInitSectorsExternalAntenna[n3] = true;
        }
        return arrayList;
    }

    protected int[] extractSectorAndSequenceAndSA(String string) {
        int n = 1;
        int n2 = string.indexOf("_SEQ");
        int n3 = n2 + "_SEQ".length();
        int n4 = string.indexOf("SA") - 1;
        int n5 = n4 + "SA".length() + 1;
        int n6 = string.length();
        String string2 = string.substring(n, n2);
        String string3 = string.substring(n3, n4);
        String string4 = string.substring(n5, n6);
        int n7 = new Integer(string2);
        int n8 = new Integer(string3);
        int n9 = new Integer(string4);
        return new int[]{n7, n8, n9};
    }

    private String[] getModelPseudos() {
        String[] stringArray = new String[]{};
        String[] stringArray2 = BemUtil.concat(this.canHaveRet ? modelPseudosRet : stringArray, this.canHaveTma ? modelPseudosTma : stringArray, modelPseudosFeeder);
        return stringArray2;
    }

    protected abstract String[] getSectorRdns() throws BemException;

    protected abstract ConfigurationCheckReport checkConfiguration(ConfigurationCheckReport var1) throws BemException;

    protected boolean checkConsistency(int n) throws CustomerParameterException {
        if (!this.retCic.checkConsistency(n)) {
            return false;
        }
        try {
            if (this.sectorExist(n) && this.sectorEquipped(n)) {
                int n2 = SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber);
                int n3 = this.getNumOfSectorAntennas(n);
                for (int i = 0; i < n3; ++i) {
                    boolean bl;
                    if (this.tmaParam[n2][i] == null) continue;
                    String string = this.tmaParam[n2][i].getValue();
                    String string2 = this.tmaParam[n2][i].getLoadedValue();
                    if (string2.equals(string) || (bl = this.cellCarrP.areCellsOffline(n))) continue;
                    return false;
                }
            }
        }
        catch (BemException bemException) {
            throw new CustomerParameterException(bemException.toString(), null);
        }
        return true;
    }

    private void checkULFeederParams(int[] nArray, List list) throws BemException {
        for (int i = 0; i < nArray.length; ++i) {
            String string;
            int n = SectorUtil.getSectorIndexFromSectorNumber(nArray[i], this.startingSectorNumber);
            if (this.bandParam[n] == null || !(string = this.bandParam[n].getValue()).equals(this.bandType32)) continue;
            this.checkULFeederParameterAval4Band32(list, n, this.ulFeederAttParam);
            this.checkULFeederParameterAval4Band32(list, n, this.ulFeederDelayParam);
        }
    }

    private void checkULFeederParameterAval4Band32(List list, int n, ListParameter[][] listParameterArray) throws BemException {
        for (int i = 0; i < branch.length; ++i) {
            if (!list.contains(listParameterArray[n][i].getName())) continue;
            this.checkULParamerAval4Band32(n, i, listParameterArray);
        }
    }

    private void checkULParamerAval4Band32(int n, int n2, ListParameter[][] listParameterArray) throws BemException {
        String string = listParameterArray[n][n2].getValue();
        if (string.equals("##UNDEFINED")) {
            return;
        }
        int n3 = 0;
        if (string.indexOf(",") == -1 && !string.equals("0") && !string.equals("-1")) {
            throw new BemException("Band type 32 not support this ulFeederParam" + string);
        }
        while (true) {
            String string2;
            int n4;
            if ((n4 = string.indexOf(",", n3)) == -1) {
                string2 = string.substring(n3, string.length()).trim();
                if (string2.equals("0") || string2.equals("-1")) break;
                throw new BemException("Band type 32 not support this ulFeederParam" + string);
            }
            string2 = string.substring(n3, n4).trim();
            if (!string2.equals("0") && !string2.equals("-1")) {
                throw new BemException("Band type 32 not support this ulFeederParam" + string);
            }
            n3 = n4 + 1;
        }
    }

    protected void createSectorRI(int n) throws BemException {
        int n2 = SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber);
        if (this.maxNoOfSectors > 0) {
            this.sectors[n2] = new SectorRI(this.rbs, this.sectorMois[n2].getLdn(), n);
            this.sectors[n2].setLoadedValues();
        }
    }

    protected void createSectorAntennaRI(int n, boolean bl) throws BemException {
        int n2 = bl ? this.getLoadedNumOfSectorAntennas(n) : this.getNumOfSectorAntennas(n);
        int n3 = SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber);
        for (int i = 0; i < n2; ++i) {
            this.sectorAntenna[n3][i] = new SectorAntennaRI(this.rbs, n, this.sectorAntennaMois[n3][i].getLdn(), i + 1);
            this.sectorAntenna[n3][i].setLoadedValues();
        }
    }

    protected void createExternalAntennaRI(int n) throws BemException {
        String string = AbstractAntennaSystemCI.getSectorPrefix(n);
        int n2 = SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber);
        int n3 = SectorUtil.getSectorAntennaNumberWithRetCascading(this.rbs, n);
        for (int i = 0; i < n3; ++i) {
            for (int j = 2; j <= this.maxSequenceNumber; ++j) {
                String string2 = AbstractAntennaSystemCI.getSequencePrefix(j);
                this.externalAntenna[n2][i][j - 2] = new ExternalAntennaRI(this.rbs, string + string2, this.externalAntennaMois[n2][i][j - 2].getLdn(), this.sectorMois[n2].getLdn(), this.sectorAntennaMois[n2][i].getLdn(), i + 1);
                this.externalAntenna[n2][i][j - 2].setLoadedValues();
            }
        }
    }

    protected void createAntennaBranchRI(int n, boolean bl) throws BemException {
        if (this.antennaBranch == null) {
            this.antennaBranch = new AntennaBranchRI[this.maxNoOfSectors][branch.length];
        }
        String string = AbstractAntennaSystemCI.getSectorPrefix(n);
        int n2 = bl ? this.getLoadedNumOfSectorAntennas(n) : this.getNumOfSectorAntennas(n);
        int n3 = SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber);
        for (int i = 0; i < n2; ++i) {
            int n4 = this.getNumberOfBranchesPerSectorAntenna(n, bl);
            for (int j = 0; j < n4; ++j) {
                this.antennaBranch[n3][i * n4 + j] = new AntennaBranchRI(this.rbs, string, branch[i * n4 + j], this.radioEP, n, this.antennaBranchMois[n3][i * n4 + j].getLdn());
                this.antennaBranch[n3][i * n4 + j].setLoadedValues();
            }
        }
    }

    protected void createTmaRI(int n) throws BemException {
        if (this.tma == null) {
            this.tma = new TmaRI[this.maxNoOfSectors][3];
        }
        int n2 = SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber);
        String string = AbstractAntennaSystemCI.getSectorPrefix(n);
        int n3 = this.getNumOfSectorAntennas(n);
        for (int i = 0; i < n3; ++i) {
            this.tma[n2][i] = new TmaRI(this.rbs, string, this.tmaMois[n2][i].getLdn(), i + 1);
            this.tma[n2][i].setLoadedValues();
            if (!this.tma[n2][i].isInstalled()) continue;
            if (this.tmaParam[n2][i].getLoadedValue().equals(ATMA_STRING)) {
                this.tmaParam[n2][i].setLoadedValue(ATMA_AND_TMA_STRING);
                continue;
            }
            this.tmaParam[n2][i].setLoadedValue(TMA_STRING);
        }
    }

    protected String getAscAtfRole(int n) throws BemException {
        return AtfProvider.ALL_CONTROLLERS_OF_ASC_INDEXED_BY_SECTOR[n];
    }

    protected void createAscRI(int n) throws BemException {
        if (this.asc == null) {
            this.asc = new AscRI[this.maxNoOfSectors][3];
        }
        int n2 = SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber);
        String string = this.getAscAtfRole(n);
        int n3 = this.getNumOfSectorAntennas(n);
        for (int i = 0; i < n3; ++i) {
            this.asc[n2][i] = new AscRI(this.rbs, this.ascMois[n2][i].getLdn(), string);
            if (!this.asc[n2][i].isInstalled()) continue;
            this.tmaParam[n2][i].setLoadedValue(ASC_STRING);
        }
    }

    protected String getAtmauAtfRole(int n) throws BemException {
        return AtfProvider.ALL_CONTROLLERS_OF_ASC_INDEXED_BY_SECTOR[n];
    }

    protected void createAtmauRI(int n) throws BemException {
        if (this.atmau == null) {
            this.atmau = new AtmauRI[this.maxNoOfSectors][3];
        }
        int n2 = SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber);
        String string = this.getAtmauAtfRole(n);
        int n3 = this.getNumOfSectorAntennas(n);
        for (int i = 0; i < n3; ++i) {
            String string2 = AbstractAntennaSystemCI.getSectorPrefix(n);
            this.atmau[n2][i] = new AtmauRI(this.rbs, string2, this.atmauMois[n2][i].getLdn(), this.tmaDeviceSetMois[n2][i].getLdn(), string, n, i + 1);
            if (!this.atmau[n2][i].isInstalled()) continue;
            this.atmau[n2][i].setLoadedValues();
            if (this.tmaParam[n2][i].getLoadedValue().equals(TMA_STRING)) {
                this.tmaParam[n2][i].setLoadedValue(ATMA_AND_TMA_STRING);
                continue;
            }
            this.tmaParam[n2][i].setLoadedValue(ATMA_STRING);
        }
    }

    protected String getTmfAtfRole(int n) throws BemException {
        return null;
    }

    protected void createTmfRI(int n) throws BemException {
        if (this.tmf == null) {
            this.tmf = new TmfRI[this.maxNoOfSectors][3];
        }
        int n2 = SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber);
        String string = this.getTmfAtfRole(n);
        int n3 = this.getNumOfSectorAntennas(n);
        for (int i = 0; i < n3; ++i) {
            this.tmf[n2][i] = new TmfRI(this.rbs, this.tmfMois[n2][i].getLdn(), this.tmfDeviceSetMois[n2][i].getLdn(), string, n, i + 1);
            if (!this.tmf[n2][i].isInstalled()) continue;
            this.tmaParam[n2][i].setLoadedValue(TMF_STRING);
        }
    }

    protected void createSiteDataRI() throws BemException {
        this.siteData = new SiteDataRI(this.rbs, this.rbs.getRootMoi().getLdn());
        this.siteData.setLoadedValues();
    }

    public String getSectorLdn(int n) throws BemException {
        String string = SectorUtil.getSectorLdn(n, this.rbs.getNodeBFunctionMoi());
        return string;
    }

    public String getBand(int n) {
        String string = null;
        int n2 = SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber);
        if (this.cellCarrP != null && this.cellCarrP.isSectorInUse(n) && this.bandParam[n2] != null) {
            string = this.bandParam[n2].getValue();
        }
        return string;
    }

    public int getDuwSlotNumbers() {
        if (this.rbs.isPantherHybridRbs() && this.startingSectorNumber == 7) {
            return 1;
        }
        return 0;
    }

    public ConfigurationCheckReport checkConfiguration() throws BemException {
        ConfigurationCheckReport configurationCheckReport = new ConfigurationCheckReport();
        configurationCheckReport = this.checkConfiguration(configurationCheckReport);
        return configurationCheckReport;
    }

    public static String getSectorPrefix(int n) {
        String string = MessageFormat.format("S{0}_", new Integer(n));
        return string;
    }

    public static String getSequencePrefix(int n) {
        String string = MessageFormat.format("SEQ{0}_", new Integer(n));
        return string;
    }

    protected static String getCellPrefix(int n) {
        String string = MessageFormat.format("C{0}_", new Integer(n));
        return string;
    }

    private void setULFeederParamsDefaultValue(int n, int n2) {
        if (n == Integer.parseInt(this.bandType32)) {
            for (int i = 0; i < branch.length; ++i) {
                this.ulFeederAttParam[n2][i].setValue(this.ulCPDefaultValue);
                this.ulFeederDelayParam[n2][i].setValue(this.ulCPDefaultValue);
            }
        }
    }

    private void setFrequencys(int n, int n2) {
        if (this.fqHiEdgeParam[n2][0] != null) {
            for (int i = 0; i < branch.length; ++i) {
                this.fqHiEdgeParam[n2][i].setValue("");
                this.fqLoEdgeParam[n2][i].setValue("");
            }
        }
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                this.fqBandHighEdgeRangeRestriction[n2].setRange(this.BAND1_RANGE_HIGH_EDGE, true);
                this.fqBandLowEdgeRangeRestriction[n2].setRange(this.BAND1_RANGE_LOW_EDGE, true);
                break;
            }
            case 2: {
                this.fqBandHighEdgeRangeRestriction[n2].setRange(this.BAND2_RANGE_HIGH_EDGE, true);
                this.fqBandLowEdgeRangeRestriction[n2].setRange(this.BAND2_RANGE_LOW_EDGE, true);
                break;
            }
            case 3: {
                this.fqBandHighEdgeRangeRestriction[n2].setRange(this.BAND3_RANGE_HIGH_EDGE, true);
                this.fqBandLowEdgeRangeRestriction[n2].setRange(this.BAND3_RANGE_LOW_EDGE, true);
                break;
            }
            case 4: {
                this.fqBandHighEdgeRangeRestriction[n2].setRange(this.BAND4_RANGE_HIGH_EDGE, true);
                this.fqBandLowEdgeRangeRestriction[n2].setRange(this.BAND4_RANGE_LOW_EDGE, true);
                break;
            }
            case 5: {
                this.fqBandHighEdgeRangeRestriction[n2].setRange(this.BAND5_RANGE_HIGH_EDGE, true);
                this.fqBandLowEdgeRangeRestriction[n2].setRange(this.BAND5_RANGE_LOW_EDGE, true);
                break;
            }
            case 6: {
                this.fqBandHighEdgeRangeRestriction[n2].setRange(this.BAND6_RANGE_HIGH_EDGE, true);
                this.fqBandLowEdgeRangeRestriction[n2].setRange(this.BAND6_RANGE_LOW_EDGE, true);
                break;
            }
            case 7: {
                this.fqBandHighEdgeRangeRestriction[n2].setRange(this.BAND7_RANGE_HIGH_EDGE, true);
                this.fqBandLowEdgeRangeRestriction[n2].setRange(this.BAND7_RANGE_LOW_EDGE, true);
                break;
            }
            case 8: {
                this.fqBandHighEdgeRangeRestriction[n2].setRange(this.BAND8_RANGE_HIGH_EDGE, true);
                this.fqBandLowEdgeRangeRestriction[n2].setRange(this.BAND8_RANGE_LOW_EDGE, true);
                break;
            }
            case 9: {
                this.fqBandHighEdgeRangeRestriction[n2].setRange(this.BAND9_RANGE_HIGH_EDGE, true);
                this.fqBandLowEdgeRangeRestriction[n2].setRange(this.BAND9_RANGE_LOW_EDGE, true);
                break;
            }
            case 10: {
                this.fqBandHighEdgeRangeRestriction[n2].setRange(this.BAND10_RANGE_HIGH_EDGE, true);
                this.fqBandLowEdgeRangeRestriction[n2].setRange(this.BAND10_RANGE_LOW_EDGE, true);
                break;
            }
            case 11: {
                this.fqBandHighEdgeRangeRestriction[n2].setRange(this.BAND11_RANGE_HIGH_EDGE, true);
                this.fqBandLowEdgeRangeRestriction[n2].setRange(this.BAND11_RANGE_LOW_EDGE, true);
                break;
            }
            case 12: {
                this.fqBandHighEdgeRangeRestriction[n2].setRange(this.BAND12_RANGE_HIGH_EDGE, true);
                this.fqBandLowEdgeRangeRestriction[n2].setRange(this.BAND12_RANGE_LOW_EDGE, true);
                break;
            }
            case 13: {
                this.fqBandHighEdgeRangeRestriction[n2].setRange(this.BAND13_RANGE_HIGH_EDGE, true);
                this.fqBandLowEdgeRangeRestriction[n2].setRange(this.BAND13_RANGE_LOW_EDGE, true);
                break;
            }
            case 14: {
                this.fqBandHighEdgeRangeRestriction[n2].setRange(this.BAND14_RANGE_HIGH_EDGE, true);
                this.fqBandLowEdgeRangeRestriction[n2].setRange(this.BAND14_RANGE_LOW_EDGE, true);
                break;
            }
            case 19: {
                this.fqBandHighEdgeRangeRestriction[n2].setRange(this.BAND19_RANGE_HIGH_EDGE, true);
                this.fqBandLowEdgeRangeRestriction[n2].setRange(this.BAND19_RANGE_LOW_EDGE, true);
                break;
            }
            case 20: {
                this.fqBandHighEdgeRangeRestriction[n2].setRange(this.BAND20_RANGE_HIGH_EDGE, true);
                this.fqBandLowEdgeRangeRestriction[n2].setRange(this.BAND20_RANGE_LOW_EDGE, true);
                break;
            }
            case 21: {
                this.fqBandHighEdgeRangeRestriction[n2].setRange(this.BAND21_RANGE_HIGH_EDGE, true);
                this.fqBandLowEdgeRangeRestriction[n2].setRange(this.BAND21_RANGE_LOW_EDGE, true);
                break;
            }
            case 32: {
                this.fqBandHighEdgeRangeRestriction[n2].setRange(this.BAND32_RANGE_HIGH_EDGE, true);
                this.fqBandLowEdgeRangeRestriction[n2].setRange(this.BAND32_RANGE_LOW_EDGE, true);
                break;
            }
        }
    }

    public void setTmaTypeRangeRestriction(int n) {
        int n2 = SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber);
        if (this.isPsiConfiguration(n2)) {
            for (int i = 0; i < 3; ++i) {
                String[] stringArray = new String[2];
                stringArray[0] = NONE_STRING;
                stringArray[1] = TMF_STRING;
                this.tmaTypeRangeRestriction[n2][i].setRange(Enumeration.newEnumeratedValueRange(stringArray), true);
            }
        } else if (this.radioEP.isExternalOutputPowerUsed()) {
            this.tmaTypeRangeRestriction[n2][0].setRange(Enumeration.newEnumeratedValueRange(new String[]{NONE_STRING, TMA_STRING, ATMA_STRING, ATMA_AND_TMA_STRING, TMF_STRING}), true);
            this.tmaTypeRangeRestriction[n2][1].setRange(Enumeration.newEnumeratedValueRange(new String[]{NONE_STRING, TMA_STRING, ATMA_STRING, TMF_STRING}), true);
        } else {
            this.tmaTypeRangeRestriction[n2][0].setRange(Enumeration.newEnumeratedValueRange(new String[]{NONE_STRING, TMA_STRING, ASC_STRING, ATMA_STRING, ATMA_AND_TMA_STRING, TMF_STRING}), true);
            this.tmaTypeRangeRestriction[n2][1].setRange(Enumeration.newEnumeratedValueRange(new String[]{NONE_STRING, TMA_STRING, ASC_STRING, ATMA_STRING, TMF_STRING}), true);
        }
    }

    public void setTmaTypeRangeRestriction(int n, int n2, EnumeratedRange enumeratedRange) {
        this.tmaTypeRangeRestriction[SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber)][n2 - 1].setRange(enumeratedRange, true);
    }

    public void setAntennaFeederCPsRestriction(int n) {
        int n2 = SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber);
        if (this.dlFeederAttParam[n2][0] != null) {
            this.clearRestrictionForAntennaFeederCPs(n);
            int n3 = this.getNumOfSupportedAntennaBranches(n);
            for (int i = 0; i < branch.length; ++i) {
                this.dlFeederAttParam[n2][i].addRestriction(this.sectorUsedRestriction[n2]);
                this.ulFeederAttParam[n2][i].addRestriction(this.sectorUsedRestriction[n2]);
                this.dlFeederDelayParam[n2][i].addRestriction(this.sectorUsedRestriction[n2]);
                this.ulFeederDelayParam[n2][i].addRestriction(this.sectorUsedRestriction[n2]);
                if (i < n3) {
                    this.dlFeederAttParam[n2][i].addRestriction(this.requiredRestriction[n2]);
                    this.ulFeederAttParam[n2][i].addRestriction(this.requiredRestriction[n2]);
                    this.dlFeederDelayParam[n2][i].addRestriction(this.requiredRestriction[n2]);
                    this.ulFeederDelayParam[n2][i].addRestriction(this.requiredRestriction[n2]);
                    continue;
                }
                this.dlFeederAttParam[n2][i].addRestriction(this.sectorAntennaRestriction[n2]);
                this.ulFeederAttParam[n2][i].addRestriction(this.sectorAntennaRestriction[n2]);
                this.dlFeederDelayParam[n2][i].addRestriction(this.sectorAntennaRestriction[n2]);
                this.ulFeederDelayParam[n2][i].addRestriction(this.sectorAntennaRestriction[n2]);
            }
        }
    }

    private void clearRestrictionForAntennaFeederCPs(int n) {
        int n2 = SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber);
        for (int i = 0; i < branch.length; ++i) {
            this.dlFeederAttParam[n2][i].removeAllRestrictions();
            this.ulFeederAttParam[n2][i].removeAllRestrictions();
            this.dlFeederDelayParam[n2][i].removeAllRestrictions();
            this.ulFeederDelayParam[n2][i].removeAllRestrictions();
        }
    }

    public void requestUninitAntennaBranch(int n, String string, Object object) {
        Vector vector = null;
        int n2 = SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber);
        for (int i = 0; i < branch.length; ++i) {
            if (string.equals(branch[i])) {
                vector = this.uninitiateAntennaBranchVector[n2][i];
            }
            if (vector == null || vector.contains(object)) continue;
            vector.add(object);
        }
    }

    public void requestUninitAntFeederCable(int n, String string, Object object) {
        int n2 = SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber);
        for (int i = 0; i < branch.length; ++i) {
            if (!string.equals(branch[i]) || this.uninitiateAntFeederCableVector[n2][i].contains(object)) continue;
            this.uninitiateAntFeederCableVector[n2][i].add(object);
        }
    }

    public void requestInitAntennaBranch(int n, String string, Object object) {
        int n2 = SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber);
        for (int i = 0; i < branch.length; ++i) {
            if (!string.equals(branch[i]) || this.initiateAntennaBranchVector[n2][i].contains(object)) continue;
            this.initiateAntennaBranchVector[n2][i].add(object);
        }
    }

    public void requestInitAntFeederCable(int n, String string, Object object) {
        int n2 = SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber);
        for (int i = 0; i < branch.length; ++i) {
            if (!string.equals(branch[i]) || this.initiateAntFeederCableVector[n2][i].contains(object)) continue;
            this.initiateAntFeederCableVector[n2][i].add(object);
        }
    }

    protected void createNewSetOfAntFeederCableRis(int n) throws BemException {
    }

    public String getConnectedToObjectARef(int n, String string) throws BemException {
        BemMo bemMo = null;
        String string2 = "";
        for (int i = 0; i < branch.length; ++i) {
            if (!string.equals(branch[i])) continue;
            string2 = this.antennaFeeder[SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber)][i][0].getLdn();
        }
        MoHandler moHandler = this.rbs.getMoHandler();
        BemMo bemMo2 = moHandler.getMo(string2);
        try {
            bemMo = (BemMo)moHandler.getAttribute(bemMo2, "connectedToObjectARef");
        }
        catch (MoHandlerException moHandlerException) {
            throw new BemException(this.getClass() + ".getConnectedToObjectARef()", (Throwable)moHandlerException);
        }
        return bemMo.getDN();
    }

    private void loadRadioPositionInfo(int n) throws BemException {
        if (!RbsUtil.isApcLightSupported(this.rbs) || !this.sectorEquipped(n)) {
            return;
        }
        AbstractRuRI[] abstractRuRIArray = this.radioEP.getSectorRadioUnits(n);
        if (null == abstractRuRIArray || !SectorUtil.isPositionConfigurationSupported(this.rbs, n)) {
            return;
        }
        for (int i = 0; i < abstractRuRIArray.length; ++i) {
            abstractRuRIArray[i].setPosPrefix(PrefixUtil.getPosPrefix(n, "RadioUnit", i + 1));
            abstractRuRIArray[i].loadPositionInfo();
        }
    }

    private void setPositionCustomerParameters(ServiceValue serviceValue) throws BemException {
        String string;
        ServiceNameValue serviceNameValue;
        if (!RbsUtil.isApcLightSupported(this.rbs)) {
            return;
        }
        Vector vector = serviceValue.getAllAttributes();
        for (int i = 0; i < vector.size() && null != (serviceNameValue = serviceValue.getAttribute((string = MessageFormat.format("POS_CONFIG{0}_", String.valueOf(i + 1))) + "sectorNumber")); ++i) {
            int n = Integer.parseInt(serviceNameValue.getValueAsString());
            serviceNameValue = serviceValue.getAttribute(string + "unitType");
            String string2 = serviceNameValue.getValueAsString();
            serviceNameValue = serviceValue.getAttribute(string + "unitNumber");
            int n2 = Integer.parseInt(serviceNameValue.getValueAsString());
            serviceNameValue = serviceValue.getAttribute(string + "positionInformation");
            String string3 = "";
            if (null != serviceNameValue) {
                string3 = serviceNameValue.getValueAsString();
            }
            serviceNameValue = serviceValue.getAttribute(string + "hwGroupId");
            String string4 = "";
            if (null != serviceNameValue && serviceNameValue.getValueAsString().length() > 0) {
                string4 = serviceNameValue.getValueAsString();
            }
            String string5 = PrefixUtil.getPosPrefix(n, string2, n2);
            String string6 = string5 + "sectorNumber";
            CustomerParameter customerParameter = this.rbs.getCustomerParameterObject(string6);
            customerParameter.setValue(String.valueOf(n));
            string6 = string5 + "unitType";
            customerParameter = this.rbs.getCustomerParameterObject(string6);
            customerParameter.setValue(string2);
            string6 = string5 + "unitNumber";
            customerParameter = this.rbs.getCustomerParameterObject(string6);
            customerParameter.setValue(String.valueOf(n2));
            string6 = string5 + "positionInformation";
            customerParameter = this.rbs.getCustomerParameterObject(string6);
            customerParameter.setValue(string3);
            string6 = string5 + "hwGroupId";
            customerParameter = this.rbs.getCustomerParameterObject(string6);
            customerParameter.setValue(string4);
        }
    }

    private boolean isSectorAntennaMoExisting(int n, int n2) throws BemException {
        boolean bl = false;
        try {
            MoHandler moHandler = this.rbs.getMoHandler();
            int n3 = SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber);
            if (this.sectorAntennaMois[n3][n2 - 1] != null) {
                BemMo bemMo = moHandler.getMo(this.sectorAntennaMois[n3][n2 - 1].getLdn());
                bl = moHandler.isExisting(bemMo);
            }
        }
        catch (MoHandlerException moHandlerException) {
            Nal.getLog().nalTrace(1, this.getClass(), "MoHandlerException caught. Failed in SectorChangedListener.isSectorAntennaNoExist, sector=" + n + "sector antenna=" + n2, moHandlerException);
        }
        return bl;
    }

    public boolean canHaveRetCascading() {
        if (this.retCic.typeOfRetParam != null) {
            for (int i = 0; i < this.retCic.typeOfRetParam.length; ++i) {
                if (this.retCic.typeOfRetParam[i][0] == null || !this.retCic.typeOfRetParam[i][0].getValue().equals("ARETU_CASCADE") && (!this.retCic.typeOfRetParam[i][1].getValue().equals("ARETU_CASCADE") || !SectorUtil.isRrus32WithRbb441d(this.rbs, i + 1))) continue;
                return true;
            }
        }
        return false;
    }

    public boolean canHaveTma() {
        return this.canHaveTma;
    }

    public boolean isPsiConfiguration(int n) {
        boolean bl = false;
        int n2 = SectorUtil.getSectorNumberFromSectorIndex(n, this.startingSectorNumber);
        int[] nArray = this.radioEP.getSupportedConfiguration(n2);
        if (BemUtil.isIntInArray(1, nArray) && (this.getNumOfSectorAntennas(n2) == 2 || this.getNumOfSectorAntennas(n2) == 3)) {
            bl = true;
        }
        return bl;
    }

    private void updateRiuRestrictions() {
        int[] nArray = this.radioEP.getEquippedSectors();
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.updateRiuRestriction(nArray[i], j + 1);
            }
        }
    }

    protected void updateRiuRestriction(int n, int n2) {
        try {
            EnumeratedRange enumeratedRange;
            int n3 = SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber);
            ParameterRestriction parameterRestriction = this.riuInstalledRestriction[n3][n2 - 1];
            String string = AbstractAntennaSystemCI.getSectorPrefix(n);
            String string2 = "riuInstalled" + (n2 == 1 ? "" : String.valueOf(n2));
            YesNoCustomerParameter yesNoCustomerParameter = (YesNoCustomerParameter)this.rbs.getCustomerParameterObject(string + string2);
            if (!this.canHaveRet || !this.hasRetOnSectorAntenna(n, n2)) {
                enumeratedRange = new EnumeratedRange(new String[]{"NO"});
                yesNoCustomerParameter.setDefaultValue("NO");
                yesNoCustomerParameter.setValue("NO");
            } else if (this.hasAuxUnitWithRetPort(n, n2)) {
                if (this.isRiuOptional(n, n2)) {
                    enumeratedRange = new EnumeratedRange(new String[]{"YES", "NO"});
                    yesNoCustomerParameter.setDefaultValue("NO");
                } else {
                    enumeratedRange = new EnumeratedRange(new String[]{"NO"});
                    yesNoCustomerParameter.setValue("NO");
                    yesNoCustomerParameter.setDefaultValue("NO");
                }
            } else {
                enumeratedRange = new EnumeratedRange(new String[]{"YES"});
                yesNoCustomerParameter.setValue("YES");
                yesNoCustomerParameter.setDefaultValue("YES");
            }
            parameterRestriction.setRange(enumeratedRange, true);
        }
        catch (BemException bemException) {
            BemLog.log(2, this.getClass() + "ParameterPropertiesChanged()", bemException);
        }
    }

    private boolean hasRetOnSectorAntenna(int n, int n2) {
        int n3 = SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber);
        String string = this.retCic.typeOfRetParam[n3][n2 - 1].getValue();
        return !string.equals(NONE_STRING);
    }

    private boolean hasAuxUnitWithRetPort(int n, int n2) {
        boolean bl = false;
        if (this.radioEP.isSectorRemote(n) || this.hasAntennaEquipmentWithRetPort(n, n2)) {
            bl = true;
        }
        return bl;
    }

    private boolean hasAntennaEquipmentWithRetPort(int n, int n2) {
        boolean bl = false;
        int n3 = SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber);
        if (this.tmaParam[n3][n2 - 1] == null) {
            return bl;
        }
        String string = this.tmaParam[n3][n2 - 1].getValue();
        if (string.equals(ATMA_STRING) || string.equals(ASC_STRING) || string.equals(TMF_STRING)) {
            bl = true;
        }
        return bl;
    }

    private boolean isRiuOptional(int n, int n2) {
        boolean bl = false;
        if (this.radioEP.isSectorRemote(n) && !this.hasAntennaEquipmentWithRetPort(n, n2)) {
            bl = true;
        }
        return bl;
    }

    public int getMaxNoOfSectorAntennasPerSector() {
        return 3;
    }

    public int getNumOfSupportedAntennaBranches(int n) {
        int n2;
        int n3 = 0;
        if (this.radioEP != null) {
            n2 = this.radioEP.getNumberOfSupportedTxBranches(n);
            n3 = n3 > n2 ? n3 : n2;
            int n4 = this.radioEP.getNumberOfSupportedRxBranches(n);
            int n5 = n3 = n3 > n4 ? n3 : n4;
        }
        if (!this.rbs.getRbsStep().equals("STEP_CABINET") && this.cellCarrP != null) {
            n2 = this.cellCarrP.getConfiguredNumberOfRxBranches(n);
            n3 = n3 > n2 ? n3 : n2;
        }
        return n3;
    }

    public int getLoadedNumOfSupportedAntennaBranches(int n) {
        int n2;
        int n3 = 0;
        if (this.radioEP != null) {
            int n4;
            n2 = this.radioEP.getLoadedNumberOfSupportedTxBranches(n);
            int n5 = n3 = n2 > (n4 = this.radioEP.getLoadedNumberOfSupportedRxBranches(n)) ? n2 : n4;
        }
        if (!this.rbs.getRbsStep().equals("STEP_CABINET") && this.cellCarrP != null) {
            n2 = this.cellCarrP.getLoadedNumberOfRxBranches(n);
            n3 = n3 > n2 ? n3 : n2;
        }
        return n3;
    }

    public int getNumOfSectorAntennas(int n) {
        int n2 = AIRUtil.getInstance(this.rbs).isAirConfigured(n) ? (this.getNumOfSupportedAntennaBranches(n) + 1) / AIRUtil.getInstance(this.rbs).getMaxNumOfBranchesPerSectorAntennaForAir(n, false) : (this.getNumOfSupportedAntennaBranches(n) + 1) / 2;
        return n2;
    }

    public int getLoadedNumOfSectorAntennas(int n) {
        int n2 = AIRUtil.getInstance(this.rbs).isNodeConfiguredWithAir(n) ? (this.getLoadedNumOfSupportedAntennaBranches(n) + 1) / AIRUtil.getInstance(this.rbs).getMaxNumOfBranchesPerSectorAntennaForAir(n, true) : (this.getLoadedNumOfSupportedAntennaBranches(n) + 1) / 2;
        return n2;
    }

    public void requestUninitAllBranches(int n) {
        int n2 = this.getLoadedNumOfSupportedAntennaBranches(n);
        for (int i = 0; i < n2; ++i) {
            this.requestUninitAntennaBranch(n, branch[i], this);
            this.requestUninitAntFeederCable(n, branch[i], this);
        }
    }

    public List getAntennaFeederRIs(int n, boolean bl) {
        ArrayList<AntennaFeederRI> arrayList = new ArrayList<AntennaFeederRI>();
        int n2 = bl ? this.getLoadedNumOfSupportedAntennaBranches(SectorUtil.getSectorNumberFromSectorIndex(n, this.startingSectorNumber)) : this.getNumOfSupportedAntennaBranches(SectorUtil.getSectorNumberFromSectorIndex(n, this.startingSectorNumber));
        for (int i = 0; i < n2; ++i) {
            if (this.antennaFeeder[n][i] == null) continue;
            for (int j = 0; j < this.antennaFeeder[n][i].length; ++j) {
                AntennaFeederRI antennaFeederRI = this.antennaFeeder[n][i][j];
                if (antennaFeederRI == null) continue;
                arrayList.add(antennaFeederRI);
            }
        }
        return arrayList;
    }

    public static int getMaxNumberOfBranches() {
        return branch.length;
    }

    public static String getBranchType(int n) {
        return branch[n];
    }

    public RetCIComponent getRetCIComponent() {
        return this.retCic;
    }

    public void setTypeOfRetRangeRestriction(int n) {
        this.retCic.setRetTypeRangeRestriction(n);
    }

    public boolean isProviderOpen() {
        return this.isProviderOpen;
    }

    private boolean canHaveRadioDot(int n) {
        return this.radioEP.getAuUnitType(n).equals("IRU");
    }

    private boolean existingRadioDot(int n) {
        return this.radioEP.getLoadedAuUnitType(n).equals("IRU");
    }

    protected String getRDAtfRole(int n) throws BemException {
        return null;
    }

    protected void createRadioDotRI(int n) throws BemException {
        if (this.radioDot == null) {
            this.radioDot = new RadioDotRI[this.maxNoOfSectors][MAX_NO_OF_RADIO_DOT_PER_SECTOR];
        }
        int n2 = SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber);
        String string = this.getRDAtfRole(n);
        for (int i = 0; i < MAX_NO_OF_RADIO_DOT_PER_SECTOR; ++i) {
            this.radioDot[n2][i] = new RadioDotRI(this.rbs, Integer.toString(i + 1), string, n);
            this.radioDot[n2][i].setLoadedValueForAU();
        }
    }

    protected void createRdiCableRI(int n) throws BemException {
        if (this.rdiCable == null) {
            this.rdiCable = new RdiCableRI[this.maxNoOfSectors][MAX_NO_OF_RADIO_DOT_PER_SECTOR];
        }
        if (this.radioEP instanceof RbbManager) {
            String string = AUTO_CREATED_RDNID_1;
            int n2 = SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber);
            AbstractRuRI abstractRuRI = ((RbbManager)this.radioEP).getRadioBuildingBlock(n).getRadioUnitResourceItems()[0];
            String string2 = abstractRuRI.getAuxPiuLdn();
            for (int i = 0; i < MAX_NO_OF_RADIO_DOT_PER_SECTOR; ++i) {
                String string3 = this.radioDot[n2][i].getAuxPiuLdn();
                int n3 = i + 1;
                String string4 = RadioDotSystemUtil.formateRdiCable(Integer.toString(n), string, Integer.toString(i + 1));
                this.rdiCable[n2][i] = new RdiCableRI(this.rbs, string2, n3, string3, string4);
            }
        }
    }

    public List getRadioDotRI(int n) {
        ArrayList<RadioDotRI> arrayList = new ArrayList<RadioDotRI>();
        if (this.radioDot == null) {
            return null;
        }
        for (int i = 0; i < MAX_NO_OF_RADIO_DOT_PER_SECTOR; ++i) {
            arrayList.add(this.radioDot[n][i]);
        }
        return arrayList;
    }

    public List getRdiCableRI(int n) {
        ArrayList<RdiCableRI> arrayList = new ArrayList<RdiCableRI>();
        if (this.rdiCable == null) {
            return null;
        }
        for (int i = 0; i < MAX_NO_OF_RADIO_DOT_PER_SECTOR; ++i) {
            arrayList.add(this.rdiCable[n][i]);
        }
        return arrayList;
    }

    private class NumberOfRxBranchesListener
    implements CustomerParameterListener {
        int sectorNo;
        int carrierNo;

        public NumberOfRxBranchesListener(int n, int n2) {
            this.sectorNo = n;
            this.carrierNo = n2;
        }

        public void parameterPropertiesChanged(CustomerParameter customerParameter, ParameterEvent parameterEvent) {
            CustomerParameter[] customerParameterArray;
            String string = customerParameter.getName();
            if (string.equalsIgnoreCase((customerParameterArray = AbstractAntennaSystemCI.this.cellCarrP.getNumOfRxBranchesPerCarrierParameter(this.sectorNo))[this.carrierNo - 1].getName()) && parameterEvent.isValueChanged()) {
                for (int i = 0; i < AbstractAntennaSystemCI.this.maxNoOfSectors; ++i) {
                    int n = SectorUtil.getSectorNumberFromSectorIndex(i, AbstractAntennaSystemCI.this.startingSectorNumber);
                    AbstractAntennaSystemCI.this.updateCustomerParametersRestrictionAccordingToNumberOfRxBranch(n);
                }
            }
        }
    }

    private class DlAttenuationListener
    implements CustomerParameterListener {
        int sectorNo;
        int antennaNo;

        public DlAttenuationListener(int n, int n2) {
            this.sectorNo = n;
            this.antennaNo = n2;
        }

        public void parameterPropertiesChanged(CustomerParameter customerParameter, ParameterEvent parameterEvent) {
            String string = customerParameter.getName();
            int n = SectorUtil.getSectorIndexFromSectorNumber(this.sectorNo, AbstractAntennaSystemCI.this.startingSectorNumber);
            if (string.equalsIgnoreCase(AbstractAntennaSystemCI.this.dlAttParam[n][this.antennaNo - 1].getName()) && parameterEvent.isValueChanged() && AbstractAntennaSystemCI.this.tmaParam[n][this.antennaNo - 1].getValue().equalsIgnoreCase(AbstractAntennaSystemCI.ATMA_AND_TMA_STRING)) {
                AbstractAntennaSystemCI.this.dlAttATMAParam[n][this.antennaNo - 1].setValue(AbstractAntennaSystemCI.this.dlAttParam[n][this.antennaNo - 1].getValue());
            }
        }
    }

    private class UlTrafficDelayListener
    implements CustomerParameterListener {
        int sectorNo;
        int antennaNo;
        int ulTrafficDelayIndex;

        public UlTrafficDelayListener(int n, int n2, int n3) {
            this.sectorNo = n;
            this.antennaNo = n2;
            this.ulTrafficDelayIndex = n3;
        }

        public void parameterPropertiesChanged(CustomerParameter customerParameter, ParameterEvent parameterEvent) {
            String string = customerParameter.getName();
            int n = SectorUtil.getSectorIndexFromSectorNumber(this.sectorNo, AbstractAntennaSystemCI.this.startingSectorNumber);
            if (string.equalsIgnoreCase(AbstractAntennaSystemCI.this.ulDelayParam[n][this.antennaNo - 1][this.ulTrafficDelayIndex].getName()) && parameterEvent.isValueChanged() && AbstractAntennaSystemCI.this.tmaParam[n][this.antennaNo - 1].getValue().equalsIgnoreCase(AbstractAntennaSystemCI.ATMA_AND_TMA_STRING)) {
                AbstractAntennaSystemCI.this.ulTrafficDelayParam[n][this.antennaNo - 1].setValue(AbstractAntennaSystemCI.this.ulDelayParam[n][this.antennaNo - 1][this.ulTrafficDelayIndex].getValue());
            }
        }
    }

    private class DlTrafficDelayListener
    implements CustomerParameterListener {
        int sectorNo;
        int antennaNo;
        int dlTrafficDelayIndex;

        public DlTrafficDelayListener(int n, int n2, int n3) {
            this.sectorNo = n;
            this.antennaNo = n2;
            this.dlTrafficDelayIndex = n3;
        }

        public void parameterPropertiesChanged(CustomerParameter customerParameter, ParameterEvent parameterEvent) {
            String string = customerParameter.getName();
            int n = SectorUtil.getSectorIndexFromSectorNumber(this.sectorNo, AbstractAntennaSystemCI.this.startingSectorNumber);
            if (string.equalsIgnoreCase(AbstractAntennaSystemCI.this.dlDelayParam[n][this.antennaNo - 1][this.dlTrafficDelayIndex].getName()) && parameterEvent.isValueChanged() && AbstractAntennaSystemCI.this.tmaParam[n][this.antennaNo - 1].getValue().equalsIgnoreCase(AbstractAntennaSystemCI.ATMA_AND_TMA_STRING)) {
                AbstractAntennaSystemCI.this.dlTrafficDelayParam[n][this.antennaNo - 1].setValue(AbstractAntennaSystemCI.this.dlDelayParam[n][this.antennaNo - 1][this.dlTrafficDelayIndex].getValue());
            }
        }
    }

    protected class SectorChangedListener
    implements RadioEquipmentListener {
        public static final int EQUIP_NEW_SECTOR = 1;
        public static final int MODIFY_SECTORANTENNA_EXPAND = 2;
        public static final int MODIFY_SECTORANTENNA_KEEP = 3;
        public static final int MODIFY_SECTORANTENNA_REDUCE = 4;
        public static final int UNEQUIP_SECTOR = 5;

        protected SectorChangedListener() {
        }

        public void update(int n) {
            try {
                int n2;
                block21: {
                    int n3;
                    block18: {
                        int n4;
                        block20: {
                            block19: {
                                block17: {
                                    n3 = SectorUtil.getSectorIndexFromSectorNumber(n, AbstractAntennaSystemCI.this.startingSectorNumber);
                                    if (!AbstractAntennaSystemCI.this.sectorEquipped(n)) {
                                        AbstractAntennaSystemCI.this.sectorNotEquippedRestriction[n3].setAccessLevel(1);
                                    } else {
                                        AbstractAntennaSystemCI.this.sectorNotEquippedRestriction[n3].setAccessLevel(3);
                                    }
                                    n2 = 0;
                                    n2 = !AbstractAntennaSystemCI.this.sectorExist(n) && AbstractAntennaSystemCI.this.sectorEquipped(n) ? 1 : (AbstractAntennaSystemCI.this.sectorExist(n) && AbstractAntennaSystemCI.this.sectorEquipped(n) ? (!AbstractAntennaSystemCI.this.isSectorAntennaMoExisting(n, n4 = AbstractAntennaSystemCI.this.getNumOfSectorAntennas(n)) ? 2 : (n4 < 3 && AbstractAntennaSystemCI.this.isSectorAntennaMoExisting(n, n4 + 1) ? 4 : 3)) : 5);
                                    AbstractAntennaSystemCI.this.createPositionConfigurationCP(n);
                                    AbstractAntennaSystemCI.this.loadRadioPositionInfo(n);
                                    if (n2 == 1) break block17;
                                    if (n2 == 2) break block17;
                                    if (n2 != 4) break block18;
                                }
                                n4 = 0;
                                if (n2 == 2) break block19;
                                if (n2 != 4) break block20;
                            }
                            n4 = 1;
                        }
                        AbstractAntennaSystemCI.this.requiredRestriction[n3].setAccessLevel(3);
                        String string = AbstractAntennaSystemCI.getSectorPrefix(n);
                        String string2 = string + "latitude";
                        int n5 = n3;
                        AbstractAntennaSystemCI.this.initAntennaMois(n5, n4 != 0);
                        if (n2 == 2) {
                            AbstractAntennaSystemCI.this.initialiseMoiResources(n5, n4 != 0);
                        }
                        if (!AbstractAntennaSystemCI.this.isParameterSupported(string2)) {
                            AbstractAntennaSystemCI.this.createSectorCP(string, n5);
                            for (int i = 0; i < 3; ++i) {
                                AbstractAntennaSystemCI.this.createAntennaTypeCP(n, i + 1, false);
                                AbstractAntennaSystemCI.this.createAntennaTypeCP(n, i + 1, true);
                                AbstractAntennaSystemCI.this.createUserLabelAretuCP(n, i + 1, true);
                                AbstractAntennaSystemCI.this.createUserLabelAretuCP(n, i + 1, false);
                                AbstractAntennaSystemCI.this.createSectorAntennaCP(string, n, i + 1);
                                AbstractAntennaSystemCI.this.createModificationTypeCP(n, i);
                            }
                            AbstractAntennaSystemCI.this.createAntennaBranchCP(string, n5);
                            AbstractAntennaSystemCI.this.createAntennaFeederCP(string, n5);
                            AbstractAntennaSystemCI.this.createExternalTpaCP(string, n5);
                            if (AbstractAntennaSystemCI.this.canHaveTma) {
                                AbstractAntennaSystemCI.this.setTmaTypeRangeRestriction(n);
                                AbstractAntennaSystemCI.this.createTmaCP(string, n);
                                AbstractAntennaSystemCI.this.createAtmaCP(string, n5);
                                AbstractAntennaSystemCI.this.createExternalTmaCP(string, n5);
                                AbstractAntennaSystemCI.this.createModifyTmfFileCP(string, n5);
                            }
                            AbstractAntennaSystemCI.this.createCustomerParameters(string, n5);
                        }
                        AbstractAntennaSystemCI.this.updateCustomerParametersForAIR(n);
                        AbstractAntennaSystemCI.this.createSectorRI(n);
                        AbstractAntennaSystemCI.this.createSectorAntennaRI(n, n4 != 0);
                        AbstractAntennaSystemCI.this.createExternalAntennaRI(n);
                        AbstractAntennaSystemCI.this.createAntennaBranchRI(n, n4 != 0);
                        AbstractAntennaSystemCI.this.createTmaRI(n);
                        AbstractAntennaSystemCI.this.createAtmauRI(n);
                        AbstractAntennaSystemCI.this.createAscRI(n);
                        AbstractAntennaSystemCI.this.createTmfRI(n);
                        AbstractAntennaSystemCI.this.updateSectorParameters(n, n4 != 0);
                        if (AbstractAntennaSystemCI.this.cellCarrP.isSectorInUse(n)) {
                            AbstractAntennaSystemCI.this.sectorUsedRestriction[n3].setAccessLevel(3);
                        } else {
                            AbstractAntennaSystemCI.this.sectorUsedRestriction[n3].setAccessLevel(1);
                        }
                        AbstractAntennaSystemCI.this.updateExternalTpaCpRestrictions(n5);
                        break block21;
                    }
                    if (n2 == 3) {
                        AbstractAntennaSystemCI.this.requiredRestriction[n3].setAccessLevel(2);
                        AbstractAntennaSystemCI.this.initAntennaMois(n3, true);
                        AbstractAntennaSystemCI.this.updateCustomerParametersForAIR(n);
                        AbstractAntennaSystemCI.this.createTmaRI(n);
                        AbstractAntennaSystemCI.this.createAscRI(n);
                        AbstractAntennaSystemCI.this.updateSectorParameters(n, true);
                        AbstractAntennaSystemCI.this.updateExternalTpaCpRestrictions(n3);
                        AbstractAntennaSystemCI.this.createSectorAntennaRI(n, true);
                    } else {
                        AbstractAntennaSystemCI.this.requiredRestriction[n3].setAccessLevel(2);
                    }
                }
                if (n2 != 5 && AbstractAntennaSystemCI.this.canHaveRadioDot(n)) {
                    AbstractAntennaSystemCI.this.createRadioDotCP(n);
                    AbstractAntennaSystemCI.this.createRadioDotRI(n);
                    AbstractAntennaSystemCI.this.createRdiCableRI(n);
                }
            }
            catch (BemException bemException) {
                Nal.getLog().nalTrace(1, this.getClass(), "BemException caught. Failed in SectorChangedListener.update, sector=" + n, bemException);
            }
        }
    }

    private class UserLabelListener
    implements CustomerParameterListener {
        final int sectorIndex;

        public UserLabelListener(int n) {
            this.sectorIndex = n;
        }

        public void parameterPropertiesChanged(CustomerParameter customerParameter, ParameterEvent parameterEvent) {
            if (parameterEvent.isValueChanged() && AbstractAntennaSystemCI.this.isOpen && customerParameter.hasValueChanged()) {
                int n = SectorUtil.getSectorNumberFromSectorIndex(this.sectorIndex, AbstractAntennaSystemCI.this.startingSectorNumber);
                AbstractAntennaSystemCI.this.cellCarrP.requestUninitiateSector(n, this);
                AbstractAntennaSystemCI.this.cellCarrP.requestInitiateSector(n, this);
            }
        }
    }

    private class AntennaTypeListener
    implements CustomerParameterListener {
        final int sectorIndex;
        final int antennaIndex;

        public AntennaTypeListener(int n, int n2) {
            this.sectorIndex = n;
            this.antennaIndex = n2;
        }

        public void parameterPropertiesChanged(CustomerParameter customerParameter, ParameterEvent parameterEvent) {
            if (parameterEvent.isValueChanged() && AbstractAntennaSystemCI.this.isOpen && customerParameter.hasValueChanged()) {
                int n = SectorUtil.getSectorNumberFromSectorIndex(this.sectorIndex, AbstractAntennaSystemCI.this.startingSectorNumber);
                AbstractAntennaSystemCI.this.cellCarrP.requestUninitiateSector(n, this);
                AbstractAntennaSystemCI.this.cellCarrP.requestInitiateSector(n, this);
                String string = AbstractAntennaSystemCI.NONE_STRING;
                int n2 = 0;
                if (AbstractAntennaSystemCI.this.antennaTypeParam[this.sectorIndex][this.antennaIndex] != null) {
                    Integer n3 = Integer.valueOf(AbstractAntennaSystemCI.this.antennaTypeParam[this.sectorIndex][this.antennaIndex].getValue());
                    n2 = n3;
                }
                if (AbstractAntennaSystemCI.this.retCic.typeOfRetParam != null && AbstractAntennaSystemCI.this.retCic.typeOfRetParam[this.sectorIndex][this.antennaIndex] != null) {
                    string = AbstractAntennaSystemCI.this.retCic.typeOfRetParam[this.sectorIndex][this.antennaIndex].getValue();
                    AbstractAntennaSystemCI.this.retCic.setMaxAndMinTiltRestriction(string, n, this.antennaIndex, n2);
                }
            }
        }
    }

    private class BandListener
    implements CustomerParameterListener {
        private int index;

        public BandListener(int n) {
            this.index = n;
        }

        public void parameterPropertiesChanged(CustomerParameter customerParameter, ParameterEvent parameterEvent) {
            String string = customerParameter.getName();
            if (string.equalsIgnoreCase(AbstractAntennaSystemCI.this.bandParam[this.index].getName())) {
                String string2 = AbstractAntennaSystemCI.this.bandParam[this.index].getValue();
                if (parameterEvent.isValueChanged() && string2 != null && !string2.equals("0")) {
                    int n = Integer.parseInt(string2);
                    AbstractAntennaSystemCI.this.setFrequencys(n, this.index);
                    AbstractAntennaSystemCI.this.setULFeederParamsDefaultValue(n, this.index);
                    AbstractAntennaSystemCI.this.cellCarrP.updateBand(this.index, string2);
                }
            }
        }
    }

    private class TmaTypeListener
    implements CustomerParameterListener {
        int sectorNumber;
        int antennaNumber;

        public TmaTypeListener(int n, int n2) {
            this.sectorNumber = n;
            this.antennaNumber = n2;
        }

        public void parameterPropertiesChanged(CustomerParameter customerParameter, ParameterEvent parameterEvent) {
            int n;
            String string = customerParameter.getName();
            if (string.equalsIgnoreCase(AbstractAntennaSystemCI.this.tmaParam[n = SectorUtil.getSectorIndexFromSectorNumber(this.sectorNumber, AbstractAntennaSystemCI.this.startingSectorNumber)][this.antennaNumber - 1].getName())) {
                String string2 = AbstractAntennaSystemCI.this.tmaParam[n][this.antennaNumber - 1].getValue();
                if (AbstractAntennaSystemCI.this.isOpen()) {
                    AbstractAntennaSystemCI.this.updateRiuRestriction(this.sectorNumber, this.antennaNumber);
                }
                if (parameterEvent.isValueChanged()) {
                    AbstractAntennaSystemCI.this.internalPowerSupportedRestriction[n][this.antennaNumber - 1].setActive(false);
                    AbstractAntennaSystemCI.this.tmaDegradedSupportedActivationRestriction[n][this.antennaNumber - 1].setAccessLevel(3);
                    if (string2.equals(AbstractAntennaSystemCI.TMA_STRING)) {
                        AbstractAntennaSystemCI.this.tmaRestriction[n][this.antennaNumber - 1].setAccessLevel(3);
                        AbstractAntennaSystemCI.this.atmaRestriction[n][this.antennaNumber - 1].setAccessLevel(1);
                        AbstractAntennaSystemCI.this.tmaAndAtmaRestriction[n][this.antennaNumber - 1].setAccessLevel(3);
                    } else if (string2.equals(AbstractAntennaSystemCI.ATMA_STRING)) {
                        AbstractAntennaSystemCI.this.atmaRestriction[n][this.antennaNumber - 1].setAccessLevel(3);
                        AbstractAntennaSystemCI.this.tmaRestriction[n][this.antennaNumber - 1].setAccessLevel(1);
                        AbstractAntennaSystemCI.this.tmaAndAtmaRestriction[n][this.antennaNumber - 1].setAccessLevel(3);
                    } else if (string2.equals(AbstractAntennaSystemCI.ATMA_AND_TMA_STRING)) {
                        AbstractAntennaSystemCI.this.tmaRestriction[n][this.antennaNumber - 1].setAccessLevel(3);
                        AbstractAntennaSystemCI.this.atmaRestriction[n][this.antennaNumber - 1].setAccessLevel(1);
                        AbstractAntennaSystemCI.this.tmaAndAtmaRestriction[n][this.antennaNumber - 1].setAccessLevel(1);
                        AbstractAntennaSystemCI.this.internalPowerParam[n][this.antennaNumber - 1].setValue("YES");
                        AbstractAntennaSystemCI.this.tmaDegradedSupportedRestriction[n][this.antennaNumber - 1].setAccessLevel(1);
                        AbstractAntennaSystemCI.this.internalPowerSupportedRestriction[n][this.antennaNumber - 1].setActive(true);
                        AbstractAntennaSystemCI.this.tmaDegradedSupportedActivationRestriction[n][this.antennaNumber - 1].setAccessLevel(1);
                        if (!AbstractAntennaSystemCI.this.dlAttParam[n][this.antennaNumber - 1].getValue().equals("##UNDEFINED")) {
                            AbstractAntennaSystemCI.this.dlAttATMAParam[n][this.antennaNumber - 1].setValue(AbstractAntennaSystemCI.this.dlAttParam[this.sectorNumber - 1][this.antennaNumber - 1].getValue());
                        }
                        if (!AbstractAntennaSystemCI.this.ulDelayParam[n][this.antennaNumber - 1][0].getValue().equals("##UNDEFINED")) {
                            AbstractAntennaSystemCI.this.ulTrafficDelayParam[n][this.antennaNumber - 1].setValue(AbstractAntennaSystemCI.this.ulDelayParam[this.sectorNumber - 1][this.antennaNumber - 1][0].getValue());
                        }
                        if (!AbstractAntennaSystemCI.this.dlDelayParam[n][this.antennaNumber - 1][0].getValue().equals("##UNDEFINED")) {
                            AbstractAntennaSystemCI.this.dlTrafficDelayParam[n][this.antennaNumber - 1].setValue(AbstractAntennaSystemCI.this.dlDelayParam[this.sectorNumber - 1][this.antennaNumber - 1][0].getValue());
                        }
                    } else {
                        AbstractAntennaSystemCI.this.tmaAndAtmaRestriction[n][this.antennaNumber - 1].setAccessLevel(1);
                        AbstractAntennaSystemCI.this.atmaRestriction[n][this.antennaNumber - 1].setAccessLevel(1);
                        AbstractAntennaSystemCI.this.tmaRestriction[n][this.antennaNumber - 1].setAccessLevel(1);
                        AbstractAntennaSystemCI.this.internalPowerParam[n][this.antennaNumber - 1].setValue("NO");
                        AbstractAntennaSystemCI.this.tmaDegradedSupported[n][this.antennaNumber - 1].setValue("NO");
                    }
                } else if (parameterEvent.isAccessLevelChanged()) {
                    if (AbstractAntennaSystemCI.this.tmaRestriction[n][this.antennaNumber - 1].getAccessLevel() == 1 && string2.equals(AbstractAntennaSystemCI.TMA_STRING)) {
                        AbstractAntennaSystemCI.this.internalPowerParam[n][this.antennaNumber - 1].setValue("NO");
                        AbstractAntennaSystemCI.this.tmaDegradedSupported[n][this.antennaNumber - 1].setValue("NO");
                    } else if (AbstractAntennaSystemCI.this.atmaRestriction[n][this.antennaNumber - 1].getAccessLevel() == 1 && string2.equals(AbstractAntennaSystemCI.ATMA_STRING)) {
                        AbstractAntennaSystemCI.this.internalPowerParam[n][this.antennaNumber - 1].setValue("NO");
                        AbstractAntennaSystemCI.this.tmaDegradedSupported[n][this.antennaNumber - 1].setValue("NO");
                    }
                }
            }
        }
    }

    private class InternalPowerListener
    implements CustomerParameterListener {
        int sectorNumber;
        int sectorAntennaNumber;

        public InternalPowerListener(int n, int n2) {
            this.sectorNumber = n;
            this.sectorAntennaNumber = n2;
        }

        public void parameterPropertiesChanged(CustomerParameter customerParameter, ParameterEvent parameterEvent) {
            String string = customerParameter.getName();
            int n = SectorUtil.getSectorIndexFromSectorNumber(this.sectorNumber, AbstractAntennaSystemCI.this.startingSectorNumber);
            if (string.equalsIgnoreCase(AbstractAntennaSystemCI.this.internalPowerParam[n][this.sectorAntennaNumber - 1].getName())) {
                Boolean bl = AbstractAntennaSystemCI.this.internalPowerParam[n][this.sectorAntennaNumber - 1].getBooleanObject();
                if (parameterEvent.isValueChanged() && bl.booleanValue()) {
                    AbstractAntennaSystemCI.this.dcVoltageRestriction[n][this.sectorAntennaNumber - 1].setActive(false);
                } else if (parameterEvent.isValueChanged() && !bl.booleanValue()) {
                    AbstractAntennaSystemCI.this.dcVoltageRestriction[n][this.sectorAntennaNumber - 1].setActive(true);
                }
            }
        }
    }

    private class TmaDegradedSupportedListener
    implements CustomerParameterListener {
        int sectorNo;
        int antennaNo;

        public TmaDegradedSupportedListener(int n, int n2) {
            this.sectorNo = n;
            this.antennaNo = n2;
        }

        public void parameterPropertiesChanged(CustomerParameter customerParameter, ParameterEvent parameterEvent) {
            String string = customerParameter.getName();
            int n = SectorUtil.getSectorIndexFromSectorNumber(this.sectorNo, AbstractAntennaSystemCI.this.startingSectorNumber);
            if (AbstractAntennaSystemCI.this.tmaDegradedSupported[n][this.antennaNo - 1].toString() != null && string.equalsIgnoreCase(AbstractAntennaSystemCI.this.tmaDegradedSupported[n][this.antennaNo - 1].getName())) {
                String string2 = AbstractAntennaSystemCI.this.tmaDegradedSupported[n][this.antennaNo - 1].getValue();
                if (parameterEvent.isValueChanged()) {
                    if (string2.equals("YES")) {
                        AbstractAntennaSystemCI.this.tmaDegradedSupportedRestriction[n][this.antennaNo - 1].setAccessLevel(3);
                    } else {
                        AbstractAntennaSystemCI.this.tmaDegradedSupportedRestriction[n][this.antennaNo - 1].setAccessLevel(1);
                    }
                }
            }
        }
    }
}

