/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.custparam;

import java.util.ArrayList;
import java.util.List;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.custparam.EtbSlotParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.custparam.ExistOnNodeParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.custparam.IpOverAtmLinkParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.custparam.PhysicalLineParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.custparam.ReqNoOfLinksParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.custparam.StandardParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.custparam.TerminationTypeParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.custparam.TimeSlotsInFractionParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterImpl;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterListener;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.Enumeration;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterEvent;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;

public class TerminationParameterList
extends Enumeration
implements CustomerParameterListener {
    public static final String ERROR_MSG_IP_OVER_ATM_LINK = "ATM port used by IP ATM can not be deleted on this page.";
    public static final String ERROR_MSG_EXISTING_ATM_PORT = "ATM port existing on node can not be deleted.\nPlease use Modify Application instead!";
    private EtbSlotParameter slotParameter;
    private TerminationTypeParameter terminationTypeParameter;
    private StandardParameter standardParameter;
    private PhysicalLineParameter lineParameter;
    private TimeSlotsInFractionParameter timeSlotsInFractionParameter;
    private ReqNoOfLinksParameter requiredNumberOfLinksParameter;
    private IpOverAtmLinkParameter ipOverAtmLinkParameter;
    private ExistOnNodeParameter existOnNodeParameter;
    private boolean hasAtmPort;
    private CustomerParameter changedCustomerParameter = null;

    public TerminationParameterList(String string, boolean bl, EtbSlotParameter etbSlotParameter, TerminationTypeParameter terminationTypeParameter, StandardParameter standardParameter, PhysicalLineParameter physicalLineParameter, TimeSlotsInFractionParameter timeSlotsInFractionParameter, ReqNoOfLinksParameter reqNoOfLinksParameter, IpOverAtmLinkParameter ipOverAtmLinkParameter, ExistOnNodeParameter existOnNodeParameter) throws BemException {
        super(string, new String[]{"OK", "NOT_OK"});
        this.setLoadedValue("OK");
        this.hasAtmPort = bl;
        this.slotParameter = etbSlotParameter;
        this.slotParameter.addCustomerParameterListener(this);
        this.terminationTypeParameter = terminationTypeParameter;
        this.terminationTypeParameter.addCustomerParameterListener(this);
        this.standardParameter = standardParameter;
        this.standardParameter.addCustomerParameterListener(this);
        this.lineParameter = physicalLineParameter;
        this.lineParameter.addCustomerParameterListener(this);
        this.timeSlotsInFractionParameter = timeSlotsInFractionParameter;
        this.timeSlotsInFractionParameter.addCustomerParameterListener(this);
        this.requiredNumberOfLinksParameter = reqNoOfLinksParameter;
        this.requiredNumberOfLinksParameter.addCustomerParameterListener(this);
        this.ipOverAtmLinkParameter = ipOverAtmLinkParameter;
        this.ipOverAtmLinkParameter.addCustomerParameterListener(this);
        this.existOnNodeParameter = existOnNodeParameter;
        this.existOnNodeParameter.addCustomerParameterListener(this);
    }

    public boolean hasAtmPort() {
        return this.hasAtmPort;
    }

    public EtbSlotParameter getSlotParameter() {
        return this.slotParameter;
    }

    public TerminationTypeParameter getTerminationTypeParameter() {
        return this.terminationTypeParameter;
    }

    public StandardParameter getStandardParameter() {
        return this.standardParameter;
    }

    public PhysicalLineParameter getLineParameter() {
        return this.lineParameter;
    }

    public TimeSlotsInFractionParameter getTimeSlotsInFractionParameter() {
        return this.timeSlotsInFractionParameter;
    }

    public ReqNoOfLinksParameter getRequiredNumberOfLinksParameter() {
        return this.requiredNumberOfLinksParameter;
    }

    public IpOverAtmLinkParameter getIpOverAtmLinkParameter() {
        return this.ipOverAtmLinkParameter;
    }

    public ExistOnNodeParameter getExistOnNodeParameter() {
        return this.existOnNodeParameter;
    }

    public CustomerParameter getChangedParameter() {
        return this.changedCustomerParameter;
    }

    public List getAllCP() {
        ArrayList<CustomerParameterImpl> arrayList = new ArrayList<CustomerParameterImpl>();
        arrayList.add(this.slotParameter);
        arrayList.add(this.lineParameter);
        arrayList.add(this.terminationTypeParameter);
        arrayList.add(this.standardParameter);
        arrayList.add(this.timeSlotsInFractionParameter);
        arrayList.add(this.requiredNumberOfLinksParameter);
        arrayList.add(this.ipOverAtmLinkParameter);
        arrayList.add(this.existOnNodeParameter);
        return arrayList;
    }

    public List getAllPseudos() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.slotParameter.getName());
        arrayList.add(this.lineParameter.getName());
        arrayList.add(this.terminationTypeParameter.getName());
        arrayList.add(this.standardParameter.getName());
        arrayList.add(this.timeSlotsInFractionParameter.getName());
        arrayList.add(this.requiredNumberOfLinksParameter.getName());
        arrayList.add(this.ipOverAtmLinkParameter.getName());
        arrayList.add(this.existOnNodeParameter.getName());
        return arrayList;
    }

    public void setAsReadOnly() {
        this.slotParameter.getRestriction().setAccessLevel(0);
        this.terminationTypeParameter.getRestriction().setAccessLevel(0);
        this.lineParameter.getRestriction().setAccessLevel(0);
        this.timeSlotsInFractionParameter.getRestriction().setAccessLevel(0);
        this.standardParameter.getRestriction().setAccessLevel(0);
        this.requiredNumberOfLinksParameter.getRestriction().setAccessLevel(0);
        this.ipOverAtmLinkParameter.getRestriction().setAccessLevel(0);
        this.existOnNodeParameter.getRestriction().setAccessLevel(0);
    }

    public String setAsOptionalCP() {
        if (this.existOnNodeParameter.getValue().equals("YES")) {
            return ERROR_MSG_EXISTING_ATM_PORT;
        }
        this.slotParameter.getRestriction().setAccessLevel(2);
        this.terminationTypeParameter.getRestriction().setAccessLevel(2);
        this.lineParameter.getRestriction().setAccessLevel(2);
        this.timeSlotsInFractionParameter.getRestriction().setAccessLevel(2);
        this.standardParameter.getRestriction().setAccessLevel(2);
        this.requiredNumberOfLinksParameter.getRestriction().setAccessLevel(2);
        this.ipOverAtmLinkParameter.getRestriction().setAccessLevel(2);
        this.existOnNodeParameter.getRestriction().setAccessLevel(2);
        return null;
    }

    public void setAsIgnoredCP() {
        this.slotParameter.getRestriction().setAccessLevel(1);
        this.terminationTypeParameter.getRestriction().setAccessLevel(1);
        this.lineParameter.getRestriction().setAccessLevel(1);
        this.timeSlotsInFractionParameter.getRestriction().setAccessLevel(1);
        this.standardParameter.getRestriction().setAccessLevel(1);
        this.requiredNumberOfLinksParameter.getRestriction().setAccessLevel(1);
        this.ipOverAtmLinkParameter.getRestriction().setAccessLevel(1);
        this.existOnNodeParameter.getRestriction().setAccessLevel(1);
    }

    public void setAsUndefinedCP() {
        this.terminationTypeParameter.setValue("##UNDEFINED");
        this.lineParameter.setValue("##UNDEFINED");
        this.timeSlotsInFractionParameter.setValue("##UNDEFINED");
        this.requiredNumberOfLinksParameter.setValue("##UNDEFINED");
    }

    public String setAsRemovedCP() {
        if (this.existOnNodeParameter.getValue().equals("YES")) {
            return ERROR_MSG_EXISTING_ATM_PORT;
        }
        if (this.ipOverAtmLinkParameter.getValue().equals("YES")) {
            return ERROR_MSG_IP_OVER_ATM_LINK;
        }
        this.setAsIgnoredCP();
        return null;
    }

    public boolean isReadOnly() {
        int n;
        int n2;
        if (this.slotParameter == null || this.terminationTypeParameter == null || this.standardParameter == null || this.lineParameter == null || this.timeSlotsInFractionParameter == null || this.ipOverAtmLinkParameter == null || this.existOnNodeParameter == null) {
            return false;
        }
        boolean bl = true;
        int n3 = this.slotParameter.getAccessLevel();
        int n4 = n3 + (n2 = this.lineParameter.getAccessLevel()) + (n = this.terminationTypeParameter.getAccessLevel());
        if (n4 != 0) {
            bl = false;
        }
        return bl;
    }

    public boolean isIgnored() {
        int n;
        if (this.slotParameter == null || this.terminationTypeParameter == null || this.standardParameter == null || this.lineParameter == null || this.timeSlotsInFractionParameter == null || this.ipOverAtmLinkParameter == null || this.existOnNodeParameter == null) {
            return false;
        }
        boolean bl = true;
        int n2 = this.lineParameter.getAccessLevel();
        int n3 = n2 * (n = this.terminationTypeParameter.getAccessLevel());
        if (n3 != 1) {
            bl = false;
        }
        return bl;
    }

    public boolean isValidValue() {
        if (this.slotParameter == null || this.terminationTypeParameter == null || this.standardParameter == null || this.lineParameter == null || this.timeSlotsInFractionParameter == null || this.ipOverAtmLinkParameter == null || this.existOnNodeParameter == null) {
            return true;
        }
        boolean bl = this.slotParameter.isValidValue();
        boolean bl2 = this.terminationTypeParameter.isValidValue();
        boolean bl3 = this.standardParameter.isValidValue();
        boolean bl4 = this.lineParameter.isValidValue();
        boolean bl5 = this.timeSlotsInFractionParameter.isValidValue();
        boolean bl6 = this.ipOverAtmLinkParameter.isValidValue();
        boolean bl7 = this.existOnNodeParameter.isValidValue();
        return bl && bl2 && bl3 && bl4 && bl5 && bl6 && bl7;
    }

    public void parameterPropertiesChanged(CustomerParameter customerParameter, ParameterEvent parameterEvent) {
        this.changedCustomerParameter = customerParameter;
        this.notifyAllListeners(parameterEvent);
    }
}

