/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.loader;

import java.util.HashMap;
import java.util.Map;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.AbstractEtmBoardManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.AtmAndPtCI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.DuwEtmBoardManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.loader.AbstractEtmTerminationLoader;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.loader.CbuTerminationLoader;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.loader.DuwTerminationLoader;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.loader.Etm1TerminationLoader;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.loader.Etm3TerminationLoader;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.loader.Etm4TerminationLoader;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.loader.Etmc1TerminationLoader;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.loader.Etmc41TerminationLoader;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.termination.TerminationData;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.EtmBoardProvider;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimAtmPort;
import se.ericsson.wcdma.rbs.bem.common.mim.MimCbu;
import se.ericsson.wcdma.rbs.bem.common.mim.MimDs0Bundle;
import se.ericsson.wcdma.rbs.bem.common.mim.MimExchangeTerminal;
import se.ericsson.wcdma.rbs.bem.common.mim.MimImaGroup;
import se.ericsson.wcdma.rbs.bem.common.mim.MimIpAtmLink;
import se.ericsson.wcdma.rbs.bem.common.mim.MimSlot;
import se.ericsson.wcdma.rbs.bem.common.mim.MimTransportNetwork;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandler;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerException;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;
import se.ericsson.wcdma.rbs.bem.common.util.BemLdn;
import se.ericsson.wcdma.rbs.bem.common.util.BemUtil;

public class TerminationLoader {
    private Map etmTypeLoaders = new HashMap();
    private MoHandler theMoHandler = null;
    private EtmBoardProvider etmBoardProvider;
    private Map usedTerminationLdns = new HashMap();
    private Map terminationLoaders = new HashMap();
    private AtmAndPtCI ci = null;
    private AbstractEtmBoardManager boardManager;
    private Map atmPortsUsedForIpAtmLinks = new HashMap();

    public TerminationLoader(AtmAndPtCI atmAndPtCI, AbstractEtmBoardManager abstractEtmBoardManager, EtmBoardProvider etmBoardProvider) {
        this.ci = atmAndPtCI;
        this.boardManager = abstractEtmBoardManager;
        this.etmBoardProvider = etmBoardProvider;
        this.theMoHandler = this.ci.getRbs().getMoHandler();
        this.createLoaders();
    }

    private void createLoaders() {
        String[] stringArray = this.etmBoardProvider.getSupportedEtmBoardTypesForAtm();
        if (BemUtil.isStringInArray(MimExchangeTerminal.MOTYPENAME, stringArray)) {
            this.etmTypeLoaders.put(MimExchangeTerminal.MOTYPENAME, new DuwTerminationLoader((DuwEtmBoardManager)this.boardManager, this.theMoHandler));
        }
        if (BemUtil.isStringInArray("Duw", stringArray)) {
            this.etmTypeLoaders.put("Duw", new DuwTerminationLoader((DuwEtmBoardManager)this.boardManager, this.theMoHandler));
        }
        if (BemUtil.isStringInArray(MimCbu.MOTYPENAME, stringArray)) {
            this.etmTypeLoaders.put(MimCbu.MOTYPENAME, new CbuTerminationLoader(this.boardManager));
        }
        if (BemUtil.isStringInArray("Etm1", stringArray)) {
            this.etmTypeLoaders.put("Etm1", new Etm1TerminationLoader(this.boardManager));
        }
        if (BemUtil.isStringInArray("Etmc1", stringArray)) {
            this.etmTypeLoaders.put("Etmc1", new Etmc1TerminationLoader(this.boardManager));
        }
        if (BemUtil.isStringInArray("Etm3", stringArray)) {
            this.etmTypeLoaders.put("Etm3", new Etm3TerminationLoader(this.boardManager));
        }
        if (BemUtil.isStringInArray("Etm4", stringArray)) {
            this.etmTypeLoaders.put("Etm4", new Etm4TerminationLoader(this.boardManager));
        }
        if (BemUtil.isStringInArray("Etmc41", stringArray)) {
            this.etmTypeLoaders.put("Etmc41", new Etmc41TerminationLoader(this.boardManager));
        }
    }

    public void loadAllTerminations() throws BemException {
        try {
            this.arrangeEtmTerminationLoaders();
            this.loadAtmPortsUsedForIpAtmLinks();
            this.loadAtmPortTerminations();
            this.loadTerminations();
        }
        catch (MoHandlerException moHandlerException) {
            throw new BemException(this.getClass().getName() + ": Load all terminations", (String)null, (Throwable)moHandlerException);
        }
    }

    private void loadAtmPortTerminations() throws MoHandlerException, BemException {
        String string = this.getTransportNetworkLdn();
        BemMo bemMo = this.theMoHandler.getMo(string);
        BemMo[] bemMoArray = this.theMoHandler.getChildren(bemMo, 1, MimAtmPort.MOTYPENAME, "");
        if (bemMoArray != null) {
            for (int i = 0; i < bemMoArray.length; ++i) {
                Object object;
                Object object2;
                Object object3;
                BemMo bemMo2 = bemMoArray[i];
                BemMo bemMo3 = (BemMo)this.theMoHandler.getAttribute(bemMo2, "uses");
                if (bemMo3 == null) continue;
                String string2 = bemMo3.getDN();
                String string3 = bemMo3.getType();
                String[] stringArray = null;
                String string4 = null;
                String string5 = null;
                boolean bl = false;
                boolean bl2 = false;
                if (string3.equals(MimDs0Bundle.MOTYPENAME)) {
                    bl = true;
                    string4 = string2;
                    object3 = bemMo3.getParent();
                    object2 = object3.getDN();
                    this.usedTerminationLdns.put(object2, null);
                    stringArray = new String[]{object2};
                } else if (string3.equals(MimImaGroup.MOTYPENAME)) {
                    bl2 = true;
                    string5 = string2;
                    object3 = (BemMo[])this.theMoHandler.getAttribute(bemMo3, "physicalPortList");
                    stringArray = new String[((BemMo[])object3).length];
                    for (int j = 0; j < ((BemMo[])object3).length; ++j) {
                        object = object3[j].getDN();
                        this.usedTerminationLdns.put(object, null);
                        stringArray[j] = object;
                    }
                } else {
                    this.usedTerminationLdns.put(string2, null);
                    stringArray = new String[]{string2};
                }
                object3 = this.extractSlotNo(stringArray[0]);
                object2 = (AbstractEtmTerminationLoader)this.terminationLoaders.get(object3);
                object = ((AbstractEtmTerminationLoader)object2).getTerminationData((String)object3, stringArray, string4, string5, bl, bl2);
                String string6 = bemMo2.getDN();
                boolean bl3 = this.atmPortsUsedForIpAtmLinks.containsValue(string6);
                if (bl3) {
                    for (int j = 0; j < 2; ++j) {
                        String string7 = (String)this.atmPortsUsedForIpAtmLinks.get(new Integer(j));
                        if (string7 == null || !string7.equals(string6)) continue;
                        this.ci.addLoadedIpAtmLinkTermination(new Integer(j), string6, string4, string5, stringArray, (TerminationData)object);
                    }
                    continue;
                }
                this.ci.addLoadedTermination(string6, string4, string5, stringArray, (TerminationData)object);
            }
        }
    }

    private void loadTerminations() throws MoHandlerException, BemException {
        String[] stringArray = this.boardManager.getAvailableSlots();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                String[] stringArray2;
                AbstractEtmTerminationLoader abstractEtmTerminationLoader = (AbstractEtmTerminationLoader)this.terminationLoaders.get(stringArray[i]);
                if (abstractEtmTerminationLoader == null || (stringArray2 = abstractEtmTerminationLoader.getAllLoadedTerminations(stringArray[i])) == null) continue;
                for (int j = 0; j < stringArray2.length; ++j) {
                    Object v = this.usedTerminationLdns.get(stringArray2[j]);
                    if (v != null) continue;
                    String[] stringArray3 = new String[]{stringArray2[j]};
                    TerminationData terminationData = abstractEtmTerminationLoader.getTerminationData(stringArray[i], stringArray3, null, null, false, false);
                    this.ci.addLoadedTermination(null, null, null, stringArray3, terminationData);
                }
            }
        }
    }

    private void loadAtmPortsUsedForIpAtmLinks() throws MoHandlerException {
        for (int i = 0; i < 2; ++i) {
            String string = BemLdn.LDN_IP + "," + MimIpAtmLink.MOTYPENAME + "=" + (i + 1);
            BemMo bemMo = this.theMoHandler.getMo(string);
            boolean bl = this.theMoHandler.isExisting(bemMo);
            if (!bl) continue;
            BemMo bemMo2 = (BemMo)this.theMoHandler.getAttribute(bemMo, "aal5TpVccTpId");
            BemMo bemMo3 = (BemMo)this.theMoHandler.getAttribute(bemMo2, "vclTpId");
            String string2 = bemMo3.getDN();
            String string3 = this.extractAtmPortLdn(string2);
            this.atmPortsUsedForIpAtmLinks.put(new Integer(i), string3);
        }
    }

    public String extractAtmPortLdn(String string) {
        String string2 = null;
        int n = string.indexOf(MimAtmPort.MOTYPENAME + "=");
        if (n != -1) {
            int n2 = string.indexOf(",", n);
            string2 = n2 != -1 ? string.substring(0, n2) : string;
        }
        return string2;
    }

    public String extractSlotNo(String string) {
        String string2 = null;
        String string3 = MimSlot.MOTYPENAME + "=";
        int n = string3.length();
        int n2 = string.indexOf(string3);
        if (n2 != -1) {
            int n3 = string.indexOf(",", n2);
            string2 = n3 != -1 ? string.substring(n2 + n, n3) : string.substring(n2 + n);
        }
        return string2;
    }

    private void arrangeEtmTerminationLoaders() {
        this.terminationLoaders = new HashMap();
        String[] stringArray = this.etmBoardProvider.getSupportedEtmBoardTypesForAtm();
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = this.boardManager.getSlotsForBoardType(stringArray[i]);
            if (stringArray2 == null) continue;
            for (int j = 0; j < stringArray2.length; ++j) {
                this.terminationLoaders.put(stringArray2[j], this.etmTypeLoaders.get(stringArray[i]));
            }
        }
    }

    protected String getTransportNetworkLdn() throws MoHandlerException {
        BemMo bemMo = this.theMoHandler.getRoot();
        BemMo[] bemMoArray = this.theMoHandler.getChildren(bemMo, 1, MimTransportNetwork.MOTYPENAME, "");
        String string = bemMoArray[0].getDN();
        return string;
    }
}

