/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.cabinetbasic;

import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.BemLog;
import se.ericsson.wcdma.rbs.bem.common.OneLeggedRpuLabels;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractResourceItem;
import se.ericsson.wcdma.rbs.bem.common.config.resource.ResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimReliableProgramUniter;
import se.ericsson.wcdma.rbs.bem.common.mim.MimSlot;
import se.ericsson.wcdma.rbs.bem.common.mim.MimSwManagement;
import se.ericsson.wcdma.rbs.bem.common.moi.FixedRdnMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.HubSubrackMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.RootMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.SingleChildMoi;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;

public class ReliableProgramUniterRI
extends AbstractResourceItem
implements ResourceItem {
    static final String[] myInstallationPhases = new String[]{"AuxUnitDbControlledCreationPhase", "SupportSystemStartupPhase"};
    protected static final String name = "RELIABLE_PROGRAM_UNITER";
    protected final int primarySlotNo;
    protected final int passiveSlotNo;
    protected final HubSubrackMoi subrackMoi;
    protected static final String SUPPORT_SYSTEM_CTRL_RPU = "RBS_support_system_ctrl";
    protected final boolean supportSystemAvailable;

    public ReliableProgramUniterRI(Rbs rbs, HubSubrackMoi hubSubrackMoi, int n, int n2, boolean bl) {
        super(name, rbs, myInstallationPhases);
        this.subrackMoi = hubSubrackMoi;
        this.primarySlotNo = n2;
        this.passiveSlotNo = n;
        this.supportSystemAvailable = bl;
    }

    public void install(String string) throws BemException {
        if (super.containsPhase(this.getInstallationPhases(), string)) {
            if (string.equals("AuxUnitDbControlledCreationPhase")) {
                String string2;
                String string3 = this.checkIfRedundantCbuSelected();
                if (string3.equals("YES")) {
                    FixedRdnMoi fixedRdnMoi = new FixedRdnMoi(this.subrackMoi, MimSlot.MOTYPENAME, String.valueOf(this.passiveSlotNo));
                    string2 = fixedRdnMoi.getLdn();
                    BemLog.log(7, "ReliableProgramUniter (CBU redundant = YES) passiveSlotLdn: " + string2);
                } else {
                    string2 = null;
                    BemLog.log(7, "ReliableProgramUniter (CBU redundant = NO) clearing admPassiveSlot");
                }
                this.setParameters(string2);
            } else if (string.equals("SupportSystemStartupPhase") && this.supportSystemAvailable) {
                this.createSupportSystemRpuIfNotExist();
            }
        }
    }

    protected void setParameters(String string) throws BemException {
        FixedRdnMoi fixedRdnMoi = new FixedRdnMoi(this.subrackMoi, MimSlot.MOTYPENAME, String.valueOf(this.primarySlotNo));
        String string2 = fixedRdnMoi.getLdn();
        BemMo bemMo = this.getMo(string);
        BemMo bemMo2 = this.getMo(string2);
        RootMoi rootMoi = new RootMoi();
        SingleChildMoi singleChildMoi = new SingleChildMoi(rootMoi, MimSwManagement.MOTYPENAME, "1");
        BemMo bemMo3 = this.getMo(singleChildMoi.getLdn());
        BemMo[] bemMoArray = this.getChildren(bemMo3, 1, MimReliableProgramUniter.MOTYPENAME, "");
        if (bemMoArray != null) {
            for (int i = 0; i < bemMoArray.length; ++i) {
                BemMo bemMo4 = bemMoArray[i];
                boolean bl = this.isPassiveSlotSet(bemMo4, string);
                if (bl) continue;
                if (OneLeggedRpuLabels.isOneLegged(bemMo4)) {
                    BemLog.log(7, "OneLegged=yes, ReliableProgramUniter rpu " + bemMo4.getLastRDN() + " Skip Setting passiveSlotLdn: " + bemMo.getDN());
                } else {
                    this.setAttribute(bemMo4, "admPassiveSlot", (Object)bemMo);
                    BemLog.log(7, "ReliableProgramUniter rpu " + bemMo4.getLastRDN() + " Setting passiveSlotLdn: " + bemMo.getDN());
                }
                boolean bl2 = this.isActiveSlotSet(bemMo4, string2);
                if (bemMo2 == null || bl2) continue;
                this.setAttribute(bemMo4, "admActiveSlot", (Object)bemMo2);
                BemLog.log(7, "ReliableProgramUnierrpu " + bemMo4.getLastRDN() + "Setting activeSlotLdn: " + bemMo2.getDN());
            }
        }
    }

    protected void createSupportSystemRpuIfNotExist() throws BemException {
        Object object;
        RootMoi rootMoi = new RootMoi();
        SingleChildMoi singleChildMoi = new SingleChildMoi(rootMoi, MimSwManagement.MOTYPENAME, "1");
        BemMo bemMo = this.getMo(singleChildMoi.getLdn());
        BemMo[] bemMoArray = this.getChildren(bemMo, 1, MimReliableProgramUniter.MOTYPENAME, "");
        boolean bl = false;
        if (bemMoArray != null) {
            for (int i = 0; i < bemMoArray.length && !(bl = (object = bemMoArray[i]).getAttribute("reliableProgramLabel").equals(SUPPORT_SYSTEM_CTRL_RPU)); ++i) {
            }
        }
        if (!bl) {
            FixedRdnMoi fixedRdnMoi = new FixedRdnMoi(singleChildMoi, MimReliableProgramUniter.MOTYPENAME, SUPPORT_SYSTEM_CTRL_RPU);
            object = fixedRdnMoi.getLdn();
            BemMo bemMo2 = this.getMo((String)object);
            FixedRdnMoi fixedRdnMoi2 = new FixedRdnMoi(this.subrackMoi, MimSlot.MOTYPENAME, String.valueOf(this.primarySlotNo));
            BemMo bemMo3 = this.getMo(fixedRdnMoi2.getLdn());
            Vector<NalNameValue> vector = new Vector<NalNameValue>(0);
            vector.addElement(Nal.getFactory().getNameValue("admActiveSlot", bemMo3));
            vector.addElement(Nal.getFactory().getNameValue("reliableProgramLabel", SUPPORT_SYSTEM_CTRL_RPU));
            this.create(bemMo2, vector);
        }
    }

    private boolean isPassiveSlotSet(BemMo bemMo, String string) throws BemException {
        String string2;
        boolean bl = false;
        BemMo bemMo2 = (BemMo)this.getAttribute(bemMo, "admPassiveSlot");
        if (bemMo2 != null && (string2 = bemMo2.getDN()) != null && string2.equals(string)) {
            bl = true;
        }
        return bl;
    }

    private boolean isActiveSlotSet(BemMo bemMo, String string) throws BemException {
        String string2;
        boolean bl = false;
        BemMo bemMo2 = (BemMo)this.getAttribute(bemMo, "admActiveSlot");
        if (bemMo2 != null && (string2 = bemMo2.getDN()) != null && string2.equals(string)) {
            bl = true;
        }
        return bl;
    }

    private String checkIfRedundantCbuSelected() throws BemException {
        String string = "NO";
        CustomerParameter customerParameter = super.getCustomerParameter("redundantControlSystem");
        string = customerParameter.getValue();
        return string;
    }

    public String getDisplayName() {
        return name;
    }

    public String getLdn() {
        return "";
    }
}

