/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.resource;

import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandler;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerException;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalCmException;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalFactory;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalLog;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;

public class SupportSystemControlRI
extends AbstractResourceItem {
    private static final String NAME = "SupportSystemControl";
    private static final String[] myInstallationPhases = new String[]{"SupportSystemControlPhase", "SupportSystemControlDeletionPhase"};
    private static final NalLog log = Nal.getLog();
    private MoInstance equipmentSupportFunctionMoi;
    private String equipmentSupportFunctionLdn;
    private String supportSystemControlAttributeValue;

    public SupportSystemControlRI(Rbs rbs, MoInstance moInstance) throws BemException {
        super(NAME, rbs, myInstallationPhases);
        this.equipmentSupportFunctionMoi = moInstance;
        this.createLdn();
    }

    public void install(String string) throws BemException {
        if (super.containsPhase(this.getInstallationPhases(), string)) {
            try {
                this.setSupportSystemControl();
            }
            catch (BemException bemException) {
                throw new BemException(bemException.toString() + "Can not set attribute supportSystemControl in MO EquipmentSupportFunction.");
            }
        }
    }

    public void uninstall(String string) throws BemException {
        if (super.containsPhase(this.getInstallationPhases(), string)) {
            try {
                this.setSupportSystemControl();
            }
            catch (BemException bemException) {
                throw new BemException(bemException.toString() + "Can not set attribute supportSystemControl in MO EquipmentSupportFunction.");
            }
        }
    }

    public String getDisplayName() {
        return "SupportSystemControl: " + this.getLdn();
    }

    public String getLdn() {
        return this.equipmentSupportFunctionLdn;
    }

    public boolean isInstalled() throws BemException {
        boolean bl = false;
        MoHandler moHandler = this.rbs.getMoHandler();
        BemMo bemMo = moHandler.getMo(this.equipmentSupportFunctionLdn);
        try {
            Boolean bl2;
            if (bemMo.isExisting() && (bl2 = (Boolean)moHandler.getAttribute(bemMo, "supportSystemControl")) != null) {
                this.supportSystemControlAttributeValue = bl2 != false ? "TRUE" : "FALSE";
                bl = true;
            }
        }
        catch (MoHandlerException moHandlerException) {
            throw new BemException(moHandlerException.toString());
        }
        catch (NalCmException nalCmException) {
            throw new BemException(nalCmException.toString());
        }
        return bl;
    }

    public String getSupportSystemControlValue() {
        return this.supportSystemControlAttributeValue;
    }

    public String getConfiguredSupportSystemControlValue() throws BemException {
        CustomerParameter customerParameter = this.rbs.getCustomerParameterObject("supportSystemControl");
        String string = customerParameter.getValue();
        return string;
    }

    private void createLdn() throws BemException {
        this.equipmentSupportFunctionLdn = this.equipmentSupportFunctionMoi.getLdn();
    }

    private void setSupportSystemControl() throws BemException {
        String string;
        MoHandler moHandler = this.rbs.getMoHandler();
        BemMo bemMo = moHandler.getMo(this.equipmentSupportFunctionLdn);
        CustomerParameter customerParameter = this.rbs.getCustomerParameterObject("supportSystemControl");
        if (customerParameter != null && customerParameter.hasValueChanged() && (string = customerParameter.getValue()) != null) {
            try {
                this.waitForEquipmentSupportFunction();
                if (!this.isExisting(bemMo)) {
                    throw new BemException("", "install()", this.equipmentSupportFunctionLdn, "Trying to set attribute supportSystemControl, but MO EquipmentSupportFunction does not exist.", null);
                }
                moHandler.setAttribute(bemMo, "supportSystemControl", Boolean.valueOf(string));
            }
            catch (MoHandlerException moHandlerException) {
                throw new BemException(moHandlerException.toString());
            }
        }
    }

    private void waitForEquipmentSupportFunction() throws BemException {
        String string;
        block2: {
            string = "MO EquipmentSupportFunction: " + this.getLdn();
            BemMo bemMo = this.getMo(this.getLdn());
            long l = System.currentTimeMillis() + 240000L;
            do {
                log.nalTrace(6, this.getClass(), string + " Wait until created.");
                boolean bl = this.isExisting(bemMo);
                if (bl) break block2;
                if (l < System.currentTimeMillis()) {
                    log.nalTrace(2, this.getClass(), string + " Timed out before existing!");
                    String string2 = "Setting supportSystemControl failed, MO EquipmentSupportFunction does not exist ldn=" + this.getLdn();
                    throw new BemException(this.getClass() + string2);
                }
                this.delay_ms(500);
            } while (!this.isInterrupted());
            log.nalTrace(2, this.getClass(), string + " Interupted by user before existing!");
            String string3 = "Setting supportSystemControl failed, user interrupted creation of MO ldn=" + this.getLdn();
            throw new BemException(this.getClass() + string3);
        }
        log.nalTrace(6, this.getClass(), string + " Is now existing.");
    }

    protected void delay_ms(int n) {
        if (this.isInterrupted()) {
            return;
        }
        try {
            NalFactory nalFactory = Nal.getFactory();
            nalFactory.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    protected boolean isInterrupted() {
        if (Thread.currentThread().isInterrupted()) {
            Nal.getLog().nalTrace(6, this.getClass(), "interupted by user");
            return true;
        }
        return false;
    }
}

