/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.iub.resource;

import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.iub.resource.atm.IubOverAtmManager;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimVclTp;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;

public class NbapCommonProtocolStackRI
extends AbstractResourceItem {
    public static final String name = "NbapCommonProtocolStack";
    private static final String[] myPhases = new String[]{"NbapCommonCreationPhase"};
    private final String atmTrafficDescriptorId;
    private String atmId;
    private static final String vpcTpId = "1";
    private static final String vplTpId = "vp1";
    private static final Integer externalVci1 = new Integer(36);
    private static final Integer externalVci2 = new Integer(43);
    private static final String externalVclTp1Id = "vc36";
    private static final String externalVclTp2Id = "vc43";
    private static final String aal5TpVccTp3Id = "bca";
    private static final String aal5TpVccTp4Id = "bcb";
    private static final String uniSaalTp3Id = "bca";
    private static final String uniSaalTp4Id = "bcb";
    private static final Integer maxSduSize = new Integer(2044);
    private static final String uniSaalProfileId = "win30";
    private static final Integer initalCredit = new Integer(30);
    private String etbSlot;
    private String etxSlot;
    private boolean isIp;
    private boolean isAtm;

    public NbapCommonProtocolStackRI(Rbs rbs, String string) {
        super(name, rbs, myPhases);
        this.atmTrafficDescriptorId = string;
    }

    private void initialiseMois() throws BemException {
        this.etxSlot = this.rbs.getCustomerParameter("IpIubTestConfiguration_etxSlot");
        this.etbSlot = this.rbs.getCustomerParameter("IubNpcTestConfiguration_etbSlot");
        if (!this.etxSlot.equals("##UNDEFINED")) {
            this.isIp = true;
        }
        if (!this.etbSlot.equals("##UNDEFINED")) {
            this.isAtm = true;
            this.atmId = "1-" + this.etbSlot + "-1";
        }
    }

    public void install(String string) throws BemException {
        if (super.containsPhase(this.getInstallationPhases(), string)) {
            this.initialiseMois();
            this.configureMos(this.atmTrafficDescriptorId);
        }
    }

    private void configureMos(String string) throws BemException {
        MoInstance moInstance = this.rbs.getMoiRefs().getNbapCommonMoi();
        BemMo bemMo = this.getMo(moInstance.getLdn());
        boolean bl = this.isExisting(bemMo);
        Vector<NalNameValue> vector = new Vector<NalNameValue>();
        if (!bl) {
            Comparable comparable;
            if (this.isAtm) {
                String string2 = IubOverAtmManager.getAtmTrafficDescriptorLdn(string);
                comparable = this.getMo(string2);
                String string3 = IubOverAtmManager.getVpcTpLdn(vplTpId, vpcTpId, this.atmId);
                String string4 = string3 + "," + MimVclTp.MOTYPENAME + "=" + externalVclTp1Id;
                Vector vector2 = IubOverAtmManager.getVclTpAttributes(externalVci1, comparable);
                this.createMoIfNotExisting(string4, vector2);
                BemMo bemMo2 = this.getMo(string4);
                String string5 = IubOverAtmManager.getAal5TpVccTpLdn("bca");
                Vector vector3 = IubOverAtmManager.getAal5TpVccTpAttributes(this.rbs, bemMo2);
                this.createMoIfNotExisting(string5, vector3);
                BemMo bemMo3 = this.getMo(string5);
                String string6 = IubOverAtmManager.getAal5TpVccTpLdn("bcb");
                String string7 = IubOverAtmManager.getUniSaalProfileLdn(uniSaalProfileId);
                Vector vector4 = IubOverAtmManager.getUniSaalProfileAttributes(initalCredit);
                this.createMoIfNotExisting(string7, vector4);
                BemMo bemMo4 = this.getMo(string7);
                String string8 = IubOverAtmManager.getUniSaalTpLdn("bca");
                Vector vector5 = IubOverAtmManager.getUniSaalTpAttributes(bemMo4, bemMo3, maxSduSize);
                this.createMoIfNotExisting(string8, vector5);
                BemMo bemMo5 = this.getMo(string8);
                vector.add(Nal.getFactory().getNameValue("uniSaalTpRef1", bemMo5));
                if (IubOverAtmManager.isIubRedunancyAllowed()) {
                    String string9 = string3 + "," + MimVclTp.MOTYPENAME + "=" + externalVclTp2Id;
                    Vector vector6 = IubOverAtmManager.getVclTpAttributes(externalVci2, comparable);
                    this.createMoIfNotExisting(string9, vector6);
                    BemMo bemMo6 = this.getMo(string9);
                    String string10 = IubOverAtmManager.getUniSaalTpLdn("bcb");
                    Vector vector7 = IubOverAtmManager.getAal5TpVccTpAttributes(this.rbs, bemMo6);
                    this.createMoIfNotExisting(string6, vector7);
                    BemMo bemMo7 = this.getMo(string6);
                    Vector vector8 = IubOverAtmManager.getUniSaalTpAttributes(bemMo4, bemMo7, maxSduSize);
                    this.createMoIfNotExisting(string10, vector8);
                    BemMo bemMo8 = this.getMo(string10);
                    vector.add(Nal.getFactory().getNameValue("uniSaalTpRef2", bemMo8));
                }
            }
            if (this.isIp) {
                comparable = new Integer(0);
                vector.add(Nal.getFactory().getNameValue("alarmStatus", comparable));
            }
            this.create(bemMo, vector);
        }
    }

    public String getLdn() {
        return null;
    }

    public String getDisplayName() {
        return name;
    }
}

