/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment;

import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.FuRI;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.AtfProvider;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractRbsSubrackRI;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimFuDeviceGroup;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.moi.RbsSubrackMoi;

public class FuSubrackRI
extends AbstractRbsSubrackRI {
    private static final String name = "FuSubrack";
    private FuRI[] boards;
    private String ldn;
    private MoInstance moi;
    private int firstPositionSlot;

    public FuSubrackRI(Rbs rbs, int n, String string, String string2) throws BemException {
        this(rbs, n, string, string2, 2);
    }

    public FuSubrackRI(Rbs rbs, int n, String string, String string2, int n2) throws BemException {
        super(name, rbs, n, string, string2);
        this.boards = new FuRI[n];
        this.moi = new RbsSubrackMoi(new String[]{MimFuDeviceGroup.MOTYPENAME}, "FU1");
        this.ldn = this.moi.getLdn();
        this.firstPositionSlot = n2;
        int n3 = 1;
        for (int i = n2; i <= n; ++i) {
            this.createSlot(i, new FuRI(rbs, this.moi, i, AtfProvider.ALL_CONTROLLERS_OF_FU_INDEXED_BY_POSITION[n3]));
            ++n3;
        }
    }

    public String getLdn() {
        return this.ldn;
    }

    public String getDisplayName() {
        return "FuSubrack:" + this.ldn;
    }

    public FuRI[] getSubRIs() {
        FuRI[] fuRIArray = new FuRI[this.boards.length - (this.firstPositionSlot - 1)];
        for (int i = 0; i < fuRIArray.length; ++i) {
            fuRIArray[i] = this.boards[i + (this.firstPositionSlot - 1)];
        }
        return fuRIArray;
    }

    public FuRI getSlot(int n) throws BemException {
        if (n < this.firstPositionSlot || n > this.getNoOfSlots()) {
            throw new BemException("FuSubrack.getSlot() slot number out of range: " + n);
        }
        return this.boards[n - 1];
    }

    private void createSlot(int n, FuRI fuRI) {
        this.boards[n - 1] = fuRI;
    }
}

