/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment;

import java.text.MessageFormat;
import java.util.ArrayList;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.TxDeviceInfoRI;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimTxDeviceGroup;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandler;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerException;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalCmException;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;

public class HspaSettingsRI
extends AbstractResourceItem {
    private static String name = "HspaSettingsRI";
    private BemMo txDeviceGroupMoProxy;
    private String slot;
    private Integer numHsCodeResources = MimTxDeviceGroup.DEFAULT_NUMHSCODERESOURCES;
    private Integer numEulResources = MimTxDeviceGroup.DEFAULT_NUMEULRESOURCES;
    private static final String[] myInstallationPhases = new String[]{"GenericSettingsPhase"};

    public HspaSettingsRI(Rbs rbs, String string, TxDeviceInfoRI txDeviceInfoRI) throws BemException, MoHandlerException {
        super(name, rbs, myInstallationPhases);
        this.slot = string;
        this.txDeviceGroupMoProxy = txDeviceInfoRI.getTxbForSLot(string);
    }

    public void install(String string) throws BemException {
        if (super.containsPhase(this.getInstallationPhases(), string)) {
            ArrayList<NalNameValue> arrayList = new ArrayList<NalNameValue>();
            String string2 = MessageFormat.format("hsSlot{0}_numHsCodeResources", new Integer(this.slot));
            CustomerParameter customerParameter = this.getRbs().getCustomerParameterObject(string2);
            if (customerParameter.hasValueChanged()) {
                this.numHsCodeResources = new Integer(customerParameter.getValue());
                arrayList.add(Nal.getFactory().getNameValue("numHsCodeResources", this.numHsCodeResources));
            }
            string2 = MessageFormat.format("eulSlot{0}_numEulResources", new Integer(this.slot));
            customerParameter = this.getRbs().getCustomerParameterObject(string2);
            if (customerParameter.hasValueChanged()) {
                this.numEulResources = new Integer(customerParameter.getValue());
                arrayList.add(Nal.getFactory().getNameValue("numEulResources", this.numEulResources));
            }
            if (arrayList.size() > 0) {
                NalNameValue[] nalNameValueArray = arrayList.toArray(new NalNameValue[0]);
                MoHandler moHandler = this.getRbs().getMoHandler();
                try {
                    if (moHandler.isExisting(this.txDeviceGroupMoProxy)) {
                        moHandler.setAttributes(this.txDeviceGroupMoProxy, nalNameValueArray);
                    }
                }
                catch (MoHandlerException moHandlerException) {
                    String string3 = moHandlerException.getAction();
                    String string4 = moHandlerException.getLdn();
                    String string5 = moHandlerException.getAdditionalInfo();
                    throw new BemException(string3, "HspaSettingsRI install()", string4, string5, moHandlerException);
                }
            }
        }
    }

    public int getNumHsCodeResources() throws BemException {
        String string = this.numHsCodeResources.toString();
        try {
            Integer n;
            MoHandler moHandler = this.getRbs().getMoHandler();
            if (this.txDeviceGroupMoProxy.isExisting() && (n = (Integer)moHandler.getAttribute(this.txDeviceGroupMoProxy, "numHsCodeResources")) != null) {
                string = n.toString();
            }
        }
        catch (MoHandlerException moHandlerException) {
            String string2 = moHandlerException.getAction();
            String string3 = moHandlerException.getLdn();
            String string4 = moHandlerException.getAdditionalInfo();
            throw new BemException(string2, "HspaSettingsRI getNumHsCodeResources()", string3, string4, moHandlerException);
        }
        catch (NalCmException nalCmException) {
            throw new BemException(nalCmException.toString());
        }
        int n = Integer.parseInt(string);
        return n;
    }

    public int getNumEulResources() throws BemException {
        String string = this.numEulResources.toString();
        int n = MimTxDeviceGroup.DEFAULT_NUMEULRESOURCES;
        try {
            Integer n2;
            MoHandler moHandler = this.getRbs().getMoHandler();
            if (this.txDeviceGroupMoProxy.isExisting() && (n2 = (Integer)moHandler.getAttribute(this.txDeviceGroupMoProxy, "numEulResources")) != null) {
                string = n2.toString();
                n = Integer.parseInt(string);
            }
        }
        catch (MoHandlerException moHandlerException) {
            String string2 = moHandlerException.getAction();
            String string3 = moHandlerException.getLdn();
            String string4 = moHandlerException.getAdditionalInfo();
            throw new BemException(string2, "HspaSettingsRI getNumEulResources()", string3, string4, moHandlerException);
        }
        catch (NalCmException nalCmException) {
            throw new BemException(nalCmException.toString());
        }
        return n;
    }

    public String getLdn() {
        String string = this.txDeviceGroupMoProxy.getDN();
        return string;
    }

    public String getDisplayName() {
        return name + ": " + this.getLdn();
    }

    public boolean isInstalled() throws BemException {
        return false;
    }
}

