/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb;

import java.text.MessageFormat;
import java.util.ArrayList;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.CpriProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.AllocatedRuwSlot;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.hspamgmt.HspaResourcesManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.modifymgmt.ModifyManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.rbbmgmt.AbstractRbb;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.rbbmgmt.RbbManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.scpm.SectorCustomerParameterManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.DuwUtil;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.SectorUtil;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.definitions.AuUnitType;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.definitions.RbsInfo;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.definitions.RbsSteps;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractRuRI;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;

public abstract class ConsistencyChecker {
    public static void checkConsistency(Rbs rbs, SectorCustomerParameterManager sectorCustomerParameterManager, RbbManager rbbManager, CpriProvider cpriProvider, HspaResourcesManager hspaResourcesManager, ModifyManager modifyManager, int n, boolean bl) throws BemException {
        ConsistencyChecker.checkConsistency(rbs, sectorCustomerParameterManager, rbbManager, cpriProvider, hspaResourcesManager, modifyManager, n, 1, bl);
    }

    public static void checkConsistency(Rbs rbs, SectorCustomerParameterManager sectorCustomerParameterManager, RbbManager rbbManager, CpriProvider cpriProvider, HspaResourcesManager hspaResourcesManager, ModifyManager modifyManager, int n, int n2, boolean bl) throws BemException {
        if (bl) {
            ConsistencyChecker.checkSectorCreationRules(rbs, sectorCustomerParameterManager, rbbManager);
            modifyManager.checkConsistency();
        }
        ConsistencyChecker.checkSectorDependentCustomerParameterRules(rbs, sectorCustomerParameterManager, rbbManager, cpriProvider, n, n2);
        ConsistencyChecker.checkHspaConsistency(hspaResourcesManager);
    }

    private static void checkSectorCreationRules(Rbs rbs, SectorCustomerParameterManager sectorCustomerParameterManager, RbbManager rbbManager) throws BemException {
        if (rbs.isCabinetWiz() && RbsInfo.RBS_6501W.NAME.equals(rbs.getRbsType())) {
            sectorCustomerParameterManager.checkThatOnlyOneSectorIsConfigured();
        }
        if (rbs.isSiteWiz() || RbsSteps.isIntegrateStep(rbs.getRbsStep())) {
            sectorCustomerParameterManager.checkThatAtLeastOneSectorIsConfigured();
        }
    }

    private static void checkHspaConsistency(HspaResourcesManager hspaResourcesManager) throws BemException {
        hspaResourcesManager.checkConsistency();
    }

    private static void checkSectorDependentCustomerParameterRules(Rbs rbs, SectorCustomerParameterManager sectorCustomerParameterManager, RbbManager rbbManager, CpriProvider cpriProvider, int n, int n2) throws BemException {
        sectorCustomerParameterManager.checkForSectorNumberWithoutLineRate();
        sectorCustomerParameterManager.checkThatNoCpsAreSetForNotConfiguredSector();
        ConsistencyChecker.checkNoOverRuPositionNumber(sectorCustomerParameterManager, rbbManager, n2);
        ConsistencyChecker.checkThatAllCascadedRbbsCanBeCascaded(sectorCustomerParameterManager, rbbManager, n2);
        ConsistencyChecker.checkThatNoCascadeRbbsIsPutAfterAnNonCascadable(rbs, sectorCustomerParameterManager, rbbManager, n2);
        ConsistencyChecker.checkForHolesInCascadeChains(sectorCustomerParameterManager, rbbManager, n2);
        ConsistencyChecker.checkThatSecondaryPortIdConfiguredForTwoCpriLinkRbbs(sectorCustomerParameterManager, rbbManager, n2);
        ConsistencyChecker.checkThatRruIsOnlyConfiguredLineRate(sectorCustomerParameterManager, rbbManager, n2);
        ConsistencyChecker.checkCpriSpecificRules(rbs, sectorCustomerParameterManager, rbbManager, n, n2);
        ConsistencyChecker.checkThatCpriIsOnlyAllocatedInDescendingOrder(sectorCustomerParameterManager, rbbManager);
        ConsistencyChecker.checkThatRbbIsConfiguredForAllSetRbbCp(sectorCustomerParameterManager, rbbManager, n, n2);
        ConsistencyChecker.checkThatSectorSequenceIsSetForCascadingSectors(sectorCustomerParameterManager, rbbManager);
        ConsistencyChecker.checkThatSecondaryPortIdIsUnique(rbbManager, n, n2);
        ConsistencyChecker.checkRadioSharedBySectorUnnique(sectorCustomerParameterManager, rbbManager, n2);
        ConsistencyChecker.checkOnlyAir32ExistInOneCascadingChain(rbs, sectorCustomerParameterManager, rbbManager, n2);
        ConsistencyChecker.checkThatCabinetNumberShallNotConfigureForMainRemoteRadio(sectorCustomerParameterManager, n, n2);
    }

    private static void checkOnlyAir32ExistInOneCascadingChain(Rbs rbs, SectorCustomerParameterManager sectorCustomerParameterManager, RbbManager rbbManager, int n) throws BemException {
        int n2 = rbbManager.getMaxNumberOfSectors();
        for (int i = 0; i < n2; ++i) {
            int n3 = SectorUtil.getSectorNumberFromSectorIndex(i, n);
            int n4 = ConsistencyChecker.findFollowerOnPrimaryPortId(rbs, sectorCustomerParameterManager, rbbManager, n3, n);
            if (n4 == 0 || (!sectorCustomerParameterManager.isAir32Configured(n3) || sectorCustomerParameterManager.isAir32Configured(n4)) && (sectorCustomerParameterManager.isAir32Configured(n3) || !sectorCustomerParameterManager.isAir32Configured(n4))) continue;
            throw new BemException("Only RBB44_1D with AIR is supported in AIR32 Cascading Chain.");
        }
    }

    private static void checkThatSectorSequenceIsSetForCascadingSectors(SectorCustomerParameterManager sectorCustomerParameterManager, RbbManager rbbManager) throws BemException {
        int[][] nArray = rbbManager.getEquippedSectorsCpriLinks();
        if (nArray != null) {
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i].length <= 1) continue;
                for (int j = 0; j < nArray[i].length; ++j) {
                    int n = nArray[i][j];
                    String string = sectorCustomerParameterManager.getUntranslatedSectorSequenceForSector(n);
                    if (string != null && !string.equals("")) continue;
                    throw new BemException("Sector sequence is not set for cascaded sector. Faulty sector number=" + n + ".");
                }
            }
        }
    }

    private static void checkThatSecondaryPortIdIsUnique(RbbManager rbbManager, int n, int n2) throws BemException {
        int n3;
        String[] stringArray = new String[n];
        for (n3 = 0; n3 < n; ++n3) {
            int n4 = SectorUtil.getSectorNumberFromSectorIndex(n3, n2);
            AbstractRbb abstractRbb = rbbManager.getRadioBuildingBlock(n4);
            if (abstractRbb != null) {
                String string = abstractRbb.getSecondaryPortId();
                if (string == null || string.equals("")) {
                    stringArray[n3] = null;
                    continue;
                }
                stringArray[n3] = string;
                continue;
            }
            stringArray[n3] = null;
        }
        for (n3 = 0; n3 < n; ++n3) {
            String string = stringArray[n3];
            if (string == null) continue;
            for (int i = 0; i < n; ++i) {
                String string2;
                int n5 = SectorUtil.getSectorNumberFromSectorIndex(i, n2);
                AbstractRbb abstractRbb = rbbManager.getRadioBuildingBlock(n5);
                if (abstractRbb == null || !(string2 = abstractRbb.getPrimaryPortId()).equals(string)) continue;
                int n6 = SectorUtil.getSectorNumberFromSectorIndex(n3, n2);
                int n7 = SectorUtil.getSectorNumberFromSectorIndex(i, n2);
                throw new BemException("secondaryPortId used for sector " + n6 + " is not unique. It is used also as primaryPortId for sector " + n7 + ".");
            }
        }
    }

    private static void checkThatRbbIsConfiguredForAllSetRbbCp(SectorCustomerParameterManager sectorCustomerParameterManager, RbbManager rbbManager, int n, int n2) throws BemException {
        int[] nArray = rbbManager.getEquippedSectors();
        for (int i = 0; i < n; ++i) {
            int n3 = SectorUtil.getSectorNumberFromSectorIndex(i, n2);
            if (!sectorCustomerParameterManager.isRbbNameForSectorSet(n3)) continue;
            if (nArray != null && nArray.length > 0) {
                boolean bl = false;
                for (int j = 0; j < nArray.length; ++j) {
                    if (n3 != nArray[j]) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                throw new BemException("checkThatRbbIsConfiguredForAllSetRbbCp() Can not interprete Sector info for sector number=" + n3 + ".");
            }
            throw new BemException("checkThatRbbIsConfiguredForAllSetRbbCp() Can not interprete Sector info for sector number=" + n3 + ".");
        }
    }

    private static void checkThatCpriIsOnlyAllocatedInDescendingOrder(SectorCustomerParameterManager sectorCustomerParameterManager, RbbManager rbbManager) throws BemException {
        int[][] nArray = rbbManager.getEquippedSectorsCpriLinks();
        if (nArray != null) {
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i].length <= 1) continue;
                boolean bl = false;
                for (int j = 0; j < nArray[i].length; ++j) {
                    int n = nArray[i][j];
                    String string = sectorCustomerParameterManager.getLineRateForSector(n);
                    if (string.endsWith("2")) {
                        bl = true;
                        continue;
                    }
                    if (string.endsWith("4")) {
                        if (!bl) continue;
                        throw new BemException("CPRI Line Rates can only be assigned in descending order. Faulty sector number=" + n + ".");
                    }
                    throw new BemException("checkThatCpriIsOnlyAllocatedInDescendingOrder() Can not interprete Linerate for sector number=" + n + ".");
                }
            }
        }
    }

    private static void checkThatAllCascadedRbbsCanBeCascaded(SectorCustomerParameterManager sectorCustomerParameterManager, RbbManager rbbManager, int n) throws BemException {
        int n2 = rbbManager.getMaxNumberOfSectors();
        for (int i = 0; i < n2; ++i) {
            int n3 = SectorUtil.getSectorNumberFromSectorIndex(i, n);
            AbstractRbb abstractRbb = rbbManager.getRadioBuildingBlock(n3);
            if (abstractRbb == null) continue;
            String string = abstractRbb.getName();
            String string2 = sectorCustomerParameterManager.getSectorSequenceForSector(n3);
            if (string2.equals("1")) continue;
            if (!abstractRbb.canBeCascaded()) {
                throw new BemException(string + " do not support sequence number higher than 1.");
            }
            ConsistencyChecker.checkAIR32CascadedRbbsNumberLimitation(sectorCustomerParameterManager, string, n3, string2);
        }
    }

    private static void checkAIR32CascadedRbbsNumberLimitation(SectorCustomerParameterManager sectorCustomerParameterManager, String string, int n, String string2) throws BemException {
        if (sectorCustomerParameterManager.getAuUnitTypeForSector(n).equalsIgnoreCase("AIR") && string.equalsIgnoreCase("RBB44_1D") && Integer.parseInt(string2) > 3) {
            throw new BemException(string + " with Air do not support sequence number higher than 3.");
        }
    }

    private static void checkThatRruIsOnlyConfiguredLineRate(SectorCustomerParameterManager sectorCustomerParameterManager, RbbManager rbbManager, int n) throws BemException {
        int n2 = rbbManager.getMaxNumberOfSectors();
        for (int i = 0; i < n2; ++i) {
            String string;
            int n3 = SectorUtil.getSectorNumberFromSectorIndex(i, n);
            AbstractRbb abstractRbb = rbbManager.getRadioBuildingBlock(n3);
            if (abstractRbb == null || !sectorCustomerParameterManager.isRruInstalledConfigured(n3) || (string = sectorCustomerParameterManager.getLineRateForSector(n3)).equals("X2")) continue;
            throw new BemException("RRU22 is restricted, only X2 is allowed.");
        }
    }

    private static void checkThatSecondaryPortIdConfiguredForTwoCpriLinkRbbs(SectorCustomerParameterManager sectorCustomerParameterManager, RbbManager rbbManager, int n) throws BemException {
        int n2 = rbbManager.getMaxNumberOfSectors();
        for (int i = 0; i < n2; ++i) {
            boolean bl;
            int n3;
            int n4 = SectorUtil.getSectorNumberFromSectorIndex(i, n);
            AbstractRbb abstractRbb = rbbManager.getRadioBuildingBlock(n4);
            if (abstractRbb == null || (n3 = abstractRbb.getNumberOfCpriLinks()) != 2 || abstractRbb.needRuPositionAllocation() || (bl = sectorCustomerParameterManager.isSecondaryPortIdConfigured(n4))) continue;
            throw new BemException("Sector " + n4 + " does not have secondary port id configured, but have RBB with 2 CPRI links.");
        }
    }

    private static void checkForHolesInCascadeChains(SectorCustomerParameterManager sectorCustomerParameterManager, RbbManager rbbManager, int n) throws BemException {
        int n2 = rbbManager.getMaxNumberOfSectors();
        for (int i = 0; i < n2; ++i) {
            int n3 = SectorUtil.getSectorNumberFromSectorIndex(i, n);
            AbstractRbb abstractRbb = rbbManager.getRadioBuildingBlock(n3);
            if (abstractRbb == null) continue;
            String string = sectorCustomerParameterManager.getPrimaryPortIdForSector(n3);
            String string2 = sectorCustomerParameterManager.getSectorSequenceForSector(n3);
            int n4 = ConsistencyChecker.getIntValueForSectorSequence(string2);
            for (int j = n4 - 1; j > 0; --j) {
                String string3 = "" + n4;
                if (ConsistencyChecker.isSectorExisting(sectorCustomerParameterManager, rbbManager, string, string3, n)) continue;
                throw new BemException("Missing sector in cascade chain. Primary port id=" + string + " Sector sequence=" + string3 + ".");
            }
        }
    }

    private static int getIntValueForSectorSequence(String string) throws BemException {
        int n = 0;
        if (string.equals("")) {
            n = 1;
        } else {
            try {
                n = Integer.parseInt(string);
            }
            catch (Exception exception) {
                throw new BemException("getIntValueForSectorSequence() can not convert sectorSequence=" + string + ".", (Throwable)exception);
            }
        }
        return n;
    }

    private static boolean isSectorExisting(SectorCustomerParameterManager sectorCustomerParameterManager, RbbManager rbbManager, String string, String string2, int n) throws BemException {
        int n2 = rbbManager.getMaxNumberOfSectors();
        boolean bl = false;
        for (int i = 0; i < n2; ++i) {
            int n3 = SectorUtil.getSectorNumberFromSectorIndex(i, n);
            AbstractRbb abstractRbb = rbbManager.getRadioBuildingBlock(n3);
            if (abstractRbb == null) continue;
            String string3 = sectorCustomerParameterManager.getSectorSequenceForSector(n3);
            String string4 = sectorCustomerParameterManager.getPrimaryPortIdForSector(n3);
            if (!string.equals(string4) || !string2.equals(string3)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private static void checkThatNoCascadeRbbsIsPutAfterAnNonCascadable(Rbs rbs, SectorCustomerParameterManager sectorCustomerParameterManager, RbbManager rbbManager, int n) throws BemException {
        int n2 = rbbManager.getMaxNumberOfSectors();
        for (int i = 0; i < n2; ++i) {
            int n3;
            int n4 = SectorUtil.getSectorNumberFromSectorIndex(i, n);
            AbstractRbb abstractRbb = rbbManager.getRadioBuildingBlock(n4);
            if (abstractRbb == null || abstractRbb.canHaveCascadesFollowing() || (n3 = ConsistencyChecker.findFollowerOnPrimaryPortId(rbs, sectorCustomerParameterManager, rbbManager, n4, n)) == 0) continue;
            String string = abstractRbb.getName();
            throw new BemException("There are sectors cascade connected after sector " + n4 + ". " + string + " configured for sector " + n4 + " do not support cascading.");
        }
    }

    private static int findFollowerOnPrimaryPortId(Rbs rbs, SectorCustomerParameterManager sectorCustomerParameterManager, RbbManager rbbManager, int n, int n2) throws BemException {
        int n3 = 0;
        int n4 = rbbManager.getMaxNumberOfSectors();
        String string = sectorCustomerParameterManager.getPrimaryPortIdForSector(n);
        String string2 = sectorCustomerParameterManager.getSectorSequenceForSector(n);
        for (int i = 0; i < n4; ++i) {
            String string3;
            int n5;
            String string4;
            int n6 = SectorUtil.getSectorNumberFromSectorIndex(i, n2);
            AbstractRbb abstractRbb = rbbManager.getRadioBuildingBlock(n6);
            if (abstractRbb == null || n6 == n || !(string4 = sectorCustomerParameterManager.getPrimaryPortIdForSector(n6)).equals(string) || (n5 = (string3 = sectorCustomerParameterManager.getSectorSequenceForSector(n6)).compareTo(string2)) <= 0) continue;
            n3 = n6;
            break;
        }
        return n3;
    }

    private static void checkThatRuwSlotsAreNotOverAllocated(Rbs rbs, SectorCustomerParameterManager sectorCustomerParameterManager, RbbManager rbbManager, int n, int n2) throws BemException {
        ArrayList arrayList = ConsistencyChecker.getAllAllocatedRuwSlots(rbbManager, n, n2);
        for (int i = 0; i < arrayList.size(); ++i) {
            AllocatedRuwSlot allocatedRuwSlot = (AllocatedRuwSlot)arrayList.get(i);
            for (int j = 0; j < arrayList.size(); ++j) {
                String string;
                String string2;
                int n3;
                if (i == j) continue;
                AllocatedRuwSlot allocatedRuwSlot2 = (AllocatedRuwSlot)arrayList.get(j);
                int n4 = allocatedRuwSlot.getRuwSlotNumber();
                if (n4 != (n3 = allocatedRuwSlot2.getRuwSlotNumber()) || !(string2 = allocatedRuwSlot.getRuwSubrackLdn()).equals(string = allocatedRuwSlot2.getRuwSubrackLdn())) continue;
                int n5 = allocatedRuwSlot.getSectorNumber();
                int n6 = allocatedRuwSlot2.getSectorNumber();
                throw new BemException("This configuration is not supported.\n\nRUW in slot " + n4 + " is allocated by " + " both sector " + n5 + " and sector " + n6 + ".");
            }
        }
    }

    private static ArrayList getAllAllocatedRuwSlots(RbbManager rbbManager, int n, int n2) throws BemException {
        ArrayList<AllocatedRuwSlot> arrayList = new ArrayList<AllocatedRuwSlot>();
        for (int i = 0; i < n; ++i) {
            int n3 = SectorUtil.getSectorNumberFromSectorIndex(i, n2);
            AbstractRbb abstractRbb = rbbManager.getRadioBuildingBlock(n3);
            if (abstractRbb == null) continue;
            AbstractRuRI[] abstractRuRIArray = abstractRbb.getRadioUnitResourceItems();
            for (int j = 0; j < abstractRuRIArray.length; ++j) {
                AbstractRuRI abstractRuRI = abstractRuRIArray[j];
                if (!abstractRbb.needRuPositionAllocation()) continue;
                AllocatedRuwSlot allocatedRuwSlot = new AllocatedRuwSlot(n3, abstractRuRI);
                arrayList.add(allocatedRuwSlot);
            }
        }
        return arrayList;
    }

    private static void checkCpriSpecificRules(Rbs rbs, SectorCustomerParameterManager sectorCustomerParameterManager, RbbManager rbbManager, int n, int n2) throws BemException {
        sectorCustomerParameterManager.checkPortIdAndSectorSeq();
        if (sectorCustomerParameterManager.hasAnySectorNeedRuPositionAllocation()) {
            ConsistencyChecker.checkThatRuwSlotsAreNotOverAllocated(rbs, sectorCustomerParameterManager, rbbManager, n, n2);
        }
    }

    private static void checkRadioSharedBySectorUnnique(SectorCustomerParameterManager sectorCustomerParameterManager, RbbManager rbbManager, int n) throws BemException {
        int n2 = rbbManager.getMaxNumberOfSectors();
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (int i = 0; i < n2; ++i) {
            int n3 = SectorUtil.getSectorNumberFromSectorIndex(i, n);
            AbstractRbb abstractRbb = rbbManager.getRadioBuildingBlock(n3);
            if (abstractRbb == null) continue;
            String string = abstractRbb.getName();
            String string2 = "";
            if (abstractRbb.supportsRadioSharedBy()) {
                string2 = sectorCustomerParameterManager.getRadioSharedBySectorForSector(n3);
                if (abstractRbb.mustConfigRadioSharedBy() && !ConsistencyChecker.isSetRadioSharedBySector(string2)) {
                    throw new BemException("Sector:" + n3 + " " + string + " must config radioSharedBy.");
                }
                if (string2.equals(n3 + "")) {
                    throw new BemException("radioSharedBy:" + string2 + " can not set the same value with sector itself.");
                }
                if (!ConsistencyChecker.isSetRadioSharedBySector(string2)) continue;
                arrayList.add(n3 + "");
                arrayList2.add(string2);
                continue;
            }
            if (!ConsistencyChecker.isSetRadioSharedBySector(string2)) continue;
            throw new BemException(string + " do not support radioSharedBy.");
        }
        ConsistencyChecker.checkIfRadioSharedByConfigCorrectly(arrayList, arrayList2, rbbManager);
    }

    public static void checkIfRadioSharedByConfigCorrectly(ArrayList arrayList, ArrayList arrayList2, RbbManager rbbManager) throws BemException {
        for (int i = 0; i < arrayList2.size(); ++i) {
            String string;
            String string2;
            int n;
            String string3 = (String)arrayList2.get(i);
            int n2 = 0;
            for (n = 0; n < arrayList2.size(); ++n) {
                if (n == i || !string3.equals(string2 = (String)arrayList2.get(n))) continue;
                string = (String)arrayList.get(i);
                String string4 = (String)arrayList.get(n);
                throw new BemException("radioSharedBy used for sector " + string + " is not unique. " + "It is used also for sector " + string4 + ".");
            }
            for (n = 0; n < arrayList.size(); ++n) {
                string2 = (String)arrayList.get(n);
                if (!string3.equals(string2)) continue;
                ++n2;
            }
            String string5 = (String)arrayList.get(i);
            string2 = rbbManager.getRbbName(Integer.parseInt(string5));
            if (n2 == 0) {
                throw new BemException("radioSharedBy:" + string3 + " used for sector " + string5 + " must have the value from the configured sector with " + string2 + ".");
            }
            string = rbbManager.getRbbName(Integer.parseInt(string3));
            if ((!string2.equalsIgnoreCase("RBB22_1F") || string.equalsIgnoreCase("RBB22_1G")) && (!string2.equalsIgnoreCase("RBB22_1G") || string.equalsIgnoreCase("RBB22_1F"))) continue;
            throw new BemException("For Dual Sector configuration, RBB22_1F should share the radio with RBB22_1G.");
        }
    }

    private static void checkNoOverRuPositionNumber(SectorCustomerParameterManager sectorCustomerParameterManager, RbbManager rbbManager, int n) throws BemException {
        int n2 = rbbManager.getMaxNumberOfSectors();
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            int n4 = SectorUtil.getSectorNumberFromSectorIndex(i, n);
            AbstractRbb abstractRbb = rbbManager.getRadioBuildingBlock(n4);
            String string = sectorCustomerParameterManager.getAuUnitTypeForSector(n4);
            if (abstractRbb == null || !AuUnitType.isMacroAuUnitType(string) || !abstractRbb.needRuPositionAllocation()) continue;
            n3 += abstractRbb.getNumOfRus();
        }
        String string = "The node is {0} DUW, the current number of macro radio unit {1} is over {2} according with the RBB input since the subrack space limitation.";
        if (DuwUtil.hasSingleDuw()) {
            if (n3 > 6) {
                throw new BemException(MessageFormat.format(string, "single", String.valueOf(n3), "6"));
            }
        } else if (n3 > 12) {
            throw new BemException(MessageFormat.format(string, "dual", String.valueOf(n3), "12"));
        }
    }

    public static boolean isSetRadioSharedBySector(String string) {
        boolean bl = false;
        if (string != null && !string.equals("") && !string.equals("##UNDEFINED")) {
            bl = true;
        }
        return bl;
    }

    private static void checkThatCabinetNumberShallNotConfigureForMainRemoteRadio(SectorCustomerParameterManager sectorCustomerParameterManager, int n, int n2) throws BemException {
        for (int i = 0; i < n; ++i) {
            int n3 = SectorUtil.getSectorNumberFromSectorIndex(i, n2);
            if (!sectorCustomerParameterManager.isCabinetNumberConfigured(n3) || AuUnitType.isMacroAuUnitType(sectorCustomerParameterManager.getAuUnitTypeForSector(n3))) continue;
            throw new BemException("cabinetNumber value=" + sectorCustomerParameterManager.getCabinetNumberForSector(n3) + " is invalid for the main-remote radio sector=" + n3);
        }
    }
}

