/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.scpm;

import java.text.MessageFormat;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.DbbManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.rbbmgmt.AbstractRbb;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.rbbmgmt.RbbManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.rbbmgmt.RbbStaticMetaDataMap;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.DuwUtil;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.EnumeratedRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterRestriction;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.definitions.AuUnitType;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.definitions.RbsInfo;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;

public class SectorCustomerParametersUtil {
    private static String[] SECTOR_NUMBER_OVER_6_NO_ISPANTERHYBRID_RBB_RANGE = new String[]{"", "RBB12_1A", "RBB22_1A", "RBB22_1B"};
    private static final String[] FULL_SECTOR_SEQUENCE_RANGE = new String[]{"", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12"};
    private static final String[] SECTOR_SEQUENCE_RANGE_WITH_AIR = new String[]{"", "1"};
    private static final String[] SECTOR_SEQUENCE_RANGE_WITH_AIR32 = new String[]{"", "1", "2", "3"};
    private static final String[] FULL_PORT_ID_RANGE = new String[]{"", "BU1_A", "BU1_B", "BU1_C", "BU1_D", "BU1_E", "BU1_F", "BU2_A", "BU2_B", "BU2_C", "BU2_D", "BU2_E", "BU2_F"};
    private static String[] allowedPortRangeSingleDuw = new String[]{"", "BU1_A", "BU1_B", "BU1_C", "BU1_D", "BU1_E", "BU1_F"};
    private static String[] allowedPortRangeDualDuw = new String[]{"", "BU1_A", "BU1_B", "BU1_C", "BU1_D", "BU1_E", "BU2_A", "BU2_B", "BU2_C", "BU2_D", "BU2_E"};
    private static String[] allowedPortRangePanthHybird = new String[]{"", "BU2_A", "BU2_B", "BU2_C", "BU2_D", "BU2_E", "BU2_F"};
    private static String[] allowedPortRangeDBB22 = new String[]{"", "BU1_A", "BU1_B", "BU1_C", "BU1_D", "BU2_A", "BU2_B", "BU2_C", "BU2_D"};
    private static String[] allowedPortRangeMicroRbs = new String[]{"", "BU1_D"};
    private static final String[] FULL_RADIO_CAN_SHARED_SECTOR_RANGE = new String[]{"", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12"};
    private static final String[] RADIO_CAN_SHARED_SECTOR_RANGE = new String[]{"", "1", "2", "3", "4", "5", "6"};

    public static String[] getFullRbbRange() {
        String[] stringArray = RbbStaticMetaDataMap.FULL_RBB_RANGE;
        return stringArray;
    }

    public static String[] getFullPortIdRange() {
        String[] stringArray = FULL_PORT_ID_RANGE;
        return stringArray;
    }

    public static String[] getSectorSequenceRangeWithAir() {
        String[] stringArray = SECTOR_SEQUENCE_RANGE_WITH_AIR;
        return stringArray;
    }

    public static String[] getSectorSequenceRangeWithAir32() {
        String[] stringArray = SECTOR_SEQUENCE_RANGE_WITH_AIR32;
        return stringArray;
    }

    public static String[] getFullSectorSequenceRange() {
        String[] stringArray = FULL_SECTOR_SEQUENCE_RANGE;
        return stringArray;
    }

    public static String[] getFullRadioCanSharedSectorRange() {
        String[] stringArray = FULL_RADIO_CAN_SHARED_SECTOR_RANGE;
        return stringArray;
    }

    public static String[] getAllAllowedPortIds() {
        String[] stringArray = null;
        stringArray = DuwUtil.hasDualDuws() ? allowedPortRangeDualDuw : allowedPortRangeSingleDuw;
        return stringArray;
    }

    public static ParameterRestriction[] getRbbRestriction(RbbManager rbbManager, int n) throws BemException {
        String string = rbbManager.getCarrierAllocationMode();
        ParameterRestriction parameterRestriction = null;
        ParameterRestriction parameterRestriction2 = null;
        ParameterRestriction parameterRestriction3 = null;
        ParameterRestriction parameterRestriction4 = null;
        EnumeratedRange enumeratedRange = null;
        String string2 = "";
        if (rbbManager.getRbs().isPantherHybridRbs() && n >= 7) {
            enumeratedRange = new EnumeratedRange(SECTOR_NUMBER_OVER_6_NO_ISPANTERHYBRID_RBB_RANGE);
            string2 = "For PanterHybrid Rbs and Sector number > 6, allowed choice of RBB's is limited.";
            parameterRestriction = new ParameterRestriction(string2 + " Valid range:" + enumeratedRange.toString() + ".", enumeratedRange, true);
            parameterRestriction.setActive(true);
        } else if (!string.equals("Flexible") && n > 6) {
            string2 = "Radio building blocks over sector 6 are only allowed for Flexible carrier allocation mode.";
            parameterRestriction2 = new ParameterRestriction(string2, new EnumeratedRange(new String[0]), true);
            parameterRestriction2.setActive(true);
        }
        if (rbbManager.needRuPositionAllocation(n)) {
            if (!RbsInfo.isMainRemoteRbs(rbbManager.getRbs().getRbsType())) {
                enumeratedRange = new EnumeratedRange(RbbStaticMetaDataMap.FULL_ELECTRICAL_CPRI_RBB_RANGE);
                if (DuwUtil.hasSingleDuw() && n > 3) {
                    enumeratedRange = (EnumeratedRange)enumeratedRange.copyAndRemove(new EnumeratedRange(new String[]{"RBB22_2B"}));
                }
                string2 = "For electrical CPRI, allowed choice of RBB's is limited.";
            } else {
                enumeratedRange = new EnumeratedRange(new String[0]);
                string2 = "Do not allow to choose the RBB with macro radio unit if it is the main-remote rbs.";
            }
        } else {
            enumeratedRange = new EnumeratedRange(RbbStaticMetaDataMap.FULL_RBB_RANGE);
            string2 = "For optical CPRI, allowed choise of RBB's is limited.";
        }
        parameterRestriction3 = new ParameterRestriction(string2 + " Valid range:" + enumeratedRange.toString() + ".", enumeratedRange, true);
        parameterRestriction3.setActive(true);
        AbstractRbb abstractRbb = rbbManager.getRadioBuildingBlock(n);
        if (rbbManager.getRbs().isSiteWiz() && abstractRbb != null && abstractRbb.needRuPositionAllocation()) {
            parameterRestriction4 = new ParameterRestriction("The sector has been configured in cabinet wizard", 0);
            parameterRestriction4.setActive(true);
        }
        return new ParameterRestriction[]{parameterRestriction, parameterRestriction2, parameterRestriction3, parameterRestriction4};
    }

    public static ParameterRestriction[] getPrimaryPortIdRestriction(RbbManager rbbManager, int n) throws BemException {
        Rbs rbs = rbbManager.getRbs();
        String[] stringArray = allowedPortRangeSingleDuw;
        String string = "Range restricted by single DUW";
        boolean bl = rbs.isPantherHybridRbs();
        boolean bl2 = RbsInfo.RBS_6501W.NAME.equals(rbs.getRbsType());
        boolean bl3 = DbbManager.getDbbValue(rbs).equals("DBB22");
        if (DuwUtil.hasDualDuws() && !bl) {
            string = "Range restricted by dual DUW";
            stringArray = allowedPortRangeDualDuw;
        }
        if (bl) {
            string = "Range restricted by PanterHybridRbs";
            stringArray = allowedPortRangePanthHybird;
        } else if (bl2) {
            string = "Range restricted by Micro Rbs";
            stringArray = allowedPortRangeMicroRbs;
        } else if (bl3) {
            string = "Range restricted by Dbb22";
            stringArray = allowedPortRangeDBB22;
        }
        ParameterRestriction parameterRestriction = null;
        if (rbbManager.needRuPositionAllocation(n)) {
            AbstractRbb abstractRbb = rbbManager.getRadioBuildingBlock(n);
            parameterRestriction = rbbManager.getRbs().isSiteWiz() && abstractRbb != null && abstractRbb.needRuPositionAllocation() ? new ParameterRestriction("The sector has been configured in cabinet wizard", 0) : (rbbManager.getRbs().isModifyWiz() && null != abstractRbb && abstractRbb.getNeedRuPostionAllocationLoadedValue() ? new ParameterRestriction("The sector can be modifed and auxPlugInUnit will be put from RbsSlot to Equipment or SectorAntenna", 2) : new ParameterRestriction("Range is restricted in Cabinet Wizard", 1));
        } else {
            EnumeratedRange enumeratedRange = new EnumeratedRange(stringArray);
            parameterRestriction = new ParameterRestriction(string + ". Valid range:" + enumeratedRange.toString(), enumeratedRange, true);
        }
        parameterRestriction.setActive(true);
        return new ParameterRestriction[]{parameterRestriction};
    }

    public static ParameterRestriction[] getSectorSequenceRestriction(RbbManager rbbManager, int n) throws BemException {
        Object object;
        String string = rbbManager.getRbbName(n);
        String string2 = rbbManager.getAuUnitType(n);
        ParameterRestriction parameterRestriction = null;
        String[] stringArray = new String[]{""};
        String string3 = "No sector cascading in Cabinet Wizard";
        if (rbbManager.needRuPositionAllocation(n)) {
            object = rbbManager.getRadioBuildingBlock(n);
            parameterRestriction = rbbManager.getRbs().isModifyWiz() && null != object && ((AbstractRbb)object).getNeedRuPostionAllocationLoadedValue() ? new ParameterRestriction("The sector can be modifed and auxPlugInUnit will be put from RbsSlot to Equipment or SectorAntenna", 2) : new ParameterRestriction(string3, 0);
        } else {
            string3 = "Range of SectorSequence is limited for sector number " + n + " with " + string;
            stringArray = "AIR".equals(string2) ? ("RBB44_1D".equals(string) ? SECTOR_SEQUENCE_RANGE_WITH_AIR32 : SECTOR_SEQUENCE_RANGE_WITH_AIR) : FULL_SECTOR_SEQUENCE_RANGE;
            object = new EnumeratedRange(stringArray);
            parameterRestriction = new ParameterRestriction(string3 + ". Valid range:" + ((EnumeratedRange)object).toString(), (ParameterRange)object, true);
        }
        parameterRestriction.setActive(true);
        object = new ParameterRestriction("AuUnitType must be configured", 3);
        ((ParameterRestriction)object).setActive(true);
        return new ParameterRestriction[]{parameterRestriction, object};
    }

    public static ParameterRestriction[] getSecondaryPortIdRestriction(RbbManager rbbManager, int n) throws BemException {
        Rbs rbs = rbbManager.getRbs();
        ParameterRestriction parameterRestriction = null;
        String[] stringArray = allowedPortRangeSingleDuw;
        String string = "Range restricted by single DUW";
        boolean bl = rbs.isPantherHybridRbs();
        boolean bl2 = RbsInfo.RBS_6501W.NAME.equals(rbs.getRbsType());
        boolean bl3 = DbbManager.getDbbValue(rbs).equals("DBB22");
        if (DuwUtil.hasDualDuws() && !bl) {
            string = "Range restricted by dual DUW";
            stringArray = allowedPortRangeDualDuw;
        }
        if (bl) {
            string = "Range restricted by PanterHybridRbs";
            stringArray = allowedPortRangePanthHybird;
        } else if (bl2) {
            string = "Range restricted by Micro Rbs";
            stringArray = new String[]{""};
        } else if (bl3) {
            string = "Range restricted by Dbb22";
            stringArray = allowedPortRangeDBB22;
        }
        if (rbbManager.needRuPositionAllocation(n)) {
            AbstractRbb abstractRbb = rbbManager.getRadioBuildingBlock(n);
            parameterRestriction = rbbManager.getRbs().isSiteWiz() && abstractRbb != null && abstractRbb.needRuPositionAllocation() ? new ParameterRestriction("The sector has been configured in cabinet wizard", 1) : (rbbManager.getRbs().isModifyWiz() && null != abstractRbb && abstractRbb.getNeedRuPostionAllocationLoadedValue() ? new ParameterRestriction("The sector can be modifed and auxPlugInUnit will be put from RbsSlot to Equipment or SectorAntenna", 2) : new ParameterRestriction("Range is restricted in Cabinet Wizard", 1));
        } else {
            EnumeratedRange enumeratedRange = new EnumeratedRange(stringArray);
            parameterRestriction = new ParameterRestriction(string + ". Valid range:" + enumeratedRange.toString(), enumeratedRange, true);
        }
        parameterRestriction.setActive(true);
        return new ParameterRestriction[]{parameterRestriction};
    }

    public static ParameterRestriction[] getAuUnitTypeRestriction(RbbManager rbbManager, int n) throws BemException {
        String string = rbbManager.getRbbName(n);
        String[] stringArray = new String[]{""};
        String string2 = "The range of AuUnitType restricted for sector " + n + " with " + string;
        String string3 = MessageFormat.format("S{0}_", new Integer(n));
        String string4 = rbbManager.getRbs().getCustomerParameter(string3 + "auUnitType");
        stringArray = rbbManager.getRbs().isModifyWiz() ? (AuUnitType.isMacroAuUnitType(string4) ? AuUnitType.getAuUnitTypeCPRangeByRbbWithSlotNum(string) : AuUnitType.getAuUnitTypeCPRangeByRbb(string)) : (rbbManager.needRuPositionAllocation(n) ? AuUnitType.getAuUnitTypeCPRangeByRbbWithSlotNum(string) : AuUnitType.getAuUnitTypeCPRangeByRbb(string));
        EnumeratedRange enumeratedRange = new EnumeratedRange(stringArray);
        ParameterRestriction parameterRestriction = new ParameterRestriction(string2 + ". Valid range:" + enumeratedRange.toString(), enumeratedRange, true);
        parameterRestriction.setActive(true);
        ParameterRestriction parameterRestriction2 = new ParameterRestriction("AuUnitType must be configured", 3);
        parameterRestriction2.setActive(true);
        ParameterRestriction parameterRestriction3 = null;
        AbstractRbb abstractRbb = rbbManager.getRadioBuildingBlock(n);
        if (rbbManager.getRbs().isSiteWiz() && abstractRbb != null && abstractRbb.needRuPositionAllocation()) {
            parameterRestriction3 = new ParameterRestriction("The sector has been configured in cabinet wizard", 0);
            parameterRestriction3.setActive(true);
        }
        return new ParameterRestriction[]{parameterRestriction, parameterRestriction2, parameterRestriction3};
    }

    public static ParameterRestriction[] getRadioSharedBySectorRestriction(RbbManager rbbManager, int n) throws BemException {
        String string = rbbManager.getRbbName(n);
        ParameterRestriction parameterRestriction = null;
        String[] stringArray = new String[]{""};
        String string2 = null;
        if (rbbManager.needRuPositionAllocation(n)) {
            parameterRestriction = new ParameterRestriction("RadioSharedBySector can not be configured in Cabinet wizard", 1);
        } else {
            Object object;
            if ("RBB22_2E".equals(string) || "RBB22_1F".equals(string) || "RBB22_1G".equals(string)) {
                stringArray = RADIO_CAN_SHARED_SECTOR_RANGE;
                string2 = "Range restricted by RBS which support 6 sector ";
                object = rbbManager.getCarrierAllocationMode();
                if (((String)object).equals("Flexible")) {
                    stringArray = FULL_RADIO_CAN_SHARED_SECTOR_RANGE;
                    string2 = "Range restricted by RBS which support 12 sector ";
                }
            }
            object = new EnumeratedRange(stringArray);
            parameterRestriction = new ParameterRestriction(string2 + ". Valid range:" + ((EnumeratedRange)object).toString(), (ParameterRange)object, true);
        }
        parameterRestriction.setActive(true);
        return new ParameterRestriction[]{parameterRestriction};
    }

    public static ParameterRestriction[] getCabinetNumberRestriction(RbbManager rbbManager, int n) throws BemException {
        ParameterRestriction parameterRestriction = null;
        AbstractRbb abstractRbb = rbbManager.getRadioBuildingBlock(n);
        if (rbbManager.getRbs().isSiteWiz() && abstractRbb != null && abstractRbb.needRuPositionAllocation() && !"##UNDEFINED".equals(abstractRbb.getCabinetNumber())) {
            parameterRestriction = new ParameterRestriction("The sector has been configured in cabinet wizard", 0);
            parameterRestriction.setActive(true);
        }
        return new ParameterRestriction[]{parameterRestriction};
    }
}

