/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.xalm;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.AbstractConfigurationItem;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.AlarmConfigurationProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.xalm.GenericAlarmManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.xalm.SauDeviceGroupRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.xalm.XalmDeviceGroupRI;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterException;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.EnumeratedRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IntegerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IntegerRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.OutOfRangeException;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterRestriction;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.YesNoCustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractDbControlledAuxillaryUnitRI;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimAuxPlugInUnit;
import se.ericsson.wcdma.rbs.bem.common.mim.MimDeviceGroup;
import se.ericsson.wcdma.rbs.bem.common.mim.MimEquipment;
import se.ericsson.wcdma.rbs.bem.common.mim.MimXalmDeviceGroup;
import se.ericsson.wcdma.rbs.bem.common.moi.ChildWithAttributeValues;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.moi.RootMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.SingleChildMoi;
import se.ericsson.wcdma.rbs.bem.common.service.ServiceNameValue;
import se.ericsson.wcdma.rbs.bem.common.service.ServiceValue;

public class XalmCI
extends AbstractConfigurationItem
implements AlarmConfigurationProvider {
    private static final String AUTO_CREATED_RDNID_1 = "1";
    public static final String name = "AlarmCI";
    public static final String SCU = "Scu";
    public static final String SAU = "Sau";
    public static final String XALM = "Xalm";
    public static final String RRUW = "Rruw";
    public static final String rruw = "Rruw";
    public static final String SUP = "Sup";
    private static final int XALM_SUP_MAX_NO_ALMDEVICES = 8;
    private static final int XALM_SUP_MAX_NO_OUTDEVICES = 0;
    private static final int XALM_SCU_MAX_NO_ALMDEVICES = 32;
    private static final int XALM_SCU_MAX_NO_OUTDEVICES = 4;
    private static final int SAU_MAX_NO_ALMDEVICES = 32;
    private static final int SAU_MAX_NO_OUTDEVICES = 8;
    private static final int RRUW_MAX_NO_ALMDEVICES = 6;
    private static final int RRUW_MAX_NO_OUTDEVICES = 0;
    private static final int MAX_NO_OF_RRUW_PER_SECTOR = 2;
    private SauDeviceGroupRI sauDeviceGroupRI = null;
    private XalmDeviceGroupRI xalmDeviceGroupRI = null;
    private MoInstance xalmDeviceGroupMoi;
    private MoInstance sauDeviceGroupMoi;
    private MoInstance scuDeviceGroupMoi;
    private MoInstance supDeviceGroupMoi;
    private MoInstance[] rruwDeviceGroupMoi;
    private ArrayList cplist;
    private boolean isOpen = false;
    private static final String ALREADY_OPEN = "XalmCI.open(): Already open";
    private static final String XALM_ONLY_AT_SITE = "Xalm must be configured at site for this RBS type";
    private static final String XALM_DELETE_NOT_SUPPOTED = "Xalm is already installed, and delete Xalm is not supported";
    private static final String XALM_IS_MANDATORY = "Xalm is mandatory for this RBS type";
    private static final String OPEN_EXCEPTION = "XalmCI.open() got exception=";
    private static final String INCONSISTENT_CONFIGURATION = "Xalm is mandatory for this RBS type\nbut no input values are entered\nand Xalm is not already installed on the basestation";
    private YesNoCustomerParameter configureXalmParameter = null;
    private YesNoCustomerParameter configureSauParameter = null;
    private YesNoCustomerParameter configureScuParameter = null;
    private YesNoCustomerParameter configureSupParameter = null;
    private boolean configureScu = false;
    private boolean configureSup = false;
    private ParameterRestriction restIgnored = new ParameterRestriction("", 1);
    private final boolean mandatoryAtNpc;
    private final boolean siteOnly;
    private boolean supportSau = false;
    private boolean supportXalm = true;
    private GenericAlarmManager xalmAlarmManager = null;
    private GenericAlarmManager scuAlarmManager = null;
    private GenericAlarmManager sauAlarmManager = null;
    private GenericAlarmManager supAlarmManager = null;
    private GenericAlarmManager[] rruwAlarmManager = new GenericAlarmManager[0];

    public XalmCI(Rbs rbs, boolean bl, boolean bl2) {
        super(rbs);
        this.mandatoryAtNpc = bl;
        this.siteOnly = bl2;
    }

    public XalmCI(Rbs rbs, boolean bl, boolean bl2, boolean bl3) {
        this(rbs, bl, bl2, bl3, false);
    }

    public XalmCI(Rbs rbs, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        super(rbs);
        this.mandatoryAtNpc = bl;
        this.siteOnly = bl2;
        this.supportSau = bl3;
        this.supportXalm = bl4;
    }

    public void setAlarmParents(MoInstance[] moInstanceArray, int n) {
        for (int i = 0; i < moInstanceArray.length; ++i) {
            if (n != 20) continue;
            this.rruwDeviceGroupMoi[i] = moInstanceArray[i];
        }
    }

    public void setAlarmParent(MoInstance moInstance, String string) throws BemException {
        int n = Integer.valueOf(string);
        if (n == 22) {
            this.scuDeviceGroupMoi = moInstance;
        }
        if (n == 6) {
            this.xalmDeviceGroupMoi = moInstance;
        }
        if (n == 21) {
            this.sauDeviceGroupMoi = moInstance;
        }
        if (n == 23) {
            this.supDeviceGroupMoi = moInstance;
        }
        if (n == 20) {
            for (int i = 0; i < this.rruwAlarmManager.length; ++i) {
                this.rruwAlarmManager[i].setDeviceGroupMoi(moInstance);
                this.rruwAlarmManager[i].createAlmdeviceRIs();
                this.rruwAlarmManager[i].saveAttributes();
            }
        }
    }

    public void setAlarmDeviceGroupForAlarmManagers() {
        this.scuAlarmManager.setDeviceGroupMoi(this.scuDeviceGroupMoi);
        this.xalmAlarmManager.setDeviceGroupMoi(this.xalmDeviceGroupMoi);
        this.sauAlarmManager.setDeviceGroupMoi(this.sauDeviceGroupMoi);
        this.supAlarmManager.setDeviceGroupMoi(this.supDeviceGroupMoi);
    }

    public void configureScu() {
        this.configureScu = true;
    }

    public void configureSup() {
        this.configureSup = true;
    }

    public boolean open() throws BemException {
        boolean bl = true;
        try {
            if (this.isOpen) {
                throw new BemException(ALREADY_OPEN);
            }
            this.isOpen = true;
            this.createCustomerParameters();
            this.xalmDeviceGroupRI = this.createXalmDeviceGroupRI();
            this.sauDeviceGroupRI = this.createSauDeviceGroupRI();
            this.xalmAlarmManager = new GenericAlarmManager(this.rbs, this.xalmDeviceGroupMoi, XALM, 32, 4);
            this.sauAlarmManager = new GenericAlarmManager(this.rbs, this.sauDeviceGroupMoi, SAU, 32, 8);
            this.scuAlarmManager = new GenericAlarmManager(this.rbs, this.scuDeviceGroupMoi, SCU, 32, 4);
            this.supAlarmManager = new GenericAlarmManager(this.rbs, this.supDeviceGroupMoi, SUP, 8, 0);
            int n = this.rbs.getMaxNumberOfSectors();
            this.rruwAlarmManager = new GenericAlarmManager[2 * n];
            this.rruwDeviceGroupMoi = new MoInstance[2 * n];
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                int n3 = i + 1;
                for (int j = 0; j < 2; ++j) {
                    int n4 = j + 1;
                    this.rruwAlarmManager[n2] = new GenericAlarmManager(this.rbs, this.rruwDeviceGroupMoi[n2], "Rruw", 6, 0, n3, n4);
                    this.rruwDeviceGroupMoi[n2] = this.rruwAlarmManager[n2].getDeviceGroupMoi();
                    this.cplist = this.rruwAlarmManager[n2].getCustomerParametersForRruw();
                    this.addParametersFromCPList(this.cplist);
                    this.rruwAlarmManager[n2].createAlmdeviceRIs();
                    ++n2;
                }
            }
            this.setAlarmParent(this.xalmDeviceGroupMoi, Integer.toString(6));
            this.setAlarmParent(this.sauDeviceGroupMoi, "21");
            this.setAlarmDeviceGroupForAlarmManagers();
            this.cplist = this.xalmAlarmManager.getCustomerParameters();
            this.addParametersFromCPList(this.cplist);
            this.cplist = this.sauAlarmManager.getCustomerParameters();
            this.addParametersFromCPList(this.cplist);
            this.cplist = this.scuAlarmManager.getCustomerParameters();
            this.addParametersFromCPList(this.cplist);
            this.cplist = this.supAlarmManager.getCustomerParameters();
            this.addParametersFromCPList(this.cplist);
            this.xalmAlarmManager.createAlmdeviceRIs();
            this.xalmAlarmManager.createOutDeviceRIs();
            this.sauAlarmManager.createAlmdeviceRIs();
            this.sauAlarmManager.createOutDeviceRIs();
            this.scuAlarmManager.createAlmdeviceRIs();
            this.scuAlarmManager.createOutDeviceRIs();
            this.supAlarmManager.createAlmdeviceRIs();
            this.supAlarmManager.createOutDeviceRIs();
            this.setRestrictions();
            super.addParameter(this.configureXalmParameter);
            super.addParameter(this.configureSauParameter);
            super.addParameter(this.configureScuParameter);
            super.addParameter(this.configureSupParameter);
        }
        catch (BemException bemException) {
            throw bemException;
        }
        catch (Exception exception) {
            throw new BemException(OPEN_EXCEPTION + exception.toString());
        }
        return bl;
    }

    private void setRestrictions() throws BemException {
        ParameterRestriction parameterRestriction;
        boolean bl = this.xalmDeviceGroupRI.isInstalled();
        boolean bl2 = this.sauDeviceGroupRI.isInstalled();
        if (bl) {
            this.configureXalmParameter.setLoadedValue("YES");
            if (this.mandatoryAtNpc && this.getRbs().getRbsStep().equals("STEP_SITE")) {
                parameterRestriction = new ParameterRestriction("configureXalm parameter value is ignored since\nXalm is mandatory for this RBS type and already\nconfigured at Cabinet Equipment configuration", 1);
                this.configureXalmParameter.addRestriction(parameterRestriction);
            } else {
                parameterRestriction = new ParameterRestriction(XALM_DELETE_NOT_SUPPOTED, new EnumeratedRange("YES"), true);
                this.configureXalmParameter.addRestriction(parameterRestriction);
            }
        } else {
            this.configureXalmParameter.setLoadedValue("NO");
            if (this.mandatoryAtNpc) {
                parameterRestriction = new ParameterRestriction(XALM_IS_MANDATORY, new EnumeratedRange("YES"), true);
                this.configureXalmParameter.setValue("YES");
                this.configureXalmParameter.addRestriction(parameterRestriction);
            } else if (this.siteOnly && this.getRbs().getRbsStep().equals("STEP_CABINET")) {
                parameterRestriction = new ParameterRestriction(XALM_ONLY_AT_SITE, new EnumeratedRange("YES"), false);
                this.configureXalmParameter.addRestriction(parameterRestriction);
            }
        }
        if (bl2) {
            this.configureSauParameter.setLoadedValue("YES");
            parameterRestriction = new ParameterRestriction(XALM_DELETE_NOT_SUPPOTED, new EnumeratedRange("YES"), true);
            this.configureSauParameter.addRestriction(parameterRestriction);
        } else {
            this.configureSauParameter.setLoadedValue("NO");
            if (!this.mandatoryAtNpc && this.siteOnly && this.getRbs().getRbsStep().equals("STEP_CABINET")) {
                parameterRestriction = new ParameterRestriction(XALM_ONLY_AT_SITE, new EnumeratedRange("YES"), false);
                this.configureSauParameter.addRestriction(parameterRestriction);
            }
        }
        this.configureScuParameter.setLoadedValue("NO");
        this.configureSupParameter.setLoadedValue("NO");
        if (this.supportSau) {
            this.configureXalmParameter.addRestriction(this.restIgnored);
        } else {
            this.configureSauParameter.addRestriction(this.restIgnored);
        }
    }

    private void createCustomerParameters() throws BemException {
        this.configureXalmParameter = new YesNoCustomerParameter("CAB1_configureXalm");
        this.configureXalmParameter.setDefaultValue("NO");
        this.configureSauParameter = new YesNoCustomerParameter("CAB1_configureSau");
        this.configureSauParameter.setDefaultValue("NO");
        this.configureScuParameter = new YesNoCustomerParameter("CAB1_configureScu");
        this.configureScuParameter.setDefaultValue("NO");
        this.configureSupParameter = new YesNoCustomerParameter("CAB1_configureSup");
        this.configureSupParameter.setDefaultValue("NO");
    }

    public void addParametersFromCPList(ArrayList arrayList) {
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            CustomerParameter customerParameter = (CustomerParameter)e;
            this.addParameter(customerParameter);
        }
    }

    public String getName() {
        return name;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public void checkConsistency(List list) throws CustomerParameterException {
        String string;
        if (!this.configureXalmParameter.isValidValue()) {
            throw new CustomerParameterException(this.configureXalmParameter);
        }
        if (this.mandatoryAtNpc && this.getRbs().getRbsStep().equals("STEP_SITE") && (string = this.configureXalmParameter.getValue()).equals("NO") && this.configureXalmParameter.getAccessLevel() != 1) {
            throw new CustomerParameterException(INCONSISTENT_CONFIGURATION, this.configureXalmParameter);
        }
    }

    public void setCustomerParameters(ServiceValue serviceValue) throws OutOfRangeException, BemException, CustomerParameterException {
        Object object;
        Object object2;
        ArrayList arrayList;
        Object object3;
        Iterator iterator;
        Object object4;
        Object object5;
        this.findInValidPortIdCustomerParams(serviceValue);
        String string = serviceValue.getValue("CAB1_configureXalm");
        if (string != null && string.length() > 0) {
            this.configureXalmParameter.setValue(string);
        }
        if (this.configureXalmParameter != null && this.configureXalmParameter.getValue() != null && this.configureXalmParameter.getValue().equals("YES")) {
            this.xalmAlarmManager.createAlmdeviceRIs(serviceValue);
            this.xalmAlarmManager.createOutdeviceRIs(serviceValue);
            object5 = this.xalmAlarmManager.getAlmDeviceCustomerParameters(serviceValue);
            object4 = ((ArrayList)object5).iterator();
            while (object4.hasNext()) {
                iterator = object4.next();
                object3 = (String[])iterator;
                super.setCustomerParametersFromSV((String[])object3, serviceValue);
            }
            arrayList = this.xalmAlarmManager.getOutDeviceCustomerParameters(serviceValue);
            iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                object3 = iterator.next();
                object2 = object3;
                super.setCustomerParametersFromSV((String[])object2, serviceValue);
            }
        }
        if (this.configureScu) {
            this.scuAlarmManager.createAlmdeviceRIs(serviceValue);
            this.scuAlarmManager.createOutdeviceRIs(serviceValue);
            object5 = this.scuAlarmManager.getAlmDeviceCustomerParameters(serviceValue);
            object4 = ((ArrayList)object5).iterator();
            while (object4.hasNext()) {
                iterator = object4.next();
                object3 = (String[])iterator;
                super.setCustomerParametersFromSV((String[])object3, serviceValue);
            }
            arrayList = this.scuAlarmManager.getOutDeviceCustomerParameters(serviceValue);
            iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                object3 = iterator.next();
                object2 = object3;
                super.setCustomerParametersFromSV((String[])object2, serviceValue);
            }
        }
        if (this.configureSup) {
            this.supAlarmManager.createAlmdeviceRIs(serviceValue);
            this.supAlarmManager.createOutdeviceRIs(serviceValue);
            object5 = this.supAlarmManager.getAlmDeviceCustomerParameters(serviceValue);
            object4 = ((ArrayList)object5).iterator();
            while (object4.hasNext()) {
                iterator = object4.next();
                object3 = (String[])iterator;
                super.setCustomerParametersFromSV((String[])object3, serviceValue);
            }
            arrayList = this.supAlarmManager.getOutDeviceCustomerParameters(serviceValue);
            iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                object3 = iterator.next();
                object2 = object3;
                super.setCustomerParametersFromSV((String[])object2, serviceValue);
            }
        }
        if ((object5 = serviceValue.getValue("CAB1_configureSau")) != null && ((String)object5).length() > 0) {
            this.configureSauParameter.setValue((String)object5);
        }
        if (this.configureSauParameter != null && this.configureSauParameter.getValue() != null && this.configureSauParameter.getValue().equals("YES")) {
            this.sauAlarmManager.createAlmdeviceRIs(serviceValue);
            this.sauAlarmManager.createOutdeviceRIs(serviceValue);
            arrayList = this.sauAlarmManager.getAlmDeviceCustomerParameters(serviceValue);
            iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                object3 = iterator.next();
                object2 = object3;
                super.setCustomerParametersFromSV((String[])object2, serviceValue);
            }
            object4 = this.sauAlarmManager.getOutDeviceCustomerParameters(serviceValue);
            object3 = ((ArrayList)object4).iterator();
            while (object3.hasNext()) {
                object2 = object3.next();
                object = object2;
                super.setCustomerParametersFromSV((String[])object, serviceValue);
            }
        }
        object4 = this.rbs.getRadioEquipmentProvider();
        iterator = object4.getRruwMois();
        object3 = new ArrayList();
        if (iterator != null) {
            int n;
            int n2;
            for (n2 = 0; n2 < iterator.size(); ++n2) {
                object = (MoInstance[])iterator.get(n2);
                if (object == null) continue;
                for (n = 0; n < ((MoInstance[])object).length; ++n) {
                    object3.add(object[n]);
                }
            }
            for (n2 = 0; n2 < this.rruwDeviceGroupMoi.length; ++n2) {
                object = this.rruwDeviceGroupMoi[n2].getLdn();
                for (n = 0; n < object3.size(); ++n) {
                    MoInstance moInstance = (MoInstance)object3.get(n);
                    String string2 = moInstance.getLdn();
                    if (!((String)object).equals(string2) || this.getRbs().getRbsStep().equals("STEP_CABINET")) continue;
                    arrayList = this.rruwAlarmManager[n2].getAlmDeviceCustomerParameters(serviceValue);
                    Iterator iterator2 = arrayList.iterator();
                    while (iterator2.hasNext()) {
                        Object e = iterator2.next();
                        String[] stringArray = (String[])e;
                        super.setCustomerParametersFromSV(stringArray, serviceValue);
                    }
                }
            }
        }
    }

    private void findInValidPortIdCustomerParams(ServiceValue serviceValue) {
        Vector vector = serviceValue.getAttributesStartingWith("SauExternalAlarm");
        Vector vector2 = serviceValue.getAttributesStartingWith("ScuExternalAlarm");
        Vector vector3 = serviceValue.getAttributesStartingWith("SupExternalAlarm");
        Vector vector4 = serviceValue.getAttributesStartingWith("XalmExternalAlarm");
        Vector vector5 = serviceValue.getAttributesStartingWith("SauControlPort");
        Vector vector6 = serviceValue.getAttributesStartingWith("ScuControlPort");
        Vector vector7 = serviceValue.getAttributesStartingWith("SupControlPort");
        Vector vector8 = serviceValue.getAttributesStartingWith("XalmControlPort");
        IntegerRange integerRange = new IntegerRange(1, 32);
        ParameterRestriction parameterRestriction = new ParameterRestriction("Port Id out of range", integerRange, true);
        this.addRestrictionsOnPortIds(vector, this.rbs, integerRange, parameterRestriction);
        IntegerRange integerRange2 = new IntegerRange(1, 8);
        ParameterRestriction parameterRestriction2 = new ParameterRestriction("Port Id out of range", integerRange2, true);
        this.addRestrictionsOnPortIds(vector5, this.rbs, integerRange2, parameterRestriction2);
        integerRange = new IntegerRange(1, 32);
        parameterRestriction = new ParameterRestriction("Port Id out of range", integerRange, true);
        integerRange2 = new IntegerRange(1, 8);
        parameterRestriction2 = new ParameterRestriction("Port Id out of range", integerRange2, true);
        this.addRestrictionsOnPortIds(vector2, this.rbs, integerRange, parameterRestriction);
        this.addRestrictionsOnPortIds(vector3, this.rbs, integerRange, parameterRestriction);
        this.addRestrictionsOnPortIds(vector4, this.rbs, integerRange, parameterRestriction);
        this.addRestrictionsOnPortIds(vector6, this.rbs, integerRange2, parameterRestriction2);
        this.addRestrictionsOnPortIds(vector7, this.rbs, integerRange2, parameterRestriction2);
        this.addRestrictionsOnPortIds(vector8, this.rbs, integerRange2, parameterRestriction2);
    }

    private void addRestrictionsOnPortIds(Vector vector, Rbs rbs, IntegerRange integerRange, ParameterRestriction parameterRestriction) {
        for (int i = 0; i < vector.size(); ++i) {
            ServiceNameValue serviceNameValue = (ServiceNameValue)vector.get(i);
            boolean bl = rbs.isParameterSupported(name);
            if (bl || !name.endsWith("portId")) continue;
            IntegerParameter integerParameter = new IntegerParameter(name, integerRange);
            integerParameter.setValue(serviceNameValue.getValueAsString());
            integerParameter.addRestriction(parameterRestriction);
            this.addParameter(integerParameter);
        }
    }

    public ArrayList getNeededRIs() {
        ArrayList arrayList;
        if (this.configureScu) {
            this.configureScuParameter.setValue("YES");
        }
        if (this.configureSup) {
            this.configureSupParameter.setValue("YES");
        }
        ArrayList<AbstractDbControlledAuxillaryUnitRI> arrayList2 = new ArrayList<AbstractDbControlledAuxillaryUnitRI>();
        String string = this.configureXalmParameter.getValue();
        String string2 = this.configureSauParameter.getValue();
        String string3 = this.configureScuParameter.getValue();
        String string4 = this.configureSupParameter.getValue();
        if (string.equals("YES") && this.supportXalm) {
            arrayList = new ArrayList();
            arrayList2.add(this.xalmDeviceGroupRI);
            arrayList = this.xalmAlarmManager.getNeededRIs();
            arrayList2.addAll(arrayList);
        }
        if (string2.equals("YES") && this.supportSau) {
            arrayList = new ArrayList();
            arrayList2.add(this.sauDeviceGroupRI);
            arrayList = this.sauAlarmManager.getNeededRIs();
            arrayList2.addAll(arrayList);
        }
        if (string3.equals("YES")) {
            arrayList = new ArrayList();
            arrayList = this.scuAlarmManager.getNeededRIs();
            arrayList2.addAll(arrayList);
        }
        if (string4.equals("YES")) {
            arrayList = new ArrayList();
            arrayList = this.supAlarmManager.getNeededRIs();
            arrayList2.addAll(arrayList);
        }
        for (int i = 0; i < this.rruwAlarmManager.length; ++i) {
            ArrayList arrayList3 = new ArrayList();
            if (!this.rruwAlarmManager[i].configureAlarmForRruw()) continue;
            arrayList3 = this.rruwAlarmManager[i].getNeededRIs();
            arrayList2.addAll(arrayList3);
        }
        return arrayList2;
    }

    public GenericAlarmManager getAlarmManager(String string) {
        if (string.endsWith(XALM)) {
            return this.xalmAlarmManager;
        }
        if (string.endsWith(SAU)) {
            return this.sauAlarmManager;
        }
        if (string.endsWith(SCU)) {
            return this.scuAlarmManager;
        }
        if (string.endsWith(SUP)) {
            return this.supAlarmManager;
        }
        return null;
    }

    protected XalmDeviceGroupRI createXalmDeviceGroupRI() throws BemException {
        RootMoi rootMoi = new RootMoi();
        SingleChildMoi singleChildMoi = new SingleChildMoi(rootMoi, MimEquipment.MOTYPENAME, AUTO_CREATED_RDNID_1);
        ChildWithAttributeValues childWithAttributeValues = new ChildWithAttributeValues(singleChildMoi, MimAuxPlugInUnit.MOTYPENAME, "auType", new Integer(6), AUTO_CREATED_RDNID_1);
        this.xalmDeviceGroupMoi = new SingleChildMoi(childWithAttributeValues, MimXalmDeviceGroup.MOTYPENAME, AUTO_CREATED_RDNID_1);
        XalmDeviceGroupRI xalmDeviceGroupRI = new XalmDeviceGroupRI(this.rbs, this.xalmDeviceGroupMoi.getLdn());
        return xalmDeviceGroupRI;
    }

    protected SauDeviceGroupRI createSauDeviceGroupRI() throws BemException {
        RootMoi rootMoi = new RootMoi();
        SingleChildMoi singleChildMoi = new SingleChildMoi(rootMoi, MimEquipment.MOTYPENAME, AUTO_CREATED_RDNID_1);
        ChildWithAttributeValues childWithAttributeValues = new ChildWithAttributeValues(singleChildMoi, MimAuxPlugInUnit.MOTYPENAME, "auType", new Integer(21), "SAU_1");
        this.sauDeviceGroupMoi = new SingleChildMoi(childWithAttributeValues, MimDeviceGroup.MOTYPENAME, "SAU");
        SauDeviceGroupRI sauDeviceGroupRI = new SauDeviceGroupRI(this.rbs, this.sauDeviceGroupMoi.getLdn());
        return sauDeviceGroupRI;
    }

    public void requestUnInitAlarms(int n, List list, Object object) throws BemException {
        for (int i = 0; i < list.size(); ++i) {
            String string = (String)list.get(i);
            for (int j = 0; j < this.rruwAlarmManager.length; ++j) {
                String string2 = this.rruwAlarmManager[j].getDeviceGroupLdn();
                if (!string.equals(string2)) continue;
                this.rruwAlarmManager[j].saveAttributes();
            }
        }
    }

    public SauDeviceGroupRI getSauDeviceGroupRI() {
        return this.sauDeviceGroupRI;
    }

    public XalmDeviceGroupRI getXalmDeviceGroupRI() {
        return this.xalmDeviceGroupRI;
    }

    public void setAlarmParents(MoInstance[] moInstanceArray, String string) throws BemException {
    }

    public void configureScu(boolean bl) {
    }

    public void configureSup(boolean bl) {
    }

    public void updateSupManager() {
    }

    public void setConfigureAlarmForRruw(int n, boolean bl) throws BemException {
        for (int i = 0; i < this.rruwAlarmManager.length; ++i) {
            String string = this.rruwAlarmManager[i].getSectorNumber();
            if (!String.valueOf(n).equals(string)) continue;
            this.rruwAlarmManager[i].setConfigureAlarmForRruw(bl);
        }
    }

    public void setAlarmParent(MoInstance moInstance, String string, int n) throws BemException {
    }
}

