/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configlogic.impl;

import java.io.Reader;
import java.io.StringReader;
import java.util.Observable;
import java.util.Observer;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.DuwUtil;
import se.ericsson.wcdma.rbs.bem.common.config.configlogic.IntegrationTypeReporter;
import se.ericsson.wcdma.rbs.bem.common.config.configlogic.ProgressReporter;
import se.ericsson.wcdma.rbs.bem.common.config.configlogic.RbsNclException;
import se.ericsson.wcdma.rbs.bem.common.config.configlogic.RbsNodeConfigurationLogic;
import se.ericsson.wcdma.rbs.bem.common.config.configlogic.impl.ProgressReporterLogImpl;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.api.InformativeText;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.api.OpenCIs;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.api.RbsFactory;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.io.xml.XmlFileHandler;
import se.ericsson.wcdma.rbs.bem.common.mim.MimRbsConfiguration;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandler;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerImpl;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.moi.SingleChildMoi;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;
import se.ericsson.wcdma.rbs.bem.common.service.ServiceValue;

public class RbsNclImpl
implements RbsNodeConfigurationLogic,
Observer {
    private static final String CABINET_EQUIPMENT = "Cabinet Equipment";
    private static final String OAM_ACCESS = "OAM Access";
    private static final String SITE_EQUIPMENT = "Site Equipment";
    private final ProgressReporter progressReporter;
    private int progressCounter = 0;
    private static final String OAM_DTD_FILE_PATH = "/se/ericsson/wcdma/rbs/bem/wizard/wizards/oam/dtd/OamAccess.dtd";
    private static final String SITE_DTD_FILE_PATH = "/se/ericsson/wcdma/rbs/bem/wizard/wizards/site/dtd/SiteEquipment.dtd";
    private static final String CABINET_DTD_FILE_PATH = "/se/ericsson/wcdma/rbs/bem/wizard/wizards/cabinet/dtd/CabinetEquipment.dtd";
    private int totalNoOfProgressReports = -1;
    private IntegrationTypeReporter integrationTypeReporter = null;
    private static final String OK = "</OK/>";
    private static boolean rbsAIConfigReportSwitch = false;
    private final NodeID nodeId;

    public RbsNclImpl(ProgressReporter progressReporter) {
        this.progressReporter = new ProgressReporterLogImpl("RbsNcl", progressReporter);
        this.nodeId = new NodeID();
    }

    public RbsNclImpl(ProgressReporter progressReporter, IntegrationTypeReporter integrationTypeReporter) {
        this(progressReporter);
        this.integrationTypeReporter = integrationTypeReporter;
    }

    public void performDhcpConfiguration(String string, String string2, String string3, String string4, String string5) {
        try {
            this.progressCounter = 0;
            Rbs rbs = RbsFactory.getRbs(new MoHandlerImpl(), "STEP_INT_DHCP");
            BemMo bemMo = this.getRbsConfigurationMo(rbs);
            rbs.addObserver(this);
            MoHandler moHandler = rbs.getMoHandler();
            OpenCIs.openIntegrateRbsDhcpCIs(rbs);
            this.setCpIfNotEmptyString(rbs, "OamIpHost_oamIpAddress", string);
            this.setCpIfNotEmptyString(rbs, "OamIpHost_oamSubnetMask", string2);
            this.setCpIfNotEmptyString(rbs, "dhcpServerPrimaryIpAddress", string3);
            this.setCpIfNotEmptyString(rbs, "dnsServerIpAddress", string4);
            this.setCpIfNotEmptyString(rbs, "defaultRouter", string5);
            this.setCpIfNotEmptyString(rbs, "OamIpHost_oamDefaultRouter0", string5);
            this.setCpIfNotEmptyString(rbs, "IPoverGigabitEthernet_transportOption", "atm");
            rbs.checkConsistency();
            this.progressCounter = 0;
            rbs.installAllCIs(false, this);
            String string6 = "\n\nSettings from DHCP\n";
            string6 = string6 + "==================\n";
            string6 = string6 + this.getInformativetText(rbs);
            moHandler.setAttribute(bemMo, "configurationReport", string6);
        }
        catch (Exception exception) {
            throw new RbsNclException(exception);
        }
    }

    private void setCpIfNotEmptyString(Rbs rbs, String string, String string2) throws BemException {
        if (string2 != null && !string2.equals("")) {
            rbs.setCustomerParameter(string, string2);
        }
    }

    public String performOamConfiguration(String string) {
        StringReader stringReader = new StringReader(string);
        return this.performOamConfiguration(stringReader, "OAM configuration file as string");
    }

    public String performOamConfiguration(Reader reader, String string) {
        Nal.getLog().nalTraceEnter(this.getClass(), "performOamConfiguration()");
        return this.performConfiguration(reader, string, OAM_DTD_FILE_PATH, OAM_ACCESS, "STEP_INT_OAM", false);
    }

    public String performSiteConfiguration(String string) {
        StringReader stringReader = new StringReader(string);
        return this.performSiteConfiguration(stringReader, "Site configuration file as string");
    }

    public String performSiteConfiguration(Reader reader, String string) {
        Nal.getLog().nalTraceEnter(this.getClass(), "performSiteConfiguration()");
        return this.performConfiguration(reader, string, SITE_DTD_FILE_PATH, SITE_EQUIPMENT, "STEP_INT_SITE", false);
    }

    public String performCabinetConfiguration(String string) {
        return this.performCabinetConfiguration(new StringReader(string), "Cabinet Equipment configuration file as string");
    }

    public String performCabinetConfiguration(Reader reader, String string) {
        return this.performConfiguration(reader, string, CABINET_DTD_FILE_PATH, CABINET_EQUIPMENT, "STEP_CABINET", true);
    }

    private void initNodeID(Rbs rbs) throws BemException {
        Nal.getLog().nalTraceEnter(this.getClass(), "initNodeID start...");
        if (rbs.isParameterSupported("nodeIdType")) {
            this.nodeId.setNodeIDType(rbs.getCustomerParameter("nodeIdType"));
        }
        if (rbs.isParameterSupported("nodeIdValue")) {
            this.nodeId.setNodeIDValue(rbs.getCustomerParameter("nodeIdValue"));
        }
        Nal.getLog().nalTraceEnter(this.getClass(), "initNodeID end...");
    }

    private String performConfiguration(Reader reader, String string, String string2, String string3, String string4, boolean bl) {
        try {
            this.progressReporter.reportProgress(0, "Performing " + string3 + " configuration");
            MoHandlerImpl moHandlerImpl = new MoHandlerImpl();
            XmlFileHandler xmlFileHandler = XmlFileHandler.getInstance();
            ServiceValue serviceValue = xmlFileHandler.startParsing(reader, string, string2);
            Rbs rbs = this.getRbs(bl, moHandlerImpl, string4, serviceValue);
            rbs.setWriteRbsConfigPhase(true);
            rbs.setAiOngoing(true);
            rbsAIConfigReportSwitch = false;
            if (string4.equals("STEP_CABINET")) {
                OpenCIs.openCabinetCIs(rbs);
            } else if (string4.equals("STEP_INT_OAM")) {
                OpenCIs.openOamCIs(rbs);
            } else if (string4.equals("STEP_INT_SITE")) {
                OpenCIs.openSiteCIs(rbs);
            }
            if (this.integrationTypeReporter != null && this.integrationTypeReporter.getIntegrationType() == 1) {
                rbs.removePhasesOnNscAi();
            }
            rbs.setCustomerParameters(serviceValue);
            if (string4.equals("STEP_INT_OAM")) {
                this.initNodeID(rbs);
            }
            rbs.checkConsistency();
            this.progressCounter = 0;
            this.totalNoOfProgressReports = rbs.getNoOfInstallationPhases() + rbs.getNoOfCIs();
            rbs.installAllCIs(false, this);
            this.totalNoOfProgressReports = -1;
        }
        catch (Exception exception) {
            String string5 = "Failed performing " + string3 + "! ";
            Nal.getLog().nalTraceError(this.getClass(), string5, exception);
            throw new RbsNclException(string5, exception);
        }
        finally {
            rbsAIConfigReportSwitch = false;
        }
        return OK;
    }

    private Rbs getRbs(boolean bl, MoHandler moHandler, String string, ServiceValue serviceValue) throws BemException {
        if (bl) {
            String string2 = serviceValue.getValue("rbsType");
            return RbsFactory.getRbs(string2, moHandler, string, DuwUtil.isPantherHybridRbs(), serviceValue);
        }
        return RbsFactory.getRbs(moHandler, string, DuwUtil.isPantherHybridRbs(), serviceValue);
    }

    public void update(Observable observable, Object object) {
        int n = this.progressCounter + 1;
        if (this.totalNoOfProgressReports > 0) {
            float f = this.progressCounter * 100 / this.totalNoOfProgressReports;
            n = Math.round(f);
            this.progressReporter.reportProgress(n, (String)object);
            ++this.progressCounter;
        }
    }

    private String getInformativetText(Rbs rbs) throws BemException {
        InformativeText informativeText = new InformativeText(rbs);
        String string = informativeText.getInformativeText();
        return string;
    }

    private BemMo getRbsConfigurationMo(Rbs rbs) throws BemException {
        MoInstance moInstance = rbs.getNodeBFunctionMoi();
        SingleChildMoi singleChildMoi = new SingleChildMoi(moInstance, MimRbsConfiguration.MOTYPENAME, "1");
        MoHandler moHandler = rbs.getMoHandler();
        BemMo bemMo = moHandler.getMo(singleChildMoi.getLdn());
        return bemMo;
    }

    public static boolean isRbsAIConfigReportSwitch() {
        return rbsAIConfigReportSwitch;
    }

    public static void setRbsAIConfigReportSwitch(boolean bl) {
        rbsAIConfigReportSwitch = bl;
    }

    public String getNodeIDType() {
        Nal.getLog().nalTraceEnter(this.getClass(), "getNodeIDType():" + this.nodeId.getNodeIDType());
        return this.nodeId.getNodeIDType();
    }

    public String getNodeIDValue() {
        Nal.getLog().nalTraceEnter(this.getClass(), "getNodeIDValue():" + this.nodeId.getNodeIDValue());
        return this.nodeId.getNodeIDValue();
    }

    public static class NodeID {
        private String nodeIDType;
        private String nodeIDValue;

        public String getNodeIDType() {
            return this.nodeIDType;
        }

        public void setNodeIDType(String string) {
            if (!string.equals("") && !string.equals("##UNDEFINED")) {
                this.nodeIDType = string;
            }
        }

        public String getNodeIDValue() {
            return this.nodeIDValue;
        }

        public void setNodeIDValue(String string) {
            if (!string.equals("") && !string.equals("##UNDEFINED")) {
                this.nodeIDValue = string;
            }
        }
    }
}

